/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics.face;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.UserInfo;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.biometrics.IBiometricServiceReceiverInternal;
import android.hardware.biometrics.face.V1_0.IBiometricsFace;
import android.hardware.biometrics.face.V1_0.IBiometricsFaceClientCallback;
import android.hardware.biometrics.face.V1_0.OptionalBool;
import android.hardware.face.Face;
import android.hardware.face.FaceManager;
import android.hardware.face.IFaceService;
import android.hardware.face.IFaceServiceReceiver;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.NativeHandle;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemServerInitThreadPool;
import com.android.server.biometrics.BiometricServiceBase;
import com.android.server.biometrics.BiometricUtils;
import com.android.server.biometrics.Constants;
import com.android.server.biometrics.EnumerateClient;
import com.android.server.biometrics.RemovalClient;
import com.android.server.biometrics.face.FaceConstants;
import com.android.server.biometrics.face.FaceUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FaceService
extends BiometricServiceBase {
    protected static final String TAG = "FaceService";
    private static final boolean DEBUG = true;
    private static final String FACE_DATA_DIR = "facedata";
    private static final String ACTION_LOCKOUT_RESET = "com.android.server.biometrics.face.ACTION_LOCKOUT_RESET";
    private static final int CHALLENGE_TIMEOUT_SEC = 600;
    private final FaceConstants mFaceConstants = new FaceConstants();
    @GuardedBy(value={"this"})
    private IBiometricsFace mDaemon;
    private int mCurrentUserLockoutMode;
    private int[] mBiometricPromptIgnoreList;
    private int[] mBiometricPromptIgnoreListVendor;
    private int[] mKeyguardIgnoreList;
    private int[] mKeyguardIgnoreListVendor;
    private int[] mEnrollIgnoreList;
    private int[] mEnrollIgnoreListVendor;
    private IBiometricsFaceClientCallback mDaemonCallback = new IBiometricsFaceClientCallback.Stub(){

        @Override
        public void onEnrollResult(long deviceId, int faceId, int userId, int remaining) {
            FaceService.this.mHandler.post(() -> {
                Face face = new Face(FaceService.this.getBiometricUtils().getUniqueName(FaceService.this.getContext(), userId), faceId, deviceId);
                FaceService.super.handleEnrollResult(face, remaining);
            });
        }

        @Override
        public void onAcquired(long deviceId, int userId, int acquiredInfo, int vendorCode) {
            FaceService.this.mHandler.post(() -> FaceService.super.handleAcquired(deviceId, acquiredInfo, vendorCode));
        }

        @Override
        public void onAuthenticated(long deviceId, int faceId, int userId, ArrayList<Byte> token) {
            FaceService.this.mHandler.post(() -> {
                Face face = new Face("", faceId, deviceId);
                FaceService.super.handleAuthenticated(face, token);
            });
        }

        @Override
        public void onError(long deviceId, int userId, int error, int vendorCode) {
            FaceService.this.mHandler.post(() -> {
                FaceService.super.handleError(deviceId, error, vendorCode);
                if (error == 1) {
                    Slog.w(FaceService.TAG, "Got ERROR_HW_UNAVAILABLE; try reconnecting next client.");
                    1 var5_4 = this;
                    synchronized (var5_4) {
                        FaceService.this.mDaemon = null;
                        FaceService.this.mHalDeviceId = 0L;
                        FaceService.this.mCurrentUserId = -10000;
                    }
                }
            });
        }

        @Override
        public void onRemoved(long deviceId, ArrayList<Integer> faceIds, int userId) {
            FaceService.this.mHandler.post(() -> {
                if (!faceIds.isEmpty()) {
                    for (int i = 0; i < faceIds.size(); ++i) {
                        Face face = new Face("", (Integer)faceIds.get(i), deviceId);
                        FaceService.super.handleRemoved(face, faceIds.size() - i - 1);
                    }
                } else {
                    Face face = new Face("", 0, deviceId);
                    FaceService.super.handleRemoved(face, 0);
                }
            });
        }

        @Override
        public void onEnumerate(long deviceId, ArrayList<Integer> faceIds, int userId) throws RemoteException {
            FaceService.this.mHandler.post(() -> {
                if (!faceIds.isEmpty()) {
                    for (int i = 0; i < faceIds.size(); ++i) {
                        Face face = new Face("", (Integer)faceIds.get(i), deviceId);
                        FaceService.super.handleEnumerate(face, faceIds.size() - i - 1);
                    }
                } else {
                    FaceService.super.handleEnumerate(null, 0);
                }
            });
        }

        @Override
        public void onLockoutChanged(long duration) {
            Slog.d(FaceService.TAG, "onLockoutChanged: " + duration);
            if (duration == 0L) {
                FaceService.this.mCurrentUserLockoutMode = 0;
            } else if (duration == Long.MAX_VALUE) {
                FaceService.this.mCurrentUserLockoutMode = 2;
            } else {
                FaceService.this.mCurrentUserLockoutMode = 1;
            }
            FaceService.this.mHandler.post(() -> {
                if (duration == 0L) {
                    FaceService.this.notifyLockoutResetMonitors();
                }
            });
        }
    };
    private final BiometricServiceBase.DaemonWrapper mDaemonWrapper = new BiometricServiceBase.DaemonWrapper(){

        @Override
        public int authenticate(long operationId, int groupId) throws RemoteException {
            IBiometricsFace daemon = FaceService.this.getFaceDaemon();
            if (daemon == null) {
                Slog.w(FaceService.TAG, "authenticate(): no face HAL!");
                return 3;
            }
            return daemon.authenticate(operationId);
        }

        @Override
        public int cancel() throws RemoteException {
            IBiometricsFace daemon = FaceService.this.getFaceDaemon();
            if (daemon == null) {
                Slog.w(FaceService.TAG, "cancel(): no face HAL!");
                return 3;
            }
            return daemon.cancel();
        }

        @Override
        public int remove(int groupId, int biometricId) throws RemoteException {
            IBiometricsFace daemon = FaceService.this.getFaceDaemon();
            if (daemon == null) {
                Slog.w(FaceService.TAG, "remove(): no face HAL!");
                return 3;
            }
            return daemon.remove(biometricId);
        }

        @Override
        public int enumerate() throws RemoteException {
            IBiometricsFace daemon = FaceService.this.getFaceDaemon();
            if (daemon == null) {
                Slog.w(FaceService.TAG, "enumerate(): no face HAL!");
                return 3;
            }
            return daemon.enumerate();
        }

        @Override
        public int enroll(byte[] cryptoToken, int groupId, int timeout, ArrayList<Integer> disabledFeatures) throws RemoteException {
            IBiometricsFace daemon = FaceService.this.getFaceDaemon();
            if (daemon == null) {
                Slog.w(FaceService.TAG, "enroll(): no face HAL!");
                return 3;
            }
            ArrayList<Byte> token = new ArrayList<Byte>();
            for (int i = 0; i < cryptoToken.length; ++i) {
                token.add(cryptoToken[i]);
            }
            return daemon.enroll(token, timeout, disabledFeatures);
        }

        @Override
        public void resetLockout(byte[] cryptoToken) throws RemoteException {
            IBiometricsFace daemon = FaceService.this.getFaceDaemon();
            if (daemon == null) {
                Slog.w(FaceService.TAG, "resetLockout(): no face HAL!");
                return;
            }
            ArrayList<Byte> token = new ArrayList<Byte>();
            for (int i = 0; i < cryptoToken.length; ++i) {
                token.add(cryptoToken[i]);
            }
            daemon.resetLockout(token);
        }
    };

    public FaceService(Context context) {
        super(context);
        this.mBiometricPromptIgnoreList = this.getContext().getResources().getIntArray(17236022);
        this.mBiometricPromptIgnoreListVendor = this.getContext().getResources().getIntArray(17236025);
        this.mKeyguardIgnoreList = this.getContext().getResources().getIntArray(17236024);
        this.mKeyguardIgnoreListVendor = this.getContext().getResources().getIntArray(17236027);
        this.mEnrollIgnoreList = this.getContext().getResources().getIntArray(17236023);
        this.mEnrollIgnoreListVendor = this.getContext().getResources().getIntArray(17236026);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.publishBinderService("face", new FaceServiceWrapper());
        SystemServerInitThreadPool.get().submit(this::getFaceDaemon, "FaceService.onStart");
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    protected BiometricServiceBase.DaemonWrapper getDaemonWrapper() {
        return this.mDaemonWrapper;
    }

    @Override
    protected BiometricUtils getBiometricUtils() {
        return FaceUtils.getInstance();
    }

    @Override
    protected Constants getConstants() {
        return this.mFaceConstants;
    }

    @Override
    protected boolean hasReachedEnrollmentLimit(int userId) {
        int limit = this.getContext().getResources().getInteger(17694810);
        int enrolled = this.getEnrolledTemplates(userId).size();
        if (enrolled >= limit) {
            Slog.w(TAG, "Too many faces registered, user: " + userId);
            return true;
        }
        return false;
    }

    @Override
    public void serviceDied(long cookie) {
        super.serviceDied(cookie);
        this.mDaemon = null;
        this.mCurrentUserId = -10000;
    }

    @Override
    protected void updateActiveGroup(int userId, String clientPackage) {
        IBiometricsFace daemon = this.getFaceDaemon();
        if (daemon != null) {
            try {
                userId = this.getUserOrWorkProfileId(clientPackage, userId);
                if (userId != this.mCurrentUserId) {
                    File baseDir = Environment.getDataVendorDeDirectory(userId);
                    File faceDir = new File(baseDir, FACE_DATA_DIR);
                    if (!faceDir.exists()) {
                        if (!faceDir.mkdir()) {
                            Slog.v(TAG, "Cannot make directory: " + faceDir.getAbsolutePath());
                            return;
                        }
                        if (!SELinux.restorecon(faceDir)) {
                            Slog.w(TAG, "Restorecons failed. Directory will have wrong label.");
                            return;
                        }
                    }
                    daemon.setActiveUser(userId, faceDir.getAbsolutePath());
                    this.mCurrentUserId = userId;
                }
                this.mAuthenticatorIds.put(userId, this.hasEnrolledBiometrics(userId) ? daemon.getAuthenticatorId().value : 0L);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to setActiveUser():", e);
            }
        }
    }

    @Override
    protected String getLockoutResetIntent() {
        return ACTION_LOCKOUT_RESET;
    }

    @Override
    protected String getLockoutBroadcastPermission() {
        return "android.permission.RESET_FACE_LOCKOUT";
    }

    @Override
    protected long getHalDeviceId() {
        return this.mHalDeviceId;
    }

    @Override
    protected void handleUserSwitching(int userId) {
        super.handleUserSwitching(userId);
        this.mCurrentUserLockoutMode = 0;
    }

    @Override
    protected boolean hasEnrolledBiometrics(int userId) {
        if (userId != UserHandle.getCallingUserId()) {
            this.checkPermission("android.permission.INTERACT_ACROSS_USERS");
        }
        return this.getBiometricUtils().getBiometricsForUser(this.getContext(), userId).size() > 0;
    }

    @Override
    protected String getManageBiometricPermission() {
        return "android.permission.MANAGE_BIOMETRIC";
    }

    @Override
    protected void checkUseBiometricPermission() {
    }

    @Override
    protected boolean checkAppOps(int uid, String opPackageName) {
        return this.mAppOps.noteOp(78, uid, opPackageName) == 0;
    }

    protected List<Face> getEnrolledTemplates(int userId) {
        return this.getBiometricUtils().getBiometricsForUser(this.getContext(), userId);
    }

    @Override
    protected void notifyClientActiveCallbacks(boolean isActive) {
    }

    @Override
    protected int statsModality() {
        return 4;
    }

    @Override
    protected int getLockoutMode() {
        return this.mCurrentUserLockoutMode;
    }

    private synchronized IBiometricsFace getFaceDaemon() {
        if (this.mDaemon == null) {
            Slog.v(TAG, "mDaemon was null, reconnect to face");
            try {
                this.mDaemon = IBiometricsFace.getService();
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to get biometric interface", e);
            }
            if (this.mDaemon == null) {
                Slog.w(TAG, "face HIDL not available");
                return null;
            }
            this.mDaemon.asBinder().linkToDeath(this, 0L);
            try {
                this.mHalDeviceId = this.mDaemon.setCallback((IBiometricsFaceClientCallback)this.mDaemonCallback).value;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to open face HAL", e);
                this.mDaemon = null;
            }
            Slog.v(TAG, "Face HAL id: " + this.mHalDeviceId);
            if (this.mHalDeviceId != 0L) {
                this.loadAuthenticatorIds();
                this.updateActiveGroup(ActivityManager.getCurrentUser(), null);
                this.doTemplateCleanupForUser(ActivityManager.getCurrentUser());
            } else {
                Slog.w(TAG, "Failed to open Face HAL!");
                MetricsLogger.count(this.getContext(), "faced_openhal_error", 1);
                this.mDaemon = null;
            }
        }
        return this.mDaemon;
    }

    private long startGenerateChallenge(IBinder token) {
        IBiometricsFace daemon = this.getFaceDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startGenerateChallenge: no face HAL!");
            return 0L;
        }
        try {
            return daemon.generateChallenge((int)600).value;
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startGenerateChallenge failed", e);
            return 0L;
        }
    }

    private int startRevokeChallenge(IBinder token) {
        IBiometricsFace daemon = this.getFaceDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startRevokeChallenge: no face HAL!");
            return 0;
        }
        try {
            return daemon.revokeChallenge();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startRevokeChallenge failed", e);
            return 0;
        }
    }

    private void dumpInternal(PrintWriter pw) {
        JSONObject dump = new JSONObject();
        try {
            dump.put("service", "Face Manager");
            JSONArray sets = new JSONArray();
            for (UserInfo user : UserManager.get(this.getContext()).getUsers()) {
                int userId = user.getUserHandle().getIdentifier();
                int N = this.getBiometricUtils().getBiometricsForUser(this.getContext(), userId).size();
                BiometricServiceBase.PerformanceStats stats = (BiometricServiceBase.PerformanceStats)this.mPerformanceMap.get(userId);
                BiometricServiceBase.PerformanceStats cryptoStats = (BiometricServiceBase.PerformanceStats)this.mCryptoPerformanceMap.get(userId);
                JSONObject set = new JSONObject();
                set.put("id", userId);
                set.put("count", N);
                set.put("accept", stats != null ? stats.accept : 0);
                set.put("reject", stats != null ? stats.reject : 0);
                set.put("acquire", stats != null ? stats.acquire : 0);
                set.put("lockout", stats != null ? stats.lockout : 0);
                set.put("permanentLockout", stats != null ? stats.permanentLockout : 0);
                set.put("acceptCrypto", cryptoStats != null ? cryptoStats.accept : 0);
                set.put("rejectCrypto", cryptoStats != null ? cryptoStats.reject : 0);
                set.put("acquireCrypto", cryptoStats != null ? cryptoStats.acquire : 0);
                set.put("lockoutCrypto", cryptoStats != null ? cryptoStats.lockout : 0);
                set.put("permanentLockoutCrypto", cryptoStats != null ? cryptoStats.permanentLockout : 0);
                sets.put(set);
            }
            dump.put("prints", sets);
        }
        catch (JSONException e) {
            Slog.e(TAG, "dump formatting failure", e);
        }
        pw.println(dump);
        pw.println("HAL Deaths: " + this.mHALDeathCount);
        this.mHALDeathCount = 0;
    }

    private void dumpProto(FileDescriptor fd) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        for (UserInfo user : UserManager.get(this.getContext()).getUsers()) {
            BiometricServiceBase.PerformanceStats crypto;
            int userId = user.getUserHandle().getIdentifier();
            long userToken = proto.start(2246267895809L);
            proto.write(0x10500000001L, userId);
            proto.write(1120986464258L, this.getBiometricUtils().getBiometricsForUser(this.getContext(), userId).size());
            BiometricServiceBase.PerformanceStats normal = (BiometricServiceBase.PerformanceStats)this.mPerformanceMap.get(userId);
            if (normal != null) {
                long countsToken = proto.start(1146756268035L);
                proto.write(0x10500000001L, normal.accept);
                proto.write(1120986464258L, normal.reject);
                proto.write(1120986464259L, normal.acquire);
                proto.write(1120986464260L, normal.lockout);
                proto.write(0x10500000005L, normal.lockout);
                proto.end(countsToken);
            }
            if ((crypto = (BiometricServiceBase.PerformanceStats)this.mCryptoPerformanceMap.get(userId)) != null) {
                long countsToken = proto.start(1146756268036L);
                proto.write(0x10500000001L, crypto.accept);
                proto.write(1120986464258L, crypto.reject);
                proto.write(1120986464259L, crypto.acquire);
                proto.write(1120986464260L, crypto.lockout);
                proto.write(0x10500000005L, crypto.lockout);
                proto.end(countsToken);
            }
            proto.end(userToken);
        }
        proto.flush();
        this.mPerformanceMap.clear();
        this.mCryptoPerformanceMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpHal(FileDescriptor fd, String[] args) {
        if (!Build.IS_ENG && !Build.IS_USERDEBUG) {
            return;
        }
        if (SystemProperties.getBoolean("ro.face.disable_debug_data", false) || SystemProperties.getBoolean("persist.face.disable_debug_data", false)) {
            return;
        }
        IBiometricsFace daemon = this.getFaceDaemon();
        if (daemon != null) {
            FileOutputStream devnull = null;
            try {
                devnull = new FileOutputStream("/dev/null");
                NativeHandle handle = new NativeHandle(new FileDescriptor[]{devnull.getFD(), fd}, new int[0], false);
                daemon.debug(handle, new ArrayList<String>(Arrays.asList(args)));
            }
            catch (RemoteException | IOException ex) {
                Slog.d(TAG, "error while reading face debugging data", ex);
            }
            finally {
                if (devnull != null) {
                    try {
                        devnull.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class ServiceListenerImpl
    implements BiometricServiceBase.ServiceListener {
        private IFaceServiceReceiver mFaceServiceReceiver;

        public ServiceListenerImpl(IFaceServiceReceiver receiver) {
            this.mFaceServiceReceiver = receiver;
        }

        @Override
        public void onEnrollResult(BiometricAuthenticator.Identifier identifier, int remaining) throws RemoteException {
            if (this.mFaceServiceReceiver != null) {
                this.mFaceServiceReceiver.onEnrollResult(identifier.getDeviceId(), identifier.getBiometricId(), remaining);
            }
        }

        @Override
        public void onAcquired(long deviceId, int acquiredInfo, int vendorCode) throws RemoteException {
            if (this.mFaceServiceReceiver != null) {
                this.mFaceServiceReceiver.onAcquired(deviceId, acquiredInfo, vendorCode);
            }
        }

        @Override
        public void onAuthenticationSucceeded(long deviceId, BiometricAuthenticator.Identifier biometric, int userId) throws RemoteException {
            if (this.mFaceServiceReceiver != null) {
                if (biometric == null || biometric instanceof Face) {
                    this.mFaceServiceReceiver.onAuthenticationSucceeded(deviceId, (Face)biometric, userId);
                } else {
                    Slog.e(FaceService.TAG, "onAuthenticationSucceeded received non-face biometric");
                }
            }
        }

        @Override
        public void onAuthenticationFailed(long deviceId) throws RemoteException {
            if (this.mFaceServiceReceiver != null) {
                this.mFaceServiceReceiver.onAuthenticationFailed(deviceId);
            }
        }

        @Override
        public void onError(long deviceId, int error, int vendorCode, int cookie) throws RemoteException {
            if (this.mFaceServiceReceiver != null) {
                this.mFaceServiceReceiver.onError(deviceId, error, vendorCode);
            }
        }

        @Override
        public void onRemoved(BiometricAuthenticator.Identifier identifier, int remaining) throws RemoteException {
            if (this.mFaceServiceReceiver != null) {
                this.mFaceServiceReceiver.onRemoved(identifier.getDeviceId(), identifier.getBiometricId(), remaining);
            }
        }

        @Override
        public void onEnumerated(BiometricAuthenticator.Identifier identifier, int remaining) throws RemoteException {
            if (this.mFaceServiceReceiver != null) {
                this.mFaceServiceReceiver.onEnumerated(identifier.getDeviceId(), identifier.getBiometricId(), remaining);
            }
        }
    }

    private class BiometricPromptServiceListenerImpl
    extends BiometricServiceBase.BiometricServiceListener {
        BiometricPromptServiceListenerImpl(IBiometricServiceReceiverInternal wrapperReceiver) {
            super(wrapperReceiver);
        }

        @Override
        public void onAcquired(long deviceId, int acquiredInfo, int vendorCode) throws RemoteException {
            if (this.getWrapperReceiver() != null) {
                this.getWrapperReceiver().onAcquired(FaceManager.getMappedAcquiredInfo(acquiredInfo, vendorCode), FaceManager.getAcquiredString(FaceService.this.getContext(), acquiredInfo, vendorCode));
            }
        }

        @Override
        public void onError(long deviceId, int error, int vendorCode, int cookie) throws RemoteException {
            if (this.getWrapperReceiver() != null) {
                this.getWrapperReceiver().onError(cookie, error, FaceManager.getErrorString(FaceService.this.getContext(), error, vendorCode));
            }
        }
    }

    private final class FaceServiceWrapper
    extends IFaceService.Stub {
        private FaceServiceWrapper() {
        }

        @Override
        public long generateChallenge(IBinder token) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            return FaceService.this.startGenerateChallenge(token);
        }

        @Override
        public int revokeChallenge(IBinder token) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            return FaceService.this.startRevokeChallenge(token);
        }

        @Override
        public void enroll(IBinder token, byte[] cryptoToken, IFaceServiceReceiver receiver, String opPackageName, int[] disabledFeatures) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            boolean restricted = FaceService.this.isRestricted();
            BiometricServiceBase.EnrollClientImpl client = new BiometricServiceBase.EnrollClientImpl(FaceService.this.getContext(), FaceService.this.mDaemonWrapper, FaceService.this.mHalDeviceId, token, (BiometricServiceBase.ServiceListener)new ServiceListenerImpl(receiver), FaceService.this.mCurrentUserId, 0, cryptoToken, restricted, opPackageName, disabledFeatures){

                @Override
                public int[] getAcquireIgnorelist() {
                    return FaceService.this.mEnrollIgnoreList;
                }

                @Override
                public int[] getAcquireVendorIgnorelist() {
                    return FaceService.this.mEnrollIgnoreListVendor;
                }

                @Override
                public boolean shouldVibrate() {
                    return false;
                }

                @Override
                protected int statsModality() {
                    return FaceService.this.statsModality();
                }
            };
            FaceService.this.enrollInternal(client, FaceService.this.mCurrentUserId);
        }

        @Override
        public void cancelEnrollment(IBinder token) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            FaceService.this.cancelEnrollmentInternal(token);
        }

        @Override
        public void authenticate(IBinder token, long opId, int userId, IFaceServiceReceiver receiver, int flags, String opPackageName) {
            FaceService.this.checkPermission("android.permission.USE_BIOMETRIC_INTERNAL");
            FaceService.this.updateActiveGroup(userId, opPackageName);
            boolean restricted = FaceService.this.isRestricted();
            FaceAuthClient client = new FaceAuthClient(FaceService.this.getContext(), FaceService.this.mDaemonWrapper, FaceService.this.mHalDeviceId, token, (BiometricServiceBase.ServiceListener)new ServiceListenerImpl(receiver), FaceService.this.mCurrentUserId, 0, opId, restricted, opPackageName, 0, false);
            FaceService.this.authenticateInternal(client, opId, opPackageName);
        }

        @Override
        public void prepareForAuthentication(boolean requireConfirmation, IBinder token, long opId, int groupId, IBiometricServiceReceiverInternal wrapperReceiver, String opPackageName, int cookie, int callingUid, int callingPid, int callingUserId) {
            FaceService.this.checkPermission("android.permission.USE_BIOMETRIC_INTERNAL");
            FaceService.this.updateActiveGroup(groupId, opPackageName);
            boolean restricted = true;
            FaceAuthClient client = new FaceAuthClient(FaceService.this.getContext(), FaceService.this.mDaemonWrapper, FaceService.this.mHalDeviceId, token, (BiometricServiceBase.ServiceListener)new BiometricPromptServiceListenerImpl(wrapperReceiver), FaceService.this.mCurrentUserId, 0, opId, true, opPackageName, cookie, requireConfirmation);
            FaceService.this.authenticateInternal(client, opId, opPackageName, callingUid, callingPid, callingUserId);
        }

        @Override
        public void startPreparedClient(int cookie) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            FaceService.this.startCurrentClient(cookie);
        }

        @Override
        public void cancelAuthentication(IBinder token, String opPackageName) {
            FaceService.this.checkPermission("android.permission.USE_BIOMETRIC_INTERNAL");
            FaceService.this.cancelAuthenticationInternal(token, opPackageName);
        }

        @Override
        public void cancelAuthenticationFromService(IBinder token, String opPackageName, int callingUid, int callingPid, int callingUserId, boolean fromClient) {
            FaceService.this.checkPermission("android.permission.USE_BIOMETRIC_INTERNAL");
            FaceService.this.cancelAuthenticationInternal(token, opPackageName, callingUid, callingPid, callingUserId, fromClient);
        }

        @Override
        public void setActiveUser(int userId) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            FaceService.this.setActiveUserInternal(userId);
        }

        @Override
        public void remove(IBinder token, int faceId, int userId, IFaceServiceReceiver receiver) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            if (token == null) {
                Slog.w(FaceService.TAG, "remove(): token is null");
                return;
            }
            boolean restricted = FaceService.this.isRestricted();
            RemovalClient client = new RemovalClient(FaceService.this.getContext(), FaceService.this.getConstants(), FaceService.this.mDaemonWrapper, FaceService.this.mHalDeviceId, token, new ServiceListenerImpl(receiver), faceId, 0, userId, restricted, token.toString(), FaceService.this.getBiometricUtils()){

                @Override
                protected int statsModality() {
                    return FaceService.this.statsModality();
                }
            };
            FaceService.this.removeInternal(client);
        }

        @Override
        public void enumerate(IBinder token, int userId, IFaceServiceReceiver receiver) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            boolean restricted = FaceService.this.isRestricted();
            EnumerateClient client = new EnumerateClient(FaceService.this.getContext(), FaceService.this.getConstants(), FaceService.this.mDaemonWrapper, FaceService.this.mHalDeviceId, token, new ServiceListenerImpl(receiver), userId, userId, restricted, FaceService.this.getContext().getOpPackageName()){

                @Override
                protected int statsModality() {
                    return FaceService.this.statsModality();
                }
            };
            FaceService.this.enumerateInternal(client);
        }

        @Override
        public void addLockoutResetCallback(IBiometricServiceLockoutResetCallback callback) throws RemoteException {
            FaceService.this.checkPermission("android.permission.USE_BIOMETRIC_INTERNAL");
            FaceService.super.addLockoutResetCallback(callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(FaceService.this.getContext(), FaceService.TAG, pw)) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                if (args.length > 1 && "--hal".equals(args[0])) {
                    FaceService.this.dumpHal(fd, (String[])Arrays.copyOfRange(args, 1, args.length, args.getClass()));
                } else if (args.length > 0 && "--proto".equals(args[0])) {
                    FaceService.this.dumpProto(fd);
                } else {
                    FaceService.this.dumpInternal(pw);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isHardwareDetected(long deviceId, String opPackageName) {
            FaceService.this.checkPermission("android.permission.USE_BIOMETRIC_INTERNAL");
            if (!FaceService.this.canUseBiometric(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getCallingUserId())) {
                return false;
            }
            long token = Binder.clearCallingIdentity();
            try {
                IBiometricsFace daemon = FaceService.this.getFaceDaemon();
                boolean bl = daemon != null && FaceService.this.mHalDeviceId != 0L;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void rename(final int faceId, final String name) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            if (!FaceService.this.isCurrentUserOrProfile(UserHandle.getCallingUserId())) {
                return;
            }
            FaceService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FaceService.this.getBiometricUtils().renameBiometricForUser(FaceService.this.getContext(), FaceService.this.mCurrentUserId, faceId, name);
                }
            });
        }

        @Override
        public List<Face> getEnrolledFaces(int userId, String opPackageName) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            if (!FaceService.this.canUseBiometric(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getCallingUserId())) {
                return null;
            }
            return FaceService.this.getEnrolledTemplates(userId);
        }

        @Override
        public boolean hasEnrolledFaces(int userId, String opPackageName) {
            FaceService.this.checkPermission("android.permission.USE_BIOMETRIC_INTERNAL");
            if (!FaceService.this.canUseBiometric(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getCallingUserId())) {
                return false;
            }
            return FaceService.this.hasEnrolledBiometrics(userId);
        }

        @Override
        public long getAuthenticatorId(String opPackageName) {
            return FaceService.this.getAuthenticatorId(opPackageName);
        }

        @Override
        public void resetLockout(byte[] token) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            if (!FaceService.this.hasEnrolledBiometrics(FaceService.this.mCurrentUserId)) {
                Slog.w(FaceService.TAG, "Ignoring lockout reset, no templates enrolled");
                return;
            }
            try {
                FaceService.this.mDaemonWrapper.resetLockout(token);
            }
            catch (RemoteException e) {
                Slog.e(FaceService.this.getTag(), "Unable to reset lockout", e);
            }
        }

        @Override
        public void setFeature(int feature, boolean enabled, byte[] token, IFaceServiceReceiver receiver) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            FaceService.this.mHandler.post(() -> {
                if (!FaceService.this.hasEnrolledBiometrics(FaceService.this.mCurrentUserId)) {
                    Slog.e(FaceService.TAG, "No enrolled biometrics while setting feature: " + feature);
                    return;
                }
                ArrayList<Byte> byteToken = new ArrayList<Byte>();
                for (int i = 0; i < token.length; ++i) {
                    byteToken.add(token[i]);
                }
                int faceId = this.getFirstTemplateForUser(FaceService.this.mCurrentUserId);
                if (FaceService.this.mDaemon != null) {
                    try {
                        int result = FaceService.this.mDaemon.setFeature(feature, enabled, byteToken, faceId);
                        receiver.onFeatureSet(result == 0, feature);
                    }
                    catch (RemoteException e) {
                        Slog.e(FaceService.this.getTag(), "Unable to set feature: " + feature + " to enabled:" + enabled, e);
                    }
                }
            });
        }

        @Override
        public void getFeature(int feature, IFaceServiceReceiver receiver) {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            FaceService.this.mHandler.post(() -> {
                if (!FaceService.this.hasEnrolledBiometrics(FaceService.this.mCurrentUserId)) {
                    Slog.e(FaceService.TAG, "No enrolled biometrics while getting feature: " + feature);
                    return;
                }
                int faceId = this.getFirstTemplateForUser(FaceService.this.mCurrentUserId);
                if (FaceService.this.mDaemon != null) {
                    try {
                        OptionalBool result = FaceService.this.mDaemon.getFeature(feature, faceId);
                        receiver.onFeatureGet(result.status == 0, feature, result.value);
                    }
                    catch (RemoteException e) {
                        Slog.e(FaceService.this.getTag(), "Unable to getRequireAttention", e);
                    }
                }
            });
        }

        @Override
        public void userActivity() {
            FaceService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            if (FaceService.this.mDaemon != null) {
                try {
                    FaceService.this.mDaemon.userActivity();
                }
                catch (RemoteException e) {
                    Slog.e(FaceService.this.getTag(), "Unable to send userActivity", e);
                }
            }
        }

        private int getFirstTemplateForUser(int user) {
            List<Face> faces = FaceService.this.getEnrolledTemplates(user);
            if (!faces.isEmpty()) {
                return faces.get(0).getBiometricId();
            }
            return 0;
        }
    }

    private final class FaceAuthClient
    extends BiometricServiceBase.AuthenticationClientImpl {
        private int mLastAcquire;

        public FaceAuthClient(Context context, BiometricServiceBase.DaemonWrapper daemon, long halDeviceId, IBinder token, BiometricServiceBase.ServiceListener listener, int targetUserId, int groupId, long opId, boolean restricted, String owner, int cookie, boolean requireConfirmation) {
            super(context, daemon, halDeviceId, token, listener, targetUserId, groupId, opId, restricted, owner, cookie, requireConfirmation);
        }

        @Override
        protected int statsModality() {
            return FaceService.this.statsModality();
        }

        @Override
        public boolean shouldFrameworkHandleLockout() {
            return false;
        }

        @Override
        public boolean wasUserDetected() {
            return this.mLastAcquire != 11;
        }

        @Override
        public boolean onAuthenticated(BiometricAuthenticator.Identifier identifier, boolean authenticated, ArrayList<Byte> token) {
            boolean result = super.onAuthenticated(identifier, authenticated, token);
            return result || !authenticated;
        }

        @Override
        public int[] getAcquireIgnorelist() {
            if (this.isBiometricPrompt()) {
                return FaceService.this.mBiometricPromptIgnoreList;
            }
            return FaceService.this.mKeyguardIgnoreList;
        }

        @Override
        public int[] getAcquireVendorIgnorelist() {
            if (this.isBiometricPrompt()) {
                return FaceService.this.mBiometricPromptIgnoreListVendor;
            }
            return FaceService.this.mKeyguardIgnoreListVendor;
        }

        @Override
        public boolean onAcquired(int acquireInfo, int vendorCode) {
            this.mLastAcquire = acquireInfo;
            if (acquireInfo == 13) {
                String name = this.getContext().getString(17039989);
                String title = this.getContext().getString(17039990);
                String content = this.getContext().getString(17039988);
                Intent intent = new Intent("android.settings.FACE_SETTINGS");
                intent.setPackage("com.android.settings");
                PendingIntent pendingIntent = PendingIntent.getActivityAsUser(this.getContext(), 0, intent, 0, null, UserHandle.CURRENT);
                String id2 = FaceService.TAG;
                NotificationManager nm = this.getContext().getSystemService(NotificationManager.class);
                NotificationChannel channel = new NotificationChannel(FaceService.TAG, name, 4);
                Notification notification = new Notification.Builder(this.getContext(), FaceService.TAG).setSmallIcon(17302445).setContentTitle(title).setContentText(content).setSubText(name).setOnlyAlertOnce(true).setLocalOnly(true).setAutoCancel(true).setCategory("sys").setContentIntent(pendingIntent).build();
                nm.createNotificationChannel(channel);
                nm.notifyAsUser(null, 0, notification, UserHandle.CURRENT);
            }
            return super.onAcquired(acquireInfo, vendorCode);
        }
    }
}

