/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics.face;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.face.Face;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.server.biometrics.BiometricUserState;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class FaceUserState
extends BiometricUserState {
    private static final String TAG = "FaceState";
    private static final String FACE_FILE = "settings_face.xml";
    private static final String TAG_FACES = "faces";
    private static final String TAG_FACE = "face";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FACE_ID = "faceId";
    private static final String ATTR_DEVICE_ID = "deviceId";

    public FaceUserState(Context ctx, int userId) {
        super(ctx, userId);
    }

    @Override
    protected String getBiometricsTag() {
        return TAG_FACES;
    }

    @Override
    protected String getBiometricFile() {
        return FACE_FILE;
    }

    @Override
    protected int getNameTemplateResource() {
        return 17039987;
    }

    public void addBiometric(BiometricAuthenticator.Identifier identifier) {
        if (identifier instanceof Face) {
            super.addBiometric(identifier);
        } else {
            Slog.w(TAG, "Attempted to add non-face identifier");
        }
    }

    protected ArrayList getCopy(ArrayList array2) {
        ArrayList<Face> result = new ArrayList<Face>(array2.size());
        for (int i = 0; i < array2.size(); ++i) {
            Face f = (Face)array2.get(i);
            result.add(new Face(f.getName(), f.getBiometricId(), f.getDeviceId()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWriteState() {
        ArrayList faces;
        AtomicFile destination = new AtomicFile(this.mFile);
        FaceUserState faceUserState = this;
        synchronized (faceUserState) {
            faces = this.getCopy(this.mBiometrics);
        }
        FileOutputStream out = null;
        try {
            out = destination.startWrite();
            XmlSerializer serializer = Xml.newSerializer();
            serializer.setOutput(out, "utf-8");
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_FACES);
            int count = faces.size();
            for (int i = 0; i < count; ++i) {
                Face f = (Face)faces.get(i);
                serializer.startTag(null, TAG_FACE);
                serializer.attribute(null, ATTR_FACE_ID, Integer.toString(f.getBiometricId()));
                serializer.attribute(null, ATTR_NAME, f.getName().toString());
                serializer.attribute(null, ATTR_DEVICE_ID, Long.toString(f.getDeviceId()));
                serializer.endTag(null, TAG_FACE);
            }
            serializer.endTag(null, TAG_FACES);
            serializer.endDocument();
            destination.finishWrite(out);
        }
        catch (Throwable t) {
            Slog.wtf(TAG, "Failed to write settings, restoring backup", t);
            destination.failWrite(out);
            throw new IllegalStateException("Failed to write faces", t);
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    @Override
    @GuardedBy(value={"this"})
    protected void parseBiometricsLocked(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3 || type == 4 || !(tagName = parser.getName()).equals(TAG_FACE)) continue;
            String name = parser.getAttributeValue(null, ATTR_NAME);
            String faceId = parser.getAttributeValue(null, ATTR_FACE_ID);
            String deviceId = parser.getAttributeValue(null, ATTR_DEVICE_ID);
            this.mBiometrics.add(new Face(name, Integer.parseInt(faceId), Integer.parseInt(deviceId)));
        }
    }
}

