/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics.face;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.face.Face;
import android.text.TextUtils;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.server.biometrics.BiometricUtils;
import com.android.server.biometrics.face.FaceUserState;
import java.util.List;

public class FaceUtils
implements BiometricUtils {
    private static final Object sInstanceLock = new Object();
    private static FaceUtils sInstance;
    @GuardedBy(value={"this"})
    private final SparseArray<FaceUserState> mUsers = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FaceUtils getInstance() {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new FaceUtils();
            }
        }
        return sInstance;
    }

    private FaceUtils() {
    }

    public List<Face> getBiometricsForUser(Context ctx, int userId) {
        return this.getStateForUser(ctx, userId).getBiometrics();
    }

    public void addBiometricForUser(Context ctx, int userId, BiometricAuthenticator.Identifier identifier) {
        this.getStateForUser(ctx, userId).addBiometric(identifier);
    }

    @Override
    public void removeBiometricForUser(Context ctx, int userId, int faceId) {
        this.getStateForUser(ctx, userId).removeBiometric(faceId);
    }

    @Override
    public void renameBiometricForUser(Context ctx, int userId, int faceId, CharSequence name) {
        if (TextUtils.isEmpty(name)) {
            return;
        }
        this.getStateForUser(ctx, userId).renameBiometric(faceId, name);
    }

    @Override
    public CharSequence getUniqueName(Context context, int userId) {
        return this.getStateForUser(context, userId).getUniqueName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FaceUserState getStateForUser(Context ctx, int userId) {
        FaceUtils faceUtils = this;
        synchronized (faceUtils) {
            FaceUserState state = this.mUsers.get(userId);
            if (state == null) {
                state = new FaceUserState(ctx, userId);
                this.mUsers.put(userId, state);
            }
            return state;
        }
    }
}

