/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics.fingerprint;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.UserInfo;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.biometrics.IBiometricServiceReceiverInternal;
import android.hardware.biometrics.fingerprint.V2_1.IBiometricsFingerprint;
import android.hardware.biometrics.fingerprint.V2_1.IBiometricsFingerprintClientCallback;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.FingerprintManager;
import android.hardware.fingerprint.IFingerprintClientActiveCallback;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemServerInitThreadPool;
import com.android.server.biometrics.BiometricServiceBase;
import com.android.server.biometrics.BiometricUtils;
import com.android.server.biometrics.ClientMonitor;
import com.android.server.biometrics.Constants;
import com.android.server.biometrics.EnumerateClient;
import com.android.server.biometrics.RemovalClient;
import com.android.server.biometrics.fingerprint.FingerprintConstants;
import com.android.server.biometrics.fingerprint.FingerprintUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FingerprintService
extends BiometricServiceBase {
    protected static final String TAG = "FingerprintService";
    private static final boolean DEBUG = true;
    private static final String FP_DATA_DIR = "fpdata";
    private static final String ACTION_LOCKOUT_RESET = "com.android.server.biometrics.fingerprint.ACTION_LOCKOUT_RESET";
    private static final int MAX_FAILED_ATTEMPTS_LOCKOUT_TIMED = 5;
    private static final int MAX_FAILED_ATTEMPTS_LOCKOUT_PERMANENT = 20;
    private static final long FAIL_LOCKOUT_TIMEOUT_MS = 30000L;
    private static final String KEY_LOCKOUT_RESET_USER = "lockout_reset_user";
    private final FingerprintConstants mFingerprintConstants = new FingerprintConstants();
    private final CopyOnWriteArrayList<IFingerprintClientActiveCallback> mClientActiveCallbacks = new CopyOnWriteArrayList();
    @GuardedBy(value={"this"})
    private IBiometricsFingerprint mDaemon;
    private final SparseBooleanArray mTimedLockoutCleared;
    private final SparseIntArray mFailedAttempts;
    private final AlarmManager mAlarmManager;
    private final LockoutReceiver mLockoutReceiver = new LockoutReceiver();
    protected final ResetFailedAttemptsForUserRunnable mResetFailedAttemptsForCurrentUserRunnable = new ResetFailedAttemptsForUserRunnable();
    private IBiometricsFingerprintClientCallback mDaemonCallback = new IBiometricsFingerprintClientCallback.Stub(){

        @Override
        public void onEnrollResult(long deviceId, int fingerId, int groupId, int remaining) {
            FingerprintService.this.mHandler.post(() -> {
                Fingerprint fingerprint = new Fingerprint(FingerprintService.this.getBiometricUtils().getUniqueName(FingerprintService.this.getContext(), groupId), groupId, fingerId, deviceId);
                FingerprintService.super.handleEnrollResult(fingerprint, remaining);
            });
        }

        @Override
        public void onAcquired(long deviceId, int acquiredInfo, int vendorCode) {
            FingerprintService.this.mHandler.post(() -> FingerprintService.super.handleAcquired(deviceId, acquiredInfo, vendorCode));
        }

        @Override
        public void onAuthenticated(long deviceId, int fingerId, int groupId, ArrayList<Byte> token) {
            FingerprintService.this.mHandler.post(() -> {
                Fingerprint fp = new Fingerprint("", groupId, fingerId, deviceId);
                FingerprintService.super.handleAuthenticated(fp, token);
            });
        }

        @Override
        public void onError(long deviceId, int error, int vendorCode) {
            FingerprintService.this.mHandler.post(() -> {
                FingerprintService.super.handleError(deviceId, error, vendorCode);
                if (error == 1) {
                    Slog.w(FingerprintService.TAG, "Got ERROR_HW_UNAVAILABLE; try reconnecting next client.");
                    1 var5_4 = this;
                    synchronized (var5_4) {
                        FingerprintService.this.mDaemon = null;
                        FingerprintService.this.mHalDeviceId = 0L;
                        FingerprintService.this.mCurrentUserId = -10000;
                    }
                }
            });
        }

        @Override
        public void onRemoved(long deviceId, int fingerId, int groupId, int remaining) {
            FingerprintService.this.mHandler.post(() -> {
                ClientMonitor client = FingerprintService.this.getCurrentClient();
                Fingerprint fp = new Fingerprint("", groupId, fingerId, deviceId);
                FingerprintService.super.handleRemoved(fp, remaining);
            });
        }

        @Override
        public void onEnumerate(long deviceId, int fingerId, int groupId, int remaining) {
            FingerprintService.this.mHandler.post(() -> {
                Fingerprint fp = new Fingerprint("", groupId, fingerId, deviceId);
                FingerprintService.super.handleEnumerate(fp, remaining);
            });
        }
    };
    private final BiometricServiceBase.DaemonWrapper mDaemonWrapper = new BiometricServiceBase.DaemonWrapper(){

        @Override
        public int authenticate(long operationId, int groupId) throws RemoteException {
            IBiometricsFingerprint daemon = FingerprintService.this.getFingerprintDaemon();
            if (daemon == null) {
                Slog.w(FingerprintService.TAG, "authenticate(): no fingerprint HAL!");
                return 3;
            }
            return daemon.authenticate(operationId, groupId);
        }

        @Override
        public int cancel() throws RemoteException {
            IBiometricsFingerprint daemon = FingerprintService.this.getFingerprintDaemon();
            if (daemon == null) {
                Slog.w(FingerprintService.TAG, "cancel(): no fingerprint HAL!");
                return 3;
            }
            return daemon.cancel();
        }

        @Override
        public int remove(int groupId, int biometricId) throws RemoteException {
            IBiometricsFingerprint daemon = FingerprintService.this.getFingerprintDaemon();
            if (daemon == null) {
                Slog.w(FingerprintService.TAG, "remove(): no fingerprint HAL!");
                return 3;
            }
            return daemon.remove(groupId, biometricId);
        }

        @Override
        public int enumerate() throws RemoteException {
            IBiometricsFingerprint daemon = FingerprintService.this.getFingerprintDaemon();
            if (daemon == null) {
                Slog.w(FingerprintService.TAG, "enumerate(): no fingerprint HAL!");
                return 3;
            }
            return daemon.enumerate();
        }

        @Override
        public int enroll(byte[] cryptoToken, int groupId, int timeout, ArrayList<Integer> disabledFeatures) throws RemoteException {
            IBiometricsFingerprint daemon = FingerprintService.this.getFingerprintDaemon();
            if (daemon == null) {
                Slog.w(FingerprintService.TAG, "enroll(): no fingerprint HAL!");
                return 3;
            }
            return daemon.enroll(cryptoToken, groupId, timeout);
        }

        @Override
        public void resetLockout(byte[] token) throws RemoteException {
            Slog.e(FingerprintService.TAG, "Not supported");
        }
    };

    public FingerprintService(Context context) {
        super(context);
        this.mTimedLockoutCleared = new SparseBooleanArray();
        this.mFailedAttempts = new SparseIntArray();
        this.mAlarmManager = context.getSystemService(AlarmManager.class);
        context.registerReceiver(this.mLockoutReceiver, new IntentFilter(this.getLockoutResetIntent()), this.getLockoutBroadcastPermission(), null);
    }

    @Override
    public void onStart() {
        super.onStart();
        this.publishBinderService("fingerprint", new FingerprintServiceWrapper());
        SystemServerInitThreadPool.get().submit(this::getFingerprintDaemon, "FingerprintService.onStart");
    }

    @Override
    protected String getTag() {
        return TAG;
    }

    @Override
    protected BiometricServiceBase.DaemonWrapper getDaemonWrapper() {
        return this.mDaemonWrapper;
    }

    @Override
    protected BiometricUtils getBiometricUtils() {
        return FingerprintUtils.getInstance();
    }

    @Override
    protected Constants getConstants() {
        return this.mFingerprintConstants;
    }

    @Override
    protected boolean hasReachedEnrollmentLimit(int userId) {
        int limit = this.getContext().getResources().getInteger(17694811);
        int enrolled = this.getEnrolledTemplates(userId).size();
        if (enrolled >= limit) {
            Slog.w(TAG, "Too many fingerprints registered");
            return true;
        }
        return false;
    }

    @Override
    public void serviceDied(long cookie) {
        super.serviceDied(cookie);
        this.mDaemon = null;
    }

    @Override
    protected void updateActiveGroup(int userId, String clientPackage) {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon != null) {
            try {
                userId = this.getUserOrWorkProfileId(clientPackage, userId);
                if (userId != this.mCurrentUserId) {
                    File baseDir;
                    File fpDir;
                    int firstSdkInt = Build.VERSION.FIRST_SDK_INT;
                    if (firstSdkInt < 1) {
                        Slog.e(TAG, "First SDK version " + firstSdkInt + " is invalid; must be at least VERSION_CODES.BASE");
                    }
                    if (!(fpDir = new File(baseDir = firstSdkInt <= 27 ? Environment.getUserSystemDirectory(userId) : Environment.getDataVendorDeDirectory(userId), FP_DATA_DIR)).exists()) {
                        if (!fpDir.mkdir()) {
                            Slog.v(TAG, "Cannot make directory: " + fpDir.getAbsolutePath());
                            return;
                        }
                        if (!SELinux.restorecon(fpDir)) {
                            Slog.w(TAG, "Restorecons failed. Directory will have wrong label.");
                            return;
                        }
                    }
                    daemon.setActiveGroup(userId, fpDir.getAbsolutePath());
                    this.mCurrentUserId = userId;
                }
                this.mAuthenticatorIds.put(userId, this.hasEnrolledBiometrics(userId) ? daemon.getAuthenticatorId() : 0L);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to setActiveGroup():", e);
            }
        }
    }

    @Override
    protected String getLockoutResetIntent() {
        return ACTION_LOCKOUT_RESET;
    }

    @Override
    protected String getLockoutBroadcastPermission() {
        return "android.permission.RESET_FINGERPRINT_LOCKOUT";
    }

    @Override
    protected long getHalDeviceId() {
        return this.mHalDeviceId;
    }

    @Override
    protected boolean hasEnrolledBiometrics(int userId) {
        if (userId != UserHandle.getCallingUserId()) {
            this.checkPermission("android.permission.INTERACT_ACROSS_USERS");
        }
        return this.getBiometricUtils().getBiometricsForUser(this.getContext(), userId).size() > 0;
    }

    @Override
    protected String getManageBiometricPermission() {
        return "android.permission.MANAGE_FINGERPRINT";
    }

    @Override
    protected void checkUseBiometricPermission() {
        if (this.getContext().checkCallingPermission("android.permission.USE_FINGERPRINT") != 0) {
            this.checkPermission("android.permission.USE_BIOMETRIC");
        }
    }

    @Override
    protected boolean checkAppOps(int uid, String opPackageName) {
        boolean appOpsOk = false;
        if (this.mAppOps.noteOp(78, uid, opPackageName) == 0) {
            appOpsOk = true;
        } else if (this.mAppOps.noteOp(55, uid, opPackageName) == 0) {
            appOpsOk = true;
        }
        return appOpsOk;
    }

    protected List<Fingerprint> getEnrolledTemplates(int userId) {
        if (userId != UserHandle.getCallingUserId()) {
            this.checkPermission("android.permission.INTERACT_ACROSS_USERS");
        }
        return this.getBiometricUtils().getBiometricsForUser(this.getContext(), userId);
    }

    @Override
    protected void notifyClientActiveCallbacks(boolean isActive) {
        CopyOnWriteArrayList<IFingerprintClientActiveCallback> callbacks = this.mClientActiveCallbacks;
        for (int i = 0; i < callbacks.size(); ++i) {
            try {
                ((IFingerprintClientActiveCallback)callbacks.get(i)).onClientActiveChanged(isActive);
                continue;
            }
            catch (RemoteException re) {
                this.mClientActiveCallbacks.remove(callbacks.get(i));
            }
        }
    }

    @Override
    protected int statsModality() {
        return 1;
    }

    @Override
    protected int getLockoutMode() {
        int currentUser = ActivityManager.getCurrentUser();
        int failedAttempts = this.mFailedAttempts.get(currentUser, 0);
        if (failedAttempts >= 20) {
            return 2;
        }
        if (failedAttempts > 0 && !this.mTimedLockoutCleared.get(currentUser, false) && failedAttempts % 5 == 0) {
            return 1;
        }
        return 0;
    }

    private synchronized IBiometricsFingerprint getFingerprintDaemon() {
        if (this.mDaemon == null) {
            Slog.v(TAG, "mDaemon was null, reconnect to fingerprint");
            try {
                this.mDaemon = IBiometricsFingerprint.getService();
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to get biometric interface", e);
            }
            if (this.mDaemon == null) {
                Slog.w(TAG, "fingerprint HIDL not available");
                return null;
            }
            this.mDaemon.asBinder().linkToDeath(this, 0L);
            try {
                this.mHalDeviceId = this.mDaemon.setNotify(this.mDaemonCallback);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to open fingerprint HAL", e);
                this.mDaemon = null;
            }
            Slog.v(TAG, "Fingerprint HAL id: " + this.mHalDeviceId);
            if (this.mHalDeviceId != 0L) {
                this.loadAuthenticatorIds();
                this.updateActiveGroup(ActivityManager.getCurrentUser(), null);
                this.doTemplateCleanupForUser(ActivityManager.getCurrentUser());
            } else {
                Slog.w(TAG, "Failed to open Fingerprint HAL!");
                MetricsLogger.count(this.getContext(), "fingerprintd_openhal_error", 1);
                this.mDaemon = null;
            }
        }
        return this.mDaemon;
    }

    private long startPreEnroll(IBinder token) {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startPreEnroll: no fingerprint HAL!");
            return 0L;
        }
        try {
            return daemon.preEnroll();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startPreEnroll failed", e);
            return 0L;
        }
    }

    private int startPostEnroll(IBinder token) {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startPostEnroll: no fingerprint HAL!");
            return 0;
        }
        try {
            return daemon.postEnroll();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startPostEnroll failed", e);
            return 0;
        }
    }

    private void resetFailedAttemptsForUser(boolean clearAttemptCounter, int userId) {
        if (this.getLockoutMode() != 0) {
            Slog.v(this.getTag(), "Reset biometric lockout, clearAttemptCounter=" + clearAttemptCounter);
        }
        if (clearAttemptCounter) {
            this.mFailedAttempts.put(userId, 0);
        }
        this.mTimedLockoutCleared.put(userId, true);
        this.cancelLockoutResetForUser(userId);
        this.notifyLockoutResetMonitors();
    }

    private void cancelLockoutResetForUser(int userId) {
        this.mAlarmManager.cancel(this.getLockoutResetIntentForUser(userId));
    }

    private void scheduleLockoutResetForUser(int userId) {
        this.mAlarmManager.setExact(2, SystemClock.elapsedRealtime() + 30000L, this.getLockoutResetIntentForUser(userId));
    }

    private PendingIntent getLockoutResetIntentForUser(int userId) {
        return PendingIntent.getBroadcast(this.getContext(), userId, new Intent(this.getLockoutResetIntent()).putExtra(KEY_LOCKOUT_RESET_USER, userId), 0x8000000);
    }

    private void dumpInternal(PrintWriter pw) {
        JSONObject dump = new JSONObject();
        try {
            dump.put("service", "Fingerprint Manager");
            JSONArray sets = new JSONArray();
            for (UserInfo user : UserManager.get(this.getContext()).getUsers()) {
                int userId = user.getUserHandle().getIdentifier();
                int N = this.getBiometricUtils().getBiometricsForUser(this.getContext(), userId).size();
                BiometricServiceBase.PerformanceStats stats = (BiometricServiceBase.PerformanceStats)this.mPerformanceMap.get(userId);
                BiometricServiceBase.PerformanceStats cryptoStats = (BiometricServiceBase.PerformanceStats)this.mCryptoPerformanceMap.get(userId);
                JSONObject set = new JSONObject();
                set.put("id", userId);
                set.put("count", N);
                set.put("accept", stats != null ? stats.accept : 0);
                set.put("reject", stats != null ? stats.reject : 0);
                set.put("acquire", stats != null ? stats.acquire : 0);
                set.put("lockout", stats != null ? stats.lockout : 0);
                set.put("permanentLockout", stats != null ? stats.permanentLockout : 0);
                set.put("acceptCrypto", cryptoStats != null ? cryptoStats.accept : 0);
                set.put("rejectCrypto", cryptoStats != null ? cryptoStats.reject : 0);
                set.put("acquireCrypto", cryptoStats != null ? cryptoStats.acquire : 0);
                set.put("lockoutCrypto", cryptoStats != null ? cryptoStats.lockout : 0);
                set.put("permanentLockoutCrypto", cryptoStats != null ? cryptoStats.permanentLockout : 0);
                sets.put(set);
            }
            dump.put("prints", sets);
        }
        catch (JSONException e) {
            Slog.e(TAG, "dump formatting failure", e);
        }
        pw.println(dump);
        pw.println("HAL Deaths: " + this.mHALDeathCount);
        this.mHALDeathCount = 0;
    }

    private void dumpProto(FileDescriptor fd) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        for (UserInfo user : UserManager.get(this.getContext()).getUsers()) {
            BiometricServiceBase.PerformanceStats crypto;
            int userId = user.getUserHandle().getIdentifier();
            long userToken = proto.start(2246267895809L);
            proto.write(0x10500000001L, userId);
            proto.write(1120986464258L, this.getBiometricUtils().getBiometricsForUser(this.getContext(), userId).size());
            BiometricServiceBase.PerformanceStats normal = (BiometricServiceBase.PerformanceStats)this.mPerformanceMap.get(userId);
            if (normal != null) {
                long countsToken = proto.start(1146756268035L);
                proto.write(0x10500000001L, normal.accept);
                proto.write(1120986464258L, normal.reject);
                proto.write(1120986464259L, normal.acquire);
                proto.write(1120986464260L, normal.lockout);
                proto.write(0x10500000005L, normal.permanentLockout);
                proto.end(countsToken);
            }
            if ((crypto = (BiometricServiceBase.PerformanceStats)this.mCryptoPerformanceMap.get(userId)) != null) {
                long countsToken = proto.start(1146756268036L);
                proto.write(0x10500000001L, crypto.accept);
                proto.write(1120986464258L, crypto.reject);
                proto.write(1120986464259L, crypto.acquire);
                proto.write(1120986464260L, crypto.lockout);
                proto.write(0x10500000005L, crypto.permanentLockout);
                proto.end(countsToken);
            }
            proto.end(userToken);
        }
        proto.flush();
        this.mPerformanceMap.clear();
        this.mCryptoPerformanceMap.clear();
    }

    private class ServiceListenerImpl
    implements BiometricServiceBase.ServiceListener {
        private IFingerprintServiceReceiver mFingerprintServiceReceiver;

        public ServiceListenerImpl(IFingerprintServiceReceiver receiver) {
            this.mFingerprintServiceReceiver = receiver;
        }

        @Override
        public void onEnrollResult(BiometricAuthenticator.Identifier identifier, int remaining) throws RemoteException {
            if (this.mFingerprintServiceReceiver != null) {
                Fingerprint fp = (Fingerprint)identifier;
                this.mFingerprintServiceReceiver.onEnrollResult(fp.getDeviceId(), fp.getBiometricId(), fp.getGroupId(), remaining);
            }
        }

        @Override
        public void onAcquired(long deviceId, int acquiredInfo, int vendorCode) throws RemoteException {
            if (this.mFingerprintServiceReceiver != null) {
                this.mFingerprintServiceReceiver.onAcquired(deviceId, acquiredInfo, vendorCode);
            }
        }

        @Override
        public void onAuthenticationSucceeded(long deviceId, BiometricAuthenticator.Identifier biometric, int userId) throws RemoteException {
            if (this.mFingerprintServiceReceiver != null) {
                if (biometric == null || biometric instanceof Fingerprint) {
                    this.mFingerprintServiceReceiver.onAuthenticationSucceeded(deviceId, (Fingerprint)biometric, userId);
                } else {
                    Slog.e(FingerprintService.TAG, "onAuthenticationSucceeded received non-fingerprint biometric");
                }
            }
        }

        @Override
        public void onAuthenticationFailed(long deviceId) throws RemoteException {
            if (this.mFingerprintServiceReceiver != null) {
                this.mFingerprintServiceReceiver.onAuthenticationFailed(deviceId);
            }
        }

        @Override
        public void onError(long deviceId, int error, int vendorCode, int cookie) throws RemoteException {
            if (this.mFingerprintServiceReceiver != null) {
                this.mFingerprintServiceReceiver.onError(deviceId, error, vendorCode);
            }
        }

        @Override
        public void onRemoved(BiometricAuthenticator.Identifier identifier, int remaining) throws RemoteException {
            if (this.mFingerprintServiceReceiver != null) {
                Fingerprint fp = (Fingerprint)identifier;
                this.mFingerprintServiceReceiver.onRemoved(fp.getDeviceId(), fp.getBiometricId(), fp.getGroupId(), remaining);
            }
        }

        @Override
        public void onEnumerated(BiometricAuthenticator.Identifier identifier, int remaining) throws RemoteException {
            if (this.mFingerprintServiceReceiver != null) {
                Fingerprint fp = (Fingerprint)identifier;
                this.mFingerprintServiceReceiver.onEnumerated(fp.getDeviceId(), fp.getBiometricId(), fp.getGroupId(), remaining);
            }
        }
    }

    private class BiometricPromptServiceListenerImpl
    extends BiometricServiceBase.BiometricServiceListener {
        BiometricPromptServiceListenerImpl(IBiometricServiceReceiverInternal wrapperReceiver) {
            super(wrapperReceiver);
        }

        @Override
        public void onAcquired(long deviceId, int acquiredInfo, int vendorCode) throws RemoteException {
            if (this.getWrapperReceiver() != null) {
                this.getWrapperReceiver().onAcquired(acquiredInfo, FingerprintManager.getAcquiredString(FingerprintService.this.getContext(), acquiredInfo, vendorCode));
            }
        }

        @Override
        public void onError(long deviceId, int error, int vendorCode, int cookie) throws RemoteException {
            if (this.getWrapperReceiver() != null) {
                this.getWrapperReceiver().onError(cookie, error, FingerprintManager.getErrorString(FingerprintService.this.getContext(), error, vendorCode));
            }
        }
    }

    private final class FingerprintServiceWrapper
    extends IFingerprintService.Stub {
        private FingerprintServiceWrapper() {
        }

        @Override
        public long preEnroll(IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            return FingerprintService.this.startPreEnroll(token);
        }

        @Override
        public int postEnroll(IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            return FingerprintService.this.startPostEnroll(token);
        }

        @Override
        public void enroll(IBinder token, byte[] cryptoToken, int userId, IFingerprintServiceReceiver receiver, int flags, String opPackageName) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            boolean restricted = FingerprintService.this.isRestricted();
            int groupId = userId;
            BiometricServiceBase.EnrollClientImpl client = new BiometricServiceBase.EnrollClientImpl(FingerprintService.this.getContext(), FingerprintService.this.mDaemonWrapper, FingerprintService.this.mHalDeviceId, token, (BiometricServiceBase.ServiceListener)new ServiceListenerImpl(receiver), FingerprintService.this.mCurrentUserId, groupId, cryptoToken, restricted, opPackageName, new int[0]){

                @Override
                public boolean shouldVibrate() {
                    return true;
                }

                @Override
                protected int statsModality() {
                    return FingerprintService.this.statsModality();
                }
            };
            FingerprintService.this.enrollInternal(client, userId);
        }

        @Override
        public void cancelEnrollment(IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.cancelEnrollmentInternal(token);
        }

        @Override
        public void authenticate(IBinder token, long opId, int groupId, IFingerprintServiceReceiver receiver, int flags, String opPackageName) {
            FingerprintService.this.updateActiveGroup(groupId, opPackageName);
            boolean restricted = FingerprintService.this.isRestricted();
            FingerprintAuthClient client = new FingerprintAuthClient(FingerprintService.this.getContext(), FingerprintService.this.mDaemonWrapper, FingerprintService.this.mHalDeviceId, token, (BiometricServiceBase.ServiceListener)new ServiceListenerImpl(receiver), FingerprintService.this.mCurrentUserId, groupId, opId, restricted, opPackageName, 0, false);
            FingerprintService.this.authenticateInternal(client, opId, opPackageName);
        }

        @Override
        public void prepareForAuthentication(IBinder token, long opId, int groupId, IBiometricServiceReceiverInternal wrapperReceiver, String opPackageName, int cookie, int callingUid, int callingPid, int callingUserId) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            FingerprintService.this.updateActiveGroup(groupId, opPackageName);
            boolean restricted = true;
            FingerprintAuthClient client = new FingerprintAuthClient(FingerprintService.this.getContext(), FingerprintService.this.mDaemonWrapper, FingerprintService.this.mHalDeviceId, token, (BiometricServiceBase.ServiceListener)new BiometricPromptServiceListenerImpl(wrapperReceiver), FingerprintService.this.mCurrentUserId, groupId, opId, true, opPackageName, cookie, false);
            FingerprintService.this.authenticateInternal(client, opId, opPackageName, callingUid, callingPid, callingUserId);
        }

        @Override
        public void startPreparedClient(int cookie) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            FingerprintService.this.startCurrentClient(cookie);
        }

        @Override
        public void cancelAuthentication(IBinder token, String opPackageName) {
            FingerprintService.this.cancelAuthenticationInternal(token, opPackageName);
        }

        @Override
        public void cancelAuthenticationFromService(IBinder token, String opPackageName, int callingUid, int callingPid, int callingUserId, boolean fromClient) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_BIOMETRIC");
            FingerprintService.this.cancelAuthenticationInternal(token, opPackageName, callingUid, callingPid, callingUserId, fromClient);
        }

        @Override
        public void setActiveUser(int userId) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.setActiveUserInternal(userId);
        }

        @Override
        public void remove(IBinder token, int fingerId, int groupId, int userId, IFingerprintServiceReceiver receiver) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            if (token == null) {
                Slog.w(FingerprintService.TAG, "remove(): token is null");
                return;
            }
            boolean restricted = FingerprintService.this.isRestricted();
            RemovalClient client = new RemovalClient(FingerprintService.this.getContext(), FingerprintService.this.getConstants(), FingerprintService.this.mDaemonWrapper, FingerprintService.this.mHalDeviceId, token, new ServiceListenerImpl(receiver), fingerId, groupId, userId, restricted, token.toString(), FingerprintService.this.getBiometricUtils()){

                @Override
                protected int statsModality() {
                    return FingerprintService.this.statsModality();
                }
            };
            FingerprintService.this.removeInternal(client);
        }

        @Override
        public void enumerate(IBinder token, int userId, IFingerprintServiceReceiver receiver) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            boolean restricted = FingerprintService.this.isRestricted();
            EnumerateClient client = new EnumerateClient(FingerprintService.this.getContext(), FingerprintService.this.getConstants(), FingerprintService.this.mDaemonWrapper, FingerprintService.this.mHalDeviceId, token, new ServiceListenerImpl(receiver), userId, userId, restricted, FingerprintService.this.getContext().getOpPackageName()){

                @Override
                protected int statsModality() {
                    return FingerprintService.this.statsModality();
                }
            };
            FingerprintService.this.enumerateInternal(client);
        }

        @Override
        public void addLockoutResetCallback(IBiometricServiceLockoutResetCallback callback) throws RemoteException {
            FingerprintService.super.addLockoutResetCallback(callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(FingerprintService.this.getContext(), FingerprintService.TAG, pw)) {
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                if (args.length > 0 && "--proto".equals(args[0])) {
                    FingerprintService.this.dumpProto(fd);
                } else {
                    FingerprintService.this.dumpInternal(pw);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isHardwareDetected(long deviceId, String opPackageName) {
            if (!FingerprintService.this.canUseBiometric(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getCallingUserId())) {
                return false;
            }
            long token = Binder.clearCallingIdentity();
            try {
                IBiometricsFingerprint daemon = FingerprintService.this.getFingerprintDaemon();
                boolean bl = daemon != null && FingerprintService.this.mHalDeviceId != 0L;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void rename(final int fingerId, final int groupId, final String name) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            if (!FingerprintService.this.isCurrentUserOrProfile(groupId)) {
                return;
            }
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.getBiometricUtils().renameBiometricForUser(FingerprintService.this.getContext(), groupId, fingerId, name);
                }
            });
        }

        @Override
        public List<Fingerprint> getEnrolledFingerprints(int userId, String opPackageName) {
            if (!FingerprintService.this.canUseBiometric(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getCallingUserId())) {
                return Collections.emptyList();
            }
            return FingerprintService.this.getEnrolledTemplates(userId);
        }

        @Override
        public boolean hasEnrolledFingerprints(int userId, String opPackageName) {
            if (!FingerprintService.this.canUseBiometric(opPackageName, false, Binder.getCallingUid(), Binder.getCallingPid(), UserHandle.getCallingUserId())) {
                return false;
            }
            return FingerprintService.this.hasEnrolledBiometrics(userId);
        }

        @Override
        public long getAuthenticatorId(String opPackageName) {
            return FingerprintService.super.getAuthenticatorId(opPackageName);
        }

        @Override
        public void resetTimeout(byte[] token) {
            FingerprintService.this.checkPermission("android.permission.RESET_FINGERPRINT_LOCKOUT");
            if (!FingerprintService.this.hasEnrolledBiometrics(FingerprintService.this.mCurrentUserId)) {
                Slog.w(FingerprintService.TAG, "Ignoring lockout reset, no templates enrolled");
                return;
            }
            FingerprintService.this.mHandler.post(FingerprintService.this.mResetFailedAttemptsForCurrentUserRunnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isClientActive() {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService fingerprintService = FingerprintService.this;
            synchronized (fingerprintService) {
                return FingerprintService.this.getCurrentClient() != null || FingerprintService.this.getPendingClient() != null;
            }
        }

        @Override
        public void addClientActiveCallback(IFingerprintClientActiveCallback callback) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.mClientActiveCallbacks.add(callback);
        }

        @Override
        public void removeClientActiveCallback(IFingerprintClientActiveCallback callback) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.mClientActiveCallbacks.remove(callback);
        }
    }

    private final class FingerprintAuthClient
    extends BiometricServiceBase.AuthenticationClientImpl {
        @Override
        protected boolean isFingerprint() {
            return true;
        }

        public FingerprintAuthClient(Context context, BiometricServiceBase.DaemonWrapper daemon, long halDeviceId, IBinder token, BiometricServiceBase.ServiceListener listener, int targetUserId, int groupId, long opId, boolean restricted, String owner, int cookie, boolean requireConfirmation) {
            super(context, daemon, halDeviceId, token, listener, targetUserId, groupId, opId, restricted, owner, cookie, requireConfirmation);
        }

        @Override
        protected int statsModality() {
            return FingerprintService.this.statsModality();
        }

        @Override
        public void resetFailedAttempts() {
            FingerprintService.this.resetFailedAttemptsForUser(true, ActivityManager.getCurrentUser());
        }

        @Override
        public boolean shouldFrameworkHandleLockout() {
            return true;
        }

        @Override
        public boolean wasUserDetected() {
            return false;
        }

        @Override
        public int handleFailedAttempt() {
            int currentUser = ActivityManager.getCurrentUser();
            FingerprintService.this.mFailedAttempts.put(currentUser, FingerprintService.this.mFailedAttempts.get(currentUser, 0) + 1);
            FingerprintService.this.mTimedLockoutCleared.put(ActivityManager.getCurrentUser(), false);
            if (FingerprintService.this.getLockoutMode() != 0) {
                FingerprintService.this.scheduleLockoutResetForUser(currentUser);
            }
            return super.handleFailedAttempt();
        }
    }

    private final class LockoutReceiver
    extends BroadcastReceiver {
        private LockoutReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            Slog.v(FingerprintService.this.getTag(), "Resetting lockout: " + intent.getAction());
            if (FingerprintService.this.getLockoutResetIntent().equals(intent.getAction())) {
                int user = intent.getIntExtra(FingerprintService.KEY_LOCKOUT_RESET_USER, 0);
                FingerprintService.this.resetFailedAttemptsForUser(false, user);
            }
        }
    }

    private final class ResetFailedAttemptsForUserRunnable
    implements Runnable {
        private ResetFailedAttemptsForUserRunnable() {
        }

        @Override
        public void run() {
            FingerprintService.this.resetFailedAttemptsForUser(true, ActivityManager.getCurrentUser());
        }
    }
}

