/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics.fingerprint;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.fingerprint.Fingerprint;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.server.biometrics.BiometricUserState;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class FingerprintUserState
extends BiometricUserState {
    private static final String TAG = "FingerprintState";
    private static final String FINGERPRINT_FILE = "settings_fingerprint.xml";
    private static final String TAG_FINGERPRINTS = "fingerprints";
    private static final String TAG_FINGERPRINT = "fingerprint";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_GROUP_ID = "groupId";
    private static final String ATTR_FINGER_ID = "fingerId";
    private static final String ATTR_DEVICE_ID = "deviceId";

    public FingerprintUserState(Context context, int userId) {
        super(context, userId);
    }

    @Override
    protected String getBiometricsTag() {
        return TAG_FINGERPRINTS;
    }

    @Override
    protected String getBiometricFile() {
        return FINGERPRINT_FILE;
    }

    @Override
    protected int getNameTemplateResource() {
        return 17040024;
    }

    public void addBiometric(BiometricAuthenticator.Identifier identifier) {
        if (identifier instanceof Fingerprint) {
            super.addBiometric(identifier);
        } else {
            Slog.w(TAG, "Attempted to add non-fingerprint identifier");
        }
    }

    protected ArrayList getCopy(ArrayList array2) {
        ArrayList<Fingerprint> result = new ArrayList<Fingerprint>();
        for (int i = 0; i < array2.size(); ++i) {
            Fingerprint fp = (Fingerprint)array2.get(i);
            result.add(new Fingerprint(fp.getName(), fp.getGroupId(), fp.getBiometricId(), fp.getDeviceId()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWriteState() {
        ArrayList fingerprints;
        AtomicFile destination = new AtomicFile(this.mFile);
        FingerprintUserState fingerprintUserState = this;
        synchronized (fingerprintUserState) {
            fingerprints = this.getCopy(this.mBiometrics);
        }
        FileOutputStream out = null;
        try {
            out = destination.startWrite();
            XmlSerializer serializer = Xml.newSerializer();
            serializer.setOutput(out, "utf-8");
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_FINGERPRINTS);
            int count = fingerprints.size();
            for (int i = 0; i < count; ++i) {
                Fingerprint fp = (Fingerprint)fingerprints.get(i);
                serializer.startTag(null, TAG_FINGERPRINT);
                serializer.attribute(null, ATTR_FINGER_ID, Integer.toString(fp.getBiometricId()));
                serializer.attribute(null, ATTR_NAME, fp.getName().toString());
                serializer.attribute(null, ATTR_GROUP_ID, Integer.toString(fp.getGroupId()));
                serializer.attribute(null, ATTR_DEVICE_ID, Long.toString(fp.getDeviceId()));
                serializer.endTag(null, TAG_FINGERPRINT);
            }
            serializer.endTag(null, TAG_FINGERPRINTS);
            serializer.endDocument();
            destination.finishWrite(out);
        }
        catch (Throwable t) {
            Slog.wtf(TAG, "Failed to write settings, restoring backup", t);
            destination.failWrite(out);
            throw new IllegalStateException("Failed to write fingerprints", t);
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    @Override
    @GuardedBy(value={"this"})
    protected void parseBiometricsLocked(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3 || type == 4 || !(tagName = parser.getName()).equals(TAG_FINGERPRINT)) continue;
            String name = parser.getAttributeValue(null, ATTR_NAME);
            String groupId = parser.getAttributeValue(null, ATTR_GROUP_ID);
            String fingerId = parser.getAttributeValue(null, ATTR_FINGER_ID);
            String deviceId = parser.getAttributeValue(null, ATTR_DEVICE_ID);
            this.mBiometrics.add(new Fingerprint(name, Integer.parseInt(groupId), Integer.parseInt(fingerId), Long.parseLong(deviceId)));
        }
    }
}

