/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics.fingerprint;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.fingerprint.Fingerprint;
import android.text.TextUtils;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.server.biometrics.BiometricUtils;
import com.android.server.biometrics.fingerprint.FingerprintUserState;
import java.util.List;

public class FingerprintUtils
implements BiometricUtils {
    private static final Object sInstanceLock = new Object();
    private static FingerprintUtils sInstance;
    @GuardedBy(value={"this"})
    private final SparseArray<FingerprintUserState> mUsers = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FingerprintUtils getInstance() {
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new FingerprintUtils();
            }
        }
        return sInstance;
    }

    private FingerprintUtils() {
    }

    public List<Fingerprint> getBiometricsForUser(Context ctx, int userId) {
        return this.getStateForUser(ctx, userId).getBiometrics();
    }

    public void addBiometricForUser(Context context, int userId, BiometricAuthenticator.Identifier identifier) {
        this.getStateForUser(context, userId).addBiometric(identifier);
    }

    @Override
    public void removeBiometricForUser(Context context, int userId, int fingerId) {
        this.getStateForUser(context, userId).removeBiometric(fingerId);
    }

    @Override
    public void renameBiometricForUser(Context context, int userId, int fingerId, CharSequence name) {
        if (TextUtils.isEmpty(name)) {
            return;
        }
        this.getStateForUser(context, userId).renameBiometric(fingerId, name);
    }

    @Override
    public CharSequence getUniqueName(Context context, int userId) {
        return this.getStateForUser(context, userId).getUniqueName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FingerprintUserState getStateForUser(Context ctx, int userId) {
        FingerprintUtils fingerprintUtils = this;
        synchronized (fingerprintUtils) {
            FingerprintUserState state = this.mUsers.get(userId);
            if (state == null) {
                state = new FingerprintUserState(ctx, userId);
                this.mUsers.put(userId, state);
            }
            return state;
        }
    }
}

