/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio;

import android.content.Context;
import android.hardware.radio.IAnnouncementListener;
import android.hardware.radio.ICloseHandle;
import android.hardware.radio.IRadioService;
import android.hardware.radio.ITuner;
import android.hardware.radio.ITunerCallback;
import android.hardware.radio.RadioManager;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.SystemService;
import com.android.server.broadcastradio.hal2.AnnouncementAggregator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public class BroadcastRadioService
extends SystemService {
    private static final String TAG = "BcRadioSrv";
    private static final boolean DEBUG = false;
    private final ServiceImpl mServiceImpl = new ServiceImpl();
    private final com.android.server.broadcastradio.hal1.BroadcastRadioService mHal1;
    private final com.android.server.broadcastradio.hal2.BroadcastRadioService mHal2;
    private final Object mLock = new Object();
    private List<RadioManager.ModuleProperties> mV1Modules = null;

    public BroadcastRadioService(Context context) {
        super(context);
        this.mHal1 = new com.android.server.broadcastradio.hal1.BroadcastRadioService();
        this.mV1Modules = this.mHal1.loadModules();
        OptionalInt max = this.mV1Modules.stream().mapToInt(RadioManager.ModuleProperties::getId).max();
        this.mHal2 = new com.android.server.broadcastradio.hal2.BroadcastRadioService(max.isPresent() ? max.getAsInt() + 1 : 0);
    }

    @Override
    public void onStart() {
        this.publishBinderService("broadcastradio", this.mServiceImpl);
    }

    private class ServiceImpl
    extends IRadioService.Stub {
        private ServiceImpl() {
        }

        private void enforcePolicyAccess() {
            if (0 != BroadcastRadioService.this.getContext().checkCallingPermission("android.permission.ACCESS_BROADCAST_RADIO")) {
                throw new SecurityException("ACCESS_BROADCAST_RADIO permission not granted");
            }
        }

        @Override
        public List<RadioManager.ModuleProperties> listModules() {
            this.enforcePolicyAccess();
            ArrayList<RadioManager.ModuleProperties> modules = new ArrayList<RadioManager.ModuleProperties>();
            modules.addAll(BroadcastRadioService.this.mV1Modules);
            modules.addAll(BroadcastRadioService.this.mHal2.listModules());
            return modules;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ITuner openTuner(int moduleId, RadioManager.BandConfig bandConfig, boolean withAudio, ITunerCallback callback) throws RemoteException {
            this.enforcePolicyAccess();
            if (callback == null) {
                throw new IllegalArgumentException("Callback must not be empty");
            }
            Object object = BroadcastRadioService.this.mLock;
            synchronized (object) {
                if (BroadcastRadioService.this.mHal2.hasModule(moduleId)) {
                    return BroadcastRadioService.this.mHal2.openSession(moduleId, bandConfig, withAudio, callback);
                }
                return BroadcastRadioService.this.mHal1.openTuner(moduleId, bandConfig, withAudio, callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICloseHandle addAnnouncementListener(int[] enabledTypes, IAnnouncementListener listener) {
            Objects.requireNonNull(enabledTypes);
            Objects.requireNonNull(listener);
            this.enforcePolicyAccess();
            Object object = BroadcastRadioService.this.mLock;
            synchronized (object) {
                if (!BroadcastRadioService.this.mHal2.hasAnyModules()) {
                    Slog.i(BroadcastRadioService.TAG, "There are no HAL 2.x modules registered");
                    return new AnnouncementAggregator(listener);
                }
                return BroadcastRadioService.this.mHal2.addAnnouncementListener(enabledTypes, listener);
            }
        }
    }
}

