/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio.hal2;

import android.hardware.radio.Announcement;
import android.hardware.radio.IAnnouncementListener;
import android.hardware.radio.ICloseHandle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.broadcastradio.hal2.RadioModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class AnnouncementAggregator
extends ICloseHandle.Stub {
    private static final String TAG = "BcRadio2Srv.AnnAggr";
    private final Object mLock = new Object();
    private final IAnnouncementListener mListener;
    private final IBinder.DeathRecipient mDeathRecipient = new DeathRecipient();
    @GuardedBy(value={"mLock"})
    private final Collection<ModuleWatcher> mModuleWatchers = new ArrayList<ModuleWatcher>();
    @GuardedBy(value={"mLock"})
    private boolean mIsClosed = false;

    public AnnouncementAggregator(IAnnouncementListener listener) {
        this.mListener = Objects.requireNonNull(listener);
        try {
            listener.asBinder().linkToDeath(this.mDeathRecipient, 0);
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onListUpdated() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                Slog.e(TAG, "Announcement aggregator is closed, it shouldn't receive callbacks");
                return;
            }
            ArrayList<Announcement> combined = new ArrayList<Announcement>();
            for (ModuleWatcher watcher : this.mModuleWatchers) {
                combined.addAll(watcher.currentList);
            }
            try {
                this.mListener.onListUpdated(combined);
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "mListener.onListUpdated() failed: ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchModule(RadioModule module, int[] enabledTypes) {
        Object object = this.mLock;
        synchronized (object) {
            ICloseHandle closeHandle;
            if (this.mIsClosed) {
                throw new IllegalStateException();
            }
            ModuleWatcher watcher = new ModuleWatcher();
            try {
                closeHandle = module.addAnnouncementListener(enabledTypes, watcher);
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "Failed to add announcement listener", ex);
                return;
            }
            watcher.setCloseHandle(closeHandle);
            this.mModuleWatchers.add(watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsClosed = true;
            this.mListener.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
            for (ModuleWatcher watcher : this.mModuleWatchers) {
                watcher.close();
            }
            this.mModuleWatchers.clear();
        }
    }

    private class DeathRecipient
    implements IBinder.DeathRecipient {
        private DeathRecipient() {
        }

        @Override
        public void binderDied() {
            try {
                AnnouncementAggregator.this.close();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private class ModuleWatcher
    extends IAnnouncementListener.Stub {
        private ICloseHandle mCloseHandle;
        public List<Announcement> currentList = new ArrayList<Announcement>();

        private ModuleWatcher() {
        }

        @Override
        public void onListUpdated(List<Announcement> active) {
            this.currentList = Objects.requireNonNull(active);
            AnnouncementAggregator.this.onListUpdated();
        }

        public void setCloseHandle(ICloseHandle closeHandle) {
            this.mCloseHandle = Objects.requireNonNull(closeHandle);
        }

        public void close() throws RemoteException {
            if (this.mCloseHandle != null) {
                this.mCloseHandle.close();
            }
        }
    }
}

