/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio.hal2;

import android.hardware.radio.IAnnouncementListener;
import android.hardware.radio.ICloseHandle;
import android.hardware.radio.ITuner;
import android.hardware.radio.ITunerCallback;
import android.hardware.radio.RadioManager;
import android.hidl.manager.V1_0.IServiceManager;
import android.hidl.manager.V1_0.IServiceNotification;
import android.os.IHwBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.broadcastradio.hal2.AnnouncementAggregator;
import com.android.server.broadcastradio.hal2.RadioModule;
import com.android.server.broadcastradio.hal2.TunerSession;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class BroadcastRadioService {
    private static final String TAG = "BcRadio2Srv";
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private int mNextModuleId = 0;
    @GuardedBy(value={"mLock"})
    private final Map<String, Integer> mServiceNameToModuleIdMap = new HashMap<String, Integer>();
    @GuardedBy(value={"mLock"})
    private final Map<Integer, RadioModule> mModules = new HashMap<Integer, RadioModule>();
    private IServiceNotification.Stub mServiceListener = new IServiceNotification.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRegistration(String fqName, String serviceName, boolean preexisting) {
            Slog.v(BroadcastRadioService.TAG, "onRegistration(" + fqName + ", " + serviceName + ", " + preexisting + ")");
            Object object = BroadcastRadioService.this.mLock;
            synchronized (object) {
                RadioModule module;
                Integer moduleId = (Integer)BroadcastRadioService.this.mServiceNameToModuleIdMap.get(serviceName);
                boolean newService = false;
                if (moduleId == null) {
                    newService = true;
                    moduleId = BroadcastRadioService.this.mNextModuleId;
                }
                if ((module = RadioModule.tryLoadingModule(moduleId, serviceName)) == null) {
                    return;
                }
                Slog.v(BroadcastRadioService.TAG, "loaded broadcast radio module " + moduleId + ": " + serviceName + " (HAL 2.0)");
                RadioModule prevModule = BroadcastRadioService.this.mModules.put(moduleId, module);
                if (prevModule != null) {
                    prevModule.closeSessions(0);
                }
                if (newService) {
                    BroadcastRadioService.this.mServiceNameToModuleIdMap.put(serviceName, moduleId);
                    BroadcastRadioService.this.mNextModuleId++;
                }
                try {
                    module.getService().linkToDeath(BroadcastRadioService.this.mDeathRecipient, moduleId.intValue());
                }
                catch (RemoteException ex) {
                    BroadcastRadioService.this.mModules.remove(moduleId);
                }
            }
        }
    };
    private IHwBinder.DeathRecipient mDeathRecipient = new IHwBinder.DeathRecipient(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void serviceDied(long cookie) {
            Slog.v(BroadcastRadioService.TAG, "serviceDied(" + cookie + ")");
            Object object = BroadcastRadioService.this.mLock;
            synchronized (object) {
                Map.Entry entry;
                int moduleId = (int)cookie;
                RadioModule prevModule = (RadioModule)BroadcastRadioService.this.mModules.remove(moduleId);
                if (prevModule != null) {
                    prevModule.closeSessions(0);
                }
                Iterator iterator = BroadcastRadioService.this.mServiceNameToModuleIdMap.entrySet().iterator();
                do {
                    if (!iterator.hasNext()) return;
                } while ((Integer)(entry = iterator.next()).getValue() != moduleId);
                Slog.i(BroadcastRadioService.TAG, "service " + (String)entry.getKey() + " died; removed RadioModule with ID " + moduleId);
                return;
            }
        }
    };

    public BroadcastRadioService(int nextModuleId) {
        this.mNextModuleId = nextModuleId;
        try {
            IServiceManager manager = IServiceManager.getService();
            if (manager == null) {
                Slog.e(TAG, "failed to get HIDL Service Manager");
                return;
            }
            manager.registerForNotifications("android.hardware.broadcastradio@2.0::IBroadcastRadio", "", this.mServiceListener);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "failed to register for service notifications: ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RadioManager.ModuleProperties> listModules() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mModules.values().stream().map(module -> module.mProperties).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasModule(int id2) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mModules.containsKey(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyModules() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mModules.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITuner openSession(int moduleId, RadioManager.BandConfig legacyConfig, boolean withAudio, ITunerCallback callback) throws RemoteException {
        Objects.requireNonNull(callback);
        if (!withAudio) {
            throw new IllegalArgumentException("Non-audio sessions not supported with HAL 2.x");
        }
        RadioModule module = null;
        Object object = this.mLock;
        synchronized (object) {
            module = this.mModules.get(moduleId);
            if (module == null) {
                throw new IllegalArgumentException("Invalid module ID");
            }
        }
        TunerSession tunerSession = module.openSession(callback);
        if (legacyConfig != null) {
            tunerSession.setConfiguration(legacyConfig);
        }
        return tunerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICloseHandle addAnnouncementListener(int[] enabledTypes, IAnnouncementListener listener) {
        AnnouncementAggregator aggregator = new AnnouncementAggregator(listener);
        boolean anySupported = false;
        Object object = this.mLock;
        synchronized (object) {
            for (RadioModule module : this.mModules.values()) {
                try {
                    aggregator.watchModule(module, enabledTypes);
                    anySupported = true;
                }
                catch (UnsupportedOperationException ex) {
                    Slog.v(TAG, "Announcements not supported for this module", ex);
                }
            }
        }
        if (!anySupported) {
            Slog.i(TAG, "There are no HAL modules that support announcements");
        }
        return aggregator;
    }
}

