/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio.hal2;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.broadcastradio.V2_0.AmFmRegionConfig;
import android.hardware.broadcastradio.V2_0.Announcement;
import android.hardware.broadcastradio.V2_0.IAnnouncementListener;
import android.hardware.broadcastradio.V2_0.IBroadcastRadio;
import android.hardware.broadcastradio.V2_0.ITunerCallback;
import android.hardware.broadcastradio.V2_0.ITunerSession;
import android.hardware.broadcastradio.V2_0.ProgramInfo;
import android.hardware.broadcastradio.V2_0.ProgramListChunk;
import android.hardware.broadcastradio.V2_0.ProgramSelector;
import android.hardware.broadcastradio.V2_0.VendorKeyValue;
import android.hardware.radio.IAnnouncementListener;
import android.hardware.radio.ICloseHandle;
import android.hardware.radio.RadioManager;
import android.os.DeadObjectException;
import android.os.RemoteException;
import android.util.MutableInt;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.broadcastradio.hal2.Convert;
import com.android.server.broadcastradio.hal2.Mutable;
import com.android.server.broadcastradio.hal2.TunerSession;
import com.android.server.broadcastradio.hal2.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class RadioModule {
    private static final String TAG = "BcRadio2Srv.module";
    private final IBroadcastRadio mService;
    public final RadioManager.ModuleProperties mProperties;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ITunerSession mHalTunerSession;
    @GuardedBy(value={"mLock"})
    private Boolean mAntennaConnected = null;
    @GuardedBy(value={"mLock"})
    private RadioManager.ProgramInfo mProgramInfo = null;
    private final ITunerCallback mHalTunerCallback = new ITunerCallback.Stub(){

        @Override
        public void onTuneFailed(int result, ProgramSelector programSelector) {
            RadioModule.this.fanoutAidlCallback(cb -> cb.onTuneFailed(result, Convert.programSelectorFromHal(programSelector)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCurrentProgramInfoChanged(ProgramInfo halProgramInfo) {
            RadioManager.ProgramInfo programInfo = Convert.programInfoFromHal(halProgramInfo);
            Object object = RadioModule.this.mLock;
            synchronized (object) {
                RadioModule.this.mProgramInfo = programInfo;
                RadioModule.this.fanoutAidlCallbackLocked(cb -> cb.onCurrentProgramInfoChanged(programInfo));
            }
        }

        @Override
        public void onProgramListUpdated(ProgramListChunk programListChunk) {
            RadioModule.this.fanoutAidlCallback(cb -> cb.onProgramListUpdated(Convert.programListChunkFromHal(programListChunk)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAntennaStateChange(boolean connected) {
            Object object = RadioModule.this.mLock;
            synchronized (object) {
                RadioModule.this.mAntennaConnected = connected;
                RadioModule.this.fanoutAidlCallbackLocked(cb -> cb.onAntennaState(connected));
            }
        }

        @Override
        public void onParametersUpdated(ArrayList<VendorKeyValue> parameters) {
            RadioModule.this.fanoutAidlCallback(cb -> cb.onParametersUpdated(Convert.vendorInfoFromHal(parameters)));
        }
    };
    @GuardedBy(value={"mLock"})
    private final Set<TunerSession> mAidlTunerSessions = new HashSet<TunerSession>();

    private RadioModule(IBroadcastRadio service, RadioManager.ModuleProperties properties) throws RemoteException {
        this.mProperties = Objects.requireNonNull(properties);
        this.mService = Objects.requireNonNull(service);
    }

    public static RadioModule tryLoadingModule(int idx, String fqName) {
        try {
            IBroadcastRadio service = IBroadcastRadio.getService(fqName);
            if (service == null) {
                return null;
            }
            Mutable amfmConfig = new Mutable();
            service.getAmFmRegionConfig(false, (result, config) -> {
                if (result == 0) {
                    amfmConfig.value = config;
                }
            });
            Mutable dabConfig = new Mutable();
            service.getDabRegionConfig((result, config) -> {
                if (result == 0) {
                    dabConfig.value = config;
                }
            });
            RadioManager.ModuleProperties prop = Convert.propertiesFromHal(idx, fqName, service.getProperties(), (AmFmRegionConfig)amfmConfig.value, (List)dabConfig.value);
            return new RadioModule(service, prop);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "failed to load module " + fqName, ex);
            return null;
        }
    }

    public IBroadcastRadio getService() {
        return this.mService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunerSession openSession(android.hardware.radio.ITunerCallback userCb) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHalTunerSession == null) {
                Mutable hwSession = new Mutable();
                this.mService.openSession(this.mHalTunerCallback, (result, session) -> {
                    Convert.throwOnError("openSession", result);
                    hwSession.value = session;
                });
                this.mHalTunerSession = Objects.requireNonNull((ITunerSession)hwSession.value);
            }
            TunerSession tunerSession = new TunerSession(this, this.mHalTunerSession, userCb);
            this.mAidlTunerSessions.add(tunerSession);
            if (this.mAntennaConnected != null) {
                userCb.onAntennaState(this.mAntennaConnected);
            }
            if (this.mProgramInfo != null) {
                userCb.onCurrentProgramInfoChanged(this.mProgramInfo);
            }
            return tunerSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSessions(Integer error) {
        TunerSession[] tunerSessionArray = this.mLock;
        synchronized (this.mLock) {
            TunerSession[] tunerSessions = new TunerSession[this.mAidlTunerSessions.size()];
            this.mAidlTunerSessions.toArray(tunerSessions);
            this.mAidlTunerSessions.clear();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (TunerSession tunerSession : tunerSessions) {
                tunerSession.close(error);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTunerSessionClosed(TunerSession tunerSession) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAidlTunerSessions.remove(tunerSession);
            if (this.mAidlTunerSessions.isEmpty() && this.mHalTunerSession != null) {
                Slog.v(TAG, "closing HAL tuner session");
                try {
                    this.mHalTunerSession.close();
                }
                catch (RemoteException ex) {
                    Slog.e(TAG, "mHalTunerSession.close() failed: ", ex);
                }
                this.mHalTunerSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fanoutAidlCallback(AidlCallbackRunnable runnable) {
        Object object = this.mLock;
        synchronized (object) {
            this.fanoutAidlCallbackLocked(runnable);
        }
    }

    private void fanoutAidlCallbackLocked(AidlCallbackRunnable runnable) {
        for (TunerSession tunerSession : this.mAidlTunerSessions) {
            try {
                runnable.run(tunerSession.mCallback);
            }
            catch (DeadObjectException ex) {
                Slog.e(TAG, "Removing dead TunerSession");
                this.mAidlTunerSessions.remove(tunerSession);
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "Failed to invoke ITunerCallback: ", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICloseHandle addAnnouncementListener(int[] enabledTypes, final IAnnouncementListener listener) throws RemoteException {
        ArrayList<Byte> enabledList = new ArrayList<Byte>();
        for (int type : enabledTypes) {
            enabledList.add((byte)type);
        }
        MutableInt halResult = new MutableInt(1);
        final Mutable hwCloseHandle = new Mutable();
        IAnnouncementListener.Stub hwListener = new IAnnouncementListener.Stub(){

            @Override
            public void onListUpdated(ArrayList<Announcement> hwAnnouncements) throws RemoteException {
                listener.onListUpdated(hwAnnouncements.stream().map(a -> Convert.announcementFromHal(a)).collect(Collectors.toList()));
            }
        };
        IBroadcastRadio iBroadcastRadio = this.mService;
        synchronized (iBroadcastRadio) {
            this.mService.registerAnnouncementListener(enabledList, hwListener, (result, closeHnd) -> {
                halResult.value = result;
                hwCloseHandle.value = closeHnd;
            });
        }
        Convert.throwOnError("addAnnouncementListener", halResult.value);
        return new ICloseHandle.Stub(){

            @Override
            public void close() {
                try {
                    ((android.hardware.broadcastradio.V2_0.ICloseHandle)hwCloseHandle.value).close();
                }
                catch (RemoteException ex) {
                    Slog.e(RadioModule.TAG, "Failed closing announcement listener", ex);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap getImage(int id2) {
        byte[] rawImage;
        if (id2 == 0) {
            throw new IllegalArgumentException("Image ID is missing");
        }
        IBroadcastRadio iBroadcastRadio = this.mService;
        synchronized (iBroadcastRadio) {
            List rawList = Utils.maybeRethrow(() -> this.mService.getImage(id2));
            rawImage = new byte[rawList.size()];
            for (int i = 0; i < rawList.size(); ++i) {
                rawImage[i] = (Byte)rawList.get(i);
            }
        }
        if (rawImage == null || rawImage.length == 0) {
            return null;
        }
        return BitmapFactory.decodeByteArray(rawImage, 0, rawImage.length);
    }

    static interface AidlCallbackRunnable {
        public void run(android.hardware.radio.ITunerCallback var1) throws RemoteException;
    }
}

