/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.clipboard;

import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IUriGrantsManager;
import android.app.KeyguardManager;
import android.app.UriGrantsManager;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Context;
import android.content.IClipboard;
import android.content.IOnPrimaryClipChangedListener;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IUserManager;
import android.os.Parcel;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.view.autofill.AutofillManagerInternal;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.clipboard.HostClipboardMonitor;
import com.android.server.contentcapture.ContentCaptureManagerInternal;
import com.android.server.uri.UriGrantsManagerInternal;
import com.android.server.wm.WindowManagerInternal;
import java.util.HashSet;
import java.util.List;

public class ClipboardService
extends SystemService {
    private static final String TAG = "ClipboardService";
    private static final boolean IS_EMULATOR = SystemProperties.getBoolean("ro.kernel.qemu", false);
    private final ActivityManagerInternal mAmInternal;
    private final IUriGrantsManager mUgm;
    private final UriGrantsManagerInternal mUgmInternal;
    private final WindowManagerInternal mWm;
    private final IUserManager mUm;
    private final PackageManager mPm;
    private final AppOpsManager mAppOps;
    private final ContentCaptureManagerInternal mContentCaptureInternal;
    private final AutofillManagerInternal mAutofillInternal;
    private final IBinder mPermissionOwner;
    private HostClipboardMonitor mHostClipboardMonitor = null;
    private Thread mHostMonitorThread = null;
    private final SparseArray<PerUserClipboard> mClipboards = new SparseArray();

    public ClipboardService(Context context) {
        super(context);
        IBinder permOwner;
        this.mAmInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mUgm = UriGrantsManager.getService();
        this.mUgmInternal = LocalServices.getService(UriGrantsManagerInternal.class);
        this.mWm = LocalServices.getService(WindowManagerInternal.class);
        this.mPm = this.getContext().getPackageManager();
        this.mUm = (IUserManager)((Object)ServiceManager.getService("user"));
        this.mAppOps = (AppOpsManager)this.getContext().getSystemService("appops");
        this.mContentCaptureInternal = LocalServices.getService(ContentCaptureManagerInternal.class);
        this.mAutofillInternal = LocalServices.getService(AutofillManagerInternal.class);
        this.mPermissionOwner = permOwner = this.mUgmInternal.newUriPermissionOwner("clipboard");
        if (IS_EMULATOR) {
            this.mHostClipboardMonitor = new HostClipboardMonitor(new HostClipboardMonitor.HostClipboardCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onHostClipboardUpdated(String contents) {
                    ClipData clip = new ClipData("host clipboard", new String[]{"text/plain"}, new ClipData.Item(contents));
                    SparseArray sparseArray = ClipboardService.this.mClipboards;
                    synchronized (sparseArray) {
                        ClipboardService.this.setPrimaryClipInternal(ClipboardService.this.getClipboard(0), clip, 1000);
                    }
                }
            });
            this.mHostMonitorThread = new Thread(this.mHostClipboardMonitor);
            this.mHostMonitorThread.start();
        }
    }

    @Override
    public void onStart() {
        this.publishBinderService("clipboard", new ClipboardImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCleanupUser(int userId) {
        SparseArray<PerUserClipboard> sparseArray = this.mClipboards;
        synchronized (sparseArray) {
            this.mClipboards.remove(userId);
        }
    }

    private boolean isInternalSysWindowAppWithWindowFocus(String callingPackage) {
        return this.mPm.checkPermission("android.permission.INTERNAL_SYSTEM_WINDOW", callingPackage) == 0 && this.mWm.isUidFocused(Binder.getCallingUid());
    }

    private int getIntendingUserId(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        if (!UserManager.supportsMultipleUsers() || callingUserId == userId) {
            return callingUserId;
        }
        int intendingUserId = callingUserId;
        intendingUserId = this.mAmInternal.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "checkClipboardServiceCallingUser", packageName);
        return intendingUserId;
    }

    private int getIntendingUid(String packageName, int userId) {
        return UserHandle.getUid(this.getIntendingUserId(packageName, userId), UserHandle.getAppId(Binder.getCallingUid()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerUserClipboard getClipboard(int userId) {
        SparseArray<PerUserClipboard> sparseArray = this.mClipboards;
        synchronized (sparseArray) {
            PerUserClipboard puc = this.mClipboards.get(userId);
            if (puc == null) {
                puc = new PerUserClipboard(userId);
                this.mClipboards.put(userId, puc);
            }
            return puc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UserInfo> getRelatedProfiles(int userId) {
        List<UserInfo> related;
        long origId = Binder.clearCallingIdentity();
        try {
            related = this.mUm.getProfiles(userId, true);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Remote Exception calling UserManager: " + e);
            List<UserInfo> list = null;
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        return related;
    }

    private boolean hasRestriction(String restriction, int userId) {
        try {
            return this.mUm.hasUserRestriction(restriction, userId);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Remote Exception calling UserManager.getUserRestrictions: ", e);
            return true;
        }
    }

    void setPrimaryClipInternal(ClipData clip, int uid) {
        int size;
        if (this.mHostClipboardMonitor != null) {
            CharSequence text;
            if (clip == null) {
                this.mHostClipboardMonitor.setHostClipboard("");
            } else if (clip.getItemCount() > 0 && (text = clip.getItemAt(0).getText()) != null) {
                this.mHostClipboardMonitor.setHostClipboard(text.toString());
            }
        }
        int userId = UserHandle.getUserId(uid);
        this.setPrimaryClipInternal(this.getClipboard(userId), clip, uid);
        List<UserInfo> related = this.getRelatedProfiles(userId);
        if (related != null && (size = related.size()) > 1) {
            int i;
            boolean canCopy;
            boolean bl = canCopy = !this.hasRestriction("no_cross_profile_copy_paste", userId);
            if (!canCopy) {
                clip = null;
            } else if (clip != null) {
                clip = new ClipData(clip);
                for (i = clip.getItemCount() - 1; i >= 0; --i) {
                    clip.setItemAt(i, new ClipData.Item(clip.getItemAt(i)));
                }
                clip.fixUrisLight(userId);
            }
            for (i = 0; i < size; ++i) {
                boolean canCopyIntoProfile;
                int id2 = related.get((int)i).id;
                if (id2 == userId) continue;
                boolean bl2 = canCopyIntoProfile = !this.hasRestriction("no_sharing_into_profile", id2);
                if (!canCopyIntoProfile) continue;
                this.setPrimaryClipInternal(this.getClipboard(id2), clip, uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrimaryClipInternal(PerUserClipboard clipboard, ClipData clip, int uid) {
        ClipDescription description;
        this.revokeUris(clipboard);
        clipboard.activePermissionOwners.clear();
        if (clip == null && clipboard.primaryClip == null) {
            return;
        }
        clipboard.primaryClip = clip;
        clipboard.primaryClipUid = clip != null ? uid : 9999;
        if (clip != null && (description = clip.getDescription()) != null) {
            description.setTimestamp(System.currentTimeMillis());
        }
        long ident = Binder.clearCallingIdentity();
        int n = clipboard.primaryClipListeners.beginBroadcast();
        try {
            for (int i = 0; i < n; ++i) {
                try {
                    ListenerInfo li = (ListenerInfo)clipboard.primaryClipListeners.getBroadcastCookie(i);
                    if (!this.clipboardAccessAllowed(29, li.mPackageName, li.mUid, UserHandle.getUserId(li.mUid))) continue;
                    clipboard.primaryClipListeners.getBroadcastItem(i).dispatchPrimaryClipChanged();
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            clipboard.primaryClipListeners.finishBroadcast();
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDeviceLocked(int userId) {
        long token = Binder.clearCallingIdentity();
        try {
            KeyguardManager keyguardManager = this.getContext().getSystemService(KeyguardManager.class);
            boolean bl = keyguardManager != null && keyguardManager.isDeviceLocked(userId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkUriOwnerLocked(Uri uri, int sourceUid) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mUgmInternal.checkGrantUriPermission(sourceUid, null, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid)));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final void checkItemOwnerLocked(ClipData.Item item, int uid) {
        Intent intent;
        if (item.getUri() != null) {
            this.checkUriOwnerLocked(item.getUri(), uid);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.checkUriOwnerLocked(intent.getData(), uid);
        }
    }

    private final void checkDataOwnerLocked(ClipData data, int uid) {
        int N = data.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.checkItemOwnerLocked(data.getItemAt(i), uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void grantUriLocked(Uri uri, int sourceUid, String targetPkg, int targetUserId) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mUgm.grantUriPermissionFromOwner(this.mPermissionOwner, sourceUid, targetPkg, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid)), targetUserId);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final void grantItemLocked(ClipData.Item item, int sourceUid, String targetPkg, int targetUserId) {
        Intent intent;
        if (item.getUri() != null) {
            this.grantUriLocked(item.getUri(), sourceUid, targetPkg, targetUserId);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.grantUriLocked(intent.getData(), sourceUid, targetPkg, targetUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addActiveOwnerLocked(int uid, String pkg) {
        IPackageManager pm = AppGlobals.getPackageManager();
        int targetUserHandle = UserHandle.getCallingUserId();
        long oldIdentity = Binder.clearCallingIdentity();
        try {
            PackageInfo pi = pm.getPackageInfo(pkg, 0, targetUserHandle);
            if (pi == null) {
                throw new IllegalArgumentException("Unknown package " + pkg);
            }
            if (!UserHandle.isSameApp(pi.applicationInfo.uid, uid)) {
                throw new SecurityException("Calling uid " + uid + " does not own package " + pkg);
            }
        }
        catch (RemoteException pi) {
        }
        finally {
            Binder.restoreCallingIdentity(oldIdentity);
        }
        PerUserClipboard clipboard = this.getClipboard(UserHandle.getUserId(uid));
        if (clipboard.primaryClip != null && !clipboard.activePermissionOwners.contains(pkg)) {
            int N = clipboard.primaryClip.getItemCount();
            for (int i = 0; i < N; ++i) {
                this.grantItemLocked(clipboard.primaryClip.getItemAt(i), clipboard.primaryClipUid, pkg, UserHandle.getUserId(uid));
            }
            clipboard.activePermissionOwners.add(pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void revokeUriLocked(Uri uri, int sourceUid) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mUgmInternal.revokeUriPermissionFromOwner(this.mPermissionOwner, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid)));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final void revokeItemLocked(ClipData.Item item, int sourceUid) {
        Intent intent;
        if (item.getUri() != null) {
            this.revokeUriLocked(item.getUri(), sourceUid);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.revokeUriLocked(intent.getData(), sourceUid);
        }
    }

    private final void revokeUris(PerUserClipboard clipboard) {
        if (clipboard.primaryClip == null) {
            return;
        }
        int N = clipboard.primaryClip.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.revokeItemLocked(clipboard.primaryClip.getItemAt(i), clipboard.primaryClipUid);
        }
    }

    private boolean clipboardAccessAllowed(int op, String callingPackage, int uid, int userId) {
        String imePkg;
        if (this.mAppOps.noteOp(op, uid, callingPackage) != 0) {
            return false;
        }
        if (this.mPm.checkPermission("android.permission.READ_CLIPBOARD_IN_BACKGROUND", callingPackage) == 0) {
            return true;
        }
        String defaultIme = Settings.Secure.getStringForUser(this.getContext().getContentResolver(), "default_input_method", userId);
        if (!TextUtils.isEmpty(defaultIme) && (imePkg = ComponentName.unflattenFromString(defaultIme).getPackageName()).equals(callingPackage)) {
            return true;
        }
        switch (op) {
            case 29: {
                boolean allowed;
                boolean bl = allowed = this.mWm.isUidFocused(uid) || this.isInternalSysWindowAppWithWindowFocus(callingPackage);
                if (!allowed && this.mContentCaptureInternal != null) {
                    allowed = this.mContentCaptureInternal.isContentCaptureServiceForUser(uid, userId);
                }
                if (!allowed && this.mAutofillInternal != null) {
                    allowed = this.mAutofillInternal.isAugmentedAutofillServiceForUser(uid, userId);
                }
                if (!allowed) {
                    Slog.e(TAG, "Denying clipboard access to " + callingPackage + ", application is not in focus neither is a system service for user " + userId);
                }
                return allowed;
            }
            case 30: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown clipboard appop " + op);
    }

    private class ClipboardImpl
    extends IClipboard.Stub {
        private ClipboardImpl() {
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            try {
                return super.onTransact(code, data, reply, flags);
            }
            catch (RuntimeException e) {
                if (!(e instanceof SecurityException)) {
                    Slog.wtf("clipboard", "Exception: ", e);
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPrimaryClip(ClipData clip, String callingPackage, int userId) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                int intendingUserId;
                if (clip == null || clip.getItemCount() <= 0) {
                    throw new IllegalArgumentException("No items");
                }
                int intendingUid = ClipboardService.this.getIntendingUid(callingPackage, userId);
                if (!ClipboardService.this.clipboardAccessAllowed(30, callingPackage, intendingUid, intendingUserId = UserHandle.getUserId(intendingUid))) {
                    return;
                }
                ClipboardService.this.checkDataOwnerLocked(clip, intendingUid);
                ClipboardService.this.setPrimaryClipInternal(clip, intendingUid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearPrimaryClip(String callingPackage, int userId) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                int intendingUid = ClipboardService.this.getIntendingUid(callingPackage, userId);
                int intendingUserId = UserHandle.getUserId(intendingUid);
                if (!ClipboardService.this.clipboardAccessAllowed(30, callingPackage, intendingUid, intendingUserId)) {
                    return;
                }
                ClipboardService.this.setPrimaryClipInternal(null, intendingUid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClipData getPrimaryClip(String pkg, int userId) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                int intendingUid = ClipboardService.this.getIntendingUid(pkg, userId);
                int intendingUserId = UserHandle.getUserId(intendingUid);
                if (!ClipboardService.this.clipboardAccessAllowed(29, pkg, intendingUid, intendingUserId) || ClipboardService.this.isDeviceLocked(intendingUserId)) {
                    return null;
                }
                ClipboardService.this.addActiveOwnerLocked(intendingUid, pkg);
                return ((ClipboardService)ClipboardService.this).getClipboard((int)intendingUserId).primaryClip;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClipDescription getPrimaryClipDescription(String callingPackage, int userId) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                int intendingUid = ClipboardService.this.getIntendingUid(callingPackage, userId);
                int intendingUserId = UserHandle.getUserId(intendingUid);
                if (!ClipboardService.this.clipboardAccessAllowed(29, callingPackage, intendingUid, intendingUserId) || ClipboardService.this.isDeviceLocked(intendingUserId)) {
                    return null;
                }
                PerUserClipboard clipboard = ClipboardService.this.getClipboard(intendingUserId);
                return clipboard.primaryClip != null ? clipboard.primaryClip.getDescription() : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrimaryClip(String callingPackage, int userId) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                int intendingUid = ClipboardService.this.getIntendingUid(callingPackage, userId);
                int intendingUserId = UserHandle.getUserId(intendingUid);
                if (!ClipboardService.this.clipboardAccessAllowed(29, callingPackage, intendingUid, intendingUserId) || ClipboardService.this.isDeviceLocked(intendingUserId)) {
                    return false;
                }
                return ((ClipboardService)ClipboardService.this).getClipboard((int)intendingUserId).primaryClip != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPrimaryClipChangedListener(IOnPrimaryClipChangedListener listener, String callingPackage, int userId) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                int intendingUid = ClipboardService.this.getIntendingUid(callingPackage, userId);
                int intendingUserId = UserHandle.getUserId(intendingUid);
                ((ClipboardService)ClipboardService.this).getClipboard((int)intendingUserId).primaryClipListeners.register(listener, new ListenerInfo(intendingUid, callingPackage));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePrimaryClipChangedListener(IOnPrimaryClipChangedListener listener, String callingPackage, int userId) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                int intendingUserId = ClipboardService.this.getIntendingUserId(callingPackage, userId);
                ((ClipboardService)ClipboardService.this).getClipboard((int)intendingUserId).primaryClipListeners.unregister(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasClipboardText(String callingPackage, int userId) {
            ClipboardImpl clipboardImpl = this;
            synchronized (clipboardImpl) {
                int intendingUid = ClipboardService.this.getIntendingUid(callingPackage, userId);
                int intendingUserId = UserHandle.getUserId(intendingUid);
                if (!ClipboardService.this.clipboardAccessAllowed(29, callingPackage, intendingUid, intendingUserId) || ClipboardService.this.isDeviceLocked(intendingUserId)) {
                    return false;
                }
                PerUserClipboard clipboard = ClipboardService.this.getClipboard(intendingUserId);
                if (clipboard.primaryClip != null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    CharSequence text = clipboard.primaryClip.getItemAt(0).getText();
                    return text != null && text.length() > 0;
                }
                return false;
            }
        }
    }

    private class PerUserClipboard {
        final int userId;
        final RemoteCallbackList<IOnPrimaryClipChangedListener> primaryClipListeners = new RemoteCallbackList();
        ClipData primaryClip;
        int primaryClipUid = 9999;
        final HashSet<String> activePermissionOwners = new HashSet();

        PerUserClipboard(int userId) {
            this.userId = userId;
        }
    }

    private class ListenerInfo {
        final int mUid;
        final String mPackageName;

        ListenerInfo(int uid, String packageName) {
            this.mUid = uid;
            this.mPackageName = packageName;
        }
    }
}

