/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.clipboard;

import android.util.Slog;
import java.io.IOException;
import java.io.RandomAccessFile;

class HostClipboardMonitor
implements Runnable {
    private RandomAccessFile mPipe = null;
    private HostClipboardCallback mHostClipboardCallback;
    private static final String PIPE_NAME = "pipe:clipboard";
    private static final String PIPE_DEVICE = "/dev/qemu_pipe";

    private void openPipe() {
        try {
            byte[] b = new byte[PIPE_NAME.length() + 1];
            b[PIPE_NAME.length()] = 0;
            System.arraycopy(PIPE_NAME.getBytes(), 0, b, 0, PIPE_NAME.length());
            this.mPipe = new RandomAccessFile(PIPE_DEVICE, "rw");
            this.mPipe.write(b);
        }
        catch (IOException e) {
            try {
                if (this.mPipe != null) {
                    this.mPipe.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mPipe = null;
        }
    }

    public HostClipboardMonitor(HostClipboardCallback cb) {
        this.mHostClipboardCallback = cb;
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                while (this.mPipe == null) {
                    this.openPipe();
                    Thread.sleep(100L);
                }
                int size = this.mPipe.readInt();
                size = Integer.reverseBytes(size);
                byte[] receivedData = new byte[size];
                this.mPipe.readFully(receivedData);
                this.mHostClipboardCallback.onHostClipboardUpdated(new String(receivedData));
            }
            catch (IOException e) {
                try {
                    this.mPipe.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mPipe = null;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setHostClipboard(String content) {
        try {
            if (this.mPipe != null) {
                this.mPipe.writeInt(Integer.reverseBytes(content.getBytes().length));
                this.mPipe.write(content.getBytes());
            }
        }
        catch (IOException e) {
            Slog.e("HostClipboardMonitor", "Failed to set host clipboard " + e.getMessage());
        }
    }

    public static interface HostClipboardCallback {
        public void onHostClipboardUpdated(String var1);
    }
}

