/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.companion;

import android.app.PendingIntent;
import android.companion.AssociationRequest;
import android.companion.ICompanionDeviceDiscoveryService;
import android.companion.ICompanionDeviceDiscoveryServiceCallback;
import android.companion.ICompanionDeviceManager;
import android.companion.IFindDeviceCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.NetworkPolicyManager;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.IDeviceIdleController;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.UserHandle;
import android.provider.Settings;
import android.provider.SettingsStringUtil;
import android.text.BidiFormatter;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.app.IAppOpsService;
import com.android.internal.content.PackageMonitor;
import com.android.internal.notification.NotificationAccessConfirmationActivityContract;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.wm.ActivityTaskManagerInternal;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class CompanionDeviceManagerService
extends SystemService
implements IBinder.DeathRecipient {
    private static final ComponentName SERVICE_TO_BIND_TO = ComponentName.createRelative("com.android.companiondevicemanager", ".DeviceDiscoveryService");
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "CompanionDeviceManagerService";
    private static final String XML_TAG_ASSOCIATIONS = "associations";
    private static final String XML_TAG_ASSOCIATION = "association";
    private static final String XML_ATTR_PACKAGE = "package";
    private static final String XML_ATTR_DEVICE = "device";
    private static final String XML_FILE_NAME = "companion_device_manager_associations.xml";
    private final CompanionDeviceManagerImpl mImpl;
    private final ConcurrentMap<Integer, AtomicFile> mUidToStorage = new ConcurrentHashMap<Integer, AtomicFile>();
    private IDeviceIdleController mIdleController;
    private ServiceConnection mServiceConnection;
    private IAppOpsService mAppOpsManager;
    private IFindDeviceCallback mFindDeviceCallback;
    private AssociationRequest mRequest;
    private String mCallingPackage;
    private final Object mLock = new Object();

    public CompanionDeviceManagerService(Context context) {
        super(context);
        this.mImpl = new CompanionDeviceManagerImpl();
        this.mIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
        this.mAppOpsManager = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        this.registerPackageMonitor();
    }

    private void registerPackageMonitor() {
        new PackageMonitor(){

            @Override
            public void onPackageRemoved(String packageName, int uid) {
                CompanionDeviceManagerService.this.updateAssociations(as -> CollectionUtils.filter(as, a -> !Objects.equals(a.companionAppPackage, packageName)), this.getChangingUserId());
            }

            @Override
            public void onPackageModified(String packageName) {
                int userId = this.getChangingUserId();
                if (!ArrayUtils.isEmpty(CompanionDeviceManagerService.this.readAllAssociations(userId, packageName))) {
                    CompanionDeviceManagerService.this.updateSpecialAccessPermissionForAssociatedPackage(packageName, userId);
                }
            }
        }.register(this.getContext(), FgThread.get().getLooper(), UserHandle.ALL, true);
    }

    @Override
    public void onStart() {
        this.publishBinderService("companiondevice", this.mImpl);
    }

    @Override
    public void onUnlockUser(int userHandle) {
        Set<Association> associations = this.readAllAssociations(userHandle);
        if (associations == null || associations.isEmpty()) {
            return;
        }
        HashSet<String> companionAppPackages = new HashSet<String>();
        for (Association association : associations) {
            companionAppPackages.add(association.companionAppPackage);
        }
        ActivityTaskManagerInternal atmInternal = LocalServices.getService(ActivityTaskManagerInternal.class);
        if (atmInternal != null) {
            atmInternal.setCompanionAppPackages(userHandle, companionAppPackages);
        }
    }

    @Override
    public void binderDied() {
        Handler.getMain().post(this::cleanup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        Object object = this.mLock;
        synchronized (object) {
            this.mServiceConnection = this.unbind(this.mServiceConnection);
            this.mFindDeviceCallback = CompanionDeviceManagerService.unlinkToDeath(this.mFindDeviceCallback, this, 0);
            this.mRequest = null;
            this.mCallingPackage = null;
        }
    }

    private static <T extends IInterface> T unlinkToDeath(T iinterface, IBinder.DeathRecipient deathRecipient, int flags) {
        if (iinterface != null) {
            iinterface.asBinder().unlinkToDeath(deathRecipient, flags);
        }
        return null;
    }

    private ServiceConnection unbind(ServiceConnection conn) {
        if (conn != null) {
            this.getContext().unbindService(conn);
        }
        return null;
    }

    private static int getCallingUserId() {
        return UserHandle.getUserId(Binder.getCallingUid());
    }

    private static boolean isCallerSystem() {
        return Binder.getCallingUid() == 1000;
    }

    private ServiceConnection createServiceConnection(final AssociationRequest request, final IFindDeviceCallback findDeviceCallback, final String callingPackage) {
        this.mServiceConnection = new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                CompanionDeviceManagerService.this.mFindDeviceCallback = findDeviceCallback;
                CompanionDeviceManagerService.this.mRequest = request;
                CompanionDeviceManagerService.this.mCallingPackage = callingPackage;
                try {
                    CompanionDeviceManagerService.this.mFindDeviceCallback.asBinder().linkToDeath(CompanionDeviceManagerService.this, 0);
                }
                catch (RemoteException e) {
                    CompanionDeviceManagerService.this.cleanup();
                    return;
                }
                try {
                    ICompanionDeviceDiscoveryService.Stub.asInterface(service).startDiscovery(request, callingPackage, findDeviceCallback, CompanionDeviceManagerService.this.getServiceCallback());
                }
                catch (RemoteException e) {
                    Log.e(CompanionDeviceManagerService.LOG_TAG, "Error while initiating device discovery", e);
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
            }
        };
        return this.mServiceConnection;
    }

    private ICompanionDeviceDiscoveryServiceCallback.Stub getServiceCallback() {
        return new ICompanionDeviceDiscoveryServiceCallback.Stub(){

            @Override
            public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                try {
                    return super.onTransact(code, data, reply, flags);
                }
                catch (Throwable e) {
                    Slog.e(CompanionDeviceManagerService.LOG_TAG, "Error during IPC", e);
                    throw ExceptionUtils.propagate(e, RemoteException.class);
                }
            }

            @Override
            public void onDeviceSelected(String packageName, int userId, String deviceAddress) {
                CompanionDeviceManagerService.this.addAssociation(userId, packageName, deviceAddress);
                CompanionDeviceManagerService.this.cleanup();
            }

            @Override
            public void onDeviceSelectionCancel() {
                CompanionDeviceManagerService.this.cleanup();
            }
        };
    }

    void addAssociation(int userId, String packageName, String deviceAddress) {
        this.updateSpecialAccessPermissionForAssociatedPackage(packageName, userId);
        this.recordAssociation(packageName, deviceAddress);
    }

    void removeAssociation(int userId, String pkg, String deviceMacAddress) {
        this.updateAssociations(associations -> CollectionUtils.remove(associations, new Association(userId, deviceMacAddress, pkg)));
    }

    private void updateSpecialAccessPermissionForAssociatedPackage(String packageName, int userId) {
        PackageInfo packageInfo = this.getPackageInfo(packageName, userId);
        if (packageInfo == null) {
            return;
        }
        Binder.withCleanCallingIdentity(PooledLambda.obtainRunnable(CompanionDeviceManagerService::updateSpecialAccessPermissionAsSystem, this, packageInfo).recycleOnUse());
    }

    private void updateSpecialAccessPermissionAsSystem(PackageInfo packageInfo) {
        try {
            if (CompanionDeviceManagerService.containsEither(packageInfo.requestedPermissions, "android.permission.RUN_IN_BACKGROUND", "android.permission.REQUEST_COMPANION_RUN_IN_BACKGROUND")) {
                this.mIdleController.addPowerSaveWhitelistApp(packageInfo.packageName);
            } else {
                this.mIdleController.removePowerSaveWhitelistApp(packageInfo.packageName);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        NetworkPolicyManager networkPolicyManager = NetworkPolicyManager.from(this.getContext());
        if (CompanionDeviceManagerService.containsEither(packageInfo.requestedPermissions, "android.permission.USE_DATA_IN_BACKGROUND", "android.permission.REQUEST_COMPANION_USE_DATA_IN_BACKGROUND")) {
            networkPolicyManager.addUidPolicy(packageInfo.applicationInfo.uid, 4);
        } else {
            networkPolicyManager.removeUidPolicy(packageInfo.applicationInfo.uid, 4);
        }
    }

    private static <T> boolean containsEither(T[] array2, T a, T b) {
        return ArrayUtils.contains(array2, a) || ArrayUtils.contains(array2, b);
    }

    private PackageInfo getPackageInfo(String packageName, int userId) {
        return (PackageInfo)Binder.withCleanCallingIdentity(PooledLambda.obtainSupplier((context, pkg, id2) -> {
            try {
                return context.getPackageManager().getPackageInfoAsUser((String)pkg, 20480, (int)id2);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.e(LOG_TAG, "Failed to get PackageInfo for package " + pkg, e);
                return null;
            }
        }, this.getContext(), packageName, userId).recycleOnUse());
    }

    private void recordAssociation(String priviledgedPackage, String deviceAddress) {
        int userId = CompanionDeviceManagerService.getCallingUserId();
        this.updateAssociations(associations -> CollectionUtils.add(associations, new Association(userId, deviceAddress, priviledgedPackage)));
    }

    private void updateAssociations(Function<Set<Association>, Set<Association>> update) {
        this.updateAssociations(update, CompanionDeviceManagerService.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAssociations(Function<Set<Association>, Set<Association>> update, int userId) {
        AtomicFile file;
        AtomicFile atomicFile = file = this.getStorageFileForUser(userId);
        synchronized (atomicFile) {
            Set<Association> associations = this.readAllAssociations(userId);
            Set<Association> old = CollectionUtils.copyOf(associations);
            associations = update.apply(associations);
            if (CollectionUtils.size(old) == CollectionUtils.size(associations)) {
                return;
            }
            Set<Association> finalAssociations = associations;
            HashSet<String> companionAppPackages = new HashSet<String>();
            for (Association association : finalAssociations) {
                companionAppPackages.add(association.companionAppPackage);
            }
            file.write(out -> {
                XmlSerializer xml2 = Xml.newSerializer();
                try {
                    xml2.setOutput((OutputStream)out, StandardCharsets.UTF_8.name());
                    xml2.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                    xml2.startDocument(null, true);
                    xml2.startTag(null, XML_TAG_ASSOCIATIONS);
                    CollectionUtils.forEach(finalAssociations, association -> xml2.startTag(null, XML_TAG_ASSOCIATION).attribute(null, XML_ATTR_PACKAGE, association.companionAppPackage).attribute(null, XML_ATTR_DEVICE, association.deviceAddress).endTag(null, XML_TAG_ASSOCIATION));
                    xml2.endTag(null, XML_TAG_ASSOCIATIONS);
                    xml2.endDocument();
                }
                catch (Exception e) {
                    Slog.e(LOG_TAG, "Error while writing associations file", e);
                    throw ExceptionUtils.propagate(e);
                }
            });
            ActivityTaskManagerInternal atmInternal = LocalServices.getService(ActivityTaskManagerInternal.class);
            atmInternal.setCompanionAppPackages(userId, companionAppPackages);
        }
    }

    private AtomicFile getStorageFileForUser(int uid) {
        return this.mUidToStorage.computeIfAbsent(uid, u -> new AtomicFile(new File(Environment.getUserSystemDirectory(u), XML_FILE_NAME)));
    }

    private Set<Association> readAllAssociations(int userId) {
        return this.readAllAssociations(userId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<Association> readAllAssociations(int userId, String packageFilter) {
        AtomicFile file = this.getStorageFileForUser(userId);
        if (!file.getBaseFile().exists()) {
            return null;
        }
        ArraySet<Association> result = null;
        XmlPullParser parser = Xml.newPullParser();
        AtomicFile atomicFile = file;
        synchronized (atomicFile) {
            try (FileInputStream in = file.openRead();){
                int type;
                parser.setInput(in, StandardCharsets.UTF_8.name());
                while ((type = parser.next()) != 1) {
                    if (type != 2 && !XML_TAG_ASSOCIATIONS.equals(parser.getName())) continue;
                    String appPackage = parser.getAttributeValue(null, XML_ATTR_PACKAGE);
                    String deviceAddress = parser.getAttributeValue(null, XML_ATTR_DEVICE);
                    if (appPackage == null || deviceAddress == null || packageFilter != null && !packageFilter.equals(appPackage)) continue;
                    result = ArrayUtils.add(result, new Association(userId, deviceAddress, appPackage));
                }
                ArraySet<Association> arraySet = result;
                return arraySet;
            }
            catch (IOException | XmlPullParserException e) {
                Slog.e(LOG_TAG, "Error while reading associations file", e);
                return null;
            }
        }
    }

    private class ShellCmd
    extends ShellCommand {
        public static final String USAGE = "help\nlist USER_ID\nassociate USER_ID PACKAGE MAC_ADDRESS\ndisassociate USER_ID PACKAGE MAC_ADDRESS";

        private ShellCmd() {
        }

        @Override
        public int onCommand(String cmd) {
            switch (cmd) {
                case "list": {
                    CollectionUtils.forEach(CompanionDeviceManagerService.this.readAllAssociations(this.getNextArgInt()), a -> this.getOutPrintWriter().println(a.companionAppPackage + " " + a.deviceAddress));
                    break;
                }
                case "associate": {
                    CompanionDeviceManagerService.this.addAssociation(this.getNextArgInt(), this.getNextArgRequired(), this.getNextArgRequired());
                    break;
                }
                case "disassociate": {
                    CompanionDeviceManagerService.this.removeAssociation(this.getNextArgInt(), this.getNextArgRequired(), this.getNextArgRequired());
                    break;
                }
                default: {
                    return this.handleDefaultCommands(cmd);
                }
            }
            return 0;
        }

        private int getNextArgInt() {
            return Integer.parseInt(this.getNextArgRequired());
        }

        @Override
        public void onHelp() {
            this.getOutPrintWriter().println(USAGE);
        }
    }

    private class Association {
        public final int uid;
        public final String deviceAddress;
        public final String companionAppPackage;

        private Association(int uid, String deviceAddress, String companionAppPackage) {
            this.uid = uid;
            this.deviceAddress = Preconditions.checkNotNull(deviceAddress);
            this.companionAppPackage = Preconditions.checkNotNull(companionAppPackage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Association that = (Association)o;
            if (this.uid != that.uid) {
                return false;
            }
            if (!this.deviceAddress.equals(that.deviceAddress)) {
                return false;
            }
            return this.companionAppPackage.equals(that.companionAppPackage);
        }

        public int hashCode() {
            int result = this.uid;
            result = 31 * result + this.deviceAddress.hashCode();
            result = 31 * result + this.companionAppPackage.hashCode();
            return result;
        }
    }

    class CompanionDeviceManagerImpl
    extends ICompanionDeviceManager.Stub {
        CompanionDeviceManagerImpl() {
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            try {
                return super.onTransact(code, data, reply, flags);
            }
            catch (Throwable e) {
                Slog.e(CompanionDeviceManagerService.LOG_TAG, "Error during IPC", e);
                throw ExceptionUtils.propagate(e, RemoteException.class);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void associate(AssociationRequest request, IFindDeviceCallback callback, String callingPackage) throws RemoteException {
            Preconditions.checkNotNull(request, "Request cannot be null");
            Preconditions.checkNotNull(callback, "Callback cannot be null");
            this.checkCallerIsSystemOr(callingPackage);
            int userId = CompanionDeviceManagerService.getCallingUserId();
            this.checkUsesFeature(callingPackage, userId);
            long callingIdentity = Binder.clearCallingIdentity();
            try {
                CompanionDeviceManagerService.this.getContext().bindServiceAsUser(new Intent().setComponent(SERVICE_TO_BIND_TO), CompanionDeviceManagerService.this.createServiceConnection(request, callback, callingPackage), 1, UserHandle.of(userId));
            }
            finally {
                Binder.restoreCallingIdentity(callingIdentity);
            }
        }

        @Override
        public void stopScan(AssociationRequest request, IFindDeviceCallback callback, String callingPackage) {
            if (Objects.equals(request, CompanionDeviceManagerService.this.mRequest) && Objects.equals(callback, CompanionDeviceManagerService.this.mFindDeviceCallback) && Objects.equals(callingPackage, CompanionDeviceManagerService.this.mCallingPackage)) {
                CompanionDeviceManagerService.this.cleanup();
            }
        }

        @Override
        public List<String> getAssociations(String callingPackage, int userId) throws RemoteException {
            this.checkCallerIsSystemOr(callingPackage, userId);
            this.checkUsesFeature(callingPackage, CompanionDeviceManagerService.getCallingUserId());
            return new ArrayList<String>(CollectionUtils.map(CompanionDeviceManagerService.this.readAllAssociations(userId, callingPackage), a -> a.deviceAddress));
        }

        @Override
        public void disassociate(String deviceMacAddress, String callingPackage) throws RemoteException {
            Preconditions.checkNotNull(deviceMacAddress);
            this.checkCallerIsSystemOr(callingPackage);
            this.checkUsesFeature(callingPackage, CompanionDeviceManagerService.getCallingUserId());
            CompanionDeviceManagerService.this.removeAssociation(CompanionDeviceManagerService.getCallingUserId(), callingPackage, deviceMacAddress);
        }

        private void checkCallerIsSystemOr(String pkg) throws RemoteException {
            this.checkCallerIsSystemOr(pkg, CompanionDeviceManagerService.getCallingUserId());
        }

        private void checkCallerIsSystemOr(String pkg, int userId) throws RemoteException {
            if (CompanionDeviceManagerService.isCallerSystem()) {
                return;
            }
            Preconditions.checkArgument(CompanionDeviceManagerService.getCallingUserId() == userId, "Must be called by either same user or system");
            CompanionDeviceManagerService.this.mAppOpsManager.checkPackage(Binder.getCallingUid(), pkg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PendingIntent requestNotificationAccess(ComponentName component) throws RemoteException {
            String callingPackage = component.getPackageName();
            this.checkCanCallNotificationApi(callingPackage);
            int userId = CompanionDeviceManagerService.getCallingUserId();
            String packageTitle = BidiFormatter.getInstance().unicodeWrap(((CompanionDeviceManagerService)CompanionDeviceManagerService.this).getPackageInfo((String)callingPackage, (int)userId).applicationInfo.loadSafeLabel(CompanionDeviceManagerService.this.getContext().getPackageManager(), 500.0f, 5).toString());
            long identity = Binder.clearCallingIdentity();
            try {
                PendingIntent pendingIntent = PendingIntent.getActivity(CompanionDeviceManagerService.this.getContext(), 0, NotificationAccessConfirmationActivityContract.launcherIntent(userId, component, packageTitle), 0x54000000);
                return pendingIntent;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public boolean hasNotificationAccess(ComponentName component) throws RemoteException {
            this.checkCanCallNotificationApi(component.getPackageName());
            String setting = Settings.Secure.getString(CompanionDeviceManagerService.this.getContext().getContentResolver(), "enabled_notification_listeners");
            return new SettingsStringUtil.ComponentNameSet(setting).contains(component);
        }

        private void checkCanCallNotificationApi(String callingPackage) throws RemoteException {
            this.checkCallerIsSystemOr(callingPackage);
            int userId = CompanionDeviceManagerService.getCallingUserId();
            Preconditions.checkState(!ArrayUtils.isEmpty(CompanionDeviceManagerService.this.readAllAssociations(userId, callingPackage)), "App must have an association before calling this API");
            this.checkUsesFeature(callingPackage, userId);
        }

        private void checkUsesFeature(String pkg, int userId) {
            if (CompanionDeviceManagerService.isCallerSystem()) {
                return;
            }
            Object[] reqFeatures = ((CompanionDeviceManagerService)CompanionDeviceManagerService.this).getPackageInfo((String)pkg, (int)userId).reqFeatures;
            String requiredFeature = "android.software.companion_device_setup";
            int numFeatures = ArrayUtils.size(reqFeatures);
            for (int i = 0; i < numFeatures; ++i) {
                if (!requiredFeature.equals(((FeatureInfo)reqFeatures[i]).name)) continue;
                return;
            }
            throw new IllegalStateException("Must declare uses-feature " + requiredFeature + " in manifest to use this API");
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
            new ShellCmd().exec(this, in, out, err, args, callback, resultReceiver);
        }
    }
}

