/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import java.util.concurrent.atomic.AtomicReference;

public class AutodestructReference<T> {
    private final AtomicReference<T> mHeld;

    public AutodestructReference(T obj) {
        if (null == obj) {
            throw new NullPointerException("Autodestruct reference to null");
        }
        this.mHeld = new AtomicReference<T>(obj);
    }

    public T getAndDestroy() {
        T obj = this.mHeld.getAndSet(null);
        if (null == obj) {
            throw new NullPointerException("Already autodestructed");
        }
        return obj;
    }
}

