/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.ISocketKeepaliveCallback;
import android.net.KeepalivePacketData;
import android.net.NattKeepalivePacketData;
import android.net.NetworkUtils;
import android.net.SocketKeepalive;
import android.net.TcpKeepalivePacketData;
import android.net.util.IpUtils;
import android.net.util.KeepaliveUtils;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.HexDump;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.connectivity.NetworkAgentInfo;
import com.android.server.connectivity.TcpKeepaliveController;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class KeepaliveTracker {
    private static final String TAG = "KeepaliveTracker";
    private static final boolean DBG = false;
    public static final String PERMISSION = "android.permission.PACKET_KEEPALIVE_OFFLOAD";
    private final HashMap<NetworkAgentInfo, HashMap<Integer, KeepaliveInfo>> mKeepalives = new HashMap();
    private final Handler mConnectivityServiceHandler;
    private final TcpKeepaliveController mTcpController;
    private final Context mContext;
    private final int[] mSupportedKeepalives;
    private final int mReservedPrivilegedSlots;
    private final int mAllowedUnprivilegedSlotsForUid;

    public KeepaliveTracker(Context context, Handler handler) {
        this.mConnectivityServiceHandler = handler;
        this.mTcpController = new TcpKeepaliveController(handler);
        this.mContext = context;
        this.mSupportedKeepalives = KeepaliveUtils.getSupportedKeepalives(this.mContext);
        this.mReservedPrivilegedSlots = this.mContext.getResources().getInteger(17694876);
        this.mAllowedUnprivilegedSlotsForUid = this.mContext.getResources().getInteger(17694733);
    }

    void notifyErrorCallback(ISocketKeepaliveCallback cb, int error) {
        try {
            cb.onError(error);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Discarded onError(" + error + ") callback");
        }
    }

    private int findFirstFreeSlot(NetworkAgentInfo nai) {
        int slot;
        HashMap<Integer, KeepaliveInfo> networkKeepalives = this.mKeepalives.get(nai);
        if (networkKeepalives == null) {
            networkKeepalives = new HashMap();
            this.mKeepalives.put(nai, networkKeepalives);
        }
        for (slot = 1; slot <= networkKeepalives.size(); ++slot) {
            if (networkKeepalives.get(slot) != null) continue;
            return slot;
        }
        return slot;
    }

    public void handleStartKeepalive(Message message) {
        KeepaliveInfo ki = (KeepaliveInfo)message.obj;
        NetworkAgentInfo nai = ki.getNai();
        int slot = this.findFirstFreeSlot(nai);
        this.mKeepalives.get(nai).put(slot, ki);
        ki.start(slot);
    }

    public void handleStopAllKeepalives(NetworkAgentInfo nai, int reason) {
        HashMap<Integer, KeepaliveInfo> networkKeepalives = this.mKeepalives.get(nai);
        if (networkKeepalives != null) {
            ArrayList<KeepaliveInfo> kalist = new ArrayList<KeepaliveInfo>(networkKeepalives.values());
            for (KeepaliveInfo ki : kalist) {
                ki.stop(reason);
                this.cleanupStoppedKeepalive(nai, ki.mSlot);
            }
        }
    }

    public void handleStopKeepalive(NetworkAgentInfo nai, int slot, int reason) {
        String networkName = nai == null ? "(null)" : nai.name();
        HashMap<Integer, KeepaliveInfo> networkKeepalives = this.mKeepalives.get(nai);
        if (networkKeepalives == null) {
            Log.e(TAG, "Attempt to stop keepalive on nonexistent network " + networkName);
            return;
        }
        KeepaliveInfo ki = networkKeepalives.get(slot);
        if (ki == null) {
            Log.e(TAG, "Attempt to stop nonexistent keepalive " + slot + " on " + networkName);
            return;
        }
        ki.stop(reason);
    }

    private void cleanupStoppedKeepalive(NetworkAgentInfo nai, int slot) {
        String networkName = nai == null ? "(null)" : nai.name();
        HashMap<Integer, KeepaliveInfo> networkKeepalives = this.mKeepalives.get(nai);
        if (networkKeepalives == null) {
            Log.e(TAG, "Attempt to remove keepalive on nonexistent network " + networkName);
            return;
        }
        KeepaliveInfo ki = networkKeepalives.get(slot);
        if (ki == null) {
            Log.e(TAG, "Attempt to remove nonexistent keepalive " + slot + " on " + networkName);
            return;
        }
        networkKeepalives.remove(slot);
        Log.d(TAG, "Remove keepalive " + slot + " on " + networkName + ", " + networkKeepalives.size() + " remains.");
        if (networkKeepalives.isEmpty()) {
            this.mKeepalives.remove(nai);
        }
    }

    public void handleCheckKeepalivesStillValid(NetworkAgentInfo nai) {
        HashMap<Integer, KeepaliveInfo> networkKeepalives = this.mKeepalives.get(nai);
        if (networkKeepalives != null) {
            ArrayList<Pair<Integer, Integer>> invalidKeepalives = new ArrayList<Pair<Integer, Integer>>();
            for (int n : networkKeepalives.keySet()) {
                int error = networkKeepalives.get(n).isValid();
                if (error == 0) continue;
                invalidKeepalives.add(Pair.create(n, error));
            }
            for (Pair pair : invalidKeepalives) {
                this.handleStopKeepalive(nai, (Integer)pair.first, (Integer)pair.second);
            }
        }
    }

    public void handleEventSocketKeepalive(NetworkAgentInfo nai, Message message) {
        int slot = message.arg1;
        int reason = message.arg2;
        KeepaliveInfo ki = null;
        try {
            ki = this.mKeepalives.get(nai).get(slot);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (ki == null) {
            Log.e(TAG, "Event " + message.what + "," + slot + "," + reason + " for unknown keepalive " + slot + " on " + nai.name());
            return;
        }
        if (2 == ki.mStartedState) {
            if (0 == reason) {
                Log.d(TAG, "Started keepalive " + slot + " on " + nai.name());
                ki.mStartedState = 3;
                try {
                    ki.mCallback.onStarted(slot);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Discarded onStarted(" + slot + ") callback");
                }
            } else {
                Log.d(TAG, "Failed to start keepalive " + slot + " on " + nai.name() + ": " + reason);
                this.handleStopKeepalive(nai, slot, reason);
            }
        } else if (4 == ki.mStartedState) {
            Log.d(TAG, "Stopped keepalive " + slot + " on " + nai.name() + " stopped: " + reason);
            ki.mStartedState = 1;
            this.cleanupStoppedKeepalive(nai, slot);
        } else {
            Log.wtf(TAG, "Event " + message.what + "," + slot + "," + reason + " for keepalive in wrong state: " + ki.toString());
        }
    }

    public void startNattKeepalive(NetworkAgentInfo nai, FileDescriptor fd, int intervalSeconds, ISocketKeepaliveCallback cb, String srcAddrString, int srcPort, String dstAddrString, int dstPort) {
        NattKeepalivePacketData packet;
        InetAddress dstAddress;
        InetAddress srcAddress;
        if (nai == null) {
            this.notifyErrorCallback(cb, -20);
            return;
        }
        try {
            srcAddress = NetworkUtils.numericToInetAddress(srcAddrString);
            dstAddress = NetworkUtils.numericToInetAddress(dstAddrString);
        }
        catch (IllegalArgumentException e) {
            this.notifyErrorCallback(cb, -21);
            return;
        }
        try {
            packet = NattKeepalivePacketData.nattKeepalivePacket(srcAddress, srcPort, dstAddress, 4500);
        }
        catch (SocketKeepalive.InvalidPacketException e) {
            this.notifyErrorCallback(cb, e.error);
            return;
        }
        KeepaliveInfo ki = null;
        try {
            ki = new KeepaliveInfo(cb, nai, packet, intervalSeconds, 1, fd);
        }
        catch (SocketKeepalive.InvalidSocketException | IllegalArgumentException | SecurityException e) {
            Log.e(TAG, "Fail to construct keepalive", e);
            this.notifyErrorCallback(cb, -25);
            return;
        }
        Log.d(TAG, "Created keepalive: " + ki.toString());
        this.mConnectivityServiceHandler.obtainMessage(528395, ki).sendToTarget();
    }

    public void startTcpKeepalive(NetworkAgentInfo nai, FileDescriptor fd, int intervalSeconds, ISocketKeepaliveCallback cb) {
        TcpKeepalivePacketData packet;
        if (nai == null) {
            this.notifyErrorCallback(cb, -20);
            return;
        }
        try {
            packet = TcpKeepaliveController.getTcpKeepalivePacket(fd);
        }
        catch (SocketKeepalive.InvalidPacketException | SocketKeepalive.InvalidSocketException e) {
            this.notifyErrorCallback(cb, e.error);
            return;
        }
        KeepaliveInfo ki = null;
        try {
            ki = new KeepaliveInfo(cb, nai, packet, intervalSeconds, 2, fd);
        }
        catch (SocketKeepalive.InvalidSocketException | IllegalArgumentException | SecurityException e) {
            Log.e(TAG, "Fail to construct keepalive e=" + e);
            this.notifyErrorCallback(cb, -25);
            return;
        }
        Log.d(TAG, "Created keepalive: " + ki.toString());
        this.mConnectivityServiceHandler.obtainMessage(528395, ki).sendToTarget();
    }

    public void startNattKeepalive(NetworkAgentInfo nai, FileDescriptor fd, int resourceId, int intervalSeconds, ISocketKeepaliveCallback cb, String srcAddrString, String dstAddrString, int dstPort) {
        if (!KeepaliveTracker.isNattKeepaliveSocketValid(fd, resourceId)) {
            this.notifyErrorCallback(cb, -25);
        }
        int srcPort = 0;
        try {
            SocketAddress srcSockAddr = Os.getsockname(fd);
            srcPort = ((InetSocketAddress)srcSockAddr).getPort();
        }
        catch (ErrnoException e) {
            this.notifyErrorCallback(cb, -25);
        }
        this.startNattKeepalive(nai, fd, intervalSeconds, cb, srcAddrString, srcPort, dstAddrString, dstPort);
    }

    public static boolean isNattKeepaliveSocketValid(FileDescriptor fd, int resourceId) {
        return null != fd;
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("Supported Socket keepalives: " + Arrays.toString(this.mSupportedKeepalives));
        pw.println("Reserved Privileged keepalives: " + this.mReservedPrivilegedSlots);
        pw.println("Allowed Unprivileged keepalives per uid: " + this.mAllowedUnprivilegedSlotsForUid);
        pw.println("Socket keepalives:");
        pw.increaseIndent();
        for (NetworkAgentInfo nai : this.mKeepalives.keySet()) {
            pw.println(nai.name());
            pw.increaseIndent();
            for (int slot : this.mKeepalives.get(nai).keySet()) {
                KeepaliveInfo ki = this.mKeepalives.get(nai).get(slot);
                pw.println(slot + ": " + ki.toString());
            }
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
    }

    class KeepaliveInfo
    implements IBinder.DeathRecipient {
        private final ISocketKeepaliveCallback mCallback;
        private final int mUid;
        private final int mPid;
        private final boolean mPrivileged;
        private final NetworkAgentInfo mNai;
        private final int mType;
        private final FileDescriptor mFd;
        public static final int TYPE_NATT = 1;
        public static final int TYPE_TCP = 2;
        private int mSlot = -1;
        private final KeepalivePacketData mPacket;
        private final int mInterval;
        private static final int NOT_STARTED = 1;
        private static final int STARTING = 2;
        private static final int STARTED = 3;
        private static final int STOPPING = 4;
        private int mStartedState = 1;

        KeepaliveInfo(ISocketKeepaliveCallback callback, NetworkAgentInfo nai, KeepalivePacketData packet, int interval, int type, FileDescriptor fd) throws SocketKeepalive.InvalidSocketException {
            this.mCallback = callback;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.mPrivileged = 0 == KeepaliveTracker.this.mContext.checkPermission(KeepaliveTracker.PERMISSION, this.mPid, this.mUid);
            this.mNai = nai;
            this.mPacket = packet;
            this.mInterval = interval;
            this.mType = type;
            try {
                if (fd != null) {
                    this.mFd = Os.dup(fd);
                } else {
                    Log.d(KeepaliveTracker.TAG, this.toString() + " calls with null fd");
                    if (!this.mPrivileged) {
                        throw new SecurityException("null fd is not allowed for unprivileged access.");
                    }
                    if (this.mType == 2) {
                        throw new IllegalArgumentException("null fd is not allowed for tcp socket keepalives.");
                    }
                    this.mFd = null;
                }
            }
            catch (ErrnoException e) {
                Log.e(KeepaliveTracker.TAG, "Cannot dup fd: ", e);
                throw new SocketKeepalive.InvalidSocketException(-25, (Throwable)e);
            }
            try {
                this.mCallback.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        public NetworkAgentInfo getNai() {
            return this.mNai;
        }

        private String startedStateString(int state) {
            switch (state) {
                case 1: {
                    return "NOT_STARTED";
                }
                case 2: {
                    return "STARTING";
                }
                case 3: {
                    return "STARTED";
                }
                case 4: {
                    return "STOPPING";
                }
            }
            throw new IllegalArgumentException("Unknown state");
        }

        public String toString() {
            return "KeepaliveInfo [ type=" + this.mType + " network=" + this.mNai.network + " startedState=" + this.startedStateString(this.mStartedState) + " " + IpUtils.addressAndPortToString(this.mPacket.srcAddress, this.mPacket.srcPort) + "->" + IpUtils.addressAndPortToString(this.mPacket.dstAddress, this.mPacket.dstPort) + " interval=" + this.mInterval + " uid=" + this.mUid + " pid=" + this.mPid + " privileged=" + this.mPrivileged + " packetData=" + HexDump.toHexString(this.mPacket.getPacket()) + " ]";
        }

        @Override
        public void binderDied() {
            this.stop(-10);
        }

        void unlinkDeathRecipient() {
            if (this.mCallback != null) {
                this.mCallback.asBinder().unlinkToDeath(this, 0);
            }
        }

        private int checkNetworkConnected() {
            if (!this.mNai.networkInfo.isConnectedOrConnecting()) {
                return -20;
            }
            return 0;
        }

        private int checkSourceAddress() {
            for (InetAddress address : this.mNai.linkProperties.getAddresses()) {
                if (!address.equals(this.mPacket.srcAddress)) continue;
                return 0;
            }
            return -21;
        }

        private int checkInterval() {
            if (this.mInterval < 10 || this.mInterval > 3600) {
                return -24;
            }
            return 0;
        }

        private int checkPermission() {
            HashMap networkKeepalives = (HashMap)KeepaliveTracker.this.mKeepalives.get(this.mNai);
            if (networkKeepalives == null) {
                return -20;
            }
            if (this.mPrivileged) {
                return 0;
            }
            int supported = KeepaliveUtils.getSupportedKeepalivesForNetworkCapabilities(KeepaliveTracker.this.mSupportedKeepalives, this.mNai.networkCapabilities);
            int takenUnprivilegedSlots = 0;
            for (KeepaliveInfo ki : networkKeepalives.values()) {
                if (ki.mPrivileged) continue;
                ++takenUnprivilegedSlots;
            }
            if (takenUnprivilegedSlots > supported - KeepaliveTracker.this.mReservedPrivilegedSlots) {
                return -32;
            }
            int unprivilegedCountSameUid = 0;
            for (HashMap kaForNetwork : KeepaliveTracker.this.mKeepalives.values()) {
                for (KeepaliveInfo ki : kaForNetwork.values()) {
                    if (ki.mUid != this.mUid) continue;
                    ++unprivilegedCountSameUid;
                }
            }
            if (unprivilegedCountSameUid > KeepaliveTracker.this.mAllowedUnprivilegedSlotsForUid) {
                return -32;
            }
            return 0;
        }

        private int checkLimit() {
            HashMap networkKeepalives = (HashMap)KeepaliveTracker.this.mKeepalives.get(this.mNai);
            if (networkKeepalives == null) {
                return -20;
            }
            int supported = KeepaliveUtils.getSupportedKeepalivesForNetworkCapabilities(KeepaliveTracker.this.mSupportedKeepalives, this.mNai.networkCapabilities);
            if (supported == 0) {
                return -30;
            }
            if (networkKeepalives.size() > supported) {
                return -32;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int isValid() {
            NetworkAgentInfo networkAgentInfo = this.mNai;
            synchronized (networkAgentInfo) {
                int error = this.checkInterval();
                if (error == 0) {
                    error = this.checkLimit();
                }
                if (error == 0) {
                    error = this.checkPermission();
                }
                if (error == 0) {
                    error = this.checkNetworkConnected();
                }
                if (error == 0) {
                    error = this.checkSourceAddress();
                }
                return error;
            }
        }

        void start(int slot) {
            this.mSlot = slot;
            int error = this.isValid();
            if (error == 0) {
                Log.d(KeepaliveTracker.TAG, "Starting keepalive " + this.mSlot + " on " + this.mNai.name());
                switch (this.mType) {
                    case 1: {
                        this.mNai.asyncChannel.sendMessage(528400, slot, 0, this.mPacket);
                        this.mNai.asyncChannel.sendMessage(528395, slot, this.mInterval, this.mPacket);
                        break;
                    }
                    case 2: {
                        try {
                            KeepaliveTracker.this.mTcpController.startSocketMonitor(this.mFd, this, this.mSlot);
                        }
                        catch (SocketKeepalive.InvalidSocketException e) {
                            KeepaliveTracker.this.handleStopKeepalive(this.mNai, this.mSlot, -25);
                            return;
                        }
                        this.mNai.asyncChannel.sendMessage(528400, slot, 0, this.mPacket);
                        this.mNai.asyncChannel.sendMessage(528395, slot, this.mInterval, this.mPacket);
                        break;
                    }
                    default: {
                        Log.wtf(KeepaliveTracker.TAG, "Starting keepalive with unknown type: " + this.mType);
                        KeepaliveTracker.this.handleStopKeepalive(this.mNai, this.mSlot, error);
                        return;
                    }
                }
            } else {
                KeepaliveTracker.this.handleStopKeepalive(this.mNai, this.mSlot, error);
                return;
            }
            this.mStartedState = 2;
        }

        void stop(int reason) {
            int uid = Binder.getCallingUid();
            if (uid == this.mUid || uid != 1000) {
                // empty if block
            }
            Log.d(KeepaliveTracker.TAG, "Stopping keepalive " + this.mSlot + " on " + this.mNai.name() + ": " + reason);
            block3 : switch (this.mStartedState) {
                case 1: {
                    KeepaliveTracker.this.cleanupStoppedKeepalive(this.mNai, this.mSlot);
                    break;
                }
                case 4: {
                    return;
                }
                default: {
                    this.mStartedState = 4;
                    switch (this.mType) {
                        case 2: {
                            KeepaliveTracker.this.mTcpController.stopSocketMonitor(this.mSlot);
                        }
                        case 1: {
                            this.mNai.asyncChannel.sendMessage(528396, this.mSlot);
                            this.mNai.asyncChannel.sendMessage(528401, this.mSlot);
                            break block3;
                        }
                    }
                    Log.wtf(KeepaliveTracker.TAG, "Stopping keepalive with unknown type: " + this.mType);
                }
            }
            if (this.mFd != null) {
                try {
                    Os.close(this.mFd);
                }
                catch (ErrnoException e) {
                    Log.wtf(KeepaliveTracker.TAG, "Error closing fd for keepalive " + this.mSlot + ": " + e);
                }
            }
            if (reason == 0) {
                try {
                    this.mCallback.onStopped();
                }
                catch (RemoteException e) {
                    Log.w(KeepaliveTracker.TAG, "Discarded onStop callback: " + reason);
                }
            } else if (reason == -2) {
                try {
                    this.mCallback.onDataReceived();
                }
                catch (RemoteException e) {
                    Log.w(KeepaliveTracker.TAG, "Discarded onDataReceived callback: " + reason);
                }
            } else {
                KeepaliveTracker.this.notifyErrorCallback(this.mCallback, reason);
            }
            this.unlinkDeathRecipient();
        }

        void onFileDescriptorInitiatedStop(int socketKeepaliveReason) {
            KeepaliveTracker.this.handleStopKeepalive(this.mNai, this.mSlot, socketKeepaliveReason);
        }
    }
}

