/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.NetworkSpecifier;
import android.net.StringNetworkSpecifier;
import android.net.wifi.WifiInfo;
import android.os.UserHandle;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.server.connectivity.NetworkAgentInfo;

public class NetworkNotificationManager {
    private static final String TAG = NetworkNotificationManager.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final Context mContext;
    private final TelephonyManager mTelephonyManager;
    private final NotificationManager mNotificationManager;
    private final SparseIntArray mNotificationTypeMap;

    public NetworkNotificationManager(Context c, TelephonyManager t, NotificationManager n) {
        this.mContext = c;
        this.mTelephonyManager = t;
        this.mNotificationManager = n;
        this.mNotificationTypeMap = new SparseIntArray();
    }

    private static int getFirstTransportType(NetworkAgentInfo nai) {
        for (int i = 0; i < 64; ++i) {
            if (!nai.networkCapabilities.hasTransport(i)) continue;
            return i;
        }
        return -1;
    }

    private static String getTransportName(int transportType) {
        Resources r = Resources.getSystem();
        String[] networkTypes = r.getStringArray(17236091);
        try {
            return networkTypes[transportType];
        }
        catch (IndexOutOfBoundsException e) {
            return r.getString(17040464);
        }
    }

    private static int getIcon(int transportType, NotificationType notifyType) {
        if (transportType != 1) {
            return 17303514;
        }
        return notifyType == NotificationType.LOGGED_IN ? 17302849 : 17303518;
    }

    public void showNotification(int id2, NotificationType notifyType, NetworkAgentInfo nai, NetworkAgentInfo switchToNai, PendingIntent intent, boolean highPriority) {
        String details;
        String title;
        int previousEventId;
        NotificationType previousNotifyType;
        String name;
        int transportType;
        String tag = NetworkNotificationManager.tagFor(id2);
        int eventId = notifyType.eventId;
        if (nai != null) {
            transportType = NetworkNotificationManager.getFirstTransportType(nai);
            String extraInfo = nai.networkInfo.getExtraInfo();
            String string2 = name = TextUtils.isEmpty(extraInfo) ? nai.networkCapabilities.getSSID() : extraInfo;
            if (!nai.networkCapabilities.hasCapability(12)) {
                return;
            }
        } else {
            transportType = 0;
            name = null;
        }
        if (NetworkNotificationManager.priority(previousNotifyType = NotificationType.getFromId(previousEventId = this.mNotificationTypeMap.get(id2))) > NetworkNotificationManager.priority(notifyType)) {
            Slog.d(TAG, String.format("ignoring notification %s for network %s with existing notification %s", new Object[]{notifyType, id2, previousNotifyType}));
            return;
        }
        this.clearNotification(id2);
        Slog.d(TAG, String.format("showNotification tag=%s event=%s transport=%s name=%s highPriority=%s", tag, NetworkNotificationManager.nameOf(eventId), NetworkNotificationManager.getTransportName(transportType), name, highPriority));
        Resources r = Resources.getSystem();
        int icon = NetworkNotificationManager.getIcon(transportType, notifyType);
        if (notifyType == NotificationType.NO_INTERNET && transportType == 1) {
            title = r.getString(17041282, WifiInfo.removeDoubleQuotes(nai.networkCapabilities.getSSID()));
            details = r.getString(17041283);
        } else if (notifyType == NotificationType.PARTIAL_CONNECTIVITY && transportType == 1) {
            title = r.getString(17040459, WifiInfo.removeDoubleQuotes(nai.networkCapabilities.getSSID()));
            details = r.getString(17040460);
        } else if (notifyType == NotificationType.LOST_INTERNET && transportType == 1) {
            title = r.getString(17041282, WifiInfo.removeDoubleQuotes(nai.networkCapabilities.getSSID()));
            details = r.getString(17041283);
        } else if (notifyType == NotificationType.SIGN_IN) {
            switch (transportType) {
                case 1: {
                    title = r.getString(17041272, 0);
                    details = r.getString(17040456, WifiInfo.removeDoubleQuotes(nai.networkCapabilities.getSSID()));
                    break;
                }
                case 0: {
                    title = r.getString(17040455, 0);
                    NetworkSpecifier specifier = nai.networkCapabilities.getNetworkSpecifier();
                    int subId = Integer.MAX_VALUE;
                    if (specifier instanceof StringNetworkSpecifier) {
                        try {
                            subId = Integer.parseInt(((StringNetworkSpecifier)specifier).specifier);
                        }
                        catch (NumberFormatException e) {
                            Slog.e(TAG, "NumberFormatException on " + ((StringNetworkSpecifier)specifier).specifier);
                        }
                    }
                    details = this.mTelephonyManager.createForSubscriptionId(subId).getNetworkOperatorName();
                    break;
                }
                default: {
                    title = r.getString(17040455, 0);
                    details = r.getString(17040456, name);
                    break;
                }
            }
        } else if (notifyType == NotificationType.LOGGED_IN) {
            title = WifiInfo.removeDoubleQuotes(nai.networkCapabilities.getSSID());
            details = r.getString(17039641);
        } else if (notifyType == NotificationType.NETWORK_SWITCH) {
            String fromTransport = NetworkNotificationManager.getTransportName(transportType);
            String toTransport = NetworkNotificationManager.getTransportName(NetworkNotificationManager.getFirstTransportType(switchToNai));
            title = r.getString(17040461, toTransport);
            details = r.getString(17040462, toTransport, fromTransport);
        } else {
            if (notifyType == NotificationType.NO_INTERNET || notifyType == NotificationType.PARTIAL_CONNECTIVITY) {
                return;
            }
            Slog.wtf(TAG, "Unknown notification type " + (Object)((Object)notifyType) + " on network transport " + NetworkNotificationManager.getTransportName(transportType));
            return;
        }
        boolean hasPreviousNotification = previousNotifyType != null;
        String channelId = highPriority && !hasPreviousNotification ? SystemNotificationChannels.NETWORK_ALERTS : SystemNotificationChannels.NETWORK_STATUS;
        Notification.Builder builder = new Notification.Builder(this.mContext, channelId).setWhen(System.currentTimeMillis()).setShowWhen(notifyType == NotificationType.NETWORK_SWITCH).setSmallIcon(icon).setAutoCancel(true).setTicker(title).setColor(this.mContext.getColor(17170460)).setContentTitle(title).setContentIntent(intent).setLocalOnly(true).setOnlyAlertOnce(true);
        if (notifyType == NotificationType.NETWORK_SWITCH) {
            builder.setStyle(new Notification.BigTextStyle().bigText(details));
        } else {
            builder.setContentText(details);
        }
        if (notifyType == NotificationType.SIGN_IN) {
            builder.extend(new Notification.TvExtender().setChannelId(channelId));
        }
        Notification notification = builder.build();
        this.mNotificationTypeMap.put(id2, eventId);
        try {
            this.mNotificationManager.notifyAsUser(tag, eventId, notification, UserHandle.ALL);
        }
        catch (NullPointerException npe) {
            Slog.d(TAG, "setNotificationVisible: visible notificationManager error", npe);
        }
    }

    public void clearNotification(int id2, NotificationType notifyType) {
        int previousEventId = this.mNotificationTypeMap.get(id2);
        NotificationType previousNotifyType = NotificationType.getFromId(previousEventId);
        if (notifyType != previousNotifyType) {
            return;
        }
        this.clearNotification(id2);
    }

    public void clearNotification(int id2) {
        if (this.mNotificationTypeMap.indexOfKey(id2) < 0) {
            return;
        }
        String tag = NetworkNotificationManager.tagFor(id2);
        int eventId = this.mNotificationTypeMap.get(id2);
        Slog.d(TAG, String.format("clearing notification tag=%s event=%s", tag, NetworkNotificationManager.nameOf(eventId)));
        try {
            this.mNotificationManager.cancelAsUser(tag, eventId, UserHandle.ALL);
        }
        catch (NullPointerException npe) {
            Slog.d(TAG, String.format("failed to clear notification tag=%s event=%s", tag, NetworkNotificationManager.nameOf(eventId)), npe);
        }
        this.mNotificationTypeMap.delete(id2);
    }

    public void setProvNotificationVisible(boolean visible, int id2, String action) {
        if (visible) {
            Intent intent = new Intent(action);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
            this.showNotification(id2, NotificationType.SIGN_IN, null, null, pendingIntent, false);
        } else {
            this.clearNotification(id2);
        }
    }

    public void showToast(NetworkAgentInfo fromNai, NetworkAgentInfo toNai) {
        String fromTransport = NetworkNotificationManager.getTransportName(NetworkNotificationManager.getFirstTransportType(fromNai));
        String toTransport = NetworkNotificationManager.getTransportName(NetworkNotificationManager.getFirstTransportType(toNai));
        String text = this.mContext.getResources().getString(17040463, fromTransport, toTransport);
        Toast.makeText(this.mContext, text, 1).show();
    }

    @VisibleForTesting
    static String tagFor(int id2) {
        return String.format("ConnectivityNotification:%d", id2);
    }

    @VisibleForTesting
    static String nameOf(int eventId) {
        NotificationType t = NotificationType.getFromId(eventId);
        return t != null ? t.name() : "UNKNOWN";
    }

    private static int priority(NotificationType t) {
        if (t == null) {
            return 0;
        }
        switch (t) {
            case SIGN_IN: {
                return 5;
            }
            case PARTIAL_CONNECTIVITY: {
                return 4;
            }
            case NO_INTERNET: {
                return 3;
            }
            case NETWORK_SWITCH: {
                return 2;
            }
            case LOST_INTERNET: 
            case LOGGED_IN: {
                return 1;
            }
        }
        return 0;
    }

    public static enum NotificationType {
        LOST_INTERNET(742),
        NETWORK_SWITCH(743),
        NO_INTERNET(741),
        LOGGED_IN(744),
        PARTIAL_CONNECTIVITY(745),
        SIGN_IN(740);

        public final int eventId;

        private NotificationType(int eventId) {
            this.eventId = eventId;
            Holder.sIdToTypeMap.put(eventId, this);
        }

        public static NotificationType getFromId(int id2) {
            return (NotificationType)((Object)Holder.sIdToTypeMap.get(id2));
        }

        private static class Holder {
            private static SparseArray<NotificationType> sIdToTypeMap = new SparseArray();

            private Holder() {
            }
        }
    }
}

