/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.UserInfo;
import android.net.INetd;
import android.net.UidRange;
import android.os.Build;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.UserHandle;
import android.os.UserManager;
import android.system.OsConstants;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.SystemConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionMonitor {
    private static final String TAG = "PermissionMonitor";
    private static final boolean DBG = true;
    protected static final Boolean SYSTEM = Boolean.TRUE;
    protected static final Boolean NETWORK = Boolean.FALSE;
    private static final int VERSION_Q = 29;
    private final PackageManager mPackageManager;
    private final UserManager mUserManager;
    private final INetd mNetd;
    @GuardedBy(value={"this"})
    private final Set<Integer> mUsers = new HashSet<Integer>();
    @GuardedBy(value={"this"})
    private final Map<Integer, Boolean> mApps = new HashMap<Integer, Boolean>();
    @GuardedBy(value={"this"})
    private final Map<String, Set<UidRange>> mVpnUidRanges = new HashMap<String, Set<UidRange>>();
    @GuardedBy(value={"this"})
    private final Set<Integer> mAllApps = new HashSet<Integer>();

    public PermissionMonitor(Context context, INetd netd) {
        this.mPackageManager = context.getPackageManager();
        this.mUserManager = (UserManager)context.getSystemService("user");
        this.mNetd = netd;
    }

    public synchronized void startMonitoring() {
        PermissionMonitor.log("Monitoring");
        PackageManagerInternal pmi = LocalServices.getService(PackageManagerInternal.class);
        if (pmi != null) {
            pmi.getPackageList(new PackageListObserver());
        } else {
            PermissionMonitor.loge("failed to get the PackageManagerInternal service");
        }
        List<PackageInfo> apps = this.mPackageManager.getInstalledPackages(0x401000);
        if (apps == null) {
            PermissionMonitor.loge("No apps");
            return;
        }
        SparseIntArray netdPermsUids = new SparseIntArray();
        for (PackageInfo packageInfo : apps) {
            Boolean permission2;
            int uid;
            int n = uid = packageInfo.applicationInfo != null ? packageInfo.applicationInfo.uid : -1;
            if (uid < 0) continue;
            this.mAllApps.add(UserHandle.getAppId(uid));
            boolean isNetwork = this.hasNetworkPermission(packageInfo);
            boolean hasRestrictedPermission = this.hasRestrictedNetworkPermission(packageInfo);
            if ((isNetwork || hasRestrictedPermission) && ((permission2 = this.mApps.get(uid)) == null || permission2 == NETWORK)) {
                this.mApps.put(uid, hasRestrictedPermission);
            }
            int otherNetdPerms = PermissionMonitor.getNetdPermissionMask(packageInfo.requestedPermissions, packageInfo.requestedPermissionsFlags);
            netdPermsUids.put(uid, netdPermsUids.get(uid) | otherNetdPerms);
        }
        List<UserInfo> users = this.mUserManager.getUsers(true);
        if (users != null) {
            for (UserInfo user : users) {
                this.mUsers.add(user.id);
            }
        }
        SparseArray<ArraySet<String>> sparseArray = SystemConfig.getInstance().getSystemPermissions();
        for (int i = 0; i < sparseArray.size(); ++i) {
            ArraySet<String> perms = sparseArray.valueAt(i);
            int uid = sparseArray.keyAt(i);
            int netdPermission = 0;
            if (perms != null) {
                netdPermission |= perms.contains("android.permission.UPDATE_DEVICE_STATS") ? 8 : 0;
                netdPermission |= perms.contains("android.permission.INTERNET") ? 4 : 0;
            }
            netdPermsUids.put(uid, netdPermsUids.get(uid) | netdPermission);
        }
        PermissionMonitor.log("Users: " + this.mUsers.size() + ", Apps: " + this.mApps.size());
        this.update(this.mUsers, this.mApps, true);
        this.sendPackagePermissionsToNetd(netdPermsUids);
    }

    @VisibleForTesting
    static boolean isVendorApp(ApplicationInfo appInfo) {
        return appInfo.isVendor() || appInfo.isOem() || appInfo.isProduct();
    }

    @VisibleForTesting
    protected int getDeviceFirstSdkInt() {
        return Build.VERSION.FIRST_SDK_INT;
    }

    @VisibleForTesting
    boolean hasPermission(PackageInfo app, String permission2) {
        if (app.requestedPermissions != null) {
            for (String p : app.requestedPermissions) {
                if (!permission2.equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNetworkPermission(PackageInfo app) {
        return this.hasPermission(app, "android.permission.CHANGE_NETWORK_STATE");
    }

    private boolean hasRestrictedNetworkPermission(PackageInfo app) {
        if (app.applicationInfo != null) {
            if (app.applicationInfo.uid == 1000 && this.getDeviceFirstSdkInt() < 29) {
                return true;
            }
            if (app.applicationInfo.targetSdkVersion < 29 && PermissionMonitor.isVendorApp(app.applicationInfo)) {
                return true;
            }
        }
        return this.hasPermission(app, "android.permission.CONNECTIVITY_INTERNAL") || this.hasPermission(app, "android.permission.CONNECTIVITY_USE_RESTRICTED_NETWORKS");
    }

    private boolean hasUseBackgroundNetworksPermission(PackageInfo app) {
        return this.hasPermission(app, "android.permission.CHANGE_NETWORK_STATE") || this.hasPermission(app, "android.permission.NETWORK_STACK") || this.hasRestrictedNetworkPermission(app);
    }

    public boolean hasUseBackgroundNetworksPermission(int uid) {
        String[] names = this.mPackageManager.getPackagesForUid(uid);
        if (null == names || names.length == 0) {
            return false;
        }
        try {
            int userId = UserHandle.getUserId(uid);
            PackageInfo app = this.mPackageManager.getPackageInfoAsUser(names[0], 4096, userId);
            return this.hasUseBackgroundNetworksPermission(app);
        }
        catch (PackageManager.NameNotFoundException e) {
            PermissionMonitor.loge("NameNotFoundException " + names[0], e);
            return false;
        }
    }

    private int[] toIntArray(Collection<Integer> list) {
        int[] array2 = new int[list.size()];
        int i = 0;
        for (Integer item : list) {
            array2[i++] = item;
        }
        return array2;
    }

    private void update(Set<Integer> users, Map<Integer, Boolean> apps, boolean add) {
        ArrayList<Integer> network = new ArrayList<Integer>();
        ArrayList<Integer> system = new ArrayList<Integer>();
        for (Map.Entry<Integer, Boolean> app : apps.entrySet()) {
            ArrayList<Integer> list = app.getValue() != false ? system : network;
            for (int user : users) {
                list.add(UserHandle.getUid(user, app.getKey()));
            }
        }
        try {
            if (add) {
                this.mNetd.networkSetPermissionForUser(1, this.toIntArray(network));
                this.mNetd.networkSetPermissionForUser(2, this.toIntArray(system));
            } else {
                this.mNetd.networkClearPermissionForUser(this.toIntArray(network));
                this.mNetd.networkClearPermissionForUser(this.toIntArray(system));
            }
        }
        catch (RemoteException e) {
            PermissionMonitor.loge("Exception when updating permissions: " + e);
        }
    }

    public synchronized void onUserAdded(int user) {
        if (user < 0) {
            PermissionMonitor.loge("Invalid user in onUserAdded: " + user);
            return;
        }
        this.mUsers.add(user);
        HashSet<Integer> users = new HashSet<Integer>();
        users.add(user);
        this.update(users, this.mApps, true);
    }

    public synchronized void onUserRemoved(int user) {
        if (user < 0) {
            PermissionMonitor.loge("Invalid user in onUserRemoved: " + user);
            return;
        }
        this.mUsers.remove(user);
        HashSet<Integer> users = new HashSet<Integer>();
        users.add(user);
        this.update(users, this.mApps, false);
    }

    @VisibleForTesting
    protected Boolean highestPermissionForUid(Boolean currentPermission, String name) {
        if (currentPermission == SYSTEM) {
            return currentPermission;
        }
        try {
            PackageInfo app = this.mPackageManager.getPackageInfo(name, 4096);
            boolean isNetwork = this.hasNetworkPermission(app);
            boolean hasRestrictedPermission = this.hasRestrictedNetworkPermission(app);
            if (isNetwork || hasRestrictedPermission) {
                currentPermission = hasRestrictedPermission;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            PermissionMonitor.loge("NameNotFoundException " + name);
        }
        return currentPermission;
    }

    public synchronized void onPackageAdded(String packageName, int uid) {
        Boolean permission2 = this.highestPermissionForUid(this.mApps.get(uid), packageName);
        if (permission2 != this.mApps.get(uid)) {
            this.mApps.put(uid, permission2);
            HashMap<Integer, Boolean> apps = new HashMap<Integer, Boolean>();
            apps.put(uid, permission2);
            this.update(this.mUsers, apps, true);
        }
        for (Map.Entry<String, Set<UidRange>> vpn : this.mVpnUidRanges.entrySet()) {
            if (!UidRange.containsUid((Collection<UidRange>)vpn.getValue(), uid)) continue;
            HashSet<Integer> changedUids = new HashSet<Integer>();
            changedUids.add(uid);
            this.removeBypassingUids(changedUids, -1);
            this.updateVpnUids(vpn.getKey(), changedUids, true);
        }
        this.mAllApps.add(UserHandle.getAppId(uid));
    }

    public synchronized void onPackageRemoved(int uid) {
        for (Map.Entry<String, Set<UidRange>> vpn : this.mVpnUidRanges.entrySet()) {
            if (!UidRange.containsUid((Collection<UidRange>)vpn.getValue(), uid)) continue;
            HashSet<Integer> changedUids = new HashSet<Integer>();
            changedUids.add(uid);
            this.removeBypassingUids(changedUids, -1);
            this.updateVpnUids(vpn.getKey(), changedUids, false);
        }
        if (this.mPackageManager.getNameForUid(uid) == null) {
            this.mAllApps.remove(UserHandle.getAppId(uid));
        }
        HashMap<Integer, Boolean> apps = new HashMap<Integer, Boolean>();
        Boolean permission2 = null;
        String[] packages = this.mPackageManager.getPackagesForUid(uid);
        if (packages != null && packages.length > 0) {
            for (String name : packages) {
                if ((permission2 = this.highestPermissionForUid(permission2, name)) != SYSTEM) continue;
                return;
            }
        }
        if (permission2 == this.mApps.get(uid)) {
            return;
        }
        if (permission2 != null) {
            this.mApps.put(uid, permission2);
            apps.put(uid, permission2);
            this.update(this.mUsers, apps, true);
        } else {
            this.mApps.remove(uid);
            apps.put(uid, NETWORK);
            this.update(this.mUsers, apps, false);
        }
    }

    private static int getNetdPermissionMask(String[] requestedPermissions, int[] requestedPermissionsFlags) {
        int permissions = 0;
        if (requestedPermissions == null || requestedPermissionsFlags == null) {
            return permissions;
        }
        for (int i = 0; i < requestedPermissions.length; ++i) {
            if (requestedPermissions[i].equals("android.permission.INTERNET") && (requestedPermissionsFlags[i] & 2) != 0) {
                permissions |= 4;
            }
            if (!requestedPermissions[i].equals("android.permission.UPDATE_DEVICE_STATS") || (requestedPermissionsFlags[i] & 2) == 0) continue;
            permissions |= 8;
        }
        return permissions;
    }

    private PackageInfo getPackageInfo(String packageName) {
        try {
            PackageInfo app = this.mPackageManager.getPackageInfo(packageName, 0x401000);
            return app;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public synchronized void onVpnUidRangesAdded(String iface, Set<UidRange> rangesToAdd, int vpnAppUid) {
        Set<Integer> changedUids = this.intersectUids(rangesToAdd, this.mAllApps);
        this.removeBypassingUids(changedUids, vpnAppUid);
        this.updateVpnUids(iface, changedUids, true);
        if (this.mVpnUidRanges.containsKey(iface)) {
            this.mVpnUidRanges.get(iface).addAll(rangesToAdd);
        } else {
            this.mVpnUidRanges.put(iface, new HashSet<UidRange>(rangesToAdd));
        }
    }

    public synchronized void onVpnUidRangesRemoved(String iface, Set<UidRange> rangesToRemove, int vpnAppUid) {
        Set<Integer> changedUids = this.intersectUids(rangesToRemove, this.mAllApps);
        this.removeBypassingUids(changedUids, vpnAppUid);
        this.updateVpnUids(iface, changedUids, false);
        Set existingRanges = this.mVpnUidRanges.getOrDefault(iface, null);
        if (existingRanges == null) {
            PermissionMonitor.loge("Attempt to remove unknown vpn uid Range iface = " + iface);
            return;
        }
        existingRanges.removeAll(rangesToRemove);
        if (existingRanges.size() == 0) {
            this.mVpnUidRanges.remove(iface);
        }
    }

    private Set<Integer> intersectUids(Set<UidRange> ranges, Set<Integer> appIds) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (UidRange range : ranges) {
            for (int userId = range.getStartUser(); userId <= range.getEndUser(); ++userId) {
                for (int appId : appIds) {
                    int uid = UserHandle.getUid(userId, appId);
                    if (!range.contains(uid)) continue;
                    result.add(uid);
                }
            }
        }
        return result;
    }

    private void removeBypassingUids(Set<Integer> uids, int vpnAppUid) {
        uids.remove(vpnAppUid);
        uids.removeIf(uid -> this.mApps.getOrDefault(uid, NETWORK) == SYSTEM);
    }

    private void updateVpnUids(String iface, Set<Integer> uids, boolean add) {
        if (uids.size() == 0) {
            return;
        }
        try {
            if (add) {
                this.mNetd.firewallAddUidInterfaceRules(iface, this.toIntArray(uids));
            } else {
                this.mNetd.firewallRemoveUidInterfaceRules(this.toIntArray(uids));
            }
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode != OsConstants.EOPNOTSUPP) {
                PermissionMonitor.loge("Exception when updating permissions: ", e);
            }
        }
        catch (RemoteException e) {
            PermissionMonitor.loge("Exception when updating permissions: ", e);
        }
    }

    @VisibleForTesting
    void sendPackagePermissionsForUid(int uid, int permissions) {
        SparseIntArray netdPermissionsAppIds = new SparseIntArray();
        netdPermissionsAppIds.put(uid, permissions);
        this.sendPackagePermissionsToNetd(netdPermissionsAppIds);
    }

    @VisibleForTesting
    void sendPackagePermissionsToNetd(SparseIntArray netdPermissionsAppIds) {
        if (this.mNetd == null) {
            Log.e(TAG, "Failed to get the netd service");
            return;
        }
        ArrayList<Integer> allPermissionAppIds = new ArrayList<Integer>();
        ArrayList<Integer> internetPermissionAppIds = new ArrayList<Integer>();
        ArrayList<Integer> updateStatsPermissionAppIds = new ArrayList<Integer>();
        ArrayList<Integer> noPermissionAppIds = new ArrayList<Integer>();
        ArrayList<Integer> uninstalledAppIds = new ArrayList<Integer>();
        block9: for (int i = 0; i < netdPermissionsAppIds.size(); ++i) {
            int permissions = netdPermissionsAppIds.valueAt(i);
            switch (permissions) {
                case 12: {
                    allPermissionAppIds.add(netdPermissionsAppIds.keyAt(i));
                    continue block9;
                }
                case 4: {
                    internetPermissionAppIds.add(netdPermissionsAppIds.keyAt(i));
                    continue block9;
                }
                case 8: {
                    updateStatsPermissionAppIds.add(netdPermissionsAppIds.keyAt(i));
                    continue block9;
                }
                case 0: {
                    noPermissionAppIds.add(netdPermissionsAppIds.keyAt(i));
                    continue block9;
                }
                case -1: {
                    uninstalledAppIds.add(netdPermissionsAppIds.keyAt(i));
                }
                default: {
                    Log.e(TAG, "unknown permission type: " + permissions + "for uid: " + netdPermissionsAppIds.keyAt(i));
                }
            }
        }
        try {
            if (allPermissionAppIds.size() != 0) {
                this.mNetd.trafficSetNetPermForUids(12, ArrayUtils.convertToIntArray(allPermissionAppIds));
            }
            if (internetPermissionAppIds.size() != 0) {
                this.mNetd.trafficSetNetPermForUids(4, ArrayUtils.convertToIntArray(internetPermissionAppIds));
            }
            if (updateStatsPermissionAppIds.size() != 0) {
                this.mNetd.trafficSetNetPermForUids(8, ArrayUtils.convertToIntArray(updateStatsPermissionAppIds));
            }
            if (noPermissionAppIds.size() != 0) {
                this.mNetd.trafficSetNetPermForUids(0, ArrayUtils.convertToIntArray(noPermissionAppIds));
            }
            if (uninstalledAppIds.size() != 0) {
                this.mNetd.trafficSetNetPermForUids(-1, ArrayUtils.convertToIntArray(uninstalledAppIds));
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Pass appId list of special permission failed." + e);
        }
    }

    @VisibleForTesting
    public Set<UidRange> getVpnUidRanges(String iface) {
        return this.mVpnUidRanges.get(iface);
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("Interface filtering rules:");
        pw.increaseIndent();
        for (Map.Entry<String, Set<UidRange>> vpn : this.mVpnUidRanges.entrySet()) {
            pw.println("Interface: " + vpn.getKey());
            pw.println("UIDs: " + vpn.getValue().toString());
            pw.println();
        }
        pw.decreaseIndent();
    }

    private static void log(String s) {
        Log.d(TAG, s);
    }

    private static void loge(String s) {
        Log.e(TAG, s);
    }

    private static void loge(String s, Throwable e) {
        Log.e(TAG, s, e);
    }

    private class PackageListObserver
    implements PackageManagerInternal.PackageListObserver {
        private PackageListObserver() {
        }

        private int getPermissionForUid(int uid) {
            int permission2 = 0;
            String[] packages = PermissionMonitor.this.mPackageManager.getPackagesForUid(uid);
            if (packages != null && packages.length > 0) {
                for (String name : packages) {
                    PackageInfo app = PermissionMonitor.this.getPackageInfo(name);
                    if (app == null || app.requestedPermissions == null) continue;
                    permission2 |= PermissionMonitor.getNetdPermissionMask(app.requestedPermissions, app.requestedPermissionsFlags);
                }
            } else {
                permission2 = -1;
            }
            return permission2;
        }

        @Override
        public void onPackageAdded(String packageName, int uid) {
            PermissionMonitor.this.sendPackagePermissionsForUid(uid, this.getPermissionForUid(uid));
        }

        @Override
        public void onPackageRemoved(String packageName, int uid) {
            PermissionMonitor.this.sendPackagePermissionsForUid(uid, this.getPermissionForUid(uid));
        }
    }
}

