/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.connectivity.PacManager;
import java.util.Objects;

public class ProxyTracker {
    private static final String TAG = ProxyTracker.class.getSimpleName();
    private static final boolean DBG = true;
    private final Context mContext;
    private final Object mProxyLock = new Object();
    @GuardedBy(value={"mProxyLock"})
    private ProxyInfo mGlobalProxy = null;
    @GuardedBy(value={"mProxyLock"})
    private volatile ProxyInfo mDefaultProxy = null;
    @GuardedBy(value={"mProxyLock"})
    private boolean mDefaultProxyEnabled = true;
    private final PacManager mPacManager;

    public ProxyTracker(Context context, Handler connectivityServiceInternalHandler, int pacChangedEvent) {
        this.mContext = context;
        this.mPacManager = new PacManager(context, connectivityServiceInternalHandler, pacChangedEvent);
    }

    private static ProxyInfo canonicalizeProxyInfo(ProxyInfo proxy) {
        if (proxy != null && TextUtils.isEmpty(proxy.getHost()) && Uri.EMPTY.equals(proxy.getPacFileUrl())) {
            return null;
        }
        return proxy;
    }

    public static boolean proxyInfoEqual(ProxyInfo a, ProxyInfo b) {
        ProxyInfo pb;
        ProxyInfo pa = ProxyTracker.canonicalizeProxyInfo(a);
        return Objects.equals(pa, pb = ProxyTracker.canonicalizeProxyInfo(b)) && (pa == null || Objects.equals(pa.getHost(), pb.getHost()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyInfo getDefaultProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            if (this.mGlobalProxy != null) {
                return this.mGlobalProxy;
            }
            if (this.mDefaultProxyEnabled) {
                return this.mDefaultProxy;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyInfo getGlobalProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            return this.mGlobalProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGlobalProxy() {
        ContentResolver res = this.mContext.getContentResolver();
        String host = Settings.Global.getString(res, "global_http_proxy_host");
        int port = Settings.Global.getInt(res, "global_http_proxy_port", 0);
        String exclList = Settings.Global.getString(res, "global_http_proxy_exclusion_list");
        String pacFileUrl = Settings.Global.getString(res, "global_proxy_pac_url");
        if (!TextUtils.isEmpty(host) || !TextUtils.isEmpty(pacFileUrl)) {
            ProxyInfo proxyProperties = !TextUtils.isEmpty(pacFileUrl) ? new ProxyInfo(pacFileUrl) : new ProxyInfo(host, port, exclList);
            if (!proxyProperties.isValid()) {
                Slog.d(TAG, "Invalid proxy properties, ignoring: " + proxyProperties);
                return;
            }
            Object object = this.mProxyLock;
            synchronized (object) {
                this.mGlobalProxy = proxyProperties;
            }
        }
        this.loadDeprecatedGlobalHttpProxy();
    }

    public void loadDeprecatedGlobalHttpProxy() {
        String proxy = Settings.Global.getString(this.mContext.getContentResolver(), "http_proxy");
        if (!TextUtils.isEmpty(proxy)) {
            String[] data = proxy.split(":");
            if (data.length == 0) {
                return;
            }
            String proxyHost = data[0];
            int proxyPort = 8080;
            if (data.length > 1) {
                try {
                    proxyPort = Integer.parseInt(data[1]);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            ProxyInfo p = new ProxyInfo(proxyHost, proxyPort, "");
            this.setGlobalProxy(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendProxyBroadcast() {
        ProxyInfo proxyInfo;
        ProxyInfo defaultProxy = this.getDefaultProxy();
        ProxyInfo proxyInfo2 = proxyInfo = null != defaultProxy ? defaultProxy : new ProxyInfo("", 0, "");
        if (!this.mPacManager.setCurrentProxyScriptUrl(proxyInfo)) {
            return;
        }
        Slog.d(TAG, "sending Proxy Broadcast for " + proxyInfo);
        Intent intent = new Intent("android.intent.action.PROXY_CHANGE");
        intent.addFlags(0x24000000);
        intent.putExtra("android.intent.extra.PROXY_INFO", proxyInfo);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalProxy(ProxyInfo proxyInfo) {
        Object object = this.mProxyLock;
        synchronized (object) {
            String pacFileUrl;
            String exclList;
            int port;
            String host;
            if (proxyInfo == this.mGlobalProxy) {
                return;
            }
            if (proxyInfo != null && proxyInfo.equals(this.mGlobalProxy)) {
                return;
            }
            if (this.mGlobalProxy != null && this.mGlobalProxy.equals(proxyInfo)) {
                return;
            }
            if (!(proxyInfo == null || TextUtils.isEmpty(proxyInfo.getHost()) && Uri.EMPTY.equals(proxyInfo.getPacFileUrl()))) {
                if (!proxyInfo.isValid()) {
                    Slog.d(TAG, "Invalid proxy properties, ignoring: " + proxyInfo);
                    return;
                }
                this.mGlobalProxy = new ProxyInfo(proxyInfo);
                host = this.mGlobalProxy.getHost();
                port = this.mGlobalProxy.getPort();
                exclList = this.mGlobalProxy.getExclusionListAsString();
                pacFileUrl = Uri.EMPTY.equals(proxyInfo.getPacFileUrl()) ? "" : proxyInfo.getPacFileUrl().toString();
            } else {
                host = "";
                port = 0;
                exclList = "";
                pacFileUrl = "";
                this.mGlobalProxy = null;
            }
            ContentResolver res = this.mContext.getContentResolver();
            long token = Binder.clearCallingIdentity();
            try {
                Settings.Global.putString(res, "global_http_proxy_host", host);
                Settings.Global.putInt(res, "global_http_proxy_port", port);
                Settings.Global.putString(res, "global_http_proxy_exclusion_list", exclList);
                Settings.Global.putString(res, "global_proxy_pac_url", pacFileUrl);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            this.sendProxyBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultProxy(ProxyInfo proxyInfo) {
        Object object = this.mProxyLock;
        synchronized (object) {
            if (Objects.equals(this.mDefaultProxy, proxyInfo)) {
                return;
            }
            if (proxyInfo != null && !proxyInfo.isValid()) {
                Slog.d(TAG, "Invalid proxy properties, ignoring: " + proxyInfo);
                return;
            }
            if (this.mGlobalProxy != null && proxyInfo != null && !Uri.EMPTY.equals(proxyInfo.getPacFileUrl()) && proxyInfo.getPacFileUrl().equals(this.mGlobalProxy.getPacFileUrl())) {
                this.mGlobalProxy = proxyInfo;
                this.sendProxyBroadcast();
                return;
            }
            this.mDefaultProxy = proxyInfo;
            if (this.mGlobalProxy != null) {
                return;
            }
            if (this.mDefaultProxyEnabled) {
                this.sendProxyBroadcast();
            }
        }
    }
}

