/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.net.NetworkUtils;
import android.net.SocketKeepalive;
import android.net.TcpKeepalivePacketData;
import android.net.TcpKeepalivePacketDataParcelable;
import android.net.TcpRepairWindow;
import android.os.Handler;
import android.os.MessageQueue;
import android.system.ErrnoException;
import android.system.Int32Ref;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.server.connectivity.KeepaliveTracker;
import java.io.FileDescriptor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public class TcpKeepaliveController {
    private static final String TAG = "TcpKeepaliveController";
    private static final boolean DBG = false;
    private final MessageQueue mFdHandlerQueue;
    private static final int FD_EVENTS = 5;
    private static final int TCP_REPAIR = 19;
    private static final int TCP_REPAIR_QUEUE = 20;
    private static final int TCP_QUEUE_SEQ = 21;
    private static final int TCP_NO_QUEUE = 0;
    private static final int TCP_RECV_QUEUE = 1;
    private static final int TCP_SEND_QUEUE = 2;
    private static final int TCP_REPAIR_OFF = 0;
    private static final int TCP_REPAIR_ON = 1;
    private static final int SIOCINQ = OsConstants.FIONREAD;
    private static final int SIOCOUTQ = OsConstants.TIOCOUTQ;
    @GuardedBy(value={"mListeners"})
    private final SparseArray<FileDescriptor> mListeners = new SparseArray();

    public TcpKeepaliveController(Handler connectivityServiceHandler) {
        this.mFdHandlerQueue = connectivityServiceHandler.getLooper().getQueue();
    }

    public static TcpKeepalivePacketData getTcpKeepalivePacket(FileDescriptor fd) throws SocketKeepalive.InvalidPacketException, SocketKeepalive.InvalidSocketException {
        try {
            TcpKeepalivePacketDataParcelable tcpDetails = TcpKeepaliveController.switchToRepairMode(fd);
            return TcpKeepalivePacketData.tcpKeepalivePacket(tcpDetails);
        }
        catch (SocketKeepalive.InvalidPacketException | SocketKeepalive.InvalidSocketException e) {
            TcpKeepaliveController.switchOutOfRepairMode(fd);
            throw e;
        }
    }

    private static TcpKeepalivePacketDataParcelable switchToRepairMode(FileDescriptor fd) throws SocketKeepalive.InvalidSocketException {
        SocketAddress dstSockAddr;
        SocketAddress srcSockAddr;
        TcpKeepalivePacketDataParcelable tcpDetails = new TcpKeepalivePacketDataParcelable();
        try {
            srcSockAddr = Os.getsockname(fd);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "Get sockname fail: ", e);
            throw new SocketKeepalive.InvalidSocketException(-25, (Throwable)e);
        }
        if (!(srcSockAddr instanceof InetSocketAddress)) {
            Log.e(TAG, "Invalid or mismatched SocketAddress");
            throw new SocketKeepalive.InvalidSocketException(-25);
        }
        tcpDetails.srcAddress = TcpKeepaliveController.getAddress((InetSocketAddress)srcSockAddr);
        tcpDetails.srcPort = TcpKeepaliveController.getPort((InetSocketAddress)srcSockAddr);
        try {
            dstSockAddr = Os.getpeername(fd);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "Get peername fail: ", e);
            throw new SocketKeepalive.InvalidSocketException(-25, (Throwable)e);
        }
        if (!(dstSockAddr instanceof InetSocketAddress)) {
            Log.e(TAG, "Invalid or mismatched peer SocketAddress");
            throw new SocketKeepalive.InvalidSocketException(-25);
        }
        tcpDetails.dstAddress = TcpKeepaliveController.getAddress((InetSocketAddress)dstSockAddr);
        tcpDetails.dstPort = TcpKeepaliveController.getPort((InetSocketAddress)dstSockAddr);
        TcpKeepaliveController.dropAllIncomingPackets(fd, true);
        try {
            Os.setsockoptInt(fd, OsConstants.IPPROTO_TCP, 19, 1);
            if (!TcpKeepaliveController.isSocketIdle(fd)) {
                Log.e(TAG, "Socket is not idle");
                throw new SocketKeepalive.InvalidSocketException(-26);
            }
            Os.setsockoptInt(fd, OsConstants.IPPROTO_TCP, 20, 2);
            tcpDetails.seq = Os.getsockoptInt(fd, OsConstants.IPPROTO_TCP, 21);
            Os.setsockoptInt(fd, OsConstants.IPPROTO_TCP, 20, 1);
            tcpDetails.ack = Os.getsockoptInt(fd, OsConstants.IPPROTO_TCP, 21);
            Os.setsockoptInt(fd, OsConstants.IPPROTO_TCP, 20, 0);
            if (!TcpKeepaliveController.isReceiveQueueEmpty(fd)) {
                Log.e(TAG, "Fatal: receive queue of this socket is not empty");
                throw new SocketKeepalive.InvalidSocketException(-25);
            }
            if (!TcpKeepaliveController.isSendQueueEmpty(fd)) {
                Log.e(TAG, "Socket is not idle");
                throw new SocketKeepalive.InvalidSocketException(-26);
            }
            TcpRepairWindow trw = NetworkUtils.getTcpRepairWindow(fd);
            tcpDetails.rcvWnd = trw.rcvWnd;
            tcpDetails.rcvWndScale = trw.rcvWndScale;
            if (tcpDetails.srcAddress.length == 4) {
                tcpDetails.tos = Os.getsockoptInt(fd, OsConstants.IPPROTO_IP, OsConstants.IP_TOS);
                tcpDetails.ttl = Os.getsockoptInt(fd, OsConstants.IPPROTO_IP, OsConstants.IP_TTL);
            }
        }
        catch (ErrnoException e) {
            Log.e(TAG, "Exception reading TCP state from socket", e);
            if (e.errno == OsConstants.ENOPROTOOPT) {
                throw new SocketKeepalive.InvalidSocketException(-30, (Throwable)e);
            }
            throw new SocketKeepalive.InvalidSocketException(-25, (Throwable)e);
        }
        finally {
            TcpKeepaliveController.dropAllIncomingPackets(fd, false);
        }
        --tcpDetails.seq;
        return tcpDetails;
    }

    private static void switchOutOfRepairMode(FileDescriptor fd) {
        try {
            Os.setsockoptInt(fd, OsConstants.IPPROTO_TCP, 19, 0);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "Cannot switch socket out of repair mode", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSocketMonitor(FileDescriptor fd, KeepaliveTracker.KeepaliveInfo ki, int slot) throws IllegalArgumentException, SocketKeepalive.InvalidSocketException {
        SparseArray<FileDescriptor> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            if (null != this.mListeners.get(slot)) {
                throw new IllegalArgumentException("This slot is already taken");
            }
            for (int i = 0; i < this.mListeners.size(); ++i) {
                if (!fd.equals(this.mListeners.valueAt(i))) continue;
                Log.e(TAG, "This fd is already registered.");
                throw new SocketKeepalive.InvalidSocketException(-25);
            }
            this.mFdHandlerQueue.addOnFileDescriptorEventListener(fd, 5, (readyFd, events) -> {
                int reason = 0 != (events & 4) ? -25 : -2;
                ki.onFileDescriptorInitiatedStop(reason);
                return 0;
            });
            this.mListeners.put(slot, fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSocketMonitor(int slot) {
        FileDescriptor fd;
        SparseArray<FileDescriptor> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            fd = this.mListeners.get(slot);
            if (null == fd) {
                return;
            }
            this.mListeners.remove(slot);
        }
        this.mFdHandlerQueue.removeOnFileDescriptorEventListener(fd);
        TcpKeepaliveController.switchOutOfRepairMode(fd);
    }

    private static byte[] getAddress(InetSocketAddress inetAddr) {
        return inetAddr.getAddress().getAddress();
    }

    private static int getPort(InetSocketAddress inetAddr) {
        return inetAddr.getPort();
    }

    private static boolean isSocketIdle(FileDescriptor fd) throws ErrnoException {
        return TcpKeepaliveController.isReceiveQueueEmpty(fd) && TcpKeepaliveController.isSendQueueEmpty(fd);
    }

    private static boolean isReceiveQueueEmpty(FileDescriptor fd) throws ErrnoException {
        Int32Ref result = new Int32Ref(-1);
        Os.ioctlInt(fd, SIOCINQ, result);
        if (result.value != 0) {
            Log.e(TAG, "Read queue has data");
            return false;
        }
        return true;
    }

    private static boolean isSendQueueEmpty(FileDescriptor fd) throws ErrnoException {
        Int32Ref result = new Int32Ref(-1);
        Os.ioctlInt(fd, SIOCOUTQ, result);
        if (result.value != 0) {
            Log.e(TAG, "Write queue has data");
            return false;
        }
        return true;
    }

    private static void dropAllIncomingPackets(FileDescriptor fd, boolean enable) throws SocketKeepalive.InvalidSocketException {
        try {
            if (enable) {
                NetworkUtils.attachDropAllBPFFilter(fd);
            } else {
                NetworkUtils.detachBPFFilter(fd);
            }
        }
        catch (SocketException e) {
            Log.e(TAG, "Socket Exception: ", e);
            throw new SocketKeepalive.InvalidSocketException(-25, (Throwable)e);
        }
    }
}

