/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.net.ConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.net.Network;
import android.net.NetworkAgent;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.net.UidRange;
import android.os.Binder;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemService;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.security.KeyStore;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnInfo;
import com.android.internal.net.VpnProfile;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.util.ArrayUtils;
import com.android.server.DeviceIdleController;
import com.android.server.LocalServices;
import com.android.server.net.BaseNetworkObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoUtils;

public class Vpn {
    private static final String NETWORKTYPE = "VPN";
    private static final String TAG = "Vpn";
    private static final boolean LOGD = true;
    private static final long VPN_LAUNCH_IDLE_WHITELIST_DURATION_MS = 60000L;
    private static final long MOST_IPV4_ADDRESSES_COUNT;
    private static final BigInteger MOST_IPV6_ADDRESSES_COUNT;
    private static final int MAX_ROUTES_TO_EVALUATE = 150;
    private final Context mContext;
    private final NetworkInfo mNetworkInfo;
    private String mPackage;
    private int mOwnerUID;
    private boolean mIsPackageTargetingAtLeastQ;
    private String mInterface;
    private Connection mConnection;
    private LegacyVpnRunner mLegacyVpnRunner;
    private PendingIntent mStatusIntent;
    private volatile boolean mEnableTeardown = true;
    private final INetworkManagementService mNetd;
    @VisibleForTesting
    protected VpnConfig mConfig;
    @VisibleForTesting
    protected NetworkAgent mNetworkAgent;
    private final Looper mLooper;
    @VisibleForTesting
    protected final NetworkCapabilities mNetworkCapabilities;
    private final SystemServices mSystemServices;
    private boolean mAlwaysOn = false;
    private boolean mLockdown = false;
    private List<String> mLockdownWhitelist = Collections.emptyList();
    @GuardedBy(value={"this"})
    private Set<UidRange> mBlockedUsers = new ArraySet<UidRange>();
    private final int mUserHandle;
    private INetworkManagementEventObserver mObserver = new BaseNetworkObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interfaceStatusChanged(String interfaze, boolean up) {
            Vpn vpn = Vpn.this;
            synchronized (vpn) {
                if (!up && Vpn.this.mLegacyVpnRunner != null) {
                    Vpn.this.mLegacyVpnRunner.check(interfaze);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interfaceRemoved(String interfaze) {
            Vpn vpn = Vpn.this;
            synchronized (vpn) {
                if (interfaze.equals(Vpn.this.mInterface) && Vpn.this.jniCheck(interfaze) == 0) {
                    Vpn.this.mStatusIntent = null;
                    Vpn.this.mNetworkCapabilities.setUids(null);
                    Vpn.this.mConfig = null;
                    Vpn.this.mInterface = null;
                    if (Vpn.this.mConnection != null) {
                        Vpn.this.mContext.unbindService(Vpn.this.mConnection);
                        Vpn.this.mConnection = null;
                        Vpn.this.agentDisconnect();
                    } else if (Vpn.this.mLegacyVpnRunner != null) {
                        Vpn.this.mLegacyVpnRunner.exit();
                        Vpn.this.mLegacyVpnRunner = null;
                    }
                }
            }
        }
    };

    public Vpn(Looper looper, Context context, INetworkManagementService netService, int userHandle) {
        this(looper, context, netService, userHandle, new SystemServices(context));
    }

    @VisibleForTesting
    protected Vpn(Looper looper, Context context, INetworkManagementService netService, int userHandle, SystemServices systemServices) {
        this.mContext = context;
        this.mNetd = netService;
        this.mUserHandle = userHandle;
        this.mLooper = looper;
        this.mSystemServices = systemServices;
        this.mPackage = "[Legacy VPN]";
        this.mOwnerUID = this.getAppUid(this.mPackage, this.mUserHandle);
        this.mIsPackageTargetingAtLeastQ = this.doesPackageTargetAtLeastQ(this.mPackage);
        try {
            netService.registerObserver(this.mObserver);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Problem registering observer", e);
        }
        this.mNetworkInfo = new NetworkInfo(17, 0, NETWORKTYPE, "");
        this.mNetworkCapabilities = new NetworkCapabilities();
        this.mNetworkCapabilities.addTransportType(4);
        this.mNetworkCapabilities.removeCapability(15);
        this.updateCapabilities(null);
        this.loadAlwaysOnPackage();
    }

    public void setEnableTeardown(boolean enableTeardown) {
        this.mEnableTeardown = enableTeardown;
    }

    @VisibleForTesting
    protected void updateState(NetworkInfo.DetailedState detailedState, String reason) {
        Log.d(TAG, "setting state=" + (Object)((Object)detailedState) + ", reason=" + reason);
        this.mNetworkInfo.setDetailedState(detailedState, reason, null);
        if (this.mNetworkAgent != null) {
            this.mNetworkAgent.sendNetworkInfo(this.mNetworkInfo);
        }
        this.updateAlwaysOnNotification(detailedState);
    }

    public synchronized NetworkCapabilities updateCapabilities(Network defaultNetwork) {
        if (this.mConfig == null) {
            return null;
        }
        Network[] underlyingNetworks = this.mConfig.underlyingNetworks;
        if (underlyingNetworks == null && defaultNetwork != null) {
            underlyingNetworks = new Network[]{defaultNetwork};
        }
        boolean isAlwaysMetered = this.mIsPackageTargetingAtLeastQ && this.mConfig.isMetered;
        Vpn.applyUnderlyingCapabilities(this.mContext.getSystemService(ConnectivityManager.class), underlyingNetworks, this.mNetworkCapabilities, isAlwaysMetered);
        return new NetworkCapabilities(this.mNetworkCapabilities);
    }

    @VisibleForTesting
    public static void applyUnderlyingCapabilities(ConnectivityManager cm, Network[] underlyingNetworks, NetworkCapabilities caps, boolean isAlwaysMetered) {
        int[] transportTypes = new int[]{4};
        int downKbps = 0;
        int upKbps = 0;
        boolean metered = isAlwaysMetered;
        boolean roaming = false;
        boolean congested = false;
        boolean hadUnderlyingNetworks = false;
        if (null != underlyingNetworks) {
            for (Network underlying : underlyingNetworks) {
                NetworkCapabilities underlyingCaps = cm.getNetworkCapabilities(underlying);
                if (underlyingCaps == null) continue;
                hadUnderlyingNetworks = true;
                for (int underlyingType : underlyingCaps.getTransportTypes()) {
                    transportTypes = ArrayUtils.appendInt(transportTypes, underlyingType);
                }
                downKbps = NetworkCapabilities.minBandwidth(downKbps, underlyingCaps.getLinkDownstreamBandwidthKbps());
                upKbps = NetworkCapabilities.minBandwidth(upKbps, underlyingCaps.getLinkUpstreamBandwidthKbps());
                metered |= !underlyingCaps.hasCapability(11);
                roaming |= !underlyingCaps.hasCapability(18);
                congested |= !underlyingCaps.hasCapability(20);
            }
        }
        if (!hadUnderlyingNetworks) {
            metered = true;
            roaming = false;
            congested = false;
        }
        caps.setTransportTypes(transportTypes);
        caps.setLinkDownstreamBandwidthKbps(downKbps);
        caps.setLinkUpstreamBandwidthKbps(upKbps);
        caps.setCapability(11, !metered);
        caps.setCapability(18, !roaming);
        caps.setCapability(20, !congested);
    }

    public synchronized void setLockdown(boolean lockdown) {
        this.enforceControlPermissionOrInternalCaller();
        this.setVpnForcedLocked(lockdown);
        this.mLockdown = lockdown;
        if (this.mAlwaysOn) {
            this.saveAlwaysOnPackage();
        }
    }

    public synchronized boolean getLockdown() {
        return this.mLockdown;
    }

    public synchronized boolean getAlwaysOn() {
        return this.mAlwaysOn;
    }

    public boolean isAlwaysOnPackageSupported(String packageName) {
        this.enforceSettingsPermission();
        if (packageName == null) {
            return false;
        }
        PackageManager pm = this.mContext.getPackageManager();
        ApplicationInfo appInfo = null;
        try {
            appInfo = pm.getApplicationInfoAsUser(packageName, 0, this.mUserHandle);
        }
        catch (PackageManager.NameNotFoundException unused) {
            Log.w(TAG, "Can't find \"" + packageName + "\" when checking always-on support");
        }
        if (appInfo == null || appInfo.targetSdkVersion < 24) {
            return false;
        }
        Intent intent = new Intent("android.net.VpnService");
        intent.setPackage(packageName);
        List<ResolveInfo> services = pm.queryIntentServicesAsUser(intent, 128, this.mUserHandle);
        if (services == null || services.size() == 0) {
            return false;
        }
        for (ResolveInfo rInfo : services) {
            Bundle metaData = rInfo.serviceInfo.metaData;
            if (metaData == null || metaData.getBoolean("android.net.VpnService.SUPPORTS_ALWAYS_ON", true)) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean setAlwaysOnPackage(String packageName, boolean lockdown, List<String> lockdownWhitelist) {
        this.enforceControlPermissionOrInternalCaller();
        if (this.setAlwaysOnPackageInternal(packageName, lockdown, lockdownWhitelist)) {
            this.saveAlwaysOnPackage();
            return true;
        }
        return false;
    }

    @GuardedBy(value={"this"})
    private boolean setAlwaysOnPackageInternal(String packageName, boolean lockdown, List<String> lockdownWhitelist) {
        if ("[Legacy VPN]".equals(packageName)) {
            Log.w(TAG, "Not setting legacy VPN \"" + packageName + "\" as always-on.");
            return false;
        }
        if (lockdownWhitelist != null) {
            for (String pkg : lockdownWhitelist) {
                if (!pkg.contains(",")) continue;
                Log.w(TAG, "Not setting always-on vpn, invalid whitelisted package: " + pkg);
                return false;
            }
        }
        if (packageName != null) {
            if (!this.setPackageAuthorization(packageName, true)) {
                return false;
            }
            this.mAlwaysOn = true;
        } else {
            packageName = "[Legacy VPN]";
            this.mAlwaysOn = false;
        }
        this.mLockdown = this.mAlwaysOn && lockdown;
        List<Object> list = this.mLockdownWhitelist = this.mLockdown && lockdownWhitelist != null ? Collections.unmodifiableList(new ArrayList<String>(lockdownWhitelist)) : Collections.emptyList();
        if (this.isCurrentPreparedPackage(packageName)) {
            this.updateAlwaysOnNotification(this.mNetworkInfo.getDetailedState());
            this.setVpnForcedLocked(this.mLockdown);
        } else {
            this.prepareInternal(packageName);
        }
        return true;
    }

    private static boolean isNullOrLegacyVpn(String packageName) {
        return packageName == null || "[Legacy VPN]".equals(packageName);
    }

    public synchronized String getAlwaysOnPackage() {
        this.enforceControlPermissionOrInternalCaller();
        return this.mAlwaysOn ? this.mPackage : null;
    }

    public synchronized List<String> getLockdownWhitelist() {
        return this.mLockdown ? this.mLockdownWhitelist : null;
    }

    @GuardedBy(value={"this"})
    private void saveAlwaysOnPackage() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mSystemServices.settingsSecurePutStringForUser("always_on_vpn_app", this.getAlwaysOnPackage(), this.mUserHandle);
            this.mSystemServices.settingsSecurePutIntForUser("always_on_vpn_lockdown", this.mAlwaysOn && this.mLockdown ? 1 : 0, this.mUserHandle);
            this.mSystemServices.settingsSecurePutStringForUser("always_on_vpn_lockdown_whitelist", String.join((CharSequence)",", this.mLockdownWhitelist), this.mUserHandle);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    private void loadAlwaysOnPackage() {
        long token = Binder.clearCallingIdentity();
        try {
            String alwaysOnPackage = this.mSystemServices.settingsSecureGetStringForUser("always_on_vpn_app", this.mUserHandle);
            boolean alwaysOnLockdown = this.mSystemServices.settingsSecureGetIntForUser("always_on_vpn_lockdown", 0, this.mUserHandle) != 0;
            String whitelistString = this.mSystemServices.settingsSecureGetStringForUser("always_on_vpn_lockdown_whitelist", this.mUserHandle);
            List<String> whitelistedPackages = TextUtils.isEmpty(whitelistString) ? Collections.emptyList() : Arrays.asList(whitelistString.split(","));
            this.setAlwaysOnPackageInternal(alwaysOnPackage, alwaysOnLockdown, whitelistedPackages);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAlwaysOnVpn() {
        String alwaysOnPackage;
        Vpn vpn = this;
        synchronized (vpn) {
            alwaysOnPackage = this.getAlwaysOnPackage();
            if (alwaysOnPackage == null) {
                return true;
            }
            if (!this.isAlwaysOnPackageSupported(alwaysOnPackage)) {
                this.setAlwaysOnPackage(null, false, null);
                return false;
            }
            if (this.getNetworkInfo().isConnected()) {
                return true;
            }
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            DeviceIdleController.LocalService idleController = LocalServices.getService(DeviceIdleController.LocalService.class);
            idleController.addPowerSaveTempWhitelistApp(Process.myUid(), alwaysOnPackage, 60000L, this.mUserHandle, false, "vpn");
            Intent serviceIntent = new Intent("android.net.VpnService");
            serviceIntent.setPackage(alwaysOnPackage);
            try {
                boolean bl = this.mContext.startServiceAsUser(serviceIntent, UserHandle.of(this.mUserHandle)) != null;
                return bl;
            }
            catch (RuntimeException e) {
                Log.e(TAG, "VpnService " + serviceIntent + " failed to start", e);
                boolean bl = false;
                Binder.restoreCallingIdentity(oldId);
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    public synchronized boolean prepare(String oldPackage, String newPackage) {
        if (oldPackage != null) {
            if (this.mAlwaysOn && !this.isCurrentPreparedPackage(oldPackage)) {
                return false;
            }
            if (!this.isCurrentPreparedPackage(oldPackage)) {
                if (!oldPackage.equals("[Legacy VPN]") && this.isVpnUserPreConsented(oldPackage)) {
                    this.prepareInternal(oldPackage);
                    return true;
                }
                return false;
            }
            if (!oldPackage.equals("[Legacy VPN]") && !this.isVpnUserPreConsented(oldPackage)) {
                this.prepareInternal("[Legacy VPN]");
                return false;
            }
        }
        if (newPackage == null || !newPackage.equals("[Legacy VPN]") && this.isCurrentPreparedPackage(newPackage)) {
            return true;
        }
        this.enforceControlPermission();
        if (this.mAlwaysOn && !this.isCurrentPreparedPackage(newPackage)) {
            return false;
        }
        this.prepareInternal(newPackage);
        return true;
    }

    private boolean isCurrentPreparedPackage(String packageName) {
        return this.getAppUid(packageName, this.mUserHandle) == this.mOwnerUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareInternal(String newPackage) {
        long token = Binder.clearCallingIdentity();
        try {
            if (this.mInterface != null) {
                this.mStatusIntent = null;
                this.agentDisconnect();
                this.jniReset(this.mInterface);
                this.mInterface = null;
                this.mNetworkCapabilities.setUids(null);
            }
            if (this.mConnection != null) {
                try {
                    this.mConnection.mService.transact(0xFFFFFF, Parcel.obtain(), null, 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mContext.unbindService(this.mConnection);
                this.mConnection = null;
            } else if (this.mLegacyVpnRunner != null) {
                this.mLegacyVpnRunner.exit();
                this.mLegacyVpnRunner = null;
            }
            try {
                this.mNetd.denyProtect(this.mOwnerUID);
            }
            catch (Exception e) {
                Log.wtf(TAG, "Failed to disallow UID " + this.mOwnerUID + " to call protect() " + e);
            }
            Log.i(TAG, "Switched from " + this.mPackage + " to " + newPackage);
            this.mPackage = newPackage;
            this.mOwnerUID = this.getAppUid(newPackage, this.mUserHandle);
            this.mIsPackageTargetingAtLeastQ = this.doesPackageTargetAtLeastQ(newPackage);
            try {
                this.mNetd.allowProtect(this.mOwnerUID);
            }
            catch (Exception e) {
                Log.wtf(TAG, "Failed to allow UID " + this.mOwnerUID + " to call protect() " + e);
            }
            this.mConfig = null;
            this.updateState(NetworkInfo.DetailedState.IDLE, "prepare");
            this.setVpnForcedLocked(this.mLockdown);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPackageAuthorization(String packageName, boolean authorized) {
        this.enforceControlPermissionOrInternalCaller();
        int uid = this.getAppUid(packageName, this.mUserHandle);
        if (uid == -1 || "[Legacy VPN]".equals(packageName)) {
            return false;
        }
        long token = Binder.clearCallingIdentity();
        try {
            AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
            appOps.setMode(47, uid, packageName, authorized ? 0 : 1);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.wtf(TAG, "Failed to set app ops for package " + packageName + ", uid " + uid, e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return false;
    }

    private boolean isVpnUserPreConsented(String packageName) {
        AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
        return appOps.noteOpNoThrow(47, Binder.getCallingUid(), packageName) == 0;
    }

    private int getAppUid(String app, int userHandle) {
        int result;
        if ("[Legacy VPN]".equals(app)) {
            return Process.myUid();
        }
        PackageManager pm = this.mContext.getPackageManager();
        try {
            result = pm.getPackageUidAsUser(app, userHandle);
        }
        catch (PackageManager.NameNotFoundException e) {
            result = -1;
        }
        return result;
    }

    private boolean doesPackageTargetAtLeastQ(String packageName) {
        if ("[Legacy VPN]".equals(packageName)) {
            return true;
        }
        PackageManager pm = this.mContext.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfoAsUser(packageName, 0, this.mUserHandle);
            return appInfo.targetSdkVersion >= 29;
        }
        catch (PackageManager.NameNotFoundException unused) {
            Log.w(TAG, "Can't find \"" + packageName + "\"");
            return false;
        }
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public int getNetId() {
        return this.mNetworkAgent != null ? this.mNetworkAgent.netId : 0;
    }

    private LinkProperties makeLinkProperties() {
        InetAddress address;
        boolean allowIPv4 = this.mConfig.allowIPv4;
        boolean allowIPv6 = this.mConfig.allowIPv6;
        LinkProperties lp = new LinkProperties();
        lp.setInterfaceName(this.mInterface);
        if (this.mConfig.addresses != null) {
            for (LinkAddress address2 : this.mConfig.addresses) {
                lp.addLinkAddress(address2);
                allowIPv4 |= address2.getAddress() instanceof Inet4Address;
                allowIPv6 |= address2.getAddress() instanceof Inet6Address;
            }
        }
        if (this.mConfig.routes != null) {
            for (RouteInfo route : this.mConfig.routes) {
                lp.addRoute(route);
                address = route.getDestination().getAddress();
                allowIPv4 |= address instanceof Inet4Address;
                allowIPv6 |= address instanceof Inet6Address;
            }
        }
        if (this.mConfig.dnsServers != null) {
            for (String dnsServer : this.mConfig.dnsServers) {
                address = InetAddress.parseNumericAddress((String)dnsServer);
                lp.addDnsServer(address);
                allowIPv4 |= address instanceof Inet4Address;
                allowIPv6 |= address instanceof Inet6Address;
            }
        }
        lp.setHttpProxy(this.mConfig.proxyInfo);
        if (!allowIPv4) {
            lp.addRoute(new RouteInfo(new IpPrefix(Inet4Address.ANY, 0), 7));
        }
        if (!allowIPv6) {
            lp.addRoute(new RouteInfo(new IpPrefix(Inet6Address.ANY, 0), 7));
        }
        StringBuilder buffer = new StringBuilder();
        if (this.mConfig.searchDomains != null) {
            for (String domain : this.mConfig.searchDomains) {
                buffer.append(domain).append(' ');
            }
        }
        lp.setDomains(buffer.toString().trim());
        return lp;
    }

    @VisibleForTesting
    static boolean providesRoutesToMostDestinations(LinkProperties lp) {
        List<RouteInfo> routes = lp.getAllRoutes();
        if (routes.size() > 150) {
            return true;
        }
        Comparator<IpPrefix> prefixLengthComparator = IpPrefix.lengthComparator();
        TreeSet<IpPrefix> ipv4Prefixes = new TreeSet<IpPrefix>(prefixLengthComparator);
        TreeSet<IpPrefix> ipv6Prefixes = new TreeSet<IpPrefix>(prefixLengthComparator);
        for (RouteInfo route : routes) {
            if (route.getType() == 7) continue;
            IpPrefix destination = route.getDestination();
            if (destination.isIPv4()) {
                ipv4Prefixes.add(destination);
                continue;
            }
            ipv6Prefixes.add(destination);
        }
        if (NetworkUtils.routedIPv4AddressCount(ipv4Prefixes) > MOST_IPV4_ADDRESSES_COUNT) {
            return true;
        }
        return NetworkUtils.routedIPv6AddressCount(ipv6Prefixes).compareTo(MOST_IPV6_ADDRESSES_COUNT) >= 0;
    }

    private boolean updateLinkPropertiesInPlaceIfPossible(NetworkAgent agent, VpnConfig oldConfig) {
        if (oldConfig.allowBypass != this.mConfig.allowBypass) {
            Log.i(TAG, "Handover not possible due to changes to allowBypass");
            return false;
        }
        if (!Objects.equals(oldConfig.allowedApplications, this.mConfig.allowedApplications) || !Objects.equals(oldConfig.disallowedApplications, this.mConfig.disallowedApplications)) {
            Log.i(TAG, "Handover not possible due to changes to whitelisted/blacklisted apps");
            return false;
        }
        agent.sendLinkProperties(this.makeLinkProperties());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentConnect() {
        LinkProperties lp = this.makeLinkProperties();
        this.mNetworkCapabilities.addCapability(12);
        this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTING, null, null);
        NetworkMisc networkMisc = new NetworkMisc();
        networkMisc.allowBypass = this.mConfig.allowBypass && !this.mLockdown;
        this.mNetworkCapabilities.setEstablishingVpnAppUid(Binder.getCallingUid());
        this.mNetworkCapabilities.setUids(this.createUserAndRestrictedProfilesRanges(this.mUserHandle, this.mConfig.allowedApplications, this.mConfig.disallowedApplications));
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkAgent = new NetworkAgent(this.mLooper, this.mContext, NETWORKTYPE, this.mNetworkInfo, this.mNetworkCapabilities, lp, 101, networkMisc, -2){

                @Override
                public void unwanted() {
                }
            };
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        this.mNetworkInfo.setIsAvailable(true);
        this.updateState(NetworkInfo.DetailedState.CONNECTED, "agentConnect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canHaveRestrictedProfile(int userId) {
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = UserManager.get(this.mContext).canHaveRestrictedProfile(userId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void agentDisconnect(NetworkAgent networkAgent) {
        if (networkAgent != null) {
            NetworkInfo networkInfo = new NetworkInfo(this.mNetworkInfo);
            networkInfo.setIsAvailable(false);
            networkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
            networkAgent.sendNetworkInfo(networkInfo);
        }
    }

    private void agentDisconnect() {
        if (this.mNetworkInfo.isConnected()) {
            this.mNetworkInfo.setIsAvailable(false);
            this.updateState(NetworkInfo.DetailedState.DISCONNECTED, "agentDisconnect");
            this.mNetworkAgent = null;
        }
    }

    public synchronized ParcelFileDescriptor establish(VpnConfig config) {
        UserManager mgr = UserManager.get(this.mContext);
        if (Binder.getCallingUid() != this.mOwnerUID) {
            return null;
        }
        if (!this.isVpnUserPreConsented(this.mPackage)) {
            return null;
        }
        Intent intent = new Intent("android.net.VpnService");
        intent.setClassName(this.mPackage, config.user);
        long token = Binder.clearCallingIdentity();
        try {
            UserInfo user = mgr.getUserInfo(this.mUserHandle);
            if (user.isRestricted()) {
                throw new SecurityException("Restricted users cannot establish VPNs");
            }
            ResolveInfo info = AppGlobals.getPackageManager().resolveService(intent, null, 0, this.mUserHandle);
            if (info == null) {
                throw new SecurityException("Cannot find " + config.user);
            }
            if (!"android.permission.BIND_VPN_SERVICE".equals(info.serviceInfo.permission)) {
                throw new SecurityException(config.user + " does not require " + "android.permission.BIND_VPN_SERVICE");
            }
        }
        catch (RemoteException e) {
            throw new SecurityException("Cannot find " + config.user);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        VpnConfig oldConfig = this.mConfig;
        String oldInterface = this.mInterface;
        Connection oldConnection = this.mConnection;
        NetworkAgent oldNetworkAgent = this.mNetworkAgent;
        Set<UidRange> oldUsers = this.mNetworkCapabilities.getUids();
        ParcelFileDescriptor tun = ParcelFileDescriptor.adoptFd(this.jniCreate(config.mtu));
        try {
            String interfaze = this.jniGetName(tun.getFd());
            StringBuilder builder = new StringBuilder();
            for (LinkAddress address : config.addresses) {
                builder.append(" " + address);
            }
            if (this.jniSetAddresses(interfaze, builder.toString()) < 1) {
                throw new IllegalArgumentException("At least one address must be specified");
            }
            Connection connection = new Connection();
            if (!this.mContext.bindServiceAsUser(intent, connection, 0x4000001, new UserHandle(this.mUserHandle))) {
                throw new IllegalStateException("Cannot bind " + config.user);
            }
            this.mConnection = connection;
            this.mInterface = interfaze;
            config.user = this.mPackage;
            config.interfaze = this.mInterface;
            config.startTime = SystemClock.elapsedRealtime();
            this.mConfig = config;
            if (oldConfig == null || !this.updateLinkPropertiesInPlaceIfPossible(this.mNetworkAgent, oldConfig)) {
                this.mNetworkAgent = null;
                this.updateState(NetworkInfo.DetailedState.CONNECTING, "establish");
                this.agentConnect();
                this.agentDisconnect(oldNetworkAgent);
            }
            if (oldConnection != null) {
                this.mContext.unbindService(oldConnection);
            }
            if (oldInterface != null && !oldInterface.equals(interfaze)) {
                this.jniReset(oldInterface);
            }
            try {
                IoUtils.setBlocking(tun.getFileDescriptor(), config.blocking);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot set tunnel's fd as blocking=" + config.blocking, e);
            }
        }
        catch (RuntimeException e) {
            IoUtils.closeQuietly(tun);
            this.agentDisconnect();
            this.mConfig = oldConfig;
            this.mConnection = oldConnection;
            this.mNetworkCapabilities.setUids(oldUsers);
            this.mNetworkAgent = oldNetworkAgent;
            this.mInterface = oldInterface;
            throw e;
        }
        Log.i(TAG, "Established by " + config.user + " on " + this.mInterface);
        return tun;
    }

    private boolean isRunningLocked() {
        return this.mNetworkAgent != null && this.mInterface != null;
    }

    @VisibleForTesting
    protected boolean isCallerEstablishedOwnerLocked() {
        return this.isRunningLocked() && Binder.getCallingUid() == this.mOwnerUID;
    }

    private SortedSet<Integer> getAppsUids(List<String> packageNames, int userHandle) {
        TreeSet<Integer> uids = new TreeSet<Integer>();
        for (String app : packageNames) {
            int uid = this.getAppUid(app, userHandle);
            if (uid == -1) continue;
            uids.add(uid);
        }
        return uids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Set<UidRange> createUserAndRestrictedProfilesRanges(int userHandle, List<String> allowedApplications, List<String> disallowedApplications) {
        ArraySet<UidRange> ranges = new ArraySet<UidRange>();
        this.addUserToRanges(ranges, userHandle, allowedApplications, disallowedApplications);
        if (this.canHaveRestrictedProfile(userHandle)) {
            List<UserInfo> users;
            long token = Binder.clearCallingIdentity();
            try {
                users = UserManager.get(this.mContext).getUsers(true);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            for (UserInfo user : users) {
                if (!user.isRestricted() || user.restrictedProfileParentId != userHandle) continue;
                this.addUserToRanges(ranges, user.id, allowedApplications, disallowedApplications);
            }
        }
        return ranges;
    }

    @VisibleForTesting
    void addUserToRanges(Set<UidRange> ranges, int userHandle, List<String> allowedApplications, List<String> disallowedApplications) {
        if (allowedApplications != null) {
            int start = -1;
            int stop = -1;
            Iterator iterator = this.getAppsUids(allowedApplications, userHandle).iterator();
            while (iterator.hasNext()) {
                int uid = (Integer)iterator.next();
                if (start == -1) {
                    start = uid;
                } else if (uid != stop + 1) {
                    ranges.add(new UidRange(start, stop));
                    start = uid;
                }
                stop = uid;
            }
            if (start != -1) {
                ranges.add(new UidRange(start, stop));
            }
        } else if (disallowedApplications != null) {
            UidRange userRange = UidRange.createForUser(userHandle);
            int start = userRange.start;
            Iterator iterator = this.getAppsUids(disallowedApplications, userHandle).iterator();
            while (iterator.hasNext()) {
                int uid = (Integer)iterator.next();
                if (uid == start) {
                    ++start;
                    continue;
                }
                ranges.add(new UidRange(start, uid - 1));
                start = uid + 1;
            }
            if (start <= userRange.stop) {
                ranges.add(new UidRange(start, userRange.stop));
            }
        } else {
            ranges.add(UidRange.createForUser(userHandle));
        }
    }

    private static List<UidRange> uidRangesForUser(int userHandle, Set<UidRange> existingRanges) {
        UidRange userRange = UidRange.createForUser(userHandle);
        ArrayList<UidRange> ranges = new ArrayList<UidRange>();
        for (UidRange range : existingRanges) {
            if (!userRange.containsRange(range)) continue;
            ranges.add(range);
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserAdded(int userHandle) {
        UserInfo user = UserManager.get(this.mContext).getUserInfo(userHandle);
        if (user.isRestricted() && user.restrictedProfileParentId == this.mUserHandle) {
            Vpn vpn = this;
            synchronized (vpn) {
                Set<UidRange> existingRanges = this.mNetworkCapabilities.getUids();
                if (existingRanges != null) {
                    try {
                        this.addUserToRanges(existingRanges, userHandle, this.mConfig.allowedApplications, this.mConfig.disallowedApplications);
                        this.mNetworkCapabilities.setUids(existingRanges);
                    }
                    catch (Exception e) {
                        Log.wtf(TAG, "Failed to add restricted user to owner", e);
                    }
                }
                this.setVpnForcedLocked(this.mLockdown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userHandle) {
        UserInfo user = UserManager.get(this.mContext).getUserInfo(userHandle);
        if (user.isRestricted() && user.restrictedProfileParentId == this.mUserHandle) {
            Vpn vpn = this;
            synchronized (vpn) {
                Set<UidRange> existingRanges = this.mNetworkCapabilities.getUids();
                if (existingRanges != null) {
                    try {
                        List<UidRange> removedRanges = Vpn.uidRangesForUser(userHandle, existingRanges);
                        existingRanges.removeAll(removedRanges);
                        this.mNetworkCapabilities.setUids(existingRanges);
                    }
                    catch (Exception e) {
                        Log.wtf(TAG, "Failed to remove restricted user to owner", e);
                    }
                }
                this.setVpnForcedLocked(this.mLockdown);
            }
        }
    }

    public synchronized void onUserStopped() {
        this.setLockdown(false);
        this.mAlwaysOn = false;
        this.agentDisconnect();
    }

    @GuardedBy(value={"this"})
    private void setVpnForcedLocked(boolean enforce) {
        ArrayList<String> exemptedPackages;
        if (Vpn.isNullOrLegacyVpn(this.mPackage)) {
            exemptedPackages = null;
        } else {
            exemptedPackages = new ArrayList<String>(this.mLockdownWhitelist);
            exemptedPackages.add(this.mPackage);
        }
        ArraySet<UidRange> removedRanges = new ArraySet<UidRange>(this.mBlockedUsers);
        Set<Object> addedRanges = Collections.emptySet();
        if (enforce) {
            addedRanges = this.createUserAndRestrictedProfilesRanges(this.mUserHandle, null, exemptedPackages);
            for (UidRange uidRange : addedRanges) {
                if (uidRange.start != 0) continue;
                addedRanges.remove(uidRange);
                if (uidRange.stop == 0) continue;
                addedRanges.add(new UidRange(1, uidRange.stop));
            }
            removedRanges.removeAll(addedRanges);
            addedRanges.removeAll(this.mBlockedUsers);
        }
        this.setAllowOnlyVpnForUids(false, removedRanges);
        this.setAllowOnlyVpnForUids(true, addedRanges);
    }

    @GuardedBy(value={"this"})
    private boolean setAllowOnlyVpnForUids(boolean enforce, Collection<UidRange> ranges) {
        if (ranges.size() == 0) {
            return true;
        }
        UidRange[] rangesArray = ranges.toArray(new UidRange[ranges.size()]);
        try {
            this.mNetd.setAllowOnlyVpnForUids(enforce, rangesArray);
        }
        catch (RemoteException | RuntimeException e) {
            Log.e(TAG, "Updating blocked=" + enforce + " for UIDs " + Arrays.toString(ranges.toArray()) + " failed", e);
            return false;
        }
        if (enforce) {
            this.mBlockedUsers.addAll(ranges);
        } else {
            this.mBlockedUsers.removeAll(ranges);
        }
        return true;
    }

    public VpnConfig getVpnConfig() {
        this.enforceControlPermission();
        return this.mConfig;
    }

    @Deprecated
    public synchronized void interfaceStatusChanged(String iface, boolean up) {
        try {
            this.mObserver.interfaceStatusChanged(iface, up);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void enforceControlPermission() {
        this.mContext.enforceCallingPermission("android.permission.CONTROL_VPN", "Unauthorized Caller");
    }

    private void enforceControlPermissionOrInternalCaller() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONTROL_VPN", "Unauthorized Caller");
    }

    private void enforceSettingsPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NETWORK_SETTINGS", "Unauthorized Caller");
    }

    private void prepareStatusIntent() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mStatusIntent = VpnConfig.getIntentForStatusPanel(this.mContext);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public synchronized boolean addAddress(String address, int prefixLength) {
        if (!this.isCallerEstablishedOwnerLocked()) {
            return false;
        }
        boolean success = this.jniAddAddress(this.mInterface, address, prefixLength);
        this.mNetworkAgent.sendLinkProperties(this.makeLinkProperties());
        return success;
    }

    public synchronized boolean removeAddress(String address, int prefixLength) {
        if (!this.isCallerEstablishedOwnerLocked()) {
            return false;
        }
        boolean success = this.jniDelAddress(this.mInterface, address, prefixLength);
        this.mNetworkAgent.sendLinkProperties(this.makeLinkProperties());
        return success;
    }

    public synchronized boolean setUnderlyingNetworks(Network[] networks) {
        if (!this.isCallerEstablishedOwnerLocked()) {
            return false;
        }
        if (networks == null) {
            this.mConfig.underlyingNetworks = null;
        } else {
            this.mConfig.underlyingNetworks = new Network[networks.length];
            for (int i = 0; i < networks.length; ++i) {
                this.mConfig.underlyingNetworks[i] = networks[i] == null ? null : new Network(networks[i].netId);
            }
        }
        return true;
    }

    public synchronized Network[] getUnderlyingNetworks() {
        if (!this.isRunningLocked()) {
            return null;
        }
        return this.mConfig.underlyingNetworks;
    }

    public synchronized VpnInfo getVpnInfo() {
        if (!this.isRunningLocked()) {
            return null;
        }
        VpnInfo info = new VpnInfo();
        info.ownerUid = this.mOwnerUID;
        info.vpnIface = this.mInterface;
        return info;
    }

    public synchronized boolean appliesToUid(int uid) {
        if (!this.isRunningLocked()) {
            return false;
        }
        return this.mNetworkCapabilities.appliesToUid(uid);
    }

    public synchronized boolean isBlockingUid(int uid) {
        if (this.mNetworkInfo.isConnected()) {
            return !this.appliesToUid(uid);
        }
        return UidRange.containsUid(this.mBlockedUsers, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAlwaysOnNotification(NetworkInfo.DetailedState networkState) {
        boolean visible = this.mAlwaysOn && networkState != NetworkInfo.DetailedState.CONNECTED;
        UserHandle user = UserHandle.of(this.mUserHandle);
        long token = Binder.clearCallingIdentity();
        try {
            NotificationManager notificationManager = NotificationManager.from(this.mContext);
            if (!visible) {
                notificationManager.cancelAsUser(TAG, 17, user);
                return;
            }
            Intent intent = new Intent();
            intent.setComponent(ComponentName.unflattenFromString(this.mContext.getString(17039691)));
            intent.putExtra("lockdown", this.mLockdown);
            intent.addFlags(0x10000000);
            PendingIntent configIntent = this.mSystemServices.pendingIntentGetActivityAsUser(intent, 0xC000000, user);
            Notification.Builder builder = new Notification.Builder(this.mContext, SystemNotificationChannels.VPN).setSmallIcon(17303772).setContentTitle(this.mContext.getString(17041210)).setContentText(this.mContext.getString(17041207)).setContentIntent(configIntent).setCategory("sys").setVisibility(1).setOngoing(true).setColor(this.mContext.getColor(17170460));
            notificationManager.notifyAsUser(TAG, 17, builder.build(), user);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private native int jniCreate(int var1);

    private native String jniGetName(int var1);

    private native int jniSetAddresses(String var1, String var2);

    private native void jniReset(String var1);

    private native int jniCheck(String var1);

    private native boolean jniAddAddress(String var1, String var2, int var3);

    private native boolean jniDelAddress(String var1, String var2, int var3);

    private static RouteInfo findIPv4DefaultRoute(LinkProperties prop) {
        for (RouteInfo route : prop.getAllRoutes()) {
            if (!route.isDefaultRoute() || !(route.getGateway() instanceof Inet4Address)) continue;
            return route;
        }
        throw new IllegalStateException("Unable to find IPv4 default gateway");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLegacyVpn(VpnProfile profile, KeyStore keyStore, LinkProperties egress) {
        this.enforceControlPermission();
        long token = Binder.clearCallingIdentity();
        try {
            this.startLegacyVpnPrivileged(profile, keyStore, egress);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public void startLegacyVpnPrivileged(VpnProfile profile, KeyStore keyStore, LinkProperties egress) {
        byte[] value;
        UserManager mgr = UserManager.get(this.mContext);
        UserInfo user = mgr.getUserInfo(this.mUserHandle);
        if (user.isRestricted() || mgr.hasUserRestriction("no_config_vpn", new UserHandle(this.mUserHandle))) {
            throw new SecurityException("Restricted users cannot establish VPNs");
        }
        RouteInfo ipv4DefaultRoute = Vpn.findIPv4DefaultRoute(egress);
        String gateway = ipv4DefaultRoute.getGateway().getHostAddress();
        String iface = ipv4DefaultRoute.getInterface();
        String privateKey = "";
        String userCert = "";
        String caCert = "";
        String serverCert = "";
        if (!profile.ipsecUserCert.isEmpty()) {
            privateKey = "USRPKEY_" + profile.ipsecUserCert;
            value = keyStore.get("USRCERT_" + profile.ipsecUserCert);
            String string2 = userCert = value == null ? null : new String(value, StandardCharsets.UTF_8);
        }
        if (!profile.ipsecCaCert.isEmpty()) {
            value = keyStore.get("CACERT_" + profile.ipsecCaCert);
            String string3 = caCert = value == null ? null : new String(value, StandardCharsets.UTF_8);
        }
        if (!profile.ipsecServerCert.isEmpty()) {
            value = keyStore.get("USRCERT_" + profile.ipsecServerCert);
            String string4 = serverCert = value == null ? null : new String(value, StandardCharsets.UTF_8);
        }
        if (privateKey == null || userCert == null || caCert == null || serverCert == null) {
            throw new IllegalStateException("Cannot load credentials");
        }
        String[] racoon = null;
        switch (profile.type) {
            case 1: {
                racoon = new String[]{iface, profile.server, "udppsk", profile.ipsecIdentifier, profile.ipsecSecret, "1701"};
                break;
            }
            case 2: {
                racoon = new String[]{iface, profile.server, "udprsa", privateKey, userCert, caCert, serverCert, "1701"};
                break;
            }
            case 3: {
                racoon = new String[]{iface, profile.server, "xauthpsk", profile.ipsecIdentifier, profile.ipsecSecret, profile.username, profile.password, "", gateway};
                break;
            }
            case 4: {
                racoon = new String[]{iface, profile.server, "xauthrsa", privateKey, userCert, caCert, serverCert, profile.username, profile.password, "", gateway};
                break;
            }
            case 5: {
                racoon = new String[]{iface, profile.server, "hybridrsa", caCert, serverCert, profile.username, profile.password, "", gateway};
            }
        }
        String[] mtpd = null;
        switch (profile.type) {
            case 0: {
                mtpd = new String[]{iface, "pptp", profile.server, "1723", "name", profile.username, "password", profile.password, "linkname", "vpn", "refuse-eap", "nodefaultroute", "usepeerdns", "idle", "1800", "mtu", "1400", "mru", "1400", profile.mppe ? "+mppe" : "nomppe"};
                break;
            }
            case 1: 
            case 2: {
                mtpd = new String[]{iface, "l2tp", profile.server, "1701", profile.l2tpSecret, "name", profile.username, "password", profile.password, "linkname", "vpn", "refuse-eap", "nodefaultroute", "usepeerdns", "idle", "1800", "mtu", "1400", "mru", "1400"};
            }
        }
        VpnConfig config = new VpnConfig();
        config.legacy = true;
        config.user = profile.key;
        config.interfaze = iface;
        config.session = profile.name;
        config.isMetered = false;
        config.proxyInfo = profile.proxy;
        config.addLegacyRoutes(profile.routes);
        if (!profile.dnsServers.isEmpty()) {
            config.dnsServers = Arrays.asList(profile.dnsServers.split(" +"));
        }
        if (!profile.searchDomains.isEmpty()) {
            config.searchDomains = Arrays.asList(profile.searchDomains.split(" +"));
        }
        this.startLegacyVpn(config, racoon, mtpd, profile);
    }

    private synchronized void startLegacyVpn(VpnConfig config, String[] racoon, String[] mtpd, VpnProfile profile) {
        this.stopLegacyVpnPrivileged();
        this.prepareInternal("[Legacy VPN]");
        this.updateState(NetworkInfo.DetailedState.CONNECTING, "startLegacyVpn");
        this.mLegacyVpnRunner = new LegacyVpnRunner(config, racoon, mtpd, profile);
        this.mLegacyVpnRunner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void stopLegacyVpnPrivileged() {
        if (this.mLegacyVpnRunner == null) return;
        this.mLegacyVpnRunner.exit();
        this.mLegacyVpnRunner = null;
        String string2 = "LegacyVpnRunner";
        synchronized ("LegacyVpnRunner") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized LegacyVpnInfo getLegacyVpnInfo() {
        this.enforceControlPermission();
        return this.getLegacyVpnInfoPrivileged();
    }

    public synchronized LegacyVpnInfo getLegacyVpnInfoPrivileged() {
        if (this.mLegacyVpnRunner == null) {
            return null;
        }
        LegacyVpnInfo info = new LegacyVpnInfo();
        info.key = this.mConfig.user;
        info.state = LegacyVpnInfo.stateFromNetworkInfo(this.mNetworkInfo);
        if (this.mNetworkInfo.isConnected()) {
            info.intent = this.mStatusIntent;
        }
        return info;
    }

    public VpnConfig getLegacyVpnConfig() {
        if (this.mLegacyVpnRunner != null) {
            return this.mConfig;
        }
        return null;
    }

    static {
        int howManyPercentIsMost = 85;
        long twoPower32 = 0x100000000L;
        MOST_IPV4_ADDRESSES_COUNT = 0xD9999999L;
        BigInteger twoPower128 = BigInteger.ONE.shiftLeft(128);
        MOST_IPV6_ADDRESSES_COUNT = twoPower128.multiply(BigInteger.valueOf(85L)).divide(BigInteger.valueOf(100L));
    }

    private class LegacyVpnRunner
    extends Thread {
        private static final String TAG = "LegacyVpnRunner";
        private final String[] mDaemons;
        private final String[][] mArguments;
        private final LocalSocket[] mSockets;
        private final String mOuterInterface;
        private final AtomicInteger mOuterConnection;
        private final VpnProfile mProfile;
        private long mBringupStartTime;
        private final BroadcastReceiver mBroadcastReceiver;

        LegacyVpnRunner(VpnConfig config, String[] racoon, String[] mtpd, VpnProfile profile) {
            super(TAG);
            this.mOuterConnection = new AtomicInteger(-1);
            this.mBringupStartTime = -1L;
            this.mBroadcastReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    NetworkInfo info;
                    if (!Vpn.this.mEnableTeardown) {
                        return;
                    }
                    if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE") && intent.getIntExtra("networkType", -1) == LegacyVpnRunner.this.mOuterConnection.get() && (info = (NetworkInfo)intent.getExtra("networkInfo")) != null && !info.isConnectedOrConnecting()) {
                        try {
                            Vpn.this.mObserver.interfaceStatusChanged(LegacyVpnRunner.this.mOuterInterface, false);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            };
            Vpn.this.mConfig = config;
            this.mDaemons = new String[]{"racoon", "mtpd"};
            this.mArguments = new String[][]{racoon, mtpd};
            this.mSockets = new LocalSocket[this.mDaemons.length];
            this.mOuterInterface = Vpn.this.mConfig.interfaze;
            this.mProfile = profile;
            if (!TextUtils.isEmpty(this.mOuterInterface)) {
                ConnectivityManager cm = ConnectivityManager.from(Vpn.this.mContext);
                for (Network network : cm.getAllNetworks()) {
                    NetworkInfo networkInfo;
                    LinkProperties lp = cm.getLinkProperties(network);
                    if (lp == null || !lp.getAllInterfaceNames().contains(this.mOuterInterface) || (networkInfo = cm.getNetworkInfo(network)) == null) continue;
                    this.mOuterConnection.set(networkInfo.getType());
                }
            }
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            Vpn.this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        }

        public void check(String interfaze) {
            if (interfaze.equals(this.mOuterInterface)) {
                Log.i(TAG, "Legacy VPN is going down with " + interfaze);
                this.exit();
            }
        }

        public void exit() {
            this.interrupt();
            Vpn.this.agentDisconnect();
            try {
                Vpn.this.mContext.unregisterReceiver(this.mBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.v(TAG, "Waiting");
            String string2 = TAG;
            synchronized (TAG) {
                Log.v(TAG, "Executing");
                try {
                    this.bringup();
                    this.waitForDaemonsToStop();
                    LegacyVpnRunner.interrupted();
                }
                catch (InterruptedException interruptedException) {
                    for (LocalSocket socket : this.mSockets) {
                        IoUtils.closeQuietly(socket);
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException2) {
                        // empty catch block
                    }
                    for (String daemon : this.mDaemons) {
                        SystemService.stop(daemon);
                    }
                }
                finally {
                    for (LocalSocket socket : this.mSockets) {
                        IoUtils.closeQuietly(socket);
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    for (String daemon : this.mDaemons) {
                        SystemService.stop(daemon);
                    }
                }
                Vpn.this.agentDisconnect();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void checkInterruptAndDelay(boolean sleepLonger) throws InterruptedException {
            long now = SystemClock.elapsedRealtime();
            if (now - this.mBringupStartTime > 60000L) {
                Vpn.this.updateState(NetworkInfo.DetailedState.FAILED, "checkpoint");
                throw new IllegalStateException("VPN bringup took too long");
            }
            Thread.sleep(sleepLonger ? 200L : 1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bringup() {
            boolean initFinished = false;
            try {
                String endpoint;
                String searchDomains;
                String dnsServers;
                int i;
                this.mBringupStartTime = SystemClock.elapsedRealtime();
                for (String daemon : this.mDaemons) {
                    while (!SystemService.isStopped(daemon)) {
                        this.checkInterruptAndDelay(true);
                    }
                }
                File state = new File("/data/misc/vpn/state");
                state.delete();
                if (state.exists()) {
                    throw new IllegalStateException("Cannot delete the state");
                }
                new File("/data/misc/vpn/abort").delete();
                initFinished = true;
                boolean restart = false;
                for (String[] arguments : this.mArguments) {
                    restart = restart || arguments != null;
                }
                if (!restart) {
                    Vpn.this.agentDisconnect();
                    return;
                }
                Vpn.this.updateState(NetworkInfo.DetailedState.CONNECTING, "execute");
                block14: for (i = 0; i < this.mDaemons.length; ++i) {
                    String[] arguments = this.mArguments[i];
                    if (arguments == null) continue;
                    String daemon = this.mDaemons[i];
                    SystemService.start(daemon);
                    while (!SystemService.isRunning(daemon)) {
                        this.checkInterruptAndDelay(true);
                    }
                    this.mSockets[i] = new LocalSocket();
                    LocalSocketAddress address = new LocalSocketAddress(daemon, LocalSocketAddress.Namespace.RESERVED);
                    while (true) {
                        try {
                            this.mSockets[i].connect(address);
                        }
                        catch (Exception exception) {
                            this.checkInterruptAndDelay(true);
                            continue;
                        }
                        break;
                    }
                    this.mSockets[i].setSoTimeout(500);
                    OutputStream out = this.mSockets[i].getOutputStream();
                    for (String argument : arguments) {
                        byte[] bytes = argument.getBytes(StandardCharsets.UTF_8);
                        if (bytes.length >= 65535) {
                            throw new IllegalArgumentException("Argument is too large");
                        }
                        out.write(bytes.length >> 8);
                        out.write(bytes.length);
                        out.write(bytes);
                        this.checkInterruptAndDelay(false);
                    }
                    out.write(255);
                    out.write(255);
                    out.flush();
                    InputStream in = this.mSockets[i].getInputStream();
                    while (true) {
                        try {
                            if (in.read() == -1) {
                                continue block14;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.checkInterruptAndDelay(true);
                    }
                }
                while (!state.exists()) {
                    for (i = 0; i < this.mDaemons.length; ++i) {
                        String daemon = this.mDaemons[i];
                        if (this.mArguments[i] == null || SystemService.isRunning(daemon)) continue;
                        throw new IllegalStateException(daemon + " is dead");
                    }
                    this.checkInterruptAndDelay(true);
                }
                String[] parameters = FileUtils.readTextFile(state, 0, null).split("\n", -1);
                if (parameters.length != 7) {
                    throw new IllegalStateException("Cannot parse the state");
                }
                Vpn.this.mConfig.interfaze = parameters[0].trim();
                Vpn.this.mConfig.addLegacyAddresses(parameters[1]);
                if (Vpn.this.mConfig.routes == null || Vpn.this.mConfig.routes.isEmpty()) {
                    Vpn.this.mConfig.addLegacyRoutes(parameters[2]);
                }
                if (!(Vpn.this.mConfig.dnsServers != null && Vpn.this.mConfig.dnsServers.size() != 0 || (dnsServers = parameters[3].trim()).isEmpty())) {
                    Vpn.this.mConfig.dnsServers = Arrays.asList(dnsServers.split(" "));
                }
                if (!(Vpn.this.mConfig.searchDomains != null && Vpn.this.mConfig.searchDomains.size() != 0 || (searchDomains = parameters[4].trim()).isEmpty())) {
                    Vpn.this.mConfig.searchDomains = Arrays.asList(searchDomains.split(" "));
                }
                String string2 = endpoint = parameters[5].isEmpty() ? this.mProfile.server : parameters[5];
                if (!endpoint.isEmpty()) {
                    try {
                        InetAddress addr = InetAddress.parseNumericAddress((String)endpoint);
                        if (addr instanceof Inet4Address) {
                            Vpn.this.mConfig.routes.add(new RouteInfo(new IpPrefix(addr, 32), 9));
                        } else if (addr instanceof Inet6Address) {
                            Vpn.this.mConfig.routes.add(new RouteInfo(new IpPrefix(addr, 128), 9));
                        } else {
                            Log.e(TAG, "Unknown IP address family for VPN endpoint: " + endpoint);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Log.e(TAG, "Exception constructing throw route to " + endpoint + ": " + e);
                    }
                }
                Vpn vpn = Vpn.this;
                synchronized (vpn) {
                    Vpn.this.mConfig.startTime = SystemClock.elapsedRealtime();
                    this.checkInterruptAndDelay(false);
                    if (Vpn.this.jniCheck(Vpn.this.mConfig.interfaze) == 0) {
                        throw new IllegalStateException(Vpn.this.mConfig.interfaze + " is gone");
                    }
                    Vpn.this.mInterface = Vpn.this.mConfig.interfaze;
                    Vpn.this.prepareStatusIntent();
                    Vpn.this.agentConnect();
                    Log.i(TAG, "Connected!");
                }
            }
            catch (Exception e) {
                Log.i(TAG, "Aborting", e);
                Vpn.this.updateState(NetworkInfo.DetailedState.FAILED, e.getMessage());
                this.exit();
            }
        }

        private void waitForDaemonsToStop() throws InterruptedException {
            if (!Vpn.this.mNetworkInfo.isConnected()) {
                return;
            }
            block0: while (true) {
                Thread.sleep(2000L);
                int i = 0;
                while (true) {
                    if (i >= this.mDaemons.length) continue block0;
                    if (this.mArguments[i] != null && SystemService.isStopped(this.mDaemons[i])) {
                        return;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    @VisibleForTesting
    public static class SystemServices {
        private final Context mContext;

        public SystemServices(Context context) {
            this.mContext = context;
        }

        public PendingIntent pendingIntentGetActivityAsUser(Intent intent, int flags, UserHandle user) {
            return PendingIntent.getActivityAsUser(this.mContext, 0, intent, flags, null, user);
        }

        public void settingsSecurePutStringForUser(String key, String value, int userId) {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), key, value, userId);
        }

        public void settingsSecurePutIntForUser(String key, int value, int userId) {
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), key, value, userId);
        }

        public String settingsSecureGetStringForUser(String key, int userId) {
            return Settings.Secure.getStringForUser(this.mContext.getContentResolver(), key, userId);
        }

        public int settingsSecureGetIntForUser(String key, int def, int userId) {
            return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), key, def, userId);
        }
    }

    private class Connection
    implements ServiceConnection {
        private IBinder mService;

        private Connection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mService = service;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            this.mService = null;
        }
    }
}

