/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.net.util.SharedLog;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.util.ArraySet;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.StateMachine;
import com.android.server.connectivity.MockableSystemProperties;
import com.android.server.connectivity.tethering.TetheringConfiguration;
import java.io.PrintWriter;

public class EntitlementManager {
    private static final String TAG = EntitlementManager.class.getSimpleName();
    private static final boolean DBG = false;
    @VisibleForTesting
    protected static final String DISABLE_PROVISIONING_SYSPROP_KEY = "net.tethering.noprovisioning";
    private static final String ACTION_PROVISIONING_ALARM = "com.android.server.connectivity.tethering.PROVISIONING_RECHECK_ALARM";
    private static final String EXTRA_SUBID = "subId";
    private static final ComponentName TETHER_SERVICE = ComponentName.unflattenFromString(Resources.getSystem().getString(17039781));
    private static final int MS_PER_HOUR = 3600000;
    private static final int EVENT_START_PROVISIONING = 0;
    private static final int EVENT_STOP_PROVISIONING = 1;
    private static final int EVENT_UPSTREAM_CHANGED = 2;
    private static final int EVENT_MAYBE_RUN_PROVISIONING = 3;
    private static final int EVENT_GET_ENTITLEMENT_VALUE = 4;
    private final ArraySet<Integer> mCurrentTethers;
    private final Context mContext;
    private final int mPermissionChangeMessageCode;
    private final MockableSystemProperties mSystemProperties;
    private final SharedLog mLog;
    private final SparseIntArray mEntitlementCacheValue;
    private final EntitlementHandler mHandler;
    private final StateMachine mTetherMasterSM;
    private final SparseIntArray mCellularPermitted;
    private PendingIntent mProvisioningRecheckAlarm;
    private boolean mCellularUpstreamPermitted = true;
    private boolean mUsingCellularAsUpstream = false;
    private boolean mNeedReRunProvisioningUi = false;
    private OnUiEntitlementFailedListener mListener;
    private TetheringConfigurationFetcher mFetcher;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (EntitlementManager.ACTION_PROVISIONING_ALARM.equals(intent.getAction())) {
                EntitlementManager.this.mLog.log("Received provisioning alarm");
                TetheringConfiguration config = EntitlementManager.this.mFetcher.fetchTetheringConfiguration();
                EntitlementManager.this.reevaluateSimCardProvisioning(config);
            }
        }
    };

    public EntitlementManager(Context ctx, StateMachine tetherMasterSM, SharedLog log, int permissionChangeMessageCode, MockableSystemProperties systemProperties) {
        this.mContext = ctx;
        this.mLog = log.forSubComponent(TAG);
        this.mCurrentTethers = new ArraySet();
        this.mCellularPermitted = new SparseIntArray();
        this.mSystemProperties = systemProperties;
        this.mEntitlementCacheValue = new SparseIntArray();
        this.mTetherMasterSM = tetherMasterSM;
        this.mPermissionChangeMessageCode = permissionChangeMessageCode;
        Handler masterHandler = tetherMasterSM.getHandler();
        this.mHandler = new EntitlementHandler(masterHandler.getLooper());
        this.mContext.registerReceiver(this.mReceiver, new IntentFilter(ACTION_PROVISIONING_ALARM), null, this.mHandler);
    }

    public void setOnUiEntitlementFailedListener(OnUiEntitlementFailedListener listener) {
        this.mListener = listener;
    }

    public void setTetheringConfigurationFetcher(TetheringConfigurationFetcher fetcher) {
        this.mFetcher = fetcher;
    }

    public boolean isCellularUpstreamPermitted() {
        return this.mCellularUpstreamPermitted;
    }

    public void startProvisioningIfNeeded(int downstreamType, boolean showProvisioningUi) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(0, downstreamType, EntitlementManager.encodeBool(showProvisioningUi)));
    }

    private void handleStartProvisioningIfNeeded(int type, boolean showProvisioningUi) {
        TetheringConfiguration config;
        if (!EntitlementManager.isValidDownstreamType(type)) {
            return;
        }
        if (!this.mCurrentTethers.contains(type)) {
            this.mCurrentTethers.add(type);
        }
        if (this.isTetherProvisioningRequired(config = this.mFetcher.fetchTetheringConfiguration())) {
            if (this.mCellularPermitted.size() == 0) {
                this.mCellularUpstreamPermitted = false;
            }
            if (this.mUsingCellularAsUpstream) {
                if (showProvisioningUi) {
                    this.runUiTetherProvisioning(type, config.subId);
                } else {
                    this.runSilentTetherProvisioning(type, config.subId);
                }
                this.mNeedReRunProvisioningUi = false;
            } else {
                this.mNeedReRunProvisioningUi |= showProvisioningUi;
            }
        } else {
            this.mCellularUpstreamPermitted = true;
        }
    }

    public void stopProvisioningIfNeeded(int type) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, type, 0));
    }

    private void handleStopProvisioningIfNeeded(int type) {
        if (!EntitlementManager.isValidDownstreamType(type)) {
            return;
        }
        this.mCurrentTethers.remove(type);
        this.removeDownstreamMapping(type);
    }

    public void notifyUpstream(boolean isCellular) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, EntitlementManager.encodeBool(isCellular), 0));
    }

    private void handleNotifyUpstream(boolean isCellular) {
        this.mUsingCellularAsUpstream = isCellular;
        if (this.mUsingCellularAsUpstream) {
            TetheringConfiguration config = this.mFetcher.fetchTetheringConfiguration();
            this.handleMaybeRunProvisioning(config);
        }
    }

    public void maybeRunProvisioning() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    private void handleMaybeRunProvisioning(TetheringConfiguration config) {
        if (this.mCurrentTethers.size() == 0 || !this.isTetherProvisioningRequired(config)) {
            return;
        }
        for (Integer downstream : this.mCurrentTethers) {
            if (this.mCellularPermitted.indexOfKey(downstream) >= 0) continue;
            if (this.mNeedReRunProvisioningUi) {
                this.mNeedReRunProvisioningUi = false;
                this.runUiTetherProvisioning(downstream, config.subId);
                continue;
            }
            this.runSilentTetherProvisioning(downstream, config.subId);
        }
    }

    @VisibleForTesting
    protected boolean isTetherProvisioningRequired(TetheringConfiguration config) {
        if (this.mSystemProperties.getBoolean(DISABLE_PROVISIONING_SYSPROP_KEY, false) || config.provisioningApp.length == 0) {
            return false;
        }
        if (this.carrierConfigAffirmsEntitlementCheckNotRequired(config)) {
            return false;
        }
        return config.provisioningApp.length == 2;
    }

    public void reevaluateSimCardProvisioning(TetheringConfiguration config) {
        if (!this.mHandler.getLooper().isCurrentThread()) {
            this.mLog.log("reevaluateSimCardProvisioning() don't run in TetherMaster thread");
        }
        this.mEntitlementCacheValue.clear();
        this.mCellularPermitted.clear();
        if (!config.hasMobileHotspotProvisionApp() || this.carrierConfigAffirmsEntitlementCheckNotRequired(config)) {
            this.evaluateCellularPermission(config);
            return;
        }
        if (this.mUsingCellularAsUpstream) {
            this.handleMaybeRunProvisioning(config);
        }
    }

    public PersistableBundle getCarrierConfig(TetheringConfiguration config) {
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configManager == null) {
            return null;
        }
        PersistableBundle carrierConfig = configManager.getConfigForSubId(config.subId);
        if (CarrierConfigManager.isConfigForIdentifiedCarrier(carrierConfig)) {
            return carrierConfig;
        }
        return null;
    }

    private boolean carrierConfigAffirmsEntitlementCheckNotRequired(TetheringConfiguration config) {
        PersistableBundle carrierConfig = this.getCarrierConfig(config);
        if (carrierConfig == null) {
            return false;
        }
        boolean isEntitlementCheckRequired = carrierConfig.getBoolean("require_entitlement_checks_bool");
        return !isEntitlementCheckRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void runSilentTetherProvisioning(int type, int subId) {
        ResultReceiver receiver = this.buildProxyReceiver(type, false, null);
        Intent intent = new Intent();
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraRunProvision", true);
        intent.putExtra("extraProvisionCallback", receiver);
        intent.putExtra(EXTRA_SUBID, subId);
        intent.setComponent(TETHER_SERVICE);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startServiceAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void runUiTetherProvisioning(int type, int subId) {
        ResultReceiver receiver = this.buildProxyReceiver(type, true, null);
        this.runUiTetherProvisioning(type, subId, receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void runUiTetherProvisioning(int type, int subId, ResultReceiver receiver) {
        Intent intent = new Intent("android.settings.TETHER_PROVISIONING_UI");
        intent.putExtra("extraAddTetherType", type);
        intent.putExtra("extraProvisionCallback", receiver);
        intent.putExtra(EXTRA_SUBID, subId);
        intent.addFlags(0x10000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void scheduleProvisioningRechecks(TetheringConfiguration config) {
        if (this.mProvisioningRecheckAlarm == null) {
            int period = config.provisioningCheckPeriod;
            if (period <= 0) {
                return;
            }
            Intent intent = new Intent(ACTION_PROVISIONING_ALARM);
            this.mProvisioningRecheckAlarm = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
            AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
            long periodMs = period * 3600000;
            long firstAlarmTime = SystemClock.elapsedRealtime() + periodMs;
            alarmManager.setRepeating(3, firstAlarmTime, periodMs, this.mProvisioningRecheckAlarm);
        }
    }

    private void cancelTetherProvisioningRechecks() {
        if (this.mProvisioningRecheckAlarm != null) {
            AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
            alarmManager.cancel(this.mProvisioningRecheckAlarm);
            this.mProvisioningRecheckAlarm = null;
        }
    }

    private void evaluateCellularPermission(TetheringConfiguration config) {
        boolean oldPermitted = this.mCellularUpstreamPermitted;
        boolean bl = this.mCellularUpstreamPermitted = !this.isTetherProvisioningRequired(config) || this.mCellularPermitted.indexOfValue(0) > -1;
        if (this.mCellularUpstreamPermitted != oldPermitted) {
            this.mLog.log("Cellular permission change: " + this.mCellularUpstreamPermitted);
            this.mTetherMasterSM.sendMessage(this.mPermissionChangeMessageCode);
        }
        if (this.mCellularUpstreamPermitted && this.mCellularPermitted.size() > 0) {
            this.scheduleProvisioningRechecks(config);
        } else {
            this.cancelTetherProvisioningRechecks();
        }
    }

    protected void addDownstreamMapping(int type, int resultCode) {
        this.mLog.i("addDownstreamMapping: " + type + ", result: " + resultCode + " ,TetherTypeRequested: " + this.mCurrentTethers.contains(type));
        if (!this.mCurrentTethers.contains(type)) {
            return;
        }
        this.mCellularPermitted.put(type, resultCode);
        TetheringConfiguration config = this.mFetcher.fetchTetheringConfiguration();
        this.evaluateCellularPermission(config);
    }

    protected void removeDownstreamMapping(int type) {
        this.mLog.i("removeDownstreamMapping: " + type);
        this.mCellularPermitted.delete(type);
        TetheringConfiguration config = this.mFetcher.fetchTetheringConfiguration();
        this.evaluateCellularPermission(config);
    }

    private static boolean toBool(int encodedBoolean) {
        return encodedBoolean != 0;
    }

    private static int encodeBool(boolean b) {
        return b ? 1 : 0;
    }

    private static boolean isValidDownstreamType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void dump(PrintWriter pw) {
        pw.print("mCellularUpstreamPermitted: ");
        pw.println(this.mCellularUpstreamPermitted);
        for (Integer type : this.mCurrentTethers) {
            pw.print("Type: ");
            pw.print(EntitlementManager.typeString(type));
            if (this.mCellularPermitted.indexOfKey(type) > -1) {
                pw.print(", Value: ");
                pw.println(EntitlementManager.errorString(this.mCellularPermitted.get(type)));
                continue;
            }
            pw.println(", Value: empty");
        }
    }

    private static String typeString(int type) {
        switch (type) {
            case 2: {
                return "TETHERING_BLUETOOTH";
            }
            case -1: {
                return "TETHERING_INVALID";
            }
            case 1: {
                return "TETHERING_USB";
            }
            case 0: {
                return "TETHERING_WIFI";
            }
        }
        return String.format("TETHERING UNKNOWN TYPE (%d)", type);
    }

    private static String errorString(int value) {
        switch (value) {
            case 13: {
                return "TETHER_ERROR_ENTITLEMENT_UNKONWN";
            }
            case 0: {
                return "TETHER_ERROR_NO_ERROR";
            }
            case 11: {
                return "TETHER_ERROR_PROVISION_FAILED";
            }
        }
        return String.format("UNKNOWN ERROR (%d)", value);
    }

    private ResultReceiver buildProxyReceiver(final int type, final boolean notifyFail, final ResultReceiver receiver) {
        ResultReceiver rr = new ResultReceiver(this.mHandler){

            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                int updatedCacheValue = EntitlementManager.this.updateEntitlementCacheValue(type, resultCode);
                EntitlementManager.this.addDownstreamMapping(type, updatedCacheValue);
                if (updatedCacheValue == 11 && notifyFail) {
                    EntitlementManager.this.mListener.onUiEntitlementFailed(type);
                }
                if (receiver != null) {
                    receiver.send(updatedCacheValue, null);
                }
            }
        };
        return this.writeToParcel(rr);
    }

    private ResultReceiver writeToParcel(ResultReceiver receiver) {
        Parcel parcel = Parcel.obtain();
        receiver.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        ResultReceiver receiverForSending = ResultReceiver.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return receiverForSending;
    }

    private int updateEntitlementCacheValue(int type, int resultCode) {
        if (resultCode == 0) {
            this.mEntitlementCacheValue.put(type, resultCode);
            return resultCode;
        }
        this.mEntitlementCacheValue.put(type, 11);
        return 11;
    }

    public void getLatestTetheringEntitlementResult(int downstream, ResultReceiver receiver, boolean showEntitlementUi) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, downstream, EntitlementManager.encodeBool(showEntitlementUi), receiver));
    }

    private void handleGetLatestTetheringEntitlementValue(int downstream, ResultReceiver receiver, boolean showEntitlementUi) {
        TetheringConfiguration config = this.mFetcher.fetchTetheringConfiguration();
        if (!this.isTetherProvisioningRequired(config)) {
            receiver.send(0, null);
            return;
        }
        int cacheValue = this.mEntitlementCacheValue.get(downstream, 13);
        if (cacheValue == 0 || !showEntitlementUi) {
            receiver.send(cacheValue, null);
        } else {
            ResultReceiver proxy = this.buildProxyReceiver(downstream, false, receiver);
            this.runUiTetherProvisioning(downstream, config.subId, proxy);
        }
    }

    private class EntitlementHandler
    extends Handler {
        EntitlementHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    EntitlementManager.this.handleStartProvisioningIfNeeded(msg.arg1, EntitlementManager.toBool(msg.arg2));
                    break;
                }
                case 1: {
                    EntitlementManager.this.handleStopProvisioningIfNeeded(msg.arg1);
                    break;
                }
                case 2: {
                    EntitlementManager.this.handleNotifyUpstream(EntitlementManager.toBool(msg.arg1));
                    break;
                }
                case 3: {
                    TetheringConfiguration config = EntitlementManager.this.mFetcher.fetchTetheringConfiguration();
                    EntitlementManager.this.handleMaybeRunProvisioning(config);
                    break;
                }
                case 4: {
                    EntitlementManager.this.handleGetLatestTetheringEntitlementValue(msg.arg1, (ResultReceiver)msg.obj, EntitlementManager.toBool(msg.arg2));
                    break;
                }
                default: {
                    EntitlementManager.this.mLog.log("Unknown event: " + msg.what);
                }
            }
        }
    }

    public static interface TetheringConfigurationFetcher {
        public TetheringConfiguration fetchTetheringConfiguration();
    }

    public static interface OnUiEntitlementFailedListener {
        public void onUiEntitlementFailed(int var1);
    }
}

