/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.util.SharedLog;
import android.provider.Settings;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringJoiner;

public class TetheringConfiguration {
    private static final String TAG = TetheringConfiguration.class.getSimpleName();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] LEGACY_DHCP_DEFAULT_RANGE = new String[]{"192.168.42.2", "192.168.42.254", "192.168.43.2", "192.168.43.254", "192.168.44.2", "192.168.44.254", "192.168.45.2", "192.168.45.254", "192.168.46.2", "192.168.46.254", "192.168.47.2", "192.168.47.254", "192.168.48.2", "192.168.48.254", "192.168.49.2", "192.168.49.254"};
    private final String[] DEFAULT_IPV4_DNS = new String[]{"8.8.4.4", "8.8.8.8"};
    public final String[] tetherableUsbRegexs;
    public final String[] tetherableWifiRegexs;
    public final String[] tetherableBluetoothRegexs;
    public final boolean isDunRequired;
    public final boolean chooseUpstreamAutomatically;
    public final Collection<Integer> preferredUpstreamIfaceTypes;
    public final String[] legacyDhcpRanges;
    public final String[] defaultIPv4DNS;
    public final boolean enableLegacyDhcpServer;
    public final String[] provisioningApp;
    public final String provisioningAppNoUi;
    public final int provisioningCheckPeriod;
    public final int subId;

    public TetheringConfiguration(Context ctx, SharedLog log, int id2) {
        SharedLog configLog = log.forSubComponent("config");
        this.subId = id2;
        Resources res = this.getResources(ctx, this.subId);
        this.tetherableUsbRegexs = TetheringConfiguration.getResourceStringArray(res, 17236070);
        this.tetherableWifiRegexs = TetheringConfiguration.getResourceStringArray(res, 17236071);
        this.tetherableBluetoothRegexs = TetheringConfiguration.getResourceStringArray(res, 17236067);
        this.isDunRequired = TetheringConfiguration.checkDunRequired(ctx);
        this.chooseUpstreamAutomatically = TetheringConfiguration.getResourceBoolean(res, 0x11100DD);
        this.preferredUpstreamIfaceTypes = TetheringConfiguration.getUpstreamIfaceTypes(res, this.isDunRequired);
        this.legacyDhcpRanges = TetheringConfiguration.getLegacyDhcpRanges(res);
        this.defaultIPv4DNS = TetheringConfiguration.copy(this.DEFAULT_IPV4_DNS);
        this.enableLegacyDhcpServer = TetheringConfiguration.getEnableLegacyDhcpServer(ctx);
        this.provisioningApp = TetheringConfiguration.getResourceStringArray(res, 17236038);
        this.provisioningAppNoUi = TetheringConfiguration.getProvisioningAppNoUi(res);
        this.provisioningCheckPeriod = TetheringConfiguration.getResourceInteger(res, 17694843, 0);
        configLog.log(this.toString());
    }

    public boolean isUsb(String iface) {
        return TetheringConfiguration.matchesDownstreamRegexs(iface, this.tetherableUsbRegexs);
    }

    public boolean isWifi(String iface) {
        return TetheringConfiguration.matchesDownstreamRegexs(iface, this.tetherableWifiRegexs);
    }

    public boolean isBluetooth(String iface) {
        return TetheringConfiguration.matchesDownstreamRegexs(iface, this.tetherableBluetoothRegexs);
    }

    public boolean hasMobileHotspotProvisionApp() {
        return !TextUtils.isEmpty(this.provisioningAppNoUi);
    }

    public void dump(PrintWriter pw) {
        pw.print("subId: ");
        pw.println(this.subId);
        TetheringConfiguration.dumpStringArray(pw, "tetherableUsbRegexs", this.tetherableUsbRegexs);
        TetheringConfiguration.dumpStringArray(pw, "tetherableWifiRegexs", this.tetherableWifiRegexs);
        TetheringConfiguration.dumpStringArray(pw, "tetherableBluetoothRegexs", this.tetherableBluetoothRegexs);
        pw.print("isDunRequired: ");
        pw.println(this.isDunRequired);
        pw.print("chooseUpstreamAutomatically: ");
        pw.println(this.chooseUpstreamAutomatically);
        TetheringConfiguration.dumpStringArray(pw, "preferredUpstreamIfaceTypes", TetheringConfiguration.preferredUpstreamNames(this.preferredUpstreamIfaceTypes));
        TetheringConfiguration.dumpStringArray(pw, "legacyDhcpRanges", this.legacyDhcpRanges);
        TetheringConfiguration.dumpStringArray(pw, "defaultIPv4DNS", this.defaultIPv4DNS);
        TetheringConfiguration.dumpStringArray(pw, "provisioningApp", this.provisioningApp);
        pw.print("provisioningAppNoUi: ");
        pw.println(this.provisioningAppNoUi);
        pw.print("enableLegacyDhcpServer: ");
        pw.println(this.enableLegacyDhcpServer);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(" ");
        sj.add(String.format("subId:%d", this.subId));
        sj.add(String.format("tetherableUsbRegexs:%s", TetheringConfiguration.makeString(this.tetherableUsbRegexs)));
        sj.add(String.format("tetherableWifiRegexs:%s", TetheringConfiguration.makeString(this.tetherableWifiRegexs)));
        sj.add(String.format("tetherableBluetoothRegexs:%s", TetheringConfiguration.makeString(this.tetherableBluetoothRegexs)));
        sj.add(String.format("isDunRequired:%s", this.isDunRequired));
        sj.add(String.format("chooseUpstreamAutomatically:%s", this.chooseUpstreamAutomatically));
        sj.add(String.format("preferredUpstreamIfaceTypes:%s", TetheringConfiguration.makeString(TetheringConfiguration.preferredUpstreamNames(this.preferredUpstreamIfaceTypes))));
        sj.add(String.format("provisioningApp:%s", TetheringConfiguration.makeString(this.provisioningApp)));
        sj.add(String.format("provisioningAppNoUi:%s", this.provisioningAppNoUi));
        sj.add(String.format("enableLegacyDhcpServer:%s", this.enableLegacyDhcpServer));
        return String.format("TetheringConfiguration{%s}", sj.toString());
    }

    private static void dumpStringArray(PrintWriter pw, String label, String[] values) {
        pw.print(label);
        pw.print(": ");
        if (values != null) {
            StringJoiner sj = new StringJoiner(", ", "[", "]");
            for (String value : values) {
                sj.add(value);
            }
            pw.print(sj.toString());
        } else {
            pw.print("null");
        }
        pw.println();
    }

    private static String makeString(String[] strings) {
        if (strings == null) {
            return "null";
        }
        StringJoiner sj = new StringJoiner(",", "[", "]");
        for (String s : strings) {
            sj.add(s);
        }
        return sj.toString();
    }

    private static String[] preferredUpstreamNames(Collection<Integer> upstreamTypes) {
        String[] upstreamNames = null;
        if (upstreamTypes != null) {
            upstreamNames = new String[upstreamTypes.size()];
            int i = 0;
            for (Integer netType : upstreamTypes) {
                upstreamNames[i] = ConnectivityManager.getNetworkTypeName(netType);
                ++i;
            }
        }
        return upstreamNames;
    }

    public static boolean checkDunRequired(Context ctx) {
        TelephonyManager tm = (TelephonyManager)ctx.getSystemService("phone");
        return tm != null ? tm.getTetherApnRequired() : false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Collection<Integer> getUpstreamIfaceTypes(Resources res, boolean dunRequired) {
        int[] ifaceTypes = res.getIntArray(17236069);
        ArrayList<Integer> upstreamIfaceTypes = new ArrayList<Integer>(ifaceTypes.length);
        block4: for (int i : ifaceTypes) {
            switch (i) {
                case 0: 
                case 5: {
                    if (!dunRequired) break;
                    continue block4;
                }
                case 4: {
                    if (!dunRequired) continue block4;
                }
            }
            upstreamIfaceTypes.add(i);
        }
        if (dunRequired) {
            TetheringConfiguration.appendIfNotPresent(upstreamIfaceTypes, 4);
        } else if (!TetheringConfiguration.containsOneOf(upstreamIfaceTypes, 0, 5)) {
            upstreamIfaceTypes.add(0);
            upstreamIfaceTypes.add(5);
        }
        TetheringConfiguration.prependIfNotPresent(upstreamIfaceTypes, 9);
        return upstreamIfaceTypes;
    }

    private static boolean matchesDownstreamRegexs(String iface, String[] regexs) {
        for (String regex : regexs) {
            if (!iface.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private static String[] getLegacyDhcpRanges(Resources res) {
        String[] fromResource = TetheringConfiguration.getResourceStringArray(res, 17236068);
        if (fromResource.length > 0 && fromResource.length % 2 == 0) {
            return fromResource;
        }
        return TetheringConfiguration.copy(LEGACY_DHCP_DEFAULT_RANGE);
    }

    private static String getProvisioningAppNoUi(Resources res) {
        try {
            return res.getString(17039756);
        }
        catch (Resources.NotFoundException e) {
            return "";
        }
    }

    private static boolean getResourceBoolean(Resources res, int resId) {
        try {
            return res.getBoolean(resId);
        }
        catch (Resources.NotFoundException e404) {
            return false;
        }
    }

    private static String[] getResourceStringArray(Resources res, int resId) {
        try {
            String[] strArray = res.getStringArray(resId);
            return strArray != null ? strArray : EMPTY_STRING_ARRAY;
        }
        catch (Resources.NotFoundException e404) {
            return EMPTY_STRING_ARRAY;
        }
    }

    private static int getResourceInteger(Resources res, int resId, int defaultValue) {
        try {
            return res.getInteger(resId);
        }
        catch (Resources.NotFoundException e404) {
            return defaultValue;
        }
    }

    private static boolean getEnableLegacyDhcpServer(Context ctx) {
        ContentResolver cr = ctx.getContentResolver();
        int intVal = Settings.Global.getInt(cr, "tether_enable_legacy_dhcp_server", 0);
        return intVal != 0;
    }

    private Resources getResources(Context ctx, int subId) {
        if (subId != -1) {
            return this.getResourcesForSubIdWrapper(ctx, subId);
        }
        return ctx.getResources();
    }

    @VisibleForTesting
    protected Resources getResourcesForSubIdWrapper(Context ctx, int subId) {
        return SubscriptionManager.getResourcesForSubId(ctx, subId);
    }

    private static String[] copy(String[] strarray) {
        return Arrays.copyOf(strarray, strarray.length);
    }

    private static void prependIfNotPresent(ArrayList<Integer> list, int value) {
        if (list.contains(value)) {
            return;
        }
        list.add(0, value);
    }

    private static void appendIfNotPresent(ArrayList<Integer> list, int value) {
        if (list.contains(value)) {
            return;
        }
        list.add(value);
    }

    private static boolean containsOneOf(ArrayList<Integer> list, Integer ... values) {
        for (Integer value : values) {
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }
}

