/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.net.LinkProperties;
import android.net.NetworkState;
import android.net.RouteInfo;
import android.net.util.InterfaceSet;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public final class TetheringInterfaceUtils {
    public static InterfaceSet getTetheringInterfaces(NetworkState ns) {
        if (ns == null) {
            return null;
        }
        LinkProperties lp = ns.linkProperties;
        String if4 = TetheringInterfaceUtils.getInterfaceForDestination(lp, Inet4Address.ANY);
        String if6 = TetheringInterfaceUtils.getIPv6Interface(ns);
        return if4 == null && if6 == null ? null : new InterfaceSet(if4, if6);
    }

    public static String getIPv6Interface(NetworkState ns) {
        boolean canTether = ns != null && ns.network != null && ns.linkProperties != null && ns.networkCapabilities != null && ns.linkProperties.hasIpv6DnsServer() && ns.linkProperties.hasGlobalIpv6Address() && ns.networkCapabilities.hasTransport(0);
        return canTether ? TetheringInterfaceUtils.getInterfaceForDestination(ns.linkProperties, Inet6Address.ANY) : null;
    }

    private static String getInterfaceForDestination(LinkProperties lp, InetAddress dst) {
        RouteInfo ri = lp != null ? RouteInfo.selectBestRoute(lp.getAllRoutes(), dst) : null;
        return ri != null ? ri.getInterface() : null;
    }
}

