/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseLongArray;
import com.android.internal.annotations.GuardedBy;
import com.android.server.content.SyncLogger;
import com.android.server.content.SyncManager;
import com.android.server.content.SyncOperation;

public class SyncJobService
extends JobService {
    private static final String TAG = "SyncManager";
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static SyncJobService sInstance;
    @GuardedBy(value={"sLock"})
    private static final SparseArray<JobParameters> sJobParamsMap;
    @GuardedBy(value={"sLock"})
    private static final SparseBooleanArray sStartedSyncs;
    @GuardedBy(value={"sLock"})
    private static final SparseLongArray sJobStartUptimes;
    private static final SyncLogger sLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInstance() {
        Class<SyncJobService> clazz = SyncJobService.class;
        synchronized (SyncJobService.class) {
            sInstance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SyncJobService getInstance() {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                Slog.wtf(TAG, "sInstance == null");
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        Object object = sLock;
        synchronized (object) {
            return sInstance != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStartJob(JobParameters params) {
        this.updateInstance();
        sLogger.purgeOldLogs();
        SyncOperation op = SyncOperation.maybeCreateFromJobExtras(params.getExtras());
        if (op == null) {
            Slog.wtf(TAG, "Got invalid job " + params.getJobId());
            return false;
        }
        boolean readyToSync = SyncManager.readyToSync(op.target.userId);
        sLogger.log("onStartJob() jobid=", params.getJobId(), " op=", op, " readyToSync", readyToSync);
        if (!readyToSync) {
            boolean wantsReschedule = !op.isPeriodic;
            this.jobFinished(params, wantsReschedule);
            return true;
        }
        boolean isLoggable = Log.isLoggable(TAG, 2);
        Object object = sLock;
        synchronized (object) {
            int jobId = params.getJobId();
            sJobParamsMap.put(jobId, params);
            sStartedSyncs.delete(jobId);
            sJobStartUptimes.put(jobId, SystemClock.uptimeMillis());
        }
        Message m = Message.obtain();
        m.what = 10;
        if (isLoggable) {
            Slog.v(TAG, "Got start job message " + op.target);
        }
        m.obj = op;
        SyncManager.sendMessage(m);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStopJob(JobParameters params) {
        SyncOperation op;
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "onStopJob called " + params.getJobId() + ", reason: " + params.getStopReason());
        }
        if ((op = SyncOperation.maybeCreateFromJobExtras(params.getExtras())) == null) {
            Slog.wtf(TAG, "Got invalid job " + params.getJobId());
            return false;
        }
        boolean readyToSync = SyncManager.readyToSync(op.target.userId);
        sLogger.log("onStopJob() ", sLogger.jobParametersToString(params), " readyToSync=", readyToSync);
        Object object = sLock;
        synchronized (object) {
            int jobId = params.getJobId();
            sJobParamsMap.remove(jobId);
            long startUptime = sJobStartUptimes.get(jobId);
            long nowUptime = SystemClock.uptimeMillis();
            long runtime = nowUptime - startUptime;
            if (runtime > 60000L && readyToSync && !sStartedSyncs.get(jobId)) {
                SyncJobService.wtf("Job " + jobId + " didn't start:  startUptime=" + startUptime + " nowUptime=" + nowUptime + " params=" + SyncJobService.jobParametersToString(params));
            }
            sStartedSyncs.delete(jobId);
            sJobStartUptimes.delete(jobId);
        }
        Message m = Message.obtain();
        m.what = 11;
        m.obj = op;
        m.arg1 = params.getStopReason() != 0 ? 1 : 0;
        m.arg2 = params.getStopReason() == 3 ? 1 : 0;
        SyncManager.sendMessage(m);
        return false;
    }

    public static void callJobFinished(int jobId, boolean needsReschedule, String why) {
        SyncJobService instance = SyncJobService.getInstance();
        if (instance != null) {
            instance.callJobFinishedInner(jobId, needsReschedule, why);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callJobFinishedInner(int jobId, boolean needsReschedule, String why) {
        Object object = sLock;
        synchronized (object) {
            JobParameters params = sJobParamsMap.get(jobId);
            sLogger.log("callJobFinished()", " jobid=", jobId, " needsReschedule=", needsReschedule, " ", sLogger.jobParametersToString(params), " why=", why);
            if (params != null) {
                this.jobFinished(params, needsReschedule);
                sJobParamsMap.remove(jobId);
            } else {
                Slog.e(TAG, "Job params not found for " + String.valueOf(jobId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markSyncStarted(int jobId) {
        Object object = sLock;
        synchronized (object) {
            sStartedSyncs.put(jobId, true);
        }
    }

    public static String jobParametersToString(JobParameters params) {
        if (params == null) {
            return "job:null";
        }
        return "job:#" + params.getJobId() + ":sr=[" + params.getStopReason() + "/" + params.getDebugStopReason() + "]:" + SyncOperation.maybeCreateFromJobExtras(params.getExtras());
    }

    private static void wtf(String message) {
        sLogger.log(message);
        Slog.wtf(TAG, message);
    }

    static {
        sJobParamsMap = new SparseArray();
        sStartedSyncs = new SparseBooleanArray();
        sJobStartUptimes = new SparseLongArray();
        sLogger = SyncLogger.getInstance();
    }
}

