/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.contentcapture;

import android.app.ActivityManagerInternal;
import android.app.ActivityThread;
import android.content.ComponentName;
import android.content.ContentCaptureOptions;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityPresentationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.DeviceConfig;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.LocalLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.contentcapture.ContentCaptureCondition;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.DataRemovalRequest;
import android.view.contentcapture.IContentCaptureManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.infra.GlobalWhitelistState;
import com.android.internal.os.IResultReceiver;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.SyncResultReceiver;
import com.android.server.LocalServices;
import com.android.server.contentcapture.ContentCaptureManagerInternal;
import com.android.server.contentcapture.ContentCaptureManagerServiceShellCommand;
import com.android.server.contentcapture.ContentCapturePerUserService;
import com.android.server.infra.AbstractMasterSystemService;
import com.android.server.infra.FrameworkResourcesServiceNameResolver;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ContentCaptureManagerService
extends AbstractMasterSystemService<ContentCaptureManagerService, ContentCapturePerUserService> {
    static final String RECEIVER_BUNDLE_EXTRA_SESSIONS = "sessions";
    private static final int MAX_TEMP_SERVICE_DURATION_MS = 120000;
    private final LocalService mLocalService = new LocalService();
    final LocalLog mRequestsHistory;
    @GuardedBy(value={"mLock"})
    private ActivityManagerInternal mAm;
    @GuardedBy(value={"mLock"})
    private SparseBooleanArray mDisabledBySettings;
    @GuardedBy(value={"mLock"})
    private boolean mDisabledByDeviceConfig;
    @GuardedBy(value={"mLock"})
    int mDevCfgLoggingLevel;
    @GuardedBy(value={"mLock"})
    int mDevCfgMaxBufferSize;
    @GuardedBy(value={"mLock"})
    int mDevCfgIdleFlushingFrequencyMs;
    @GuardedBy(value={"mLock"})
    int mDevCfgTextChangeFlushingFrequencyMs;
    @GuardedBy(value={"mLock"})
    int mDevCfgLogHistorySize;
    @GuardedBy(value={"mLock"})
    int mDevCfgIdleUnbindTimeoutMs;
    final GlobalContentCaptureOptions mGlobalContentCaptureOptions = new GlobalContentCaptureOptions();

    public ContentCaptureManagerService(Context context) {
        super(context, new FrameworkResourcesServiceNameResolver(context, 17039701), "no_content_capture", 0);
        DeviceConfig.addOnPropertiesChangedListener("content_capture", ActivityThread.currentApplication().getMainExecutor(), properties -> this.onDeviceConfigChange(properties));
        this.setDeviceConfigProperties();
        if (this.mDevCfgLogHistorySize > 0) {
            if (this.debug) {
                Slog.d(this.mTag, "log history size: " + this.mDevCfgLogHistorySize);
            }
            this.mRequestsHistory = new LocalLog(this.mDevCfgLogHistorySize);
        } else {
            if (this.debug) {
                Slog.d(this.mTag, "disabled log history because size is " + this.mDevCfgLogHistorySize);
            }
            this.mRequestsHistory = null;
        }
        UserManager um = this.getContext().getSystemService(UserManager.class);
        List<UserInfo> users = um.getUsers();
        for (int i = 0; i < users.size(); ++i) {
            boolean disabled;
            int userId = users.get((int)i).id;
            boolean bl = disabled = !this.isEnabledBySettings(userId);
            if (disabled) {
                Slog.i(this.mTag, "user " + userId + " disabled by settings");
                if (this.mDisabledBySettings == null) {
                    this.mDisabledBySettings = new SparseBooleanArray(1);
                }
                this.mDisabledBySettings.put(userId, true);
            }
            this.mGlobalContentCaptureOptions.setServiceInfo(userId, this.mServiceNameResolver.getServiceName(userId), this.mServiceNameResolver.isTemporary(userId));
        }
    }

    @Override
    protected ContentCapturePerUserService newServiceLocked(int resolvedUserId, boolean disabled) {
        return new ContentCapturePerUserService(this, this.mLock, disabled, resolvedUserId);
    }

    @Override
    public void onStart() {
        this.publishBinderService("content_capture", new ContentCaptureManagerServiceStub());
        this.publishLocalService(ContentCaptureManagerInternal.class, this.mLocalService);
    }

    @Override
    protected void onServiceRemoved(ContentCapturePerUserService service, int userId) {
        service.destroyLocked();
    }

    @Override
    protected void onServicePackageUpdatingLocked(int userId) {
        ContentCapturePerUserService service = (ContentCapturePerUserService)this.getServiceForUserLocked(userId);
        if (service != null) {
            service.onPackageUpdatingLocked();
        }
    }

    @Override
    protected void onServicePackageUpdatedLocked(int userId) {
        ContentCapturePerUserService service = (ContentCapturePerUserService)this.getServiceForUserLocked(userId);
        if (service != null) {
            service.onPackageUpdatedLocked();
        }
    }

    @Override
    protected void onServiceNameChanged(int userId, String serviceName, boolean isTemporary) {
        this.mGlobalContentCaptureOptions.setServiceInfo(userId, serviceName, isTemporary);
        super.onServiceNameChanged(userId, serviceName, isTemporary);
    }

    @Override
    protected void enforceCallingPermissionForManagement() {
        this.getContext().enforceCallingPermission("android.permission.MANAGE_CONTENT_CAPTURE", this.mTag);
    }

    @Override
    protected int getMaximumTemporaryServiceDurationMs() {
        return 120000;
    }

    @Override
    protected void registerForExtraSettingsChanges(ContentResolver resolver, ContentObserver observer) {
        resolver.registerContentObserver(Settings.Secure.getUriFor("content_capture_enabled"), false, observer, -1);
    }

    @Override
    protected void onSettingsChanged(int userId, String property) {
        switch (property) {
            case "content_capture_enabled": {
                this.setContentCaptureFeatureEnabledBySettingsForUser(userId, this.isEnabledBySettings(userId));
                return;
            }
        }
        Slog.w(this.mTag, "Unexpected property (" + property + "); updating cache instead");
    }

    @Override
    protected boolean isDisabledLocked(int userId) {
        return this.mDisabledByDeviceConfig || this.isDisabledBySettingsLocked(userId) || super.isDisabledLocked(userId);
    }

    private boolean isDisabledBySettingsLocked(int userId) {
        return this.mDisabledBySettings != null && this.mDisabledBySettings.get(userId);
    }

    private boolean isEnabledBySettings(int userId) {
        boolean enabled = Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "content_capture_enabled", 1, userId) == 1;
        return enabled;
    }

    private void onDeviceConfigChange(DeviceConfig.Properties properties) {
        Iterator<String> iterator = properties.getKeyset().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "service_explicitly_enabled": {
                    this.setDisabledByDeviceConfig(properties.getString(key, null));
                    return;
                }
                case "logging_level": {
                    this.setLoggingLevelFromDeviceConfig();
                    return;
                }
                case "max_buffer_size": 
                case "idle_flush_frequency": 
                case "log_history_size": 
                case "text_change_flush_frequency": 
                case "idle_unbind_timeout": {
                    this.setFineTuneParamsFromDeviceConfig();
                    return;
                }
            }
            Slog.i(this.mTag, "Ignoring change on " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFineTuneParamsFromDeviceConfig() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDevCfgMaxBufferSize = DeviceConfig.getInt("content_capture", "max_buffer_size", 100);
            this.mDevCfgIdleFlushingFrequencyMs = DeviceConfig.getInt("content_capture", "idle_flush_frequency", 5000);
            this.mDevCfgTextChangeFlushingFrequencyMs = DeviceConfig.getInt("content_capture", "text_change_flush_frequency", 1000);
            this.mDevCfgLogHistorySize = DeviceConfig.getInt("content_capture", "log_history_size", 20);
            this.mDevCfgIdleUnbindTimeoutMs = DeviceConfig.getInt("content_capture", "idle_unbind_timeout", 0);
            if (this.verbose) {
                Slog.v(this.mTag, "setFineTuneParamsFromDeviceConfig(): bufferSize=" + this.mDevCfgMaxBufferSize + ", idleFlush=" + this.mDevCfgIdleFlushingFrequencyMs + ", textFluxh=" + this.mDevCfgTextChangeFlushingFrequencyMs + ", logHistory=" + this.mDevCfgLogHistorySize + ", idleUnbindTimeoutMs=" + this.mDevCfgIdleUnbindTimeoutMs);
            }
        }
    }

    private void setLoggingLevelFromDeviceConfig() {
        this.mDevCfgLoggingLevel = DeviceConfig.getInt("content_capture", "logging_level", ContentCaptureHelper.getDefaultLoggingLevel());
        ContentCaptureHelper.setLoggingLevel(this.mDevCfgLoggingLevel);
        this.verbose = ContentCaptureHelper.sVerbose;
        this.debug = ContentCaptureHelper.sDebug;
        if (this.verbose) {
            Slog.v(this.mTag, "setLoggingLevelFromDeviceConfig(): level=" + this.mDevCfgLoggingLevel + ", debug=" + this.debug + ", verbose=" + this.verbose);
        }
    }

    private void setDeviceConfigProperties() {
        this.setLoggingLevelFromDeviceConfig();
        this.setFineTuneParamsFromDeviceConfig();
        String enabled = DeviceConfig.getProperty("content_capture", "service_explicitly_enabled");
        this.setDisabledByDeviceConfig(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisabledByDeviceConfig(String explicitlyEnabled) {
        if (this.verbose) {
            Slog.v(this.mTag, "setDisabledByDeviceConfig(): explicitlyEnabled=" + explicitlyEnabled);
        }
        UserManager um = this.getContext().getSystemService(UserManager.class);
        List<UserInfo> users = um.getUsers();
        boolean newDisabledValue = explicitlyEnabled != null && explicitlyEnabled.equalsIgnoreCase("false");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDisabledByDeviceConfig == newDisabledValue) {
                if (this.verbose) {
                    Slog.v(this.mTag, "setDisabledByDeviceConfig(): already " + newDisabledValue);
                }
                return;
            }
            this.mDisabledByDeviceConfig = newDisabledValue;
            Slog.i(this.mTag, "setDisabledByDeviceConfig(): set to " + this.mDisabledByDeviceConfig);
            for (int i = 0; i < users.size(); ++i) {
                int userId = users.get((int)i).id;
                boolean disabled = this.mDisabledByDeviceConfig || this.isDisabledBySettingsLocked(userId);
                Slog.i(this.mTag, "setDisabledByDeviceConfig(): updating service for user " + userId + " to " + (disabled ? "'disabled'" : "'enabled'"));
                this.updateCachedServiceLocked(userId, disabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContentCaptureFeatureEnabledBySettingsForUser(int userId, boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            boolean alreadyEnabled;
            if (this.mDisabledBySettings == null) {
                this.mDisabledBySettings = new SparseBooleanArray();
            }
            boolean bl = alreadyEnabled = !this.mDisabledBySettings.get(userId);
            if (!(enabled ^ alreadyEnabled)) {
                if (this.debug) {
                    Slog.d(this.mTag, "setContentCaptureFeatureEnabledForUser(): already " + enabled);
                }
                return;
            }
            if (enabled) {
                Slog.i(this.mTag, "setContentCaptureFeatureEnabled(): enabling service for user " + userId);
                this.mDisabledBySettings.delete(userId);
            } else {
                Slog.i(this.mTag, "setContentCaptureFeatureEnabled(): disabling service for user " + userId);
                this.mDisabledBySettings.put(userId, true);
            }
            boolean disabled = !enabled || this.mDisabledByDeviceConfig;
            this.updateCachedServiceLocked(userId, disabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroySessions(int userId, IResultReceiver receiver) {
        Slog.i(this.mTag, "destroySessions() for userId " + userId);
        this.enforceCallingPermissionForManagement();
        Object object = this.mLock;
        synchronized (object) {
            if (userId != -1) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.destroySessionsLocked();
                }
            } else {
                this.visitServicesLocked(s -> s.destroySessionsLocked());
            }
        }
        try {
            receiver.send(0, new Bundle());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listSessions(int userId, IResultReceiver receiver) {
        Slog.i(this.mTag, "listSessions() for userId " + userId);
        this.enforceCallingPermissionForManagement();
        Bundle resultData = new Bundle();
        ArrayList<String> sessions = new ArrayList<String>();
        Object object = this.mLock;
        synchronized (object) {
            if (userId != -1) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.listSessionsLocked(sessions);
                }
            } else {
                this.visitServicesLocked(s -> s.listSessionsLocked(sessions));
            }
        }
        resultData.putStringArrayList(RECEIVER_BUNDLE_EXTRA_SESSIONS, sessions);
        try {
            receiver.send(0, resultData);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityManagerInternal getAmInternal() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAm == null) {
                this.mAm = LocalServices.getService(ActivityManagerInternal.class);
            }
        }
        return this.mAm;
    }

    @GuardedBy(value={"mLock"})
    private void assertCalledByServiceLocked(String methodName) {
        if (!this.isCalledByServiceLocked(methodName)) {
            throw new SecurityException("caller is not user's ContentCapture service");
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean isCalledByServiceLocked(String methodName) {
        int serviceUid;
        int userId = UserHandle.getCallingUserId();
        int callingUid = Binder.getCallingUid();
        String serviceName = this.mServiceNameResolver.getServiceName(userId);
        if (serviceName == null) {
            Slog.e(this.mTag, methodName + ": called by UID " + callingUid + ", but there's no service set for user " + userId);
            return false;
        }
        ComponentName serviceComponent = ComponentName.unflattenFromString(serviceName);
        if (serviceComponent == null) {
            Slog.w(this.mTag, methodName + ": invalid service name: " + serviceName);
            return false;
        }
        String servicePackageName = serviceComponent.getPackageName();
        PackageManager pm = this.getContext().getPackageManager();
        try {
            serviceUid = pm.getPackageUidAsUser(servicePackageName, UserHandle.getCallingUserId());
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(this.mTag, methodName + ": could not verify UID for " + serviceName);
            return false;
        }
        if (callingUid != serviceUid) {
            Slog.e(this.mTag, methodName + ": called by UID " + callingUid + ", but service UID is " + serviceUid);
            return false;
        }
        return true;
    }

    private boolean throwsSecurityException(IResultReceiver result, Runnable runable) {
        try {
            runable.run();
            return false;
        }
        catch (SecurityException e) {
            try {
                result.send(-1, SyncResultReceiver.bundleFor(e.getMessage()));
            }
            catch (RemoteException e2) {
                Slog.w(this.mTag, "Unable to send security exception (" + e + "): ", e2);
            }
            return true;
        }
    }

    @Override
    protected void dumpLocked(String prefix, PrintWriter pw) {
        super.dumpLocked(prefix, pw);
        String prefix2 = prefix + "  ";
        pw.print(prefix);
        pw.print("Users disabled by Settings: ");
        pw.println(this.mDisabledBySettings);
        pw.print(prefix);
        pw.println("DeviceConfig Settings: ");
        pw.print(prefix2);
        pw.print("disabled: ");
        pw.println(this.mDisabledByDeviceConfig);
        pw.print(prefix2);
        pw.print("loggingLevel: ");
        pw.println(this.mDevCfgLoggingLevel);
        pw.print(prefix2);
        pw.print("maxBufferSize: ");
        pw.println(this.mDevCfgMaxBufferSize);
        pw.print(prefix2);
        pw.print("idleFlushingFrequencyMs: ");
        pw.println(this.mDevCfgIdleFlushingFrequencyMs);
        pw.print(prefix2);
        pw.print("textChangeFlushingFrequencyMs: ");
        pw.println(this.mDevCfgTextChangeFlushingFrequencyMs);
        pw.print(prefix2);
        pw.print("logHistorySize: ");
        pw.println(this.mDevCfgLogHistorySize);
        pw.print(prefix2);
        pw.print("idleUnbindTimeoutMs: ");
        pw.println(this.mDevCfgIdleUnbindTimeoutMs);
        pw.print(prefix);
        pw.println("Global Options:");
        this.mGlobalContentCaptureOptions.dump(prefix2, pw);
    }

    final class GlobalContentCaptureOptions
    extends GlobalWhitelistState {
        @GuardedBy(value={"mGlobalWhitelistStateLock"})
        private final SparseArray<String> mServicePackages = new SparseArray();
        @GuardedBy(value={"mGlobalWhitelistStateLock"})
        private final SparseBooleanArray mTemporaryServices = new SparseBooleanArray();

        GlobalContentCaptureOptions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setServiceInfo(int userId, String serviceName, boolean isTemporary) {
            Object object = this.mGlobalWhitelistStateLock;
            synchronized (object) {
                if (isTemporary) {
                    this.mTemporaryServices.put(userId, true);
                } else {
                    this.mTemporaryServices.delete(userId);
                }
                if (serviceName != null) {
                    ComponentName componentName = ComponentName.unflattenFromString(serviceName);
                    if (componentName == null) {
                        Slog.w(ContentCaptureManagerService.this.mTag, "setServiceInfo(): invalid name: " + serviceName);
                        this.mServicePackages.remove(userId);
                    } else {
                        this.mServicePackages.put(userId, componentName.getPackageName());
                    }
                } else {
                    this.mServicePackages.remove(userId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mGlobalWhitelistStateLock"})
        public ContentCaptureOptions getOptions(int userId, String packageName) {
            boolean packageWhitelisted;
            ArraySet<ComponentName> whitelistedComponents = null;
            Object object = this.mGlobalWhitelistStateLock;
            synchronized (object) {
                packageWhitelisted = this.isWhitelisted(userId, packageName);
                if (!packageWhitelisted && (whitelistedComponents = this.getWhitelistedComponents(userId, packageName)) == null && packageName.equals(this.mServicePackages.get(userId))) {
                    if (ContentCaptureManagerService.this.verbose) {
                        Slog.v(ContentCaptureManagerService.this.mTag, "getOptionsForPackage() lite for " + packageName);
                    }
                    return new ContentCaptureOptions(ContentCaptureManagerService.this.mDevCfgLoggingLevel);
                }
            }
            if (Build.IS_USER && ContentCaptureManagerService.this.mServiceNameResolver.isTemporary(userId) && !packageName.equals(this.mServicePackages.get(userId))) {
                Slog.w(ContentCaptureManagerService.this.mTag, "Ignoring package " + packageName + " while using temporary service " + this.mServicePackages.get(userId));
                return null;
            }
            if (!packageWhitelisted && whitelistedComponents == null) {
                if (ContentCaptureManagerService.this.verbose) {
                    Slog.v(ContentCaptureManagerService.this.mTag, "getOptionsForPackage(" + packageName + "): not whitelisted");
                }
                return null;
            }
            ContentCaptureOptions options = new ContentCaptureOptions(ContentCaptureManagerService.this.mDevCfgLoggingLevel, ContentCaptureManagerService.this.mDevCfgMaxBufferSize, ContentCaptureManagerService.this.mDevCfgIdleFlushingFrequencyMs, ContentCaptureManagerService.this.mDevCfgTextChangeFlushingFrequencyMs, ContentCaptureManagerService.this.mDevCfgLogHistorySize, whitelistedComponents);
            if (ContentCaptureManagerService.this.verbose) {
                Slog.v(ContentCaptureManagerService.this.mTag, "getOptionsForPackage(" + packageName + "): " + options);
            }
            return options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(String prefix, PrintWriter pw) {
            super.dump(prefix, pw);
            Object object = this.mGlobalWhitelistStateLock;
            synchronized (object) {
                if (this.mServicePackages.size() > 0) {
                    pw.print(prefix);
                    pw.print("Service packages: ");
                    pw.println(this.mServicePackages);
                }
                if (this.mTemporaryServices.size() > 0) {
                    pw.print(prefix);
                    pw.print("Temp services: ");
                    pw.println(this.mTemporaryServices);
                }
            }
        }
    }

    private final class LocalService
    extends ContentCaptureManagerInternal {
        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isContentCaptureServiceForUser(int uid, int userId) {
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)ContentCaptureManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return service.isContentCaptureServiceForUserLocked(uid);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean sendActivityAssistData(int userId, IBinder activityToken, Bundle data) {
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)ContentCaptureManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    return service.sendActivityAssistDataLocked(activityToken, data);
                }
            }
            return false;
        }

        @Override
        public ContentCaptureOptions getOptionsForPackage(int userId, String packageName) {
            return ContentCaptureManagerService.this.mGlobalContentCaptureOptions.getOptions(userId, packageName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyActivityEvent(int userId, ComponentName activityComponent, int eventType) {
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)ContentCaptureManagerService.this.peekServiceForUserLocked(userId);
                if (service != null) {
                    service.onActivityEventLocked(activityComponent, eventType);
                }
            }
        }
    }

    final class ContentCaptureManagerServiceStub
    extends IContentCaptureManager.Stub {
        ContentCaptureManagerServiceStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startSession(IBinder activityToken, ComponentName componentName, int sessionId, int flags, IResultReceiver result) {
            Preconditions.checkNotNull(activityToken);
            Preconditions.checkNotNull(sessionId);
            int userId = UserHandle.getCallingUserId();
            ActivityPresentationInfo activityPresentationInfo = ContentCaptureManagerService.this.getAmInternal().getActivityPresentationInfo(activityToken);
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)ContentCaptureManagerService.this.getServiceForUserLocked(userId);
                service.startSessionLocked(activityToken, activityPresentationInfo, sessionId, Binder.getCallingUid(), flags, result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishSession(int sessionId) {
            Preconditions.checkNotNull(sessionId);
            int userId = UserHandle.getCallingUserId();
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)ContentCaptureManagerService.this.getServiceForUserLocked(userId);
                service.finishSessionLocked(sessionId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getServiceComponentName(IResultReceiver result) {
            ComponentName connectedServiceComponentName;
            int userId = UserHandle.getCallingUserId();
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)ContentCaptureManagerService.this.getServiceForUserLocked(userId);
                connectedServiceComponentName = service.getServiceComponentName();
            }
            try {
                result.send(0, SyncResultReceiver.bundleFor(connectedServiceComponentName));
            }
            catch (RemoteException e) {
                Slog.w(ContentCaptureManagerService.this.mTag, "Unable to send service component name: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeData(DataRemovalRequest request) {
            Preconditions.checkNotNull(request);
            ContentCaptureManagerService.this.assertCalledByPackageOwner(request.getPackageName());
            int userId = UserHandle.getCallingUserId();
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)ContentCaptureManagerService.this.getServiceForUserLocked(userId);
                service.removeDataLocked(request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void isContentCaptureFeatureEnabled(IResultReceiver result) {
            boolean enabled;
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                if (ContentCaptureManagerService.this.throwsSecurityException(result, () -> ContentCaptureManagerService.this.assertCalledByServiceLocked("isContentCaptureFeatureEnabled()"))) {
                    return;
                }
                int userId = UserHandle.getCallingUserId();
                enabled = !ContentCaptureManagerService.this.mDisabledByDeviceConfig && !ContentCaptureManagerService.this.isDisabledBySettingsLocked(userId);
            }
            try {
                result.send(enabled ? 1 : 2, null);
            }
            catch (RemoteException e) {
                Slog.w(ContentCaptureManagerService.this.mTag, "Unable to send isContentCaptureFeatureEnabled(): " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getServiceSettingsActivity(IResultReceiver result) {
            ComponentName componentName;
            if (ContentCaptureManagerService.this.throwsSecurityException(result, () -> ContentCaptureManagerService.this.enforceCallingPermissionForManagement())) {
                return;
            }
            int userId = UserHandle.getCallingUserId();
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)ContentCaptureManagerService.this.getServiceForUserLocked(userId);
                if (service == null) {
                    return;
                }
                componentName = service.getServiceSettingsActivityLocked();
            }
            try {
                result.send(0, SyncResultReceiver.bundleFor(componentName));
            }
            catch (RemoteException e) {
                Slog.w(ContentCaptureManagerService.this.mTag, "Unable to send getServiceSettingsIntent(): " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getContentCaptureConditions(String packageName, IResultReceiver result) {
            ArrayList<ContentCaptureCondition> conditions;
            if (ContentCaptureManagerService.this.throwsSecurityException(result, () -> ContentCaptureManagerService.this.assertCalledByPackageOwner(packageName))) {
                return;
            }
            int userId = UserHandle.getCallingUserId();
            Object object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCapturePerUserService service = (ContentCapturePerUserService)ContentCaptureManagerService.this.getServiceForUserLocked(userId);
                conditions = service == null ? null : ContentCaptureHelper.toList(service.getContentCaptureConditionsLocked(packageName));
            }
            try {
                result.send(0, SyncResultReceiver.bundleFor(conditions));
            }
            catch (RemoteException e) {
                Slog.w(ContentCaptureManagerService.this.mTag, "Unable to send getServiceComponentName(): " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            Object object;
            if (!DumpUtils.checkDumpPermission(ContentCaptureManagerService.this.getContext(), ContentCaptureManagerService.this.mTag, pw)) {
                return;
            }
            boolean showHistory = true;
            if (args != null) {
                object = args;
                int n = ((String[])object).length;
                block11: for (int i = 0; i < n; ++i) {
                    String arg;
                    switch (arg = object[i]) {
                        case "--no-history": {
                            showHistory = false;
                            continue block11;
                        }
                        case "--help": {
                            pw.println("Usage: dumpsys content_capture [--no-history]");
                            return;
                        }
                        default: {
                            Slog.w(ContentCaptureManagerService.this.mTag, "Ignoring invalid dump arg: " + arg);
                        }
                    }
                }
            }
            object = ContentCaptureManagerService.this.mLock;
            synchronized (object) {
                ContentCaptureManagerService.this.dumpLocked("", pw);
            }
            pw.print("Requests history: ");
            if (ContentCaptureManagerService.this.mRequestsHistory == null) {
                pw.println("disabled by device config");
            } else if (showHistory) {
                pw.println();
                ContentCaptureManagerService.this.mRequestsHistory.reverseDump(fd, pw, args);
                pw.println();
            } else {
                pw.println();
            }
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
            new ContentCaptureManagerServiceShellCommand(ContentCaptureManagerService.this).exec(this, in, out, err, args, callback, resultReceiver);
        }
    }
}

