/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.contentcapture;

import android.os.Bundle;
import android.os.ShellCommand;
import android.os.UserHandle;
import com.android.internal.os.IResultReceiver;
import com.android.server.contentcapture.ContentCaptureManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class ContentCaptureManagerServiceShellCommand
extends ShellCommand {
    private final ContentCaptureManagerService mService;

    public ContentCaptureManagerServiceShellCommand(ContentCaptureManagerService service) {
        this.mService = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        switch (cmd) {
            case "list": {
                return this.requestList(pw);
            }
            case "destroy": {
                return this.requestDestroy(pw);
            }
            case "get": {
                return this.requestGet(pw);
            }
            case "set": {
                return this.requestSet(pw);
            }
        }
        return this.handleDefaultCommands(cmd);
    }

    @Override
    public void onHelp() {
        try (PrintWriter pw = this.getOutPrintWriter();){
            pw.println("ContentCapture Service (content_capture) commands:");
            pw.println("  help");
            pw.println("    Prints this help text.");
            pw.println("");
            pw.println("  get bind-instant-service-allowed");
            pw.println("    Gets whether binding to services provided by instant apps is allowed");
            pw.println("");
            pw.println("  set bind-instant-service-allowed [true | false]");
            pw.println("    Sets whether binding to services provided by instant apps is allowed");
            pw.println("");
            pw.println("  set temporary-service USER_ID [COMPONENT_NAME DURATION]");
            pw.println("    Temporarily (for DURATION ms) changes the service implemtation.");
            pw.println("    To reset, call with just the USER_ID argument.");
            pw.println("");
            pw.println("  set default-service-enabled USER_ID [true|false]");
            pw.println("    Enable / disable the default service for the user.");
            pw.println("");
            pw.println("  get default-service-enabled USER_ID");
            pw.println("    Checks whether the default service is enabled for the user.");
            pw.println("");
            pw.println("  list sessions [--user USER_ID]");
            pw.println("    Lists all pending sessions.");
            pw.println("");
            pw.println("  destroy sessions [--user USER_ID]");
            pw.println("    Destroys all pending sessions.");
            pw.println("");
        }
    }

    private int requestGet(PrintWriter pw) {
        String what;
        switch (what = this.getNextArgRequired()) {
            case "bind-instant-service-allowed": {
                return this.getBindInstantService(pw);
            }
            case "default-service-enabled": {
                return this.getDefaultServiceEnabled(pw);
            }
        }
        pw.println("Invalid set: " + what);
        return -1;
    }

    private int requestSet(PrintWriter pw) {
        String what;
        switch (what = this.getNextArgRequired()) {
            case "bind-instant-service-allowed": {
                return this.setBindInstantService(pw);
            }
            case "temporary-service": {
                return this.setTemporaryService(pw);
            }
            case "default-service-enabled": {
                return this.setDefaultServiceEnabled(pw);
            }
        }
        pw.println("Invalid set: " + what);
        return -1;
    }

    private int getBindInstantService(PrintWriter pw) {
        if (this.mService.getAllowInstantService()) {
            pw.println("true");
        } else {
            pw.println("false");
        }
        return 0;
    }

    private int setBindInstantService(PrintWriter pw) {
        String mode = this.getNextArgRequired();
        switch (mode.toLowerCase()) {
            case "true": {
                this.mService.setAllowInstantService(true);
                return 0;
            }
            case "false": {
                this.mService.setAllowInstantService(false);
                return 0;
            }
        }
        pw.println("Invalid mode: " + mode);
        return -1;
    }

    private int setTemporaryService(PrintWriter pw) {
        int userId = this.getNextIntArgRequired();
        String serviceName = this.getNextArg();
        if (serviceName == null) {
            this.mService.resetTemporaryService(userId);
            return 0;
        }
        int duration = this.getNextIntArgRequired();
        this.mService.setTemporaryService(userId, serviceName, duration);
        pw.println("ContentCaptureService temporarily set to " + serviceName + " for " + duration + "ms");
        return 0;
    }

    private int setDefaultServiceEnabled(PrintWriter pw) {
        boolean enabled;
        int userId = this.getNextIntArgRequired();
        boolean changed = this.mService.setDefaultServiceEnabled(userId, enabled = Boolean.parseBoolean(this.getNextArgRequired()));
        if (!changed) {
            pw.println("already " + enabled);
        }
        return 0;
    }

    private int getDefaultServiceEnabled(PrintWriter pw) {
        int userId = this.getNextIntArgRequired();
        boolean enabled = this.mService.isDefaultServiceEnabled(userId);
        pw.println(enabled);
        return 0;
    }

    private int requestDestroy(PrintWriter pw) {
        if (!this.isNextArgSessions(pw)) {
            return -1;
        }
        int userId = this.getUserIdFromArgsOrAllUsers();
        final CountDownLatch latch = new CountDownLatch(1);
        IResultReceiver.Stub receiver = new IResultReceiver.Stub(){

            @Override
            public void send(int resultCode, Bundle resultData) {
                latch.countDown();
            }
        };
        return this.requestSessionCommon(pw, latch, () -> this.mService.destroySessions(userId, receiver));
    }

    private int requestList(final PrintWriter pw) {
        if (!this.isNextArgSessions(pw)) {
            return -1;
        }
        int userId = this.getUserIdFromArgsOrAllUsers();
        final CountDownLatch latch = new CountDownLatch(1);
        IResultReceiver.Stub receiver = new IResultReceiver.Stub(){

            @Override
            public void send(int resultCode, Bundle resultData) {
                ArrayList<String> sessions = resultData.getStringArrayList("sessions");
                for (String session : sessions) {
                    pw.println(session);
                }
                latch.countDown();
            }
        };
        return this.requestSessionCommon(pw, latch, () -> this.mService.listSessions(userId, receiver));
    }

    private boolean isNextArgSessions(PrintWriter pw) {
        String type = this.getNextArgRequired();
        if (!type.equals("sessions")) {
            pw.println("Error: invalid list type");
            return false;
        }
        return true;
    }

    private int requestSessionCommon(PrintWriter pw, CountDownLatch latch, Runnable command) {
        command.run();
        return this.waitForLatch(pw, latch);
    }

    private int waitForLatch(PrintWriter pw, CountDownLatch latch) {
        try {
            boolean received = latch.await(5L, TimeUnit.SECONDS);
            if (!received) {
                pw.println("Timed out after 5 seconds");
                return -1;
            }
        }
        catch (InterruptedException e) {
            pw.println("System call interrupted");
            Thread.currentThread().interrupt();
            return -1;
        }
        return 0;
    }

    private int getUserIdFromArgsOrAllUsers() {
        if ("--user".equals(this.getNextArg())) {
            return UserHandle.parseUserArg(this.getNextArgRequired());
        }
        return -1;
    }

    private int getNextIntArgRequired() {
        return Integer.parseInt(this.getNextArgRequired());
    }
}

