/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.contentcapture;

import android.app.ActivityManagerInternal;
import android.app.assist.AssistContent;
import android.app.assist.AssistStructure;
import android.content.ComponentName;
import android.content.ContentCaptureOptions;
import android.content.pm.ActivityPresentationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.contentcapture.ActivityEvent;
import android.service.contentcapture.ContentCaptureService;
import android.service.contentcapture.ContentCaptureServiceInfo;
import android.service.contentcapture.FlushMetrics;
import android.service.contentcapture.IContentCaptureServiceCallback;
import android.service.contentcapture.SnapshotData;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.contentcapture.ContentCaptureCondition;
import android.view.contentcapture.DataRemovalRequest;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.IResultReceiver;
import com.android.server.LocalServices;
import com.android.server.contentcapture.ContentCaptureManagerService;
import com.android.server.contentcapture.ContentCaptureMetricsLogger;
import com.android.server.contentcapture.ContentCaptureServerSession;
import com.android.server.contentcapture.RemoteContentCaptureService;
import com.android.server.infra.AbstractPerUserSystemService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

final class ContentCapturePerUserService
extends AbstractPerUserSystemService<ContentCapturePerUserService, ContentCaptureManagerService>
implements RemoteContentCaptureService.ContentCaptureServiceCallbacks {
    private static final String TAG = ContentCapturePerUserService.class.getSimpleName();
    @GuardedBy(value={"mLock"})
    private final SparseArray<ContentCaptureServerSession> mSessions = new SparseArray();
    @GuardedBy(value={"mLock"})
    RemoteContentCaptureService mRemoteService;
    private final ContentCaptureServiceRemoteCallback mRemoteServiceCallback = new ContentCaptureServiceRemoteCallback();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<String, ArraySet<ContentCaptureCondition>> mConditionsByPkg = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private boolean mZombie;
    @GuardedBy(value={"mLock"})
    private ContentCaptureServiceInfo mInfo;

    ContentCapturePerUserService(ContentCaptureManagerService master, Object lock, boolean disabled, int userId) {
        super(master, lock, userId);
        this.updateRemoteServiceLocked(disabled);
    }

    private void updateRemoteServiceLocked(boolean disabled) {
        ComponentName serviceComponentName;
        if (((ContentCaptureManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "updateRemoteService(disabled=" + disabled + ")");
        }
        if (this.mRemoteService != null) {
            if (((ContentCaptureManagerService)this.mMaster).debug) {
                Slog.d(TAG, "updateRemoteService(): destroying old remote service");
            }
            this.mRemoteService.destroy();
            this.mRemoteService = null;
            this.resetContentCaptureWhitelistLocked();
        }
        if ((serviceComponentName = this.updateServiceInfoLocked()) == null) {
            if (((ContentCaptureManagerService)this.mMaster).debug) {
                Slog.d(TAG, "updateRemoteService(): no service component name");
            }
            return;
        }
        if (!disabled) {
            if (((ContentCaptureManagerService)this.mMaster).debug) {
                Slog.d(TAG, "updateRemoteService(): creating new remote service for " + serviceComponentName);
            }
            this.mRemoteService = new RemoteContentCaptureService(((ContentCaptureManagerService)this.mMaster).getContext(), "android.service.contentcapture.ContentCaptureService", serviceComponentName, this.mRemoteServiceCallback, this.mUserId, this, ((ContentCaptureManagerService)this.mMaster).isBindInstantServiceAllowed(), ((ContentCaptureManagerService)this.mMaster).verbose, ((ContentCaptureManagerService)this.mMaster).mDevCfgIdleUnbindTimeoutMs);
        }
    }

    @Override
    protected ServiceInfo newServiceInfoLocked(ComponentName serviceComponent) throws PackageManager.NameNotFoundException {
        this.mInfo = new ContentCaptureServiceInfo(this.getContext(), serviceComponent, this.isTemporaryServiceSetLocked(), this.mUserId);
        return this.mInfo.getServiceInfo();
    }

    @Override
    @GuardedBy(value={"mLock"})
    protected boolean updateLocked(boolean disabled) {
        boolean disabledStateChanged = super.updateLocked(disabled);
        if (disabledStateChanged) {
            for (int i = 0; i < this.mSessions.size(); ++i) {
                this.mSessions.valueAt(i).setContentCaptureEnabledLocked(!disabled);
            }
        }
        this.destroyLocked();
        this.updateRemoteServiceLocked(disabled);
        return disabledStateChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDied(RemoteContentCaptureService service) {
        Slog.w(TAG, "remote service died: " + service);
        Object object = this.mLock;
        synchronized (object) {
            this.mZombie = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConnected() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mZombie) {
                if (this.mRemoteService == null) {
                    Slog.w(TAG, "Cannot ressurect sessions because remote service is null");
                    return;
                }
                this.mZombie = false;
                this.resurrectSessionsLocked();
            }
        }
    }

    private void resurrectSessionsLocked() {
        int numSessions = this.mSessions.size();
        if (((ContentCaptureManagerService)this.mMaster).debug) {
            Slog.d(TAG, "Ressurrecting remote service (" + this.mRemoteService + ") on " + numSessions + " sessions");
        }
        for (int i = 0; i < numSessions; ++i) {
            ContentCaptureServerSession session = this.mSessions.valueAt(i);
            session.resurrectLocked();
        }
    }

    void onPackageUpdatingLocked() {
        int numSessions = this.mSessions.size();
        if (((ContentCaptureManagerService)this.mMaster).debug) {
            Slog.d(TAG, "Pausing " + numSessions + " sessions while package is updating");
        }
        for (int i = 0; i < numSessions; ++i) {
            ContentCaptureServerSession session = this.mSessions.valueAt(i);
            session.pauseLocked();
        }
    }

    void onPackageUpdatedLocked() {
        this.updateRemoteServiceLocked(!this.isEnabledLocked());
        this.resurrectSessionsLocked();
    }

    @GuardedBy(value={"mLock"})
    public void startSessionLocked(IBinder activityToken, ActivityPresentationInfo activityPresentationInfo, int sessionId, int uid, int flags, IResultReceiver clientReceiver) {
        if (activityPresentationInfo == null) {
            Slog.w(TAG, "basic activity info is null");
            ContentCaptureService.setClientState(clientReceiver, 260, null);
            return;
        }
        int taskId = activityPresentationInfo.taskId;
        int displayId = activityPresentationInfo.displayId;
        ComponentName componentName = activityPresentationInfo.componentName;
        boolean whiteListed = ((ContentCaptureManagerService)this.mMaster).mGlobalContentCaptureOptions.isWhitelisted(this.mUserId, componentName) || ((ContentCaptureManagerService)this.mMaster).mGlobalContentCaptureOptions.isWhitelisted(this.mUserId, componentName.getPackageName());
        ComponentName serviceComponentName = this.getServiceComponentName();
        boolean enabled = this.isEnabledLocked();
        if (((ContentCaptureManagerService)this.mMaster).mRequestsHistory != null) {
            String historyItem = "id=" + sessionId + " uid=" + uid + " a=" + ComponentName.flattenToShortString(componentName) + " t=" + taskId + " d=" + displayId + " s=" + ComponentName.flattenToShortString(serviceComponentName) + " u=" + this.mUserId + " f=" + flags + (enabled ? "" : " (disabled)") + " w=" + whiteListed;
            ((ContentCaptureManagerService)this.mMaster).mRequestsHistory.log(historyItem);
        }
        if (!enabled) {
            ContentCaptureService.setClientState(clientReceiver, 20, null);
            ContentCaptureMetricsLogger.writeSessionEvent(sessionId, 3, 20, serviceComponentName, componentName, false);
            return;
        }
        if (serviceComponentName == null) {
            if (((ContentCaptureManagerService)this.mMaster).debug) {
                Slog.d(TAG, "startSession(" + activityToken + "): hold your horses");
            }
            return;
        }
        if (!whiteListed) {
            if (((ContentCaptureManagerService)this.mMaster).debug) {
                Slog.d(TAG, "startSession(" + componentName + "): package or component not whitelisted");
            }
            ContentCaptureService.setClientState(clientReceiver, 516, null);
            ContentCaptureMetricsLogger.writeSessionEvent(sessionId, 3, 516, serviceComponentName, componentName, false);
            return;
        }
        ContentCaptureServerSession existingSession = this.mSessions.get(sessionId);
        if (existingSession != null) {
            Slog.w(TAG, "startSession(id=" + existingSession + ", token=" + activityToken + ": ignoring because it already exists for " + existingSession.mActivityToken);
            ContentCaptureService.setClientState(clientReceiver, 12, null);
            ContentCaptureMetricsLogger.writeSessionEvent(sessionId, 3, 12, serviceComponentName, componentName, false);
            return;
        }
        if (this.mRemoteService == null) {
            this.updateRemoteServiceLocked(false);
        }
        if (this.mRemoteService == null) {
            Slog.w(TAG, "startSession(id=" + existingSession + ", token=" + activityToken + ": ignoring because service is not set");
            ContentCaptureService.setClientState(clientReceiver, 20, null);
            ContentCaptureMetricsLogger.writeSessionEvent(sessionId, 3, 20, serviceComponentName, componentName, false);
            return;
        }
        this.mRemoteService.ensureBoundLocked();
        ContentCaptureServerSession newSession = new ContentCaptureServerSession(this.mLock, activityToken, this, componentName, clientReceiver, taskId, displayId, sessionId, uid, flags);
        if (((ContentCaptureManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "startSession(): new session for " + ComponentName.flattenToShortString(componentName) + " and id " + sessionId);
        }
        this.mSessions.put(sessionId, newSession);
        newSession.notifySessionStartedLocked(clientReceiver);
    }

    @GuardedBy(value={"mLock"})
    public void finishSessionLocked(int sessionId) {
        if (!this.isEnabledLocked()) {
            return;
        }
        ContentCaptureServerSession session = this.mSessions.get(sessionId);
        if (session == null) {
            if (((ContentCaptureManagerService)this.mMaster).debug) {
                Slog.d(TAG, "finishSession(): no session with id" + sessionId);
            }
            return;
        }
        if (((ContentCaptureManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "finishSession(): id=" + sessionId);
        }
        session.removeSelfLocked(true);
    }

    @GuardedBy(value={"mLock"})
    public void removeDataLocked(DataRemovalRequest request) {
        if (!this.isEnabledLocked()) {
            return;
        }
        this.assertCallerLocked(request.getPackageName());
        this.mRemoteService.onDataRemovalRequest(request);
    }

    @GuardedBy(value={"mLock"})
    public ComponentName getServiceSettingsActivityLocked() {
        if (this.mInfo == null) {
            return null;
        }
        String activityName = this.mInfo.getSettingsActivity();
        if (activityName == null) {
            return null;
        }
        String packageName = this.mInfo.getServiceInfo().packageName;
        return new ComponentName(packageName, activityName);
    }

    @GuardedBy(value={"mLock"})
    private void assertCallerLocked(String packageName) {
        int packageUid;
        PackageManager pm = this.getContext().getPackageManager();
        int callingUid = Binder.getCallingUid();
        try {
            packageUid = pm.getPackageUidAsUser(packageName, UserHandle.getCallingUserId());
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException("Could not verify UID for " + packageName);
        }
        if (callingUid != packageUid && !LocalServices.getService(ActivityManagerInternal.class).hasRunningActivity(callingUid, packageName)) {
            String[] packages = pm.getPackagesForUid(callingUid);
            String callingPackage = packages != null ? packages[0] : "uid-" + callingUid;
            Slog.w(TAG, "App (package=" + callingPackage + ", UID=" + callingUid + ") passed package (" + packageName + ") owned by UID " + packageUid);
            throw new SecurityException("Invalid package: " + packageName);
        }
    }

    @GuardedBy(value={"mLock"})
    public boolean sendActivityAssistDataLocked(IBinder activityToken, Bundle data) {
        int id2 = this.getSessionId(activityToken);
        if (id2 != 0) {
            ContentCaptureServerSession session = this.mSessions.get(id2);
            Bundle assistData = data.getBundle("data");
            AssistStructure assistStructure = (AssistStructure)data.getParcelable("structure");
            AssistContent assistContent = (AssistContent)data.getParcelable("content");
            SnapshotData snapshotData = new SnapshotData(assistData, assistStructure, assistContent);
            session.sendActivitySnapshotLocked(snapshotData);
            return true;
        }
        Slog.e(TAG, "Failed to notify activity assist data for activity: " + activityToken);
        return false;
    }

    @GuardedBy(value={"mLock"})
    public void removeSessionLocked(int sessionId) {
        this.mSessions.remove(sessionId);
    }

    @GuardedBy(value={"mLock"})
    public boolean isContentCaptureServiceForUserLocked(int uid) {
        return uid == this.getServiceUidLocked();
    }

    @GuardedBy(value={"mLock"})
    private ContentCaptureServerSession getSession(IBinder activityToken) {
        for (int i = 0; i < this.mSessions.size(); ++i) {
            ContentCaptureServerSession session = this.mSessions.valueAt(i);
            if (!session.mActivityToken.equals(activityToken)) continue;
            return session;
        }
        return null;
    }

    @GuardedBy(value={"mLock"})
    public void destroyLocked() {
        if (((ContentCaptureManagerService)this.mMaster).debug) {
            Slog.d(TAG, "destroyLocked()");
        }
        if (this.mRemoteService != null) {
            this.mRemoteService.destroy();
        }
        this.destroySessionsLocked();
    }

    @GuardedBy(value={"mLock"})
    void destroySessionsLocked() {
        int numSessions = this.mSessions.size();
        for (int i = 0; i < numSessions; ++i) {
            ContentCaptureServerSession session = this.mSessions.valueAt(i);
            session.destroyLocked(true);
        }
        this.mSessions.clear();
    }

    @GuardedBy(value={"mLock"})
    void listSessionsLocked(ArrayList<String> output) {
        int numSessions = this.mSessions.size();
        for (int i = 0; i < numSessions; ++i) {
            ContentCaptureServerSession session = this.mSessions.valueAt(i);
            output.add(session.toShortString());
        }
    }

    @GuardedBy(value={"mLock"})
    ArraySet<ContentCaptureCondition> getContentCaptureConditionsLocked(String packageName) {
        return this.mConditionsByPkg.get(packageName);
    }

    @GuardedBy(value={"mLock"})
    void onActivityEventLocked(ComponentName componentName, int type) {
        if (this.mRemoteService == null) {
            if (((ContentCaptureManagerService)this.mMaster).debug) {
                Slog.d(this.mTag, "onActivityEvent(): no remote service");
            }
            return;
        }
        ActivityEvent event = new ActivityEvent(componentName, type);
        if (((ContentCaptureManagerService)this.mMaster).verbose) {
            Slog.v(this.mTag, "onActivityEvent(): " + event);
        }
        this.mRemoteService.onActivityLifecycleEvent(event);
    }

    @Override
    protected void dumpLocked(String prefix, PrintWriter pw) {
        super.dumpLocked(prefix, pw);
        String prefix2 = prefix + "  ";
        pw.print(prefix);
        pw.print("Service Info: ");
        if (this.mInfo == null) {
            pw.println("N/A");
        } else {
            pw.println();
            this.mInfo.dump(prefix2, pw);
        }
        pw.print(prefix);
        pw.print("Zombie: ");
        pw.println(this.mZombie);
        if (this.mRemoteService != null) {
            pw.print(prefix);
            pw.println("remote service:");
            this.mRemoteService.dump(prefix2, pw);
        }
        if (this.mSessions.size() == 0) {
            pw.print(prefix);
            pw.println("no sessions");
        } else {
            int sessionsSize = this.mSessions.size();
            pw.print(prefix);
            pw.print("number sessions: ");
            pw.println(sessionsSize);
            for (int i = 0; i < sessionsSize; ++i) {
                pw.print(prefix);
                pw.print("#");
                pw.println(i);
                ContentCaptureServerSession session = this.mSessions.valueAt(i);
                session.dumpLocked(prefix2, pw);
                pw.println();
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private int getSessionId(IBinder activityToken) {
        for (int i = 0; i < this.mSessions.size(); ++i) {
            ContentCaptureServerSession session = this.mSessions.valueAt(i);
            if (!session.isActivitySession(activityToken)) continue;
            return this.mSessions.keyAt(i);
        }
        return 0;
    }

    @GuardedBy(value={"mLock"})
    private void resetContentCaptureWhitelistLocked() {
        if (((ContentCaptureManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "resetting content capture whitelist");
        }
        ((ContentCaptureManagerService)this.mMaster).mGlobalContentCaptureOptions.resetWhitelist(this.mUserId);
    }

    private final class ContentCaptureServiceRemoteCallback
    extends IContentCaptureServiceCallback.Stub {
        private ContentCaptureServiceRemoteCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setContentCaptureWhitelist(List<String> packages, List<ComponentName> activities) {
            int sessionId;
            if (((ContentCaptureManagerService)((ContentCapturePerUserService)ContentCapturePerUserService.this).mMaster).verbose) {
                Slog.v(TAG, "setContentCaptureWhitelist(" + (packages == null ? "null_packages" : packages.size() + " packages") + ", " + (activities == null ? "null_activities" : activities.size() + " activities") + ") for user " + ContentCapturePerUserService.this.mUserId);
            }
            ((ContentCaptureManagerService)((ContentCapturePerUserService)ContentCapturePerUserService.this).mMaster).mGlobalContentCaptureOptions.setWhitelist(ContentCapturePerUserService.this.mUserId, packages, activities);
            ContentCaptureMetricsLogger.writeSetWhitelistEvent(ContentCapturePerUserService.this.getServiceComponentName(), packages, activities);
            int numSessions = ContentCapturePerUserService.this.mSessions.size();
            if (numSessions <= 0) {
                return;
            }
            SparseBooleanArray blacklistedSessions = new SparseBooleanArray(numSessions);
            for (int i = 0; i < numSessions; ++i) {
                ContentCaptureServerSession session = (ContentCaptureServerSession)ContentCapturePerUserService.this.mSessions.valueAt(i);
                boolean whitelisted = ((ContentCaptureManagerService)((ContentCapturePerUserService)ContentCapturePerUserService.this).mMaster).mGlobalContentCaptureOptions.isWhitelisted(ContentCapturePerUserService.this.mUserId, session.appComponentName);
                if (whitelisted) continue;
                sessionId = ContentCapturePerUserService.this.mSessions.keyAt(i);
                if (((ContentCaptureManagerService)((ContentCapturePerUserService)ContentCapturePerUserService.this).mMaster).debug) {
                    Slog.d(TAG, "marking session " + sessionId + " (" + session.appComponentName + ") for un-whitelisting");
                }
                blacklistedSessions.append(sessionId, true);
            }
            int numBlacklisted = blacklistedSessions.size();
            if (numBlacklisted <= 0) {
                return;
            }
            Object object = ContentCapturePerUserService.this.mLock;
            synchronized (object) {
                for (int i = 0; i < numBlacklisted; ++i) {
                    sessionId = blacklistedSessions.keyAt(i);
                    if (((ContentCaptureManagerService)((ContentCapturePerUserService)ContentCapturePerUserService.this).mMaster).debug) {
                        Slog.d(TAG, "un-whitelisting " + sessionId);
                    }
                    ContentCaptureServerSession session = (ContentCaptureServerSession)ContentCapturePerUserService.this.mSessions.get(sessionId);
                    session.setContentCaptureEnabledLocked(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setContentCaptureConditions(String packageName, List<ContentCaptureCondition> conditions) {
            if (((ContentCaptureManagerService)((ContentCapturePerUserService)ContentCapturePerUserService.this).mMaster).verbose) {
                Slog.v(TAG, "setContentCaptureConditions(" + packageName + "): " + (conditions == null ? "null" : conditions.size() + " conditions"));
            }
            Object object = ContentCapturePerUserService.this.mLock;
            synchronized (object) {
                if (conditions == null) {
                    ContentCapturePerUserService.this.mConditionsByPkg.remove(packageName);
                } else {
                    ContentCapturePerUserService.this.mConditionsByPkg.put(packageName, new ArraySet<ContentCaptureCondition>(conditions));
                }
            }
        }

        @Override
        public void disableSelf() {
            if (((ContentCaptureManagerService)((ContentCapturePerUserService)ContentCapturePerUserService.this).mMaster).verbose) {
                Slog.v(TAG, "disableSelf()");
            }
            long token = Binder.clearCallingIdentity();
            try {
                Settings.Secure.putStringForUser(ContentCapturePerUserService.this.getContext().getContentResolver(), "content_capture_enabled", "0", ContentCapturePerUserService.this.mUserId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            ContentCaptureMetricsLogger.writeServiceEvent(4, ContentCapturePerUserService.this.getServiceComponentName());
        }

        @Override
        public void writeSessionFlush(int sessionId, ComponentName app, FlushMetrics flushMetrics, ContentCaptureOptions options, int flushReason) {
            ContentCaptureMetricsLogger.writeSessionFlush(sessionId, ContentCapturePerUserService.this.getServiceComponentName(), app, flushMetrics, options, flushReason);
        }
    }
}

