/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.contentcapture;

import android.content.ComponentName;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.contentcapture.ContentCaptureService;
import android.service.contentcapture.SnapshotData;
import android.util.LocalLog;
import android.util.Slog;
import android.view.contentcapture.ContentCaptureContext;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.IResultReceiver;
import com.android.internal.util.Preconditions;
import com.android.server.contentcapture.ContentCaptureManagerService;
import com.android.server.contentcapture.ContentCapturePerUserService;
import com.android.server.contentcapture.RemoteContentCaptureService;
import java.io.PrintWriter;

final class ContentCaptureServerSession {
    private static final String TAG = ContentCaptureServerSession.class.getSimpleName();
    final IBinder mActivityToken;
    private final ContentCapturePerUserService mService;
    private final ContentCaptureContext mContentCaptureContext;
    private final IResultReceiver mSessionStateReceiver;
    private final int mId;
    private final int mUid;
    private final Object mLock;
    public final ComponentName appComponentName;

    ContentCaptureServerSession(Object lock, IBinder activityToken, ContentCapturePerUserService service, ComponentName appComponentName, IResultReceiver sessionStateReceiver, int taskId, int displayId, int sessionId, int uid, int flags) {
        Preconditions.checkArgument(sessionId != 0);
        this.mLock = lock;
        this.mActivityToken = activityToken;
        this.appComponentName = appComponentName;
        this.mService = service;
        this.mId = sessionId;
        this.mUid = uid;
        this.mContentCaptureContext = new ContentCaptureContext(null, appComponentName, taskId, displayId, flags);
        this.mSessionStateReceiver = sessionStateReceiver;
        try {
            sessionStateReceiver.asBinder().linkToDeath(() -> this.onClientDeath(), 0);
        }
        catch (Exception e) {
            Slog.w(TAG, "could not register DeathRecipient for " + activityToken);
        }
    }

    boolean isActivitySession(IBinder activityToken) {
        return this.mActivityToken.equals(activityToken);
    }

    @GuardedBy(value={"mLock"})
    public void notifySessionStartedLocked(IResultReceiver clientReceiver) {
        if (this.mService.mRemoteService == null) {
            Slog.w(TAG, "notifySessionStartedLocked(): no remote service");
            return;
        }
        this.mService.mRemoteService.onSessionStarted(this.mContentCaptureContext, this.mId, this.mUid, clientReceiver, 2);
    }

    @GuardedBy(value={"mLock"})
    public void setContentCaptureEnabledLocked(boolean enabled) {
        try {
            Bundle extras = new Bundle();
            extras.putBoolean("enabled", true);
            this.mSessionStateReceiver.send(enabled ? 1 : 2, extras);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Error async reporting result to client: " + e);
        }
    }

    @GuardedBy(value={"mLock"})
    public void sendActivitySnapshotLocked(SnapshotData snapshotData) {
        LocalLog logHistory = ((ContentCaptureManagerService)this.mService.getMaster()).mRequestsHistory;
        if (logHistory != null) {
            logHistory.log("snapshot: id=" + this.mId);
        }
        if (this.mService.mRemoteService == null) {
            Slog.w(TAG, "sendActivitySnapshotLocked(): no remote service");
            return;
        }
        this.mService.mRemoteService.onActivitySnapshotRequest(this.mId, snapshotData);
    }

    @GuardedBy(value={"mLock"})
    public void removeSelfLocked(boolean notifyRemoteService) {
        try {
            this.destroyLocked(notifyRemoteService);
        }
        finally {
            this.mService.removeSessionLocked(this.mId);
        }
    }

    @GuardedBy(value={"mLock"})
    public void destroyLocked(boolean notifyRemoteService) {
        if (this.mService.isVerbose()) {
            Slog.v(TAG, "destroy(notifyRemoteService=" + notifyRemoteService + ")");
        }
        if (notifyRemoteService) {
            if (this.mService.mRemoteService == null) {
                Slog.w(TAG, "destroyLocked(): no remote service");
                return;
            }
            this.mService.mRemoteService.onSessionFinished(this.mId);
        }
    }

    @GuardedBy(value={"mLock"})
    public void resurrectLocked() {
        RemoteContentCaptureService remoteService = this.mService.mRemoteService;
        if (remoteService == null) {
            Slog.w(TAG, "destroyLocked(: no remote service");
            return;
        }
        if (this.mService.isVerbose()) {
            Slog.v(TAG, "resurrecting " + this.mActivityToken + " on " + remoteService);
        }
        remoteService.onSessionStarted(new ContentCaptureContext(this.mContentCaptureContext, 4), this.mId, this.mUid, this.mSessionStateReceiver, 4098);
    }

    @GuardedBy(value={"mLock"})
    public void pauseLocked() {
        if (this.mService.isVerbose()) {
            Slog.v(TAG, "pausing " + this.mActivityToken);
        }
        ContentCaptureService.setClientState(this.mSessionStateReceiver, 2052, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClientDeath() {
        if (this.mService.isVerbose()) {
            Slog.v(TAG, "onClientDeath(" + this.mActivityToken + "): removing session " + this.mId);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.removeSelfLocked(true);
        }
    }

    @GuardedBy(value={"mLock"})
    public void dumpLocked(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("id: ");
        pw.print(this.mId);
        pw.println();
        pw.print(prefix);
        pw.print("uid: ");
        pw.print(this.mUid);
        pw.println();
        pw.print(prefix);
        pw.print("context: ");
        this.mContentCaptureContext.dump(pw);
        pw.println();
        pw.print(prefix);
        pw.print("activity token: ");
        pw.println(this.mActivityToken);
        pw.print(prefix);
        pw.print("app component: ");
        pw.println(this.appComponentName);
        pw.print(prefix);
        pw.print("has autofill callback: ");
    }

    String toShortString() {
        return this.mId + ":" + this.mActivityToken;
    }

    public String toString() {
        return "ContentCaptureSession[id=" + this.mId + ", act=" + this.mActivityToken + "]";
    }
}

