/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.contentcapture;

import android.content.ComponentName;
import android.content.Context;
import android.os.IBinder;
import android.service.contentcapture.ActivityEvent;
import android.service.contentcapture.IContentCaptureService;
import android.service.contentcapture.IContentCaptureServiceCallback;
import android.service.contentcapture.SnapshotData;
import android.util.Slog;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.DataRemovalRequest;
import com.android.internal.infra.AbstractMultiplePendingRequestsRemoteService;
import com.android.internal.infra.AbstractRemoteService;
import com.android.internal.os.IResultReceiver;
import com.android.server.contentcapture.ContentCaptureMetricsLogger;
import com.android.server.contentcapture.ContentCapturePerUserService;

final class RemoteContentCaptureService
extends AbstractMultiplePendingRequestsRemoteService<RemoteContentCaptureService, IContentCaptureService> {
    private final IBinder mServerCallback;
    private final int mIdleUnbindTimeoutMs;
    private final ContentCapturePerUserService mPerUserService;

    RemoteContentCaptureService(Context context, String serviceInterface, ComponentName serviceComponentName, IContentCaptureServiceCallback callback, int userId, ContentCapturePerUserService perUserService, boolean bindInstantServiceAllowed, boolean verbose, int idleUnbindTimeoutMs) {
        super(context, serviceInterface, serviceComponentName, userId, perUserService, context.getMainThreadHandler(), bindInstantServiceAllowed ? 0x400000 : 0, verbose, 2);
        this.mPerUserService = perUserService;
        this.mServerCallback = callback.asBinder();
        this.mIdleUnbindTimeoutMs = idleUnbindTimeoutMs;
        this.ensureBoundLocked();
    }

    @Override
    protected IContentCaptureService getServiceInterface(IBinder service) {
        return IContentCaptureService.Stub.asInterface(service);
    }

    @Override
    protected long getTimeoutIdleBindMillis() {
        return this.mIdleUnbindTimeoutMs;
    }

    @Override
    protected void handleOnConnectedStateChanged(boolean connected) {
        block7: {
            if (connected && this.getTimeoutIdleBindMillis() != 0L) {
                this.scheduleUnbind();
            }
            try {
                if (connected) {
                    try {
                        ((IContentCaptureService)this.mService).onConnected(this.mServerCallback, ContentCaptureHelper.sVerbose, ContentCaptureHelper.sDebug);
                        ContentCaptureMetricsLogger.writeServiceEvent(1, this.mComponentName);
                        break block7;
                    }
                    finally {
                        this.mPerUserService.onConnected();
                    }
                }
                ((IContentCaptureService)this.mService).onDisconnected();
                ContentCaptureMetricsLogger.writeServiceEvent(2, this.mComponentName);
            }
            catch (Exception e) {
                Slog.w(this.mTag, "Exception calling onConnectedStateChanged(" + connected + "): " + e);
            }
        }
    }

    public void ensureBoundLocked() {
        this.scheduleBind();
    }

    public void onSessionStarted(ContentCaptureContext context, int sessionId, int uid, IResultReceiver clientReceiver, int initialState) {
        this.scheduleAsyncRequest(s -> s.onSessionStarted(context, sessionId, uid, clientReceiver, initialState));
        ContentCaptureMetricsLogger.writeSessionEvent(sessionId, 1, initialState, this.getComponentName(), context.getActivityComponent(), false);
    }

    public void onSessionFinished(int sessionId) {
        this.scheduleAsyncRequest(s -> s.onSessionFinished(sessionId));
        ContentCaptureMetricsLogger.writeSessionEvent(sessionId, 2, 0, this.getComponentName(), null, false);
    }

    public void onActivitySnapshotRequest(int sessionId, SnapshotData snapshotData) {
        this.scheduleAsyncRequest(s -> s.onActivitySnapshot(sessionId, snapshotData));
    }

    public void onDataRemovalRequest(DataRemovalRequest request) {
        this.scheduleAsyncRequest(s -> s.onDataRemovalRequest(request));
        ContentCaptureMetricsLogger.writeServiceEvent(5, this.mComponentName);
    }

    public void onActivityLifecycleEvent(ActivityEvent event) {
        this.scheduleAsyncRequest(s -> s.onActivityEvent(event));
    }

    public static interface ContentCaptureServiceCallbacks
    extends AbstractRemoteService.VultureCallback<RemoteContentCaptureService> {
    }
}

