/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.contentsuggestions;

import android.app.contentsuggestions.ClassificationsRequest;
import android.app.contentsuggestions.IClassificationsCallback;
import android.app.contentsuggestions.IContentSuggestionsManager;
import android.app.contentsuggestions.ISelectionsCallback;
import android.app.contentsuggestions.SelectionsRequest;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.os.IResultReceiver;
import com.android.server.LocalServices;
import com.android.server.contentsuggestions.ContentSuggestionsManagerServiceShellCommand;
import com.android.server.contentsuggestions.ContentSuggestionsPerUserService;
import com.android.server.infra.AbstractMasterSystemService;
import com.android.server.infra.FrameworkResourcesServiceNameResolver;
import com.android.server.wm.ActivityTaskManagerInternal;
import java.io.FileDescriptor;

public class ContentSuggestionsManagerService
extends AbstractMasterSystemService<ContentSuggestionsManagerService, ContentSuggestionsPerUserService> {
    private static final String TAG = ContentSuggestionsManagerService.class.getSimpleName();
    private static final boolean VERBOSE = false;
    private static final int MAX_TEMP_SERVICE_DURATION_MS = 120000;
    private ActivityTaskManagerInternal mActivityTaskManagerInternal = LocalServices.getService(ActivityTaskManagerInternal.class);

    public ContentSuggestionsManagerService(Context context) {
        super(context, new FrameworkResourcesServiceNameResolver(context, 17039702), "no_content_suggestions");
    }

    @Override
    protected ContentSuggestionsPerUserService newServiceLocked(int resolvedUserId, boolean disabled) {
        return new ContentSuggestionsPerUserService(this, this.mLock, resolvedUserId);
    }

    @Override
    public void onStart() {
        this.publishBinderService("content_suggestions", new ContentSuggestionsManagerStub());
    }

    @Override
    protected void enforceCallingPermissionForManagement() {
        this.getContext().enforceCallingPermission("android.permission.MANAGE_CONTENT_SUGGESTIONS", TAG);
    }

    @Override
    protected int getMaximumTemporaryServiceDurationMs() {
        return 120000;
    }

    private void enforceCaller(int userId, String func) {
        Context ctx = this.getContext();
        if (ctx.checkCallingPermission("android.permission.BIND_CONTENT_SUGGESTIONS_SERVICE") == 0 || this.mServiceNameResolver.isTemporary(userId) || this.mActivityTaskManagerInternal.isCallerRecents(Binder.getCallingUid())) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " expected caller is recents";
        Slog.w(TAG, msg);
        throw new SecurityException(msg);
    }

    private class ContentSuggestionsManagerStub
    extends IContentSuggestionsManager.Stub {
        private ContentSuggestionsManagerStub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void provideContextImage(int userId, int taskId, Bundle imageContextRequestExtras) {
            if (imageContextRequestExtras == null) {
                throw new IllegalArgumentException("Expected non-null imageContextRequestExtras");
            }
            ContentSuggestionsManagerService.this.enforceCaller(UserHandle.getCallingUserId(), "provideContextImage");
            Object object = ContentSuggestionsManagerService.this.mLock;
            synchronized (object) {
                ContentSuggestionsPerUserService service = (ContentSuggestionsPerUserService)ContentSuggestionsManagerService.this.getServiceForUserLocked(userId);
                if (service != null) {
                    service.provideContextImageLocked(taskId, imageContextRequestExtras);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void suggestContentSelections(int userId, SelectionsRequest selectionsRequest, ISelectionsCallback selectionsCallback) {
            ContentSuggestionsManagerService.this.enforceCaller(UserHandle.getCallingUserId(), "suggestContentSelections");
            Object object = ContentSuggestionsManagerService.this.mLock;
            synchronized (object) {
                ContentSuggestionsPerUserService service = (ContentSuggestionsPerUserService)ContentSuggestionsManagerService.this.getServiceForUserLocked(userId);
                if (service != null) {
                    service.suggestContentSelectionsLocked(selectionsRequest, selectionsCallback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void classifyContentSelections(int userId, ClassificationsRequest classificationsRequest, IClassificationsCallback callback) {
            ContentSuggestionsManagerService.this.enforceCaller(UserHandle.getCallingUserId(), "classifyContentSelections");
            Object object = ContentSuggestionsManagerService.this.mLock;
            synchronized (object) {
                ContentSuggestionsPerUserService service = (ContentSuggestionsPerUserService)ContentSuggestionsManagerService.this.getServiceForUserLocked(userId);
                if (service != null) {
                    service.classifyContentSelectionsLocked(classificationsRequest, callback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyInteraction(int userId, String requestId, Bundle bundle) {
            ContentSuggestionsManagerService.this.enforceCaller(UserHandle.getCallingUserId(), "notifyInteraction");
            Object object = ContentSuggestionsManagerService.this.mLock;
            synchronized (object) {
                ContentSuggestionsPerUserService service = (ContentSuggestionsPerUserService)ContentSuggestionsManagerService.this.getServiceForUserLocked(userId);
                if (service != null) {
                    service.notifyInteractionLocked(requestId, bundle);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void isEnabled(int userId, IResultReceiver receiver) throws RemoteException {
            boolean isDisabled;
            ContentSuggestionsManagerService.this.enforceCaller(UserHandle.getCallingUserId(), "isEnabled");
            Object object = ContentSuggestionsManagerService.this.mLock;
            synchronized (object) {
                isDisabled = ContentSuggestionsManagerService.this.isDisabledLocked(userId);
            }
            receiver.send(isDisabled ? 0 : 1, null);
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
            int callingUid = Binder.getCallingUid();
            if (callingUid != 2000 && callingUid != 0) {
                Slog.e(TAG, "Expected shell caller");
                return;
            }
            new ContentSuggestionsManagerServiceShellCommand(ContentSuggestionsManagerService.this).exec(this, in, out, err, args, callback, resultReceiver);
        }
    }
}

