/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.contentsuggestions;

import android.os.ShellCommand;
import com.android.server.contentsuggestions.ContentSuggestionsManagerService;
import java.io.PrintWriter;

public class ContentSuggestionsManagerServiceShellCommand
extends ShellCommand {
    private static final String TAG = ContentSuggestionsManagerServiceShellCommand.class.getSimpleName();
    private final ContentSuggestionsManagerService mService;

    public ContentSuggestionsManagerServiceShellCommand(ContentSuggestionsManagerService service) {
        this.mService = service;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        switch (cmd) {
            case "set": {
                return this.requestSet(pw);
            }
            case "get": {
                return this.requestGet(pw);
            }
        }
        return this.handleDefaultCommands(cmd);
    }

    @Override
    public void onHelp() {
        try (PrintWriter pw = this.getOutPrintWriter();){
            pw.println("ContentSuggestionsManagerService commands:");
            pw.println("  help");
            pw.println("    Prints this help text.");
            pw.println("");
            pw.println("  set temporary-service USER_ID [COMPONENT_NAME DURATION]");
            pw.println("    Temporarily (for DURATION ms) changes the service implementation.");
            pw.println("    To reset, call with just the USER_ID argument.");
            pw.println("");
            pw.println("  set default-service-enabled USER_ID [true|false]");
            pw.println("    Enable / disable the default service for the user.");
            pw.println("");
            pw.println("  get default-service-enabled USER_ID");
            pw.println("    Checks whether the default service is enabled for the user.");
            pw.println("");
        }
    }

    private int requestSet(PrintWriter pw) {
        String what;
        switch (what = this.getNextArgRequired()) {
            case "temporary-service": {
                return this.setTemporaryService(pw);
            }
            case "default-service-enabled": {
                return this.setDefaultServiceEnabled();
            }
        }
        pw.println("Invalid set: " + what);
        return -1;
    }

    private int requestGet(PrintWriter pw) {
        String what;
        switch (what = this.getNextArgRequired()) {
            case "default-service-enabled": {
                return this.getDefaultServiceEnabled(pw);
            }
        }
        pw.println("Invalid get: " + what);
        return -1;
    }

    private int setTemporaryService(PrintWriter pw) {
        int userId = Integer.parseInt(this.getNextArgRequired());
        String serviceName = this.getNextArg();
        if (serviceName == null) {
            this.mService.resetTemporaryService(userId);
            return 0;
        }
        int duration = Integer.parseInt(this.getNextArgRequired());
        this.mService.setTemporaryService(userId, serviceName, duration);
        pw.println("ContentSuggestionsService temporarily set to " + serviceName + " for " + duration + "ms");
        return 0;
    }

    private int setDefaultServiceEnabled() {
        int userId = this.getNextIntArgRequired();
        boolean enabled = Boolean.parseBoolean(this.getNextArg());
        this.mService.setDefaultServiceEnabled(userId, enabled);
        return 0;
    }

    private int getDefaultServiceEnabled(PrintWriter pw) {
        int userId = this.getNextIntArgRequired();
        boolean enabled = this.mService.isDefaultServiceEnabled(userId);
        pw.println(enabled);
        return 0;
    }

    private int getNextIntArgRequired() {
        return Integer.parseInt(this.getNextArgRequired());
    }
}

