/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.contentsuggestions;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.contentsuggestions.ClassificationsRequest;
import android.app.contentsuggestions.IClassificationsCallback;
import android.app.contentsuggestions.ISelectionsCallback;
import android.app.contentsuggestions.SelectionsRequest;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.LocalServices;
import com.android.server.contentsuggestions.ContentSuggestionsManagerService;
import com.android.server.contentsuggestions.RemoteContentSuggestionsService;
import com.android.server.infra.AbstractPerUserSystemService;
import com.android.server.wm.ActivityTaskManagerInternal;

public final class ContentSuggestionsPerUserService
extends AbstractPerUserSystemService<ContentSuggestionsPerUserService, ContentSuggestionsManagerService> {
    private static final String TAG = ContentSuggestionsPerUserService.class.getSimpleName();
    @GuardedBy(value={"mLock"})
    private RemoteContentSuggestionsService mRemoteService;
    private final ActivityTaskManagerInternal mActivityTaskManagerInternal = LocalServices.getService(ActivityTaskManagerInternal.class);

    ContentSuggestionsPerUserService(ContentSuggestionsManagerService master, Object lock, int userId) {
        super(master, lock, userId);
    }

    @Override
    @GuardedBy(value={"mLock"})
    protected ServiceInfo newServiceInfoLocked(ComponentName serviceComponent) throws PackageManager.NameNotFoundException {
        ServiceInfo si;
        try {
            si = AppGlobals.getPackageManager().getServiceInfo(serviceComponent, 128, this.mUserId);
        }
        catch (RemoteException e) {
            throw new PackageManager.NameNotFoundException("Could not get service for " + serviceComponent);
        }
        if (!"android.permission.BIND_CONTENT_SUGGESTIONS_SERVICE".equals(si.permission)) {
            Slog.w(TAG, "ContentSuggestionsService from '" + si.packageName + "' does not require permission " + "android.permission.BIND_CONTENT_SUGGESTIONS_SERVICE");
            throw new SecurityException("Service does not require permission android.permission.BIND_CONTENT_SUGGESTIONS_SERVICE");
        }
        return si;
    }

    @Override
    @GuardedBy(value={"mLock"})
    protected boolean updateLocked(boolean disabled) {
        boolean enabledChanged = super.updateLocked(disabled);
        this.updateRemoteServiceLocked();
        return enabledChanged;
    }

    @GuardedBy(value={"mLock"})
    void provideContextImageLocked(int taskId, Bundle imageContextRequestExtras) {
        RemoteContentSuggestionsService service = this.ensureRemoteServiceLocked();
        if (service != null) {
            ActivityManager.TaskSnapshot snapshot = this.mActivityTaskManagerInternal.getTaskSnapshotNoRestore(taskId, false);
            GraphicBuffer snapshotBuffer = null;
            int colorSpaceId = 0;
            if (snapshot != null) {
                snapshotBuffer = snapshot.getSnapshot();
                ColorSpace colorSpace = snapshot.getColorSpace();
                if (colorSpace != null) {
                    colorSpaceId = colorSpace.getId();
                }
            }
            service.provideContextImage(taskId, snapshotBuffer, colorSpaceId, imageContextRequestExtras);
        }
    }

    @GuardedBy(value={"mLock"})
    void suggestContentSelectionsLocked(SelectionsRequest selectionsRequest, ISelectionsCallback selectionsCallback) {
        RemoteContentSuggestionsService service = this.ensureRemoteServiceLocked();
        if (service != null) {
            service.suggestContentSelections(selectionsRequest, selectionsCallback);
        }
    }

    @GuardedBy(value={"mLock"})
    void classifyContentSelectionsLocked(ClassificationsRequest classificationsRequest, IClassificationsCallback callback) {
        RemoteContentSuggestionsService service = this.ensureRemoteServiceLocked();
        if (service != null) {
            service.classifyContentSelections(classificationsRequest, callback);
        }
    }

    @GuardedBy(value={"mLock"})
    void notifyInteractionLocked(String requestId, Bundle bundle) {
        RemoteContentSuggestionsService service = this.ensureRemoteServiceLocked();
        if (service != null) {
            service.notifyInteraction(requestId, bundle);
        }
    }

    @GuardedBy(value={"mLock"})
    private void updateRemoteServiceLocked() {
        if (this.mRemoteService != null) {
            this.mRemoteService.destroy();
            this.mRemoteService = null;
        }
    }

    @GuardedBy(value={"mLock"})
    private RemoteContentSuggestionsService ensureRemoteServiceLocked() {
        if (this.mRemoteService == null) {
            String serviceName = this.getComponentNameLocked();
            if (serviceName == null) {
                if (((ContentSuggestionsManagerService)this.mMaster).verbose) {
                    Slog.v(TAG, "ensureRemoteServiceLocked(): not set");
                }
                return null;
            }
            ComponentName serviceComponent = ComponentName.unflattenFromString(serviceName);
            this.mRemoteService = new RemoteContentSuggestionsService(this.getContext(), serviceComponent, this.mUserId, new RemoteContentSuggestionsService.Callbacks(){

                @Override
                public void onServiceDied(RemoteContentSuggestionsService service) {
                    Slog.w(TAG, "remote content suggestions service died");
                    ContentSuggestionsPerUserService.this.updateRemoteServiceLocked();
                }
            }, ((ContentSuggestionsManagerService)this.mMaster).isBindInstantServiceAllowed(), ((ContentSuggestionsManagerService)this.mMaster).verbose);
        }
        return this.mRemoteService;
    }
}

