/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.deviceidle;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.DeviceIdleController;
import com.android.server.deviceidle.IDeviceIdleConstraint;

public class BluetoothConstraint
implements IDeviceIdleConstraint {
    private static final String TAG = BluetoothConstraint.class.getSimpleName();
    private static final long INACTIVITY_TIMEOUT_MS = 1200000L;
    private final Context mContext;
    private final Handler mHandler;
    private final DeviceIdleController.LocalService mLocalService;
    private final BluetoothManager mBluetoothManager;
    private volatile boolean mConnected = true;
    private volatile boolean mMonitoring = false;
    @VisibleForTesting
    final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.bluetooth.device.action.ACL_CONNECTED".equals(intent.getAction())) {
                BluetoothConstraint.this.mLocalService.exitIdle("bluetooth");
            } else {
                BluetoothConstraint.this.updateAndReportActiveLocked();
            }
        }
    };
    private final Runnable mTimeoutCallback = () -> this.cancelMonitoringDueToTimeout();

    public BluetoothConstraint(Context context, Handler handler, DeviceIdleController.LocalService localService) {
        this.mContext = context;
        this.mHandler = handler;
        this.mLocalService = localService;
        this.mBluetoothManager = this.mContext.getSystemService(BluetoothManager.class);
    }

    @Override
    public synchronized void startMonitoring() {
        this.mConnected = true;
        this.mMonitoring = true;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.mHandler.sendMessageDelayed(Message.obtain(this.mHandler, this.mTimeoutCallback), 1200000L);
        this.updateAndReportActiveLocked();
    }

    @Override
    public synchronized void stopMonitoring() {
        this.mContext.unregisterReceiver(this.mReceiver);
        this.mHandler.removeCallbacks(this.mTimeoutCallback);
        this.mMonitoring = false;
    }

    private synchronized void cancelMonitoringDueToTimeout() {
        if (this.mMonitoring) {
            this.mMonitoring = false;
            this.mLocalService.onConstraintStateChanged(this, false);
        }
    }

    @GuardedBy(value={"this"})
    private void updateAndReportActiveLocked() {
        boolean connected = BluetoothConstraint.isBluetoothConnected(this.mBluetoothManager);
        if (connected != this.mConnected) {
            this.mConnected = connected;
            this.mLocalService.onConstraintStateChanged(this, this.mConnected);
        }
    }

    @VisibleForTesting
    static boolean isBluetoothConnected(BluetoothManager bluetoothManager) {
        BluetoothAdapter adapter = bluetoothManager.getAdapter();
        if (adapter != null && adapter.isEnabled()) {
            return bluetoothManager.getConnectedDevices(7).size() > 0;
        }
        return false;
    }
}

