/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.deviceidle;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import com.android.server.DeviceIdleController;
import com.android.server.LocalServices;
import com.android.server.deviceidle.BluetoothConstraint;
import com.android.server.deviceidle.ConstraintController;

public class TvConstraintController
implements ConstraintController {
    private final Context mContext;
    private final Handler mHandler;
    private final DeviceIdleController.LocalService mDeviceIdleService;
    private final BluetoothConstraint mBluetoothConstraint;

    public TvConstraintController(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
        this.mDeviceIdleService = LocalServices.getService(DeviceIdleController.LocalService.class);
        PackageManager pm = context.getPackageManager();
        this.mBluetoothConstraint = pm.hasSystemFeature("android.hardware.bluetooth") ? new BluetoothConstraint(this.mContext, this.mHandler, this.mDeviceIdleService) : null;
    }

    @Override
    public void start() {
        if (this.mBluetoothConstraint != null) {
            this.mDeviceIdleService.registerDeviceIdleConstraint(this.mBluetoothConstraint, "bluetooth", 1);
        }
    }

    @Override
    public void stop() {
        if (this.mBluetoothConstraint != null) {
            this.mDeviceIdleService.unregisterDeviceIdleConstraint(this.mBluetoothConstraint);
        }
    }
}

