/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.admin.StartInstallingUpdateCallback;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.os.UpdateEngine;
import android.os.UpdateEngineCallback;
import android.util.Log;
import com.android.server.devicepolicy.DevicePolicyConstants;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import com.android.server.devicepolicy.UpdateInstaller;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

class AbUpdateInstaller
extends UpdateInstaller {
    private static final String PAYLOAD_BIN = "payload.bin";
    private static final String PAYLOAD_PROPERTIES_TXT = "payload_properties.txt";
    private static final int OFFSET_TO_FILE_NAME = 30;
    private static final int DOWNLOAD_STATE_INITIALIZATION_ERROR = 20;
    private long mSizeForUpdate;
    private long mOffsetForUpdate;
    private List<String> mProperties;
    private Enumeration<? extends ZipEntry> mEntries;
    private ZipFile mPackedUpdateFile;
    private static final Map<Integer, Integer> errorCodesMap = AbUpdateInstaller.buildErrorCodesMap();
    private static final Map<Integer, String> errorStringsMap = AbUpdateInstaller.buildErrorStringsMap();
    public static final String UNKNOWN_ERROR = "Unknown error with error code = ";
    private boolean mUpdateInstalled = false;

    private static Map<Integer, Integer> buildErrorCodesMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 1);
        map.put(20, 2);
        map.put(51, 2);
        map.put(12, 3);
        map.put(11, 3);
        map.put(6, 3);
        map.put(10, 3);
        map.put(26, 3);
        map.put(5, 1);
        map.put(7, 1);
        map.put(9, 1);
        map.put(52, 1);
        return map;
    }

    private static Map<Integer, String> buildErrorStringsMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, UNKNOWN_ERROR);
        map.put(20, "The delta update payload was targeted for another version or the source partitionwas modified after it was installed");
        map.put(5, "Failed to finish the configured postinstall works.");
        map.put(7, "Failed to open one of the partitions it tried to write to or read data from.");
        map.put(6, "Payload mismatch error.");
        map.put(9, "Failed to read the payload data from the given URL.");
        map.put(10, "Payload hash error.");
        map.put(11, "Payload size mismatch error.");
        map.put(12, "Failed to verify the signature of the payload.");
        map.put(52, "The payload has been successfully installed,but the active slot was not flipped.");
        return map;
    }

    AbUpdateInstaller(Context context, ParcelFileDescriptor updateFileDescriptor, StartInstallingUpdateCallback callback, DevicePolicyManagerService.Injector injector, DevicePolicyConstants constants) {
        super(context, updateFileDescriptor, callback, injector, constants);
    }

    @Override
    public void installUpdateInThread() {
        if (this.mUpdateInstalled) {
            throw new IllegalStateException("installUpdateInThread can be called only once.");
        }
        try {
            this.setState();
            this.applyPayload(Paths.get(this.mCopiedUpdateFile.getAbsolutePath(), new String[0]).toUri().toString());
        }
        catch (ZipException e) {
            Log.w("UpdateInstaller", e);
            this.notifyCallbackOnError(3, Log.getStackTraceString(e));
        }
        catch (IOException e) {
            Log.w("UpdateInstaller", e);
            this.notifyCallbackOnError(1, Log.getStackTraceString(e));
        }
    }

    private void setState() throws IOException {
        this.mUpdateInstalled = true;
        this.mPackedUpdateFile = new ZipFile(this.mCopiedUpdateFile);
        this.mProperties = new ArrayList<String>();
        this.mSizeForUpdate = -1L;
        this.mOffsetForUpdate = 0L;
        this.mEntries = this.mPackedUpdateFile.entries();
    }

    private UpdateEngine buildBoundUpdateEngine() {
        UpdateEngine updateEngine = new UpdateEngine();
        updateEngine.bind(new DelegatingUpdateEngineCallback(this, updateEngine));
        return updateEngine;
    }

    private void applyPayload(String updatePath) throws IOException {
        if (!this.updateStateForPayload()) {
            return;
        }
        String[] headerKeyValuePairs = (String[])this.mProperties.stream().toArray(String[]::new);
        if (this.mSizeForUpdate == -1L) {
            Log.w("UpdateInstaller", "Failed to find payload entry in the given package.");
            this.notifyCallbackOnError(3, "Failed to find payload entry in the given package.");
            return;
        }
        UpdateEngine updateEngine = this.buildBoundUpdateEngine();
        try {
            updateEngine.applyPayload(updatePath, this.mOffsetForUpdate, this.mSizeForUpdate, headerKeyValuePairs);
        }
        catch (Exception e) {
            Log.w("UpdateInstaller", "Failed to install update from file.", e);
            this.notifyCallbackOnError(1, "Failed to install update from file.");
        }
    }

    private boolean updateStateForPayload() throws IOException {
        long offset = 0L;
        while (this.mEntries.hasMoreElements()) {
            ZipEntry entry = this.mEntries.nextElement();
            String name = entry.getName();
            offset += this.buildOffsetForEntry(entry, name);
            if (entry.isDirectory()) {
                offset -= entry.getCompressedSize();
                continue;
            }
            if (PAYLOAD_BIN.equals(name)) {
                if (entry.getMethod() != 0) {
                    Log.w("UpdateInstaller", "Invalid compression method.");
                    this.notifyCallbackOnError(3, "Invalid compression method.");
                    return false;
                }
                this.mSizeForUpdate = entry.getCompressedSize();
                this.mOffsetForUpdate = offset - entry.getCompressedSize();
                continue;
            }
            if (!PAYLOAD_PROPERTIES_TXT.equals(name)) continue;
            this.updatePropertiesForEntry(entry);
        }
        return true;
    }

    private long buildOffsetForEntry(ZipEntry entry, String name) {
        return (long)(30 + name.length()) + entry.getCompressedSize() + (long)(entry.getExtra() == null ? 0 : entry.getExtra().length);
    }

    private void updatePropertiesForEntry(ZipEntry entry) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.mPackedUpdateFile.getInputStream(entry)));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                this.mProperties.add(line);
            }
        }
    }

    private static class DelegatingUpdateEngineCallback
    extends UpdateEngineCallback {
        private UpdateInstaller mUpdateInstaller;
        private UpdateEngine mUpdateEngine;

        DelegatingUpdateEngineCallback(UpdateInstaller updateInstaller, UpdateEngine updateEngine) {
            this.mUpdateInstaller = updateInstaller;
            this.mUpdateEngine = updateEngine;
        }

        @Override
        public void onStatusUpdate(int statusCode, float percentage) {
        }

        @Override
        public void onPayloadApplicationComplete(int errorCode) {
            this.mUpdateEngine.unbind();
            if (errorCode == 0) {
                this.mUpdateInstaller.notifyCallbackOnSuccess();
            } else {
                this.mUpdateInstaller.notifyCallbackOnError(errorCodesMap.getOrDefault(errorCode, 1), errorStringsMap.getOrDefault(errorCode, AbUpdateInstaller.UNKNOWN_ERROR + errorCode));
            }
        }
    }
}

