/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.admin.DeviceAdminService;
import android.app.admin.IDeviceAdminService;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.IBinder;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.server.am.PersistentConnection;
import com.android.server.appbinding.AppBindingUtils;
import com.android.server.devicepolicy.DevicePolicyConstants;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import java.io.PrintWriter;

public class DeviceAdminServiceController {
    static final String TAG = "DevicePolicyManager";
    static final boolean DEBUG = false;
    final Object mLock = new Object();
    final Context mContext;
    private final DevicePolicyManagerService mService;
    private final DevicePolicyManagerService.Injector mInjector;
    private final DevicePolicyConstants mConstants;
    private final Handler mHandler;
    @GuardedBy(value={"mLock"})
    private final SparseArray<DevicePolicyServiceConnection> mConnections = new SparseArray();

    static void debug(String format, Object ... args) {
    }

    public DeviceAdminServiceController(DevicePolicyManagerService service, DevicePolicyConstants constants) {
        this.mService = service;
        this.mInjector = service.mInjector;
        this.mContext = this.mInjector.mContext;
        this.mHandler = new Handler(BackgroundThread.get().getLooper());
        this.mConstants = constants;
    }

    private ServiceInfo findService(String packageName, int userId) {
        return AppBindingUtils.findService(packageName, userId, "android.app.action.DEVICE_ADMIN_SERVICE", "android.permission.BIND_DEVICE_ADMIN", DeviceAdminService.class, this.mInjector.getIPackageManager(), new StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServiceForOwner(String packageName, int userId, String actionForLog) {
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                ServiceInfo service;
                block9: {
                    service = this.findService(packageName, userId);
                    if (service != null) break block9;
                    DeviceAdminServiceController.debug("Owner package %s on u%d has no service.", packageName, userId);
                    this.disconnectServiceOnUserLocked(userId, actionForLog);
                    return;
                }
                PersistentConnection existing = this.mConnections.get(userId);
                if (existing != null) {
                    DeviceAdminServiceController.debug("Disconnecting from existing service connection.", packageName, userId);
                    this.disconnectServiceOnUserLocked(userId, actionForLog);
                }
                DeviceAdminServiceController.debug("Owner package %s on u%d has service %s for %s", packageName, userId, service.getComponentName().flattenToShortString(), actionForLog);
                DevicePolicyServiceConnection conn = new DevicePolicyServiceConnection(userId, service.getComponentName());
                this.mConnections.put(userId, conn);
                conn.bind();
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServiceForOwner(int userId, String actionForLog) {
        long token = this.mInjector.binderClearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.disconnectServiceOnUserLocked(userId, actionForLog);
            }
        }
        finally {
            this.mInjector.binderRestoreCallingIdentity(token);
        }
    }

    @GuardedBy(value={"mLock"})
    private void disconnectServiceOnUserLocked(int userId, String actionForLog) {
        DevicePolicyServiceConnection conn = this.mConnections.get(userId);
        if (conn != null) {
            DeviceAdminServiceController.debug("Stopping service for u%d if already running for %s.", userId, actionForLog);
            conn.unbind();
            this.mConnections.remove(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnections.size() == 0) {
                return;
            }
            pw.println();
            pw.print(prefix);
            pw.println("Owner Services:");
            for (int i = 0; i < this.mConnections.size(); ++i) {
                int userId = this.mConnections.keyAt(i);
                pw.print(prefix);
                pw.print("  ");
                pw.print("User: ");
                pw.println(userId);
                DevicePolicyServiceConnection con = this.mConnections.valueAt(i);
                con.dump(prefix + "    ", pw);
            }
            pw.println();
        }
    }

    private class DevicePolicyServiceConnection
    extends PersistentConnection<IDeviceAdminService> {
        public DevicePolicyServiceConnection(int userId, ComponentName componentName) {
            super(DeviceAdminServiceController.TAG, DeviceAdminServiceController.this.mContext, DeviceAdminServiceController.this.mHandler, userId, componentName, ((DeviceAdminServiceController)DeviceAdminServiceController.this).mConstants.DAS_DIED_SERVICE_RECONNECT_BACKOFF_SEC, ((DeviceAdminServiceController)DeviceAdminServiceController.this).mConstants.DAS_DIED_SERVICE_RECONNECT_BACKOFF_INCREASE, ((DeviceAdminServiceController)DeviceAdminServiceController.this).mConstants.DAS_DIED_SERVICE_RECONNECT_MAX_BACKOFF_SEC, ((DeviceAdminServiceController)DeviceAdminServiceController.this).mConstants.DAS_DIED_SERVICE_STABLE_CONNECTION_THRESHOLD_SEC);
        }

        @Override
        protected int getBindFlags() {
            return 0x4000000;
        }

        @Override
        protected IDeviceAdminService asInterface(IBinder binder) {
            return IDeviceAdminService.Stub.asInterface(binder);
        }
    }
}

