/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.admin.DevicePolicyCache;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import java.io.PrintWriter;

public class DevicePolicyCacheImpl
extends DevicePolicyCache {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final SparseBooleanArray mScreenCaptureDisabled = new SparseBooleanArray();
    @GuardedBy(value={"mLock"})
    private final SparseIntArray mPasswordQuality = new SparseIntArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.mScreenCaptureDisabled.delete(userHandle);
            this.mPasswordQuality.delete(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getScreenCaptureDisabled(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mScreenCaptureDisabled.get(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScreenCaptureDisabled(int userHandle, boolean disabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.mScreenCaptureDisabled.put(userHandle, disabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordQuality(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPasswordQuality.get(userHandle, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordQuality(int userHandle, int quality) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPasswordQuality.put(userHandle, quality);
        }
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.println("Device policy cache");
        pw.println(prefix + "Screen capture disabled: " + this.mScreenCaptureDisabled.toString());
        pw.println(prefix + "Password quality: " + this.mPasswordQuality.toString());
    }
}

