/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.util.ArraySet;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSystemProperty;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.server.inputmethod.InputMethodManagerInternal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class OverlayPackagesProvider {
    protected static final String TAG = "OverlayPackagesProvider";
    private final PackageManager mPm;
    private final Context mContext;
    private final Injector mInjector;

    public OverlayPackagesProvider(Context context) {
        this(context, new DefaultInjector());
    }

    @VisibleForTesting
    OverlayPackagesProvider(Context context, Injector injector) {
        this.mContext = context;
        this.mPm = Preconditions.checkNotNull(context.getPackageManager());
        this.mInjector = Preconditions.checkNotNull(injector);
    }

    public Set<String> getNonRequiredApps(ComponentName admin, int userId, String provisioningAction) {
        Set<String> nonRequiredApps = this.getLaunchableApps(userId);
        nonRequiredApps.removeAll(this.getRequiredApps(provisioningAction, admin.getPackageName()));
        if (this.mInjector.isPerProfileImeEnabled()) {
            nonRequiredApps.removeAll(this.getSystemInputMethods(userId));
        } else if ("android.app.action.PROVISION_MANAGED_DEVICE".equals(provisioningAction) || "android.app.action.PROVISION_MANAGED_USER".equals(provisioningAction)) {
            nonRequiredApps.removeAll(this.getSystemInputMethods(userId));
        }
        nonRequiredApps.addAll(this.getDisallowedApps(provisioningAction));
        return nonRequiredApps;
    }

    private Set<String> getLaunchableApps(int userId) {
        Intent launcherIntent = new Intent("android.intent.action.MAIN");
        launcherIntent.addCategory("android.intent.category.LAUNCHER");
        List<ResolveInfo> resolveInfos = this.mPm.queryIntentActivitiesAsUser(launcherIntent, 795136, userId);
        ArraySet<String> apps = new ArraySet<String>();
        for (ResolveInfo resolveInfo : resolveInfos) {
            apps.add(resolveInfo.activityInfo.packageName);
        }
        return apps;
    }

    private Set<String> getSystemInputMethods(int userId) {
        List<InputMethodInfo> inputMethods = this.mInjector.getInputMethodListAsUser(userId);
        ArraySet<String> systemInputMethods = new ArraySet<String>();
        for (InputMethodInfo inputMethodInfo : inputMethods) {
            ApplicationInfo applicationInfo = inputMethodInfo.getServiceInfo().applicationInfo;
            if (!applicationInfo.isSystemApp()) continue;
            systemInputMethods.add(inputMethodInfo.getPackageName());
        }
        return systemInputMethods;
    }

    private Set<String> getRequiredApps(String provisioningAction, String dpcPackageName) {
        ArraySet<String> requiredApps = new ArraySet<String>();
        requiredApps.addAll(this.getRequiredAppsSet(provisioningAction));
        requiredApps.addAll(this.getVendorRequiredAppsSet(provisioningAction));
        requiredApps.add(dpcPackageName);
        return requiredApps;
    }

    private Set<String> getDisallowedApps(String provisioningAction) {
        ArraySet<String> disallowedApps = new ArraySet<String>();
        disallowedApps.addAll(this.getDisallowedAppsSet(provisioningAction));
        disallowedApps.addAll(this.getVendorDisallowedAppsSet(provisioningAction));
        return disallowedApps;
    }

    private Set<String> getRequiredAppsSet(String provisioningAction) {
        int resId;
        switch (provisioningAction) {
            case "android.app.action.PROVISION_MANAGED_USER": {
                resId = 17236101;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_PROFILE": {
                resId = 17236100;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_DEVICE": {
                resId = 17236099;
                break;
            }
            default: {
                throw new IllegalArgumentException("Provisioning type " + provisioningAction + " not supported.");
            }
        }
        return new ArraySet<String>(Arrays.asList(this.mContext.getResources().getStringArray(resId)));
    }

    private Set<String> getDisallowedAppsSet(String provisioningAction) {
        int resId;
        switch (provisioningAction) {
            case "android.app.action.PROVISION_MANAGED_USER": {
                resId = 17236082;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_PROFILE": {
                resId = 0x1070071;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_DEVICE": {
                resId = 0x1070070;
                break;
            }
            default: {
                throw new IllegalArgumentException("Provisioning type " + provisioningAction + " not supported.");
            }
        }
        return new ArraySet<String>(Arrays.asList(this.mContext.getResources().getStringArray(resId)));
    }

    private Set<String> getVendorRequiredAppsSet(String provisioningAction) {
        int resId;
        switch (provisioningAction) {
            case "android.app.action.PROVISION_MANAGED_USER": {
                resId = 17236113;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_PROFILE": {
                resId = 17236112;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_DEVICE": {
                resId = 17236111;
                break;
            }
            default: {
                throw new IllegalArgumentException("Provisioning type " + provisioningAction + " not supported.");
            }
        }
        return new ArraySet<String>(Arrays.asList(this.mContext.getResources().getStringArray(resId)));
    }

    private Set<String> getVendorDisallowedAppsSet(String provisioningAction) {
        int resId;
        switch (provisioningAction) {
            case "android.app.action.PROVISION_MANAGED_USER": {
                resId = 17236110;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_PROFILE": {
                resId = 17236109;
                break;
            }
            case "android.app.action.PROVISION_MANAGED_DEVICE": {
                resId = 17236108;
                break;
            }
            default: {
                throw new IllegalArgumentException("Provisioning type " + provisioningAction + " not supported.");
            }
        }
        return new ArraySet<String>(Arrays.asList(this.mContext.getResources().getStringArray(resId)));
    }

    private static final class DefaultInjector
    implements Injector {
        private DefaultInjector() {
        }

        @Override
        public boolean isPerProfileImeEnabled() {
            return InputMethodSystemProperty.PER_PROFILE_IME_ENABLED;
        }

        @Override
        public List<InputMethodInfo> getInputMethodListAsUser(int userId) {
            return InputMethodManagerInternal.get().getInputMethodListAsUser(userId);
        }
    }

    @VisibleForTesting
    static interface Injector {
        public boolean isPerProfileImeEnabled();

        public List<InputMethodInfo> getInputMethodListAsUser(int var1);
    }
}

