/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.app.admin.DevicePolicyEventLogger;
import android.app.admin.StartInstallingUpdateCallback;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Environment;
import android.os.FileUtils;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.server.devicepolicy.DevicePolicyConstants;
import com.android.server.devicepolicy.DevicePolicyManagerService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

abstract class UpdateInstaller {
    private StartInstallingUpdateCallback mCallback;
    private ParcelFileDescriptor mUpdateFileDescriptor;
    private DevicePolicyConstants mConstants;
    protected Context mContext;
    protected File mCopiedUpdateFile;
    static final String TAG = "UpdateInstaller";
    private DevicePolicyManagerService.Injector mInjector;

    protected UpdateInstaller(Context context, ParcelFileDescriptor updateFileDescriptor, StartInstallingUpdateCallback callback, DevicePolicyManagerService.Injector injector, DevicePolicyConstants constants) {
        this.mContext = context;
        this.mCallback = callback;
        this.mUpdateFileDescriptor = updateFileDescriptor;
        this.mInjector = injector;
        this.mConstants = constants;
    }

    public abstract void installUpdateInThread();

    public void startInstallUpdate() {
        this.mCopiedUpdateFile = null;
        if (!this.isBatteryLevelSufficient()) {
            this.notifyCallbackOnError(5, "The battery level must be above " + this.mConstants.BATTERY_THRESHOLD_NOT_CHARGING + " while not charging orabove " + this.mConstants.BATTERY_THRESHOLD_CHARGING + " while charging");
            return;
        }
        Thread thread = new Thread(() -> {
            this.mCopiedUpdateFile = this.copyUpdateFileToDataOtaPackageDir();
            if (this.mCopiedUpdateFile == null) {
                this.notifyCallbackOnError(1, "Error while copying file.");
                return;
            }
            this.installUpdateInThread();
        });
        thread.setPriority(10);
        thread.start();
    }

    private boolean isBatteryLevelSufficient() {
        boolean isBatteryPluggedIn;
        Intent batteryStatus = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        float batteryPercentage = this.calculateBatteryPercentage(batteryStatus);
        boolean bl = isBatteryPluggedIn = batteryStatus.getIntExtra("plugged", -1) > 0;
        return isBatteryPluggedIn ? batteryPercentage >= (float)this.mConstants.BATTERY_THRESHOLD_CHARGING : batteryPercentage >= (float)this.mConstants.BATTERY_THRESHOLD_NOT_CHARGING;
    }

    private float calculateBatteryPercentage(Intent batteryStatus) {
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        return (float)(100 * level) / (float)scale;
    }

    private File copyUpdateFileToDataOtaPackageDir() {
        try {
            File destination = this.createNewFileWithPermissions();
            this.copyToFile(destination);
            return destination;
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to copy update file to OTA directory", e);
            this.notifyCallbackOnError(1, Log.getStackTraceString(e));
            return null;
        }
    }

    private File createNewFileWithPermissions() throws IOException {
        File destination = File.createTempFile("update", ".zip", new File(Environment.getDataDirectory() + "/ota_package"));
        FileUtils.setPermissions(destination, 484, -1, -1);
        return destination;
    }

    private void copyToFile(File destination) throws IOException {
        try (FileOutputStream out = new FileOutputStream(destination);
             ParcelFileDescriptor.AutoCloseInputStream in = new ParcelFileDescriptor.AutoCloseInputStream(this.mUpdateFileDescriptor);){
            FileUtils.copy(in, out);
        }
    }

    void cleanupUpdateFile() {
        if (this.mCopiedUpdateFile != null && this.mCopiedUpdateFile.exists()) {
            this.mCopiedUpdateFile.delete();
        }
    }

    protected void notifyCallbackOnError(int errorCode, String errorMessage) {
        this.cleanupUpdateFile();
        DevicePolicyEventLogger.createEvent(74).setInt(errorCode).write();
        try {
            this.mCallback.onStartInstallingUpdateError(errorCode, errorMessage);
        }
        catch (RemoteException e) {
            Log.d(TAG, "Error while calling callback", e);
        }
    }

    protected void notifyCallbackOnSuccess() {
        this.cleanupUpdateFile();
        this.mInjector.powerManagerReboot("deviceowner");
    }
}

