/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.hardware.display.AmbientBrightnessDayStats;
import android.os.SystemClock;
import android.os.UserManager;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AmbientBrightnessStatsTracker {
    private static final String TAG = "AmbientBrightnessStatsTracker";
    private static final boolean DEBUG = false;
    @VisibleForTesting
    static final float[] BUCKET_BOUNDARIES_FOR_NEW_STATS = new float[]{0.0f, 0.1f, 0.3f, 1.0f, 3.0f, 10.0f, 30.0f, 100.0f, 300.0f, 1000.0f, 3000.0f, 10000.0f};
    @VisibleForTesting
    static final int MAX_DAYS_TO_TRACK = 7;
    private final AmbientBrightnessStats mAmbientBrightnessStats;
    private final Timer mTimer;
    private final Injector mInjector;
    private final UserManager mUserManager;
    private float mCurrentAmbientBrightness;
    private int mCurrentUserId;

    public AmbientBrightnessStatsTracker(UserManager userManager, Injector injector) {
        this.mUserManager = userManager;
        this.mInjector = injector != null ? injector : new Injector();
        this.mAmbientBrightnessStats = new AmbientBrightnessStats();
        this.mTimer = new Timer(() -> this.mInjector.elapsedRealtimeMillis());
        this.mCurrentAmbientBrightness = -1.0f;
    }

    public synchronized void start() {
        this.mTimer.reset();
        this.mTimer.start();
    }

    public synchronized void stop() {
        if (this.mTimer.isRunning()) {
            this.mAmbientBrightnessStats.log(this.mCurrentUserId, this.mInjector.getLocalDate(), this.mCurrentAmbientBrightness, this.mTimer.totalDurationSec());
        }
        this.mTimer.reset();
        this.mCurrentAmbientBrightness = -1.0f;
    }

    public synchronized void add(int userId, float newAmbientBrightness) {
        if (this.mTimer.isRunning()) {
            if (userId == this.mCurrentUserId) {
                this.mAmbientBrightnessStats.log(this.mCurrentUserId, this.mInjector.getLocalDate(), this.mCurrentAmbientBrightness, this.mTimer.totalDurationSec());
            } else {
                this.mCurrentUserId = userId;
            }
            this.mTimer.reset();
            this.mTimer.start();
            this.mCurrentAmbientBrightness = newAmbientBrightness;
        }
    }

    public synchronized void writeStats(OutputStream stream) throws IOException {
        this.mAmbientBrightnessStats.writeToXML(stream);
    }

    public synchronized void readStats(InputStream stream) throws IOException {
        this.mAmbientBrightnessStats.readFromXML(stream);
    }

    public synchronized ArrayList<AmbientBrightnessDayStats> getUserStats(int userId) {
        return this.mAmbientBrightnessStats.getUserStats(userId);
    }

    public synchronized void dump(PrintWriter pw) {
        pw.println("AmbientBrightnessStats:");
        pw.print(this.mAmbientBrightnessStats);
    }

    @VisibleForTesting
    static class Injector {
        Injector() {
        }

        public long elapsedRealtimeMillis() {
            return SystemClock.elapsedRealtime();
        }

        public int getUserSerialNumber(UserManager userManager, int userId) {
            return userManager.getUserSerialNumber(userId);
        }

        public int getUserId(UserManager userManager, int userSerialNumber) {
            return userManager.getUserHandle(userSerialNumber);
        }

        public LocalDate getLocalDate() {
            return LocalDate.now();
        }
    }

    @VisibleForTesting
    static class Timer {
        private final Clock clock;
        private long startTimeMillis;
        private boolean started;

        public Timer(Clock clock) {
            this.clock = clock;
        }

        public void reset() {
            this.started = false;
        }

        public void start() {
            if (!this.started) {
                this.startTimeMillis = this.clock.elapsedTimeMillis();
                this.started = true;
            }
        }

        public boolean isRunning() {
            return this.started;
        }

        public float totalDurationSec() {
            if (this.started) {
                return (float)((double)(this.clock.elapsedTimeMillis() - this.startTimeMillis) / 1000.0);
            }
            return 0.0f;
        }
    }

    @VisibleForTesting
    static interface Clock {
        public long elapsedTimeMillis();
    }

    class AmbientBrightnessStats {
        private static final String TAG_AMBIENT_BRIGHTNESS_STATS = "ambient-brightness-stats";
        private static final String TAG_AMBIENT_BRIGHTNESS_DAY_STATS = "ambient-brightness-day-stats";
        private static final String ATTR_USER = "user";
        private static final String ATTR_LOCAL_DATE = "local-date";
        private static final String ATTR_BUCKET_BOUNDARIES = "bucket-boundaries";
        private static final String ATTR_BUCKET_STATS = "bucket-stats";
        private Map<Integer, Deque<AmbientBrightnessDayStats>> mStats = new HashMap<Integer, Deque<AmbientBrightnessDayStats>>();

        public void log(int userId, LocalDate localDate, float ambientBrightness, float durationSec) {
            Deque<AmbientBrightnessDayStats> userStats = this.getOrCreateUserStats(this.mStats, userId);
            AmbientBrightnessDayStats dayStats = this.getOrCreateDayStats(userStats, localDate);
            dayStats.log(ambientBrightness, durationSec);
        }

        public ArrayList<AmbientBrightnessDayStats> getUserStats(int userId) {
            if (this.mStats.containsKey(userId)) {
                return new ArrayList<AmbientBrightnessDayStats>((Collection)this.mStats.get(userId));
            }
            return null;
        }

        public void writeToXML(OutputStream stream) throws IOException {
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            LocalDate cutOffDate = AmbientBrightnessStatsTracker.this.mInjector.getLocalDate().minusDays(7L);
            out.startTag(null, TAG_AMBIENT_BRIGHTNESS_STATS);
            for (Map.Entry<Integer, Deque<AmbientBrightnessDayStats>> entry : this.mStats.entrySet()) {
                for (AmbientBrightnessDayStats userDayStats : entry.getValue()) {
                    int userSerialNumber = AmbientBrightnessStatsTracker.this.mInjector.getUserSerialNumber(AmbientBrightnessStatsTracker.this.mUserManager, entry.getKey());
                    if (userSerialNumber == -1 || !userDayStats.getLocalDate().isAfter(cutOffDate)) continue;
                    out.startTag(null, TAG_AMBIENT_BRIGHTNESS_DAY_STATS);
                    out.attribute(null, ATTR_USER, Integer.toString(userSerialNumber));
                    out.attribute(null, ATTR_LOCAL_DATE, userDayStats.getLocalDate().toString());
                    StringBuilder bucketBoundariesValues = new StringBuilder();
                    StringBuilder timeSpentValues = new StringBuilder();
                    for (int i = 0; i < userDayStats.getBucketBoundaries().length; ++i) {
                        if (i > 0) {
                            bucketBoundariesValues.append(",");
                            timeSpentValues.append(",");
                        }
                        bucketBoundariesValues.append(userDayStats.getBucketBoundaries()[i]);
                        timeSpentValues.append(userDayStats.getStats()[i]);
                    }
                    out.attribute(null, ATTR_BUCKET_BOUNDARIES, bucketBoundariesValues.toString());
                    out.attribute(null, ATTR_BUCKET_STATS, timeSpentValues.toString());
                    out.endTag(null, TAG_AMBIENT_BRIGHTNESS_DAY_STATS);
                }
            }
            out.endTag(null, TAG_AMBIENT_BRIGHTNESS_STATS);
            out.endDocument();
            stream.flush();
        }

        public void readFromXML(InputStream stream) throws IOException {
            try {
                int type;
                HashMap<Integer, Deque<AmbientBrightnessDayStats>> parsedStats = new HashMap<Integer, Deque<AmbientBrightnessDayStats>>();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(stream, StandardCharsets.UTF_8.name());
                while ((type = parser.next()) != 1 && type != 2) {
                }
                String tag = parser.getName();
                if (!TAG_AMBIENT_BRIGHTNESS_STATS.equals(tag)) {
                    throw new XmlPullParserException("Ambient brightness stats not found in tracker file " + tag);
                }
                LocalDate cutOffDate = AmbientBrightnessStatsTracker.this.mInjector.getLocalDate().minusDays(7L);
                parser.next();
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    String[] bucketStats;
                    if (type == 3 || type == 4 || !TAG_AMBIENT_BRIGHTNESS_DAY_STATS.equals(tag = parser.getName())) continue;
                    String userSerialNumber = parser.getAttributeValue(null, ATTR_USER);
                    LocalDate localDate = LocalDate.parse(parser.getAttributeValue(null, ATTR_LOCAL_DATE));
                    String[] bucketBoundaries = parser.getAttributeValue(null, ATTR_BUCKET_BOUNDARIES).split(",");
                    if (bucketBoundaries.length != (bucketStats = parser.getAttributeValue(null, ATTR_BUCKET_STATS).split(",")).length || bucketBoundaries.length < 1) {
                        throw new IOException("Invalid brightness stats string.");
                    }
                    float[] parsedBucketBoundaries = new float[bucketBoundaries.length];
                    float[] parsedBucketStats = new float[bucketStats.length];
                    for (int i = 0; i < bucketBoundaries.length; ++i) {
                        parsedBucketBoundaries[i] = Float.parseFloat(bucketBoundaries[i]);
                        parsedBucketStats[i] = Float.parseFloat(bucketStats[i]);
                    }
                    int userId = AmbientBrightnessStatsTracker.this.mInjector.getUserId(AmbientBrightnessStatsTracker.this.mUserManager, Integer.parseInt(userSerialNumber));
                    if (userId == -1 || !localDate.isAfter(cutOffDate)) continue;
                    Deque<AmbientBrightnessDayStats> userStats = this.getOrCreateUserStats(parsedStats, userId);
                    userStats.offer(new AmbientBrightnessDayStats(localDate, parsedBucketBoundaries, parsedBucketStats));
                }
                this.mStats = parsedStats;
            }
            catch (IOException | NullPointerException | NumberFormatException | DateTimeParseException | XmlPullParserException e) {
                throw new IOException("Failed to parse brightness stats file.", e);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Integer, Deque<AmbientBrightnessDayStats>> entry : this.mStats.entrySet()) {
                for (AmbientBrightnessDayStats dayStats : entry.getValue()) {
                    builder.append("  ");
                    builder.append(entry.getKey()).append(" ");
                    builder.append(dayStats).append("\n");
                }
            }
            return builder.toString();
        }

        private Deque<AmbientBrightnessDayStats> getOrCreateUserStats(Map<Integer, Deque<AmbientBrightnessDayStats>> stats, int userId) {
            if (!stats.containsKey(userId)) {
                stats.put(userId, new ArrayDeque());
            }
            return stats.get(userId);
        }

        private AmbientBrightnessDayStats getOrCreateDayStats(Deque<AmbientBrightnessDayStats> userStats, LocalDate localDate) {
            AmbientBrightnessDayStats lastBrightnessStats = userStats.peekLast();
            if (lastBrightnessStats != null && lastBrightnessStats.getLocalDate().equals(localDate)) {
                return lastBrightnessStats;
            }
            AmbientBrightnessDayStats dayStats = new AmbientBrightnessDayStats(localDate, BUCKET_BOUNDARIES_FOR_NEW_STATS);
            if (userStats.size() == 7) {
                userStats.poll();
            }
            userStats.offer(dayStats);
            return dayStats;
        }
    }
}

