/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.IActivityTaskManager;
import android.app.TaskStackListener;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.DisplayManagerInternal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.util.EventLog;
import android.util.MathUtils;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.os.BackgroundThread;
import com.android.server.display.BrightnessMappingStrategy;
import com.android.server.display.HysteresisLevels;
import java.io.PrintWriter;

class AutomaticBrightnessController {
    private static final String TAG = "AutomaticBrightnessController";
    private static final boolean DEBUG_PRETEND_LIGHT_SENSOR_ABSENT = false;
    private static final boolean USE_SCREEN_AUTO_BRIGHTNESS_ADJUSTMENT = true;
    private static final long AMBIENT_LIGHT_PREDICTION_TIME_MILLIS = 100L;
    private static final int BRIGHTNESS_ADJUSTMENT_SAMPLE_DEBOUNCE_MILLIS = 10000;
    private static final int MSG_UPDATE_AMBIENT_LUX = 1;
    private static final int MSG_BRIGHTNESS_ADJUSTMENT_SAMPLE = 2;
    private static final int MSG_INVALIDATE_SHORT_TERM_MODEL = 3;
    private static final int MSG_UPDATE_FOREGROUND_APP = 4;
    private static final int MSG_UPDATE_FOREGROUND_APP_SYNC = 5;
    private static final int AMBIENT_LIGHT_LONG_HORIZON_MILLIS = 10000;
    private static final int AMBIENT_LIGHT_SHORT_HORIZON_MILLIS = 2000;
    private final Callbacks mCallbacks;
    private final SensorManager mSensorManager;
    private final Sensor mLightSensor;
    private final BrightnessMappingStrategy mBrightnessMapper;
    private final int mScreenBrightnessRangeMinimum;
    private final int mScreenBrightnessRangeMaximum;
    private final float mDozeScaleFactor;
    private final int mInitialLightSensorRate;
    private final int mNormalLightSensorRate;
    private int mCurrentLightSensorRate;
    private final long mBrighteningLightDebounceConfig;
    private final long mDarkeningLightDebounceConfig;
    private final boolean mResetAmbientLuxAfterWarmUpConfig;
    private final int mAmbientLightHorizon;
    private final int mWeightingIntercept;
    private final HysteresisLevels mAmbientBrightnessThresholds;
    private final HysteresisLevels mScreenBrightnessThresholds;
    private boolean mLoggingEnabled;
    private long mShortTermModelTimeout;
    private int mLightSensorWarmUpTimeConfig;
    private boolean mLightSensorEnabled;
    private long mLightSensorEnableTime;
    private float mAmbientLux;
    private boolean mAmbientLuxValid;
    private float mAmbientBrighteningThreshold;
    private float mAmbientDarkeningThreshold;
    private float mScreenBrighteningThreshold;
    private float mScreenDarkeningThreshold;
    private float mLastObservedLux;
    private long mLastObservedLuxTime;
    private int mRecentLightSamples;
    private AmbientLightRingBuffer mAmbientLightRingBuffer;
    private AutomaticBrightnessHandler mHandler;
    private int mScreenAutoBrightness = -1;
    private int mDisplayPolicy = 0;
    private boolean mBrightnessAdjustmentSamplePending;
    private float mBrightnessAdjustmentSampleOldLux;
    private int mBrightnessAdjustmentSampleOldBrightness;
    private boolean mShortTermModelValid;
    private float mShortTermModelAnchor;
    private float SHORT_TERM_MODEL_THRESHOLD_RATIO = 0.6f;
    private String mForegroundAppPackageName;
    private String mPendingForegroundAppPackageName;
    private int mForegroundAppCategory;
    private int mPendingForegroundAppCategory;
    private TaskStackListenerImpl mTaskStackListener;
    private IActivityTaskManager mActivityTaskManager;
    private PackageManager mPackageManager;
    private final SensorEventListener mLightSensorListener = new SensorEventListener(){

        @Override
        public void onSensorChanged(SensorEvent event) {
            if (AutomaticBrightnessController.this.mLightSensorEnabled) {
                long time = SystemClock.uptimeMillis();
                float lux = event.values[0];
                AutomaticBrightnessController.this.handleLightSensorEvent(time, lux);
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    public AutomaticBrightnessController(Callbacks callbacks, Looper looper, SensorManager sensorManager, Sensor lightSensor, BrightnessMappingStrategy mapper, int lightSensorWarmUpTime, int brightnessMin, int brightnessMax, float dozeScaleFactor, int lightSensorRate, int initialLightSensorRate, long brighteningLightDebounceConfig, long darkeningLightDebounceConfig, boolean resetAmbientLuxAfterWarmUpConfig, HysteresisLevels ambientBrightnessThresholds, HysteresisLevels screenBrightnessThresholds, long shortTermModelTimeout, PackageManager packageManager) {
        this.mCallbacks = callbacks;
        this.mSensorManager = sensorManager;
        this.mBrightnessMapper = mapper;
        this.mScreenBrightnessRangeMinimum = brightnessMin;
        this.mScreenBrightnessRangeMaximum = brightnessMax;
        this.mLightSensorWarmUpTimeConfig = lightSensorWarmUpTime;
        this.mDozeScaleFactor = dozeScaleFactor;
        this.mNormalLightSensorRate = lightSensorRate;
        this.mInitialLightSensorRate = initialLightSensorRate;
        this.mCurrentLightSensorRate = -1;
        this.mBrighteningLightDebounceConfig = brighteningLightDebounceConfig;
        this.mDarkeningLightDebounceConfig = darkeningLightDebounceConfig;
        this.mResetAmbientLuxAfterWarmUpConfig = resetAmbientLuxAfterWarmUpConfig;
        this.mAmbientLightHorizon = 10000;
        this.mWeightingIntercept = 10000;
        this.mAmbientBrightnessThresholds = ambientBrightnessThresholds;
        this.mScreenBrightnessThresholds = screenBrightnessThresholds;
        this.mShortTermModelTimeout = shortTermModelTimeout;
        this.mShortTermModelValid = true;
        this.mShortTermModelAnchor = -1.0f;
        this.mHandler = new AutomaticBrightnessHandler(looper);
        this.mAmbientLightRingBuffer = new AmbientLightRingBuffer(this.mNormalLightSensorRate, this.mAmbientLightHorizon);
        this.mLightSensor = lightSensor;
        this.mActivityTaskManager = ActivityTaskManager.getService();
        this.mPackageManager = packageManager;
        this.mTaskStackListener = new TaskStackListenerImpl();
        this.mForegroundAppPackageName = null;
        this.mPendingForegroundAppPackageName = null;
        this.mForegroundAppCategory = -1;
        this.mPendingForegroundAppCategory = -1;
    }

    public boolean setLoggingEnabled(boolean loggingEnabled) {
        if (this.mLoggingEnabled == loggingEnabled) {
            return false;
        }
        this.mBrightnessMapper.setLoggingEnabled(loggingEnabled);
        this.mLoggingEnabled = loggingEnabled;
        return true;
    }

    public int getAutomaticScreenBrightness() {
        if (!this.mAmbientLuxValid) {
            return -1;
        }
        if (this.mDisplayPolicy == 1) {
            return (int)((float)this.mScreenAutoBrightness * this.mDozeScaleFactor);
        }
        return this.mScreenAutoBrightness;
    }

    public boolean hasValidAmbientLux() {
        return this.mAmbientLuxValid;
    }

    public float getAutomaticScreenBrightnessAdjustment() {
        return this.mBrightnessMapper.getAutoBrightnessAdjustment();
    }

    public void configure(boolean enable, BrightnessConfiguration configuration, float brightness, boolean userChangedBrightness, float adjustment, boolean userChangedAutoBrightnessAdjustment, int displayPolicy) {
        boolean userInitiatedChange;
        boolean dozing = displayPolicy == 1;
        boolean changed = this.setBrightnessConfiguration(configuration);
        changed |= this.setDisplayPolicy(displayPolicy);
        if (userChangedAutoBrightnessAdjustment) {
            changed |= this.setAutoBrightnessAdjustment(adjustment);
        }
        if (userChangedBrightness && enable) {
            changed |= this.setScreenBrightnessByUser(brightness);
        }
        boolean bl = userInitiatedChange = userChangedBrightness || userChangedAutoBrightnessAdjustment;
        if (userInitiatedChange && enable && !dozing) {
            this.prepareBrightnessAdjustmentSample();
        }
        if (changed |= this.setLightSensorEnabled(enable && !dozing)) {
            this.updateAutoBrightness(false, userInitiatedChange);
        }
    }

    public boolean hasUserDataPoints() {
        return this.mBrightnessMapper.hasUserDataPoints();
    }

    public boolean isDefaultConfig() {
        return this.mBrightnessMapper.isDefaultConfig();
    }

    public BrightnessConfiguration getDefaultConfig() {
        return this.mBrightnessMapper.getDefaultConfig();
    }

    private boolean setDisplayPolicy(int policy) {
        if (this.mDisplayPolicy == policy) {
            return false;
        }
        int oldPolicy = this.mDisplayPolicy;
        this.mDisplayPolicy = policy;
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "Display policy transitioning from " + oldPolicy + " to " + policy);
        }
        if (!AutomaticBrightnessController.isInteractivePolicy(policy) && AutomaticBrightnessController.isInteractivePolicy(oldPolicy)) {
            this.mHandler.sendEmptyMessageDelayed(3, this.mShortTermModelTimeout);
        } else if (AutomaticBrightnessController.isInteractivePolicy(policy) && !AutomaticBrightnessController.isInteractivePolicy(oldPolicy)) {
            this.mHandler.removeMessages(3);
        }
        return true;
    }

    private static boolean isInteractivePolicy(int policy) {
        return policy == 3 || policy == 2 || policy == 4;
    }

    private boolean setScreenBrightnessByUser(float brightness) {
        if (!this.mAmbientLuxValid) {
            return false;
        }
        this.mBrightnessMapper.addUserDataPoint(this.mAmbientLux, brightness);
        this.mShortTermModelValid = true;
        this.mShortTermModelAnchor = this.mAmbientLux;
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "ShortTermModel: anchor=" + this.mShortTermModelAnchor);
        }
        return true;
    }

    public void resetShortTermModel() {
        this.mBrightnessMapper.clearUserDataPoints();
        this.mShortTermModelValid = true;
        this.mShortTermModelAnchor = -1.0f;
    }

    private void invalidateShortTermModel() {
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "ShortTermModel: invalidate user data");
        }
        this.mShortTermModelValid = false;
    }

    public boolean setBrightnessConfiguration(BrightnessConfiguration configuration) {
        if (this.mBrightnessMapper.setBrightnessConfiguration(configuration)) {
            this.resetShortTermModel();
            return true;
        }
        return false;
    }

    public void dump(PrintWriter pw) {
        pw.println();
        pw.println("Automatic Brightness Controller Configuration:");
        pw.println("  mScreenBrightnessRangeMinimum=" + this.mScreenBrightnessRangeMinimum);
        pw.println("  mScreenBrightnessRangeMaximum=" + this.mScreenBrightnessRangeMaximum);
        pw.println("  mDozeScaleFactor=" + this.mDozeScaleFactor);
        pw.println("  mInitialLightSensorRate=" + this.mInitialLightSensorRate);
        pw.println("  mNormalLightSensorRate=" + this.mNormalLightSensorRate);
        pw.println("  mLightSensorWarmUpTimeConfig=" + this.mLightSensorWarmUpTimeConfig);
        pw.println("  mBrighteningLightDebounceConfig=" + this.mBrighteningLightDebounceConfig);
        pw.println("  mDarkeningLightDebounceConfig=" + this.mDarkeningLightDebounceConfig);
        pw.println("  mResetAmbientLuxAfterWarmUpConfig=" + this.mResetAmbientLuxAfterWarmUpConfig);
        pw.println("  mAmbientLightHorizon=" + this.mAmbientLightHorizon);
        pw.println("  mWeightingIntercept=" + this.mWeightingIntercept);
        pw.println();
        pw.println("Automatic Brightness Controller State:");
        pw.println("  mLightSensor=" + this.mLightSensor);
        pw.println("  mLightSensorEnabled=" + this.mLightSensorEnabled);
        pw.println("  mLightSensorEnableTime=" + TimeUtils.formatUptime(this.mLightSensorEnableTime));
        pw.println("  mCurrentLightSensorRate=" + this.mCurrentLightSensorRate);
        pw.println("  mAmbientLux=" + this.mAmbientLux);
        pw.println("  mAmbientLuxValid=" + this.mAmbientLuxValid);
        pw.println("  mAmbientBrighteningThreshold=" + this.mAmbientBrighteningThreshold);
        pw.println("  mAmbientDarkeningThreshold=" + this.mAmbientDarkeningThreshold);
        pw.println("  mScreenBrighteningThreshold=" + this.mScreenBrighteningThreshold);
        pw.println("  mScreenDarkeningThreshold=" + this.mScreenDarkeningThreshold);
        pw.println("  mLastObservedLux=" + this.mLastObservedLux);
        pw.println("  mLastObservedLuxTime=" + TimeUtils.formatUptime(this.mLastObservedLuxTime));
        pw.println("  mRecentLightSamples=" + this.mRecentLightSamples);
        pw.println("  mAmbientLightRingBuffer=" + this.mAmbientLightRingBuffer);
        pw.println("  mScreenAutoBrightness=" + this.mScreenAutoBrightness);
        pw.println("  mDisplayPolicy=" + DisplayManagerInternal.DisplayPowerRequest.policyToString(this.mDisplayPolicy));
        pw.println("  mShortTermModelTimeout=" + this.mShortTermModelTimeout);
        pw.println("  mShortTermModelAnchor=" + this.mShortTermModelAnchor);
        pw.println("  mShortTermModelValid=" + this.mShortTermModelValid);
        pw.println("  mBrightnessAdjustmentSamplePending=" + this.mBrightnessAdjustmentSamplePending);
        pw.println("  mBrightnessAdjustmentSampleOldLux=" + this.mBrightnessAdjustmentSampleOldLux);
        pw.println("  mBrightnessAdjustmentSampleOldBrightness=" + this.mBrightnessAdjustmentSampleOldBrightness);
        pw.println("  mForegroundAppPackageName=" + this.mForegroundAppPackageName);
        pw.println("  mPendingForegroundAppPackageName=" + this.mPendingForegroundAppPackageName);
        pw.println("  mForegroundAppCategory=" + this.mForegroundAppCategory);
        pw.println("  mPendingForegroundAppCategory=" + this.mPendingForegroundAppCategory);
        pw.println();
        this.mBrightnessMapper.dump(pw);
        pw.println();
        this.mAmbientBrightnessThresholds.dump(pw);
        this.mScreenBrightnessThresholds.dump(pw);
    }

    private boolean setLightSensorEnabled(boolean enable) {
        if (enable) {
            if (!this.mLightSensorEnabled) {
                this.mLightSensorEnabled = true;
                this.mLightSensorEnableTime = SystemClock.uptimeMillis();
                this.mCurrentLightSensorRate = this.mInitialLightSensorRate;
                this.registerForegroundAppUpdater();
                this.mSensorManager.registerListener(this.mLightSensorListener, this.mLightSensor, this.mCurrentLightSensorRate * 1000, this.mHandler);
                return true;
            }
        } else if (this.mLightSensorEnabled) {
            this.mLightSensorEnabled = false;
            this.mAmbientLuxValid = !this.mResetAmbientLuxAfterWarmUpConfig;
            this.mScreenAutoBrightness = -1;
            this.mRecentLightSamples = 0;
            this.mAmbientLightRingBuffer.clear();
            this.mCurrentLightSensorRate = -1;
            this.mHandler.removeMessages(1);
            this.unregisterForegroundAppUpdater();
            this.mSensorManager.unregisterListener(this.mLightSensorListener);
        }
        return false;
    }

    private void handleLightSensorEvent(long time, float lux) {
        Trace.traceCounter(131072L, "ALS", (int)lux);
        this.mHandler.removeMessages(1);
        if (this.mAmbientLightRingBuffer.size() == 0) {
            this.adjustLightSensorRate(this.mNormalLightSensorRate);
        }
        this.applyLightSensorMeasurement(time, lux);
        this.updateAmbientLux(time);
    }

    private void applyLightSensorMeasurement(long time, float lux) {
        ++this.mRecentLightSamples;
        this.mAmbientLightRingBuffer.prune(time - (long)this.mAmbientLightHorizon);
        this.mAmbientLightRingBuffer.push(time, lux);
        this.mLastObservedLux = lux;
        this.mLastObservedLuxTime = time;
    }

    private void adjustLightSensorRate(int lightSensorRate) {
        if (lightSensorRate != this.mCurrentLightSensorRate) {
            if (this.mLoggingEnabled) {
                Slog.d(TAG, "adjustLightSensorRate: previousRate=" + this.mCurrentLightSensorRate + ", currentRate=" + lightSensorRate);
            }
            this.mCurrentLightSensorRate = lightSensorRate;
            this.mSensorManager.unregisterListener(this.mLightSensorListener);
            this.mSensorManager.registerListener(this.mLightSensorListener, this.mLightSensor, lightSensorRate * 1000, this.mHandler);
        }
    }

    private boolean setAutoBrightnessAdjustment(float adjustment) {
        return this.mBrightnessMapper.setAutoBrightnessAdjustment(adjustment);
    }

    private void setAmbientLux(float lux) {
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "setAmbientLux(" + lux + ")");
        }
        if (lux < 0.0f) {
            Slog.w(TAG, "Ambient lux was negative, ignoring and setting to 0");
            lux = 0.0f;
        }
        this.mAmbientLux = lux;
        this.mAmbientBrighteningThreshold = this.mAmbientBrightnessThresholds.getBrighteningThreshold(lux);
        this.mAmbientDarkeningThreshold = this.mAmbientBrightnessThresholds.getDarkeningThreshold(lux);
        if (!this.mShortTermModelValid && this.mShortTermModelAnchor != -1.0f) {
            float minAmbientLux = this.mShortTermModelAnchor - this.mShortTermModelAnchor * this.SHORT_TERM_MODEL_THRESHOLD_RATIO;
            float maxAmbientLux = this.mShortTermModelAnchor + this.mShortTermModelAnchor * this.SHORT_TERM_MODEL_THRESHOLD_RATIO;
            if (minAmbientLux < this.mAmbientLux && this.mAmbientLux < maxAmbientLux) {
                if (this.mLoggingEnabled) {
                    Slog.d(TAG, "ShortTermModel: re-validate user data, ambient lux is " + minAmbientLux + " < " + this.mAmbientLux + " < " + maxAmbientLux);
                }
                this.mShortTermModelValid = true;
            } else {
                Slog.d(TAG, "ShortTermModel: reset data, ambient lux is " + this.mAmbientLux + "(" + minAmbientLux + ", " + maxAmbientLux + ")");
                this.resetShortTermModel();
            }
        }
    }

    private float calculateAmbientLux(long now, long horizon) {
        int N;
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "calculateAmbientLux(" + now + ", " + horizon + ")");
        }
        if ((N = this.mAmbientLightRingBuffer.size()) == 0) {
            Slog.e(TAG, "calculateAmbientLux: No ambient light readings available");
            return -1.0f;
        }
        int endIndex = 0;
        long horizonStartTime = now - horizon;
        for (int i = 0; i < N - 1 && this.mAmbientLightRingBuffer.getTime(i + 1) <= horizonStartTime; ++i) {
            ++endIndex;
        }
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "calculateAmbientLux: selected endIndex=" + endIndex + ", point=(" + this.mAmbientLightRingBuffer.getTime(endIndex) + ", " + this.mAmbientLightRingBuffer.getLux(endIndex) + ")");
        }
        float sum = 0.0f;
        float totalWeight = 0.0f;
        long endTime = 100L;
        for (int i = N - 1; i >= endIndex; --i) {
            long eventTime = this.mAmbientLightRingBuffer.getTime(i);
            if (i == endIndex && eventTime < horizonStartTime) {
                eventTime = horizonStartTime;
            }
            long startTime = eventTime - now;
            float weight = this.calculateWeight(startTime, endTime);
            float lux = this.mAmbientLightRingBuffer.getLux(i);
            if (this.mLoggingEnabled) {
                Slog.d(TAG, "calculateAmbientLux: [" + startTime + ", " + endTime + "]: lux=" + lux + ", weight=" + weight);
            }
            totalWeight += weight;
            sum += lux * weight;
            endTime = startTime;
        }
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "calculateAmbientLux: totalWeight=" + totalWeight + ", newAmbientLux=" + sum / totalWeight);
        }
        return sum / totalWeight;
    }

    private float calculateWeight(long startDelta, long endDelta) {
        return this.weightIntegral(endDelta) - this.weightIntegral(startDelta);
    }

    private float weightIntegral(long x) {
        return (float)x * ((float)x * 0.5f + (float)this.mWeightingIntercept);
    }

    private long nextAmbientLightBrighteningTransition(long time) {
        int N = this.mAmbientLightRingBuffer.size();
        long earliestValidTime = time;
        for (int i = N - 1; i >= 0 && !(this.mAmbientLightRingBuffer.getLux(i) <= this.mAmbientBrighteningThreshold); --i) {
            earliestValidTime = this.mAmbientLightRingBuffer.getTime(i);
        }
        return earliestValidTime + this.mBrighteningLightDebounceConfig;
    }

    private long nextAmbientLightDarkeningTransition(long time) {
        int N = this.mAmbientLightRingBuffer.size();
        long earliestValidTime = time;
        for (int i = N - 1; i >= 0 && !(this.mAmbientLightRingBuffer.getLux(i) >= this.mAmbientDarkeningThreshold); --i) {
            earliestValidTime = this.mAmbientLightRingBuffer.getTime(i);
        }
        return earliestValidTime + this.mDarkeningLightDebounceConfig;
    }

    private void updateAmbientLux() {
        long time = SystemClock.uptimeMillis();
        this.mAmbientLightRingBuffer.prune(time - (long)this.mAmbientLightHorizon);
        this.updateAmbientLux(time);
    }

    private void updateAmbientLux(long time) {
        long nextTransitionTime;
        if (!this.mAmbientLuxValid) {
            long timeWhenSensorWarmedUp = (long)this.mLightSensorWarmUpTimeConfig + this.mLightSensorEnableTime;
            if (time < timeWhenSensorWarmedUp) {
                if (this.mLoggingEnabled) {
                    Slog.d(TAG, "updateAmbientLux: Sensor not ready yet: time=" + time + ", timeWhenSensorWarmedUp=" + timeWhenSensorWarmedUp);
                }
                this.mHandler.sendEmptyMessageAtTime(1, timeWhenSensorWarmedUp);
                return;
            }
            this.setAmbientLux(this.calculateAmbientLux(time, 2000L));
            this.mAmbientLuxValid = true;
            if (this.mLoggingEnabled) {
                Slog.d(TAG, "updateAmbientLux: Initializing: mAmbientLightRingBuffer=" + this.mAmbientLightRingBuffer + ", mAmbientLux=" + this.mAmbientLux);
            }
            this.updateAutoBrightness(true, false);
        }
        long nextBrightenTransition = this.nextAmbientLightBrighteningTransition(time);
        long nextDarkenTransition = this.nextAmbientLightDarkeningTransition(time);
        float slowAmbientLux = this.calculateAmbientLux(time, 10000L);
        float fastAmbientLux = this.calculateAmbientLux(time, 2000L);
        if (slowAmbientLux >= this.mAmbientBrighteningThreshold && fastAmbientLux >= this.mAmbientBrighteningThreshold && nextBrightenTransition <= time || slowAmbientLux <= this.mAmbientDarkeningThreshold && fastAmbientLux <= this.mAmbientDarkeningThreshold && nextDarkenTransition <= time) {
            this.setAmbientLux(fastAmbientLux);
            if (this.mLoggingEnabled) {
                Slog.d(TAG, "updateAmbientLux: " + (fastAmbientLux > this.mAmbientLux ? "Brightened" : "Darkened") + ": mBrighteningLuxThreshold=" + this.mAmbientBrighteningThreshold + ", mAmbientLightRingBuffer=" + this.mAmbientLightRingBuffer + ", mAmbientLux=" + this.mAmbientLux);
            }
            this.updateAutoBrightness(true, false);
            nextBrightenTransition = this.nextAmbientLightBrighteningTransition(time);
            nextDarkenTransition = this.nextAmbientLightDarkeningTransition(time);
        }
        long l = nextTransitionTime = (nextTransitionTime = Math.min(nextDarkenTransition, nextBrightenTransition)) > time ? nextTransitionTime : time + (long)this.mNormalLightSensorRate;
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "updateAmbientLux: Scheduling ambient lux update for " + nextTransitionTime + TimeUtils.formatUptime(nextTransitionTime));
        }
        this.mHandler.sendEmptyMessageAtTime(1, nextTransitionTime);
    }

    private void updateAutoBrightness(boolean sendUpdate, boolean isManuallySet) {
        if (!this.mAmbientLuxValid) {
            return;
        }
        float value = this.mBrightnessMapper.getBrightness(this.mAmbientLux, this.mForegroundAppPackageName, this.mForegroundAppCategory);
        int newScreenAutoBrightness = this.clampScreenBrightness(Math.round(value * 255.0f));
        if (this.mScreenAutoBrightness != -1 && !isManuallySet && (float)newScreenAutoBrightness > this.mScreenDarkeningThreshold && (float)newScreenAutoBrightness < this.mScreenBrighteningThreshold) {
            if (this.mLoggingEnabled) {
                Slog.d(TAG, "ignoring newScreenAutoBrightness: " + this.mScreenDarkeningThreshold + " < " + newScreenAutoBrightness + " < " + this.mScreenBrighteningThreshold);
            }
            return;
        }
        if (this.mScreenAutoBrightness != newScreenAutoBrightness) {
            if (this.mLoggingEnabled) {
                Slog.d(TAG, "updateAutoBrightness: mScreenAutoBrightness=" + this.mScreenAutoBrightness + ", newScreenAutoBrightness=" + newScreenAutoBrightness);
            }
            this.mScreenAutoBrightness = newScreenAutoBrightness;
            this.mScreenBrighteningThreshold = this.mScreenBrightnessThresholds.getBrighteningThreshold(newScreenAutoBrightness);
            this.mScreenDarkeningThreshold = this.mScreenBrightnessThresholds.getDarkeningThreshold(newScreenAutoBrightness);
            if (sendUpdate) {
                this.mCallbacks.updateBrightness();
            }
        }
    }

    private int clampScreenBrightness(int value) {
        return MathUtils.constrain(value, this.mScreenBrightnessRangeMinimum, this.mScreenBrightnessRangeMaximum);
    }

    private void prepareBrightnessAdjustmentSample() {
        if (!this.mBrightnessAdjustmentSamplePending) {
            this.mBrightnessAdjustmentSamplePending = true;
            this.mBrightnessAdjustmentSampleOldLux = this.mAmbientLuxValid ? this.mAmbientLux : -1.0f;
            this.mBrightnessAdjustmentSampleOldBrightness = this.mScreenAutoBrightness;
        } else {
            this.mHandler.removeMessages(2);
        }
        this.mHandler.sendEmptyMessageDelayed(2, 10000L);
    }

    private void cancelBrightnessAdjustmentSample() {
        if (this.mBrightnessAdjustmentSamplePending) {
            this.mBrightnessAdjustmentSamplePending = false;
            this.mHandler.removeMessages(2);
        }
    }

    private void collectBrightnessAdjustmentSample() {
        if (this.mBrightnessAdjustmentSamplePending) {
            this.mBrightnessAdjustmentSamplePending = false;
            if (this.mAmbientLuxValid && this.mScreenAutoBrightness >= 0) {
                if (this.mLoggingEnabled) {
                    Slog.d(TAG, "Auto-brightness adjustment changed by user: lux=" + this.mAmbientLux + ", brightness=" + this.mScreenAutoBrightness + ", ring=" + this.mAmbientLightRingBuffer);
                }
                EventLog.writeEvent(35000, Float.valueOf(this.mBrightnessAdjustmentSampleOldLux), this.mBrightnessAdjustmentSampleOldBrightness, Float.valueOf(this.mAmbientLux), this.mScreenAutoBrightness);
            }
        }
    }

    private void registerForegroundAppUpdater() {
        block2: {
            try {
                this.mActivityTaskManager.registerTaskStackListener(this.mTaskStackListener);
                this.updateForegroundApp();
            }
            catch (RemoteException e) {
                if (!this.mLoggingEnabled) break block2;
                Slog.e(TAG, "Failed to register foreground app updater: " + e);
            }
        }
    }

    private void unregisterForegroundAppUpdater() {
        try {
            this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mForegroundAppPackageName = null;
        this.mForegroundAppCategory = -1;
    }

    private void updateForegroundApp() {
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "Attempting to update foreground app");
        }
        BackgroundThread.getHandler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    ActivityManager.StackInfo info = AutomaticBrightnessController.this.mActivityTaskManager.getFocusedStackInfo();
                    if (info == null || info.topActivity == null) {
                        return;
                    }
                    String packageName = info.topActivity.getPackageName();
                    if (AutomaticBrightnessController.this.mForegroundAppPackageName != null && AutomaticBrightnessController.this.mForegroundAppPackageName.equals(packageName)) {
                        return;
                    }
                    AutomaticBrightnessController.this.mPendingForegroundAppPackageName = packageName;
                    AutomaticBrightnessController.this.mPendingForegroundAppCategory = -1;
                    try {
                        ApplicationInfo app = AutomaticBrightnessController.this.mPackageManager.getApplicationInfo(packageName, 0x400000);
                        AutomaticBrightnessController.this.mPendingForegroundAppCategory = app.category;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                    AutomaticBrightnessController.this.mHandler.sendEmptyMessage(5);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
    }

    private void updateForegroundAppSync() {
        if (this.mLoggingEnabled) {
            Slog.d(TAG, "Updating foreground app: packageName=" + this.mPendingForegroundAppPackageName + ", category=" + this.mPendingForegroundAppCategory);
        }
        this.mForegroundAppPackageName = this.mPendingForegroundAppPackageName;
        this.mPendingForegroundAppPackageName = null;
        this.mForegroundAppCategory = this.mPendingForegroundAppCategory;
        this.mPendingForegroundAppCategory = -1;
        this.updateAutoBrightness(true, false);
    }

    private static final class AmbientLightRingBuffer {
        private static final float BUFFER_SLACK = 1.5f;
        private float[] mRingLux;
        private long[] mRingTime;
        private int mCapacity;
        private int mStart;
        private int mEnd;
        private int mCount;

        public AmbientLightRingBuffer(long lightSensorRate, int ambientLightHorizon) {
            this.mCapacity = (int)Math.ceil((float)ambientLightHorizon * 1.5f / (float)lightSensorRate);
            this.mRingLux = new float[this.mCapacity];
            this.mRingTime = new long[this.mCapacity];
        }

        public float getLux(int index) {
            return this.mRingLux[this.offsetOf(index)];
        }

        public long getTime(int index) {
            return this.mRingTime[this.offsetOf(index)];
        }

        public void push(long time, float lux) {
            int next = this.mEnd;
            if (this.mCount == this.mCapacity) {
                int newSize = this.mCapacity * 2;
                float[] newRingLux = new float[newSize];
                long[] newRingTime = new long[newSize];
                int length = this.mCapacity - this.mStart;
                System.arraycopy(this.mRingLux, this.mStart, newRingLux, 0, length);
                System.arraycopy(this.mRingTime, this.mStart, newRingTime, 0, length);
                if (this.mStart != 0) {
                    System.arraycopy(this.mRingLux, 0, newRingLux, length, this.mStart);
                    System.arraycopy(this.mRingTime, 0, newRingTime, length, this.mStart);
                }
                this.mRingLux = newRingLux;
                this.mRingTime = newRingTime;
                next = this.mCapacity;
                this.mCapacity = newSize;
                this.mStart = 0;
            }
            this.mRingTime[next] = time;
            this.mRingLux[next] = lux;
            this.mEnd = next + 1;
            if (this.mEnd == this.mCapacity) {
                this.mEnd = 0;
            }
            ++this.mCount;
        }

        public void prune(long horizon) {
            if (this.mCount == 0) {
                return;
            }
            while (this.mCount > 1) {
                int next = this.mStart + 1;
                if (next >= this.mCapacity) {
                    next -= this.mCapacity;
                }
                if (this.mRingTime[next] > horizon) break;
                this.mStart = next;
                --this.mCount;
            }
            if (this.mRingTime[this.mStart] < horizon) {
                this.mRingTime[this.mStart] = horizon;
            }
        }

        public int size() {
            return this.mCount;
        }

        public void clear() {
            this.mStart = 0;
            this.mEnd = 0;
            this.mCount = 0;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            for (int i = 0; i < this.mCount; ++i) {
                long next;
                long l = next = i + 1 < this.mCount ? this.getTime(i + 1) : SystemClock.uptimeMillis();
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(this.getLux(i));
                buf.append(" / ");
                buf.append(next - this.getTime(i));
                buf.append("ms");
            }
            buf.append(']');
            return buf.toString();
        }

        private int offsetOf(int index) {
            if (index >= this.mCount || index < 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            if ((index += this.mStart) >= this.mCapacity) {
                index -= this.mCapacity;
            }
            return index;
        }
    }

    static interface Callbacks {
        public void updateBrightness();
    }

    class TaskStackListenerImpl
    extends TaskStackListener {
        TaskStackListenerImpl() {
        }

        @Override
        public void onTaskStackChanged() {
            AutomaticBrightnessController.this.mHandler.sendEmptyMessage(4);
        }
    }

    private final class AutomaticBrightnessHandler
    extends Handler {
        public AutomaticBrightnessHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AutomaticBrightnessController.this.updateAmbientLux();
                    break;
                }
                case 2: {
                    AutomaticBrightnessController.this.collectBrightnessAdjustmentSample();
                    break;
                }
                case 3: {
                    AutomaticBrightnessController.this.invalidateShortTermModel();
                    break;
                }
                case 4: {
                    AutomaticBrightnessController.this.updateForegroundApp();
                    break;
                }
                case 5: {
                    AutomaticBrightnessController.this.updateForegroundAppSync();
                }
            }
        }
    }
}

