/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ParceledListSlice;
import android.database.ContentObserver;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.display.AmbientBrightnessDayStats;
import android.hardware.display.BrightnessChangeEvent;
import android.hardware.display.ColorDisplayManager;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerInternal;
import android.hardware.display.DisplayedContentSample;
import android.hardware.display.DisplayedContentSamplingAttributes;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserManager;
import android.provider.Settings;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import android.view.Display;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.RingBuffer;
import com.android.server.LocalServices;
import com.android.server.display.AmbientBrightnessStatsTracker;
import com.android.server.display.BrightnessIdleJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BrightnessTracker {
    static final String TAG = "BrightnessTracker";
    static final boolean DEBUG = false;
    private static final String EVENTS_FILE = "brightness_events.xml";
    private static final String AMBIENT_BRIGHTNESS_STATS_FILE = "ambient_brightness_stats.xml";
    private static final int MAX_EVENTS = 100;
    private static final long MAX_EVENT_AGE = TimeUnit.DAYS.toMillis(30L);
    private static final long LUX_EVENT_HORIZON = TimeUnit.SECONDS.toNanos(10L);
    private static final String TAG_EVENTS = "events";
    private static final String TAG_EVENT = "event";
    private static final String ATTR_NITS = "nits";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_PACKAGE_NAME = "packageName";
    private static final String ATTR_USER = "user";
    private static final String ATTR_LUX = "lux";
    private static final String ATTR_LUX_TIMESTAMPS = "luxTimestamps";
    private static final String ATTR_BATTERY_LEVEL = "batteryLevel";
    private static final String ATTR_NIGHT_MODE = "nightMode";
    private static final String ATTR_COLOR_TEMPERATURE = "colorTemperature";
    private static final String ATTR_LAST_NITS = "lastNits";
    private static final String ATTR_DEFAULT_CONFIG = "defaultConfig";
    private static final String ATTR_POWER_SAVE = "powerSaveFactor";
    private static final String ATTR_USER_POINT = "userPoint";
    private static final String ATTR_COLOR_SAMPLE_DURATION = "colorSampleDuration";
    private static final String ATTR_COLOR_VALUE_BUCKETS = "colorValueBuckets";
    private static final int MSG_BACKGROUND_START = 0;
    private static final int MSG_BRIGHTNESS_CHANGED = 1;
    private static final int MSG_STOP_SENSOR_LISTENER = 2;
    private static final int MSG_START_SENSOR_LISTENER = 3;
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
    private static final long COLOR_SAMPLE_DURATION = TimeUnit.SECONDS.toSeconds(10L);
    private static final int COLOR_SAMPLE_COMPONENT_MASK = 4;
    private final Object mEventsLock = new Object();
    @GuardedBy(value={"mEventsLock"})
    private RingBuffer<BrightnessChangeEvent> mEvents = new RingBuffer<BrightnessChangeEvent>(BrightnessChangeEvent.class, 100);
    @GuardedBy(value={"mEventsLock"})
    private boolean mEventsDirty;
    private volatile boolean mWriteBrightnessTrackerStateScheduled;
    private AmbientBrightnessStatsTracker mAmbientBrightnessStatsTracker;
    private final UserManager mUserManager;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final Handler mBgHandler;
    private BroadcastReceiver mBroadcastReceiver;
    private SensorListener mSensorListener;
    private SettingsObserver mSettingsObserver;
    private DisplayListener mDisplayListener;
    private boolean mSensorRegistered;
    private boolean mColorSamplingEnabled;
    private int mNoFramesToSample;
    private float mFrameRate;
    private int mCurrentUserId = -10000;
    private final Object mDataCollectionLock = new Object();
    @GuardedBy(value={"mDataCollectionLock"})
    private Deque<LightData> mLastSensorReadings = new ArrayDeque<LightData>();
    @GuardedBy(value={"mDataCollectionLock"})
    private float mLastBatteryLevel = Float.NaN;
    @GuardedBy(value={"mDataCollectionLock"})
    private float mLastBrightness = -1.0f;
    @GuardedBy(value={"mDataCollectionLock"})
    private boolean mStarted;
    private final Injector mInjector;

    public BrightnessTracker(Context context, Injector injector) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mInjector = injector != null ? injector : new Injector();
        this.mBgHandler = new TrackerHandler(this.mInjector.getBackgroundHandler().getLooper());
        this.mUserManager = this.mContext.getSystemService(UserManager.class);
    }

    public void start(float initialBrightness) {
        this.mCurrentUserId = ActivityManager.getCurrentUser();
        this.mBgHandler.obtainMessage(0, Float.valueOf(initialBrightness)).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundStart(float initialBrightness) {
        this.readEvents();
        this.readAmbientBrightnessStats();
        this.mSensorListener = new SensorListener();
        this.mSettingsObserver = new SettingsObserver(this.mBgHandler);
        this.mInjector.registerBrightnessModeObserver(this.mContentResolver, this.mSettingsObserver);
        this.startSensorListener();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.ACTION_SHUTDOWN");
        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        this.mBroadcastReceiver = new Receiver();
        this.mInjector.registerReceiver(this.mContext, this.mBroadcastReceiver, intentFilter);
        this.mInjector.scheduleIdleJob(this.mContext);
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            this.mLastBrightness = initialBrightness;
            this.mStarted = true;
        }
        this.enableColorSampling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void stop() {
        this.mBgHandler.removeMessages(0);
        this.stopSensorListener();
        this.mInjector.unregisterSensorListener(this.mContext, this.mSensorListener);
        this.mInjector.unregisterBrightnessModeObserver(this.mContext, this.mSettingsObserver);
        this.mInjector.unregisterReceiver(this.mContext, this.mBroadcastReceiver);
        this.mInjector.cancelIdleJob(this.mContext);
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            this.mStarted = false;
        }
        this.disableColorSampling();
    }

    public void onSwitchUser(int newUserId) {
        this.mCurrentUserId = newUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParceledListSlice<BrightnessChangeEvent> getEvents(int userId, boolean includePackage) {
        BrightnessChangeEvent[] events;
        Object object = this.mEventsLock;
        synchronized (object) {
            events = this.mEvents.toArray();
        }
        int[] profiles = this.mInjector.getProfileIds(this.mUserManager, userId);
        HashMap<Integer, Boolean> toRedact = new HashMap<Integer, Boolean>();
        for (int i = 0; i < profiles.length; ++i) {
            int profileId = profiles[i];
            boolean redact = !includePackage || profileId != userId;
            toRedact.put(profiles[i], redact);
        }
        ArrayList<BrightnessChangeEvent> out = new ArrayList<BrightnessChangeEvent>(events.length);
        for (int i = 0; i < events.length; ++i) {
            Boolean redact = (Boolean)toRedact.get(events[i].userId);
            if (redact == null) continue;
            if (!redact.booleanValue()) {
                out.add(events[i]);
                continue;
            }
            BrightnessChangeEvent event = new BrightnessChangeEvent(events[i], true);
            out.add(event);
        }
        return new ParceledListSlice<BrightnessChangeEvent>(out);
    }

    public void persistBrightnessTrackerState() {
        this.scheduleWriteBrightnessTrackerState();
    }

    public void notifyBrightnessChanged(float brightness, boolean userInitiated, float powerBrightnessFactor, boolean isUserSetBrightness, boolean isDefaultBrightnessConfig) {
        Message m = this.mBgHandler.obtainMessage(1, userInitiated ? 1 : 0, 0, new BrightnessChangeValues(brightness, powerBrightnessFactor, isUserSetBrightness, isDefaultBrightnessConfig, this.mInjector.currentTimeMillis()));
        m.sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBrightnessChanged(float brightness, boolean userInitiated, float powerBrightnessFactor, boolean isUserSetBrightness, boolean isDefaultBrightnessConfig, long timestamp) {
        DisplayedContentSample sample;
        BrightnessChangeEvent.Builder builder;
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            if (!this.mStarted) {
                return;
            }
            float previousBrightness = this.mLastBrightness;
            this.mLastBrightness = brightness;
            if (!userInitiated) {
                return;
            }
            builder = new BrightnessChangeEvent.Builder();
            builder.setBrightness(brightness);
            builder.setTimeStamp(timestamp);
            builder.setPowerBrightnessFactor(powerBrightnessFactor);
            builder.setUserBrightnessPoint(isUserSetBrightness);
            builder.setIsDefaultBrightnessConfig(isDefaultBrightnessConfig);
            int readingCount = this.mLastSensorReadings.size();
            if (readingCount == 0) {
                return;
            }
            float[] luxValues = new float[readingCount];
            long[] luxTimestamps = new long[readingCount];
            int pos = 0;
            long currentTimeMillis = this.mInjector.currentTimeMillis();
            long elapsedTimeNanos = this.mInjector.elapsedRealtimeNanos();
            for (LightData reading : this.mLastSensorReadings) {
                luxValues[pos] = reading.lux;
                luxTimestamps[pos] = currentTimeMillis - TimeUnit.NANOSECONDS.toMillis(elapsedTimeNanos - reading.timestamp);
                ++pos;
            }
            builder.setLuxValues(luxValues);
            builder.setLuxTimestamps(luxTimestamps);
            builder.setBatteryLevel(this.mLastBatteryLevel);
            builder.setLastBrightness(previousBrightness);
        }
        try {
            ActivityManager.StackInfo focusedStack = this.mInjector.getFocusedStack();
            if (focusedStack == null || focusedStack.topActivity == null) {
                return;
            }
            builder.setUserId(focusedStack.userId);
            builder.setPackageName(focusedStack.topActivity.getPackageName());
        }
        catch (RemoteException e) {
            return;
        }
        builder.setNightMode(this.mInjector.isNightDisplayActivated(this.mContext));
        builder.setColorTemperature(this.mInjector.getNightDisplayColorTemperature(this.mContext));
        if (this.mColorSamplingEnabled && (sample = this.mInjector.sampleColor(this.mNoFramesToSample)) != null && sample.getSampleComponent(DisplayedContentSample.ColorComponent.CHANNEL2) != null) {
            float numMillis = (float)sample.getNumFrames() / this.mFrameRate * 1000.0f;
            builder.setColorValues(sample.getSampleComponent(DisplayedContentSample.ColorComponent.CHANNEL2), Math.round(numMillis));
        }
        BrightnessChangeEvent event = builder.build();
        Object object2 = this.mEventsLock;
        synchronized (object2) {
            this.mEventsDirty = true;
            this.mEvents.append(event);
        }
    }

    private void startSensorListener() {
        if (!this.mSensorRegistered && this.mInjector.isInteractive(this.mContext) && this.mInjector.isBrightnessModeAutomatic(this.mContentResolver)) {
            this.mAmbientBrightnessStatsTracker.start();
            this.mSensorRegistered = true;
            this.mInjector.registerSensorListener(this.mContext, this.mSensorListener, this.mInjector.getBackgroundHandler());
        }
    }

    private void stopSensorListener() {
        if (this.mSensorRegistered) {
            this.mAmbientBrightnessStatsTracker.stop();
            this.mInjector.unregisterSensorListener(this.mContext, this.mSensorListener);
            this.mSensorRegistered = false;
        }
    }

    private void scheduleWriteBrightnessTrackerState() {
        if (!this.mWriteBrightnessTrackerStateScheduled) {
            this.mBgHandler.post(() -> {
                this.mWriteBrightnessTrackerStateScheduled = false;
                this.writeEvents();
                this.writeAmbientBrightnessStats();
            });
            this.mWriteBrightnessTrackerStateScheduled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEvents() {
        Object object = this.mEventsLock;
        synchronized (object) {
            if (!this.mEventsDirty) {
                return;
            }
            AtomicFile writeTo = this.mInjector.getFile(EVENTS_FILE);
            if (writeTo == null) {
                return;
            }
            if (this.mEvents.isEmpty()) {
                if (writeTo.exists()) {
                    writeTo.delete();
                }
                this.mEventsDirty = false;
            } else {
                FileOutputStream output = null;
                try {
                    output = writeTo.startWrite();
                    this.writeEventsLocked(output);
                    writeTo.finishWrite(output);
                    this.mEventsDirty = false;
                }
                catch (IOException e) {
                    writeTo.failWrite(output);
                    Slog.e(TAG, "Failed to write change mEvents.", e);
                }
            }
        }
    }

    private void writeAmbientBrightnessStats() {
        AtomicFile writeTo = this.mInjector.getFile(AMBIENT_BRIGHTNESS_STATS_FILE);
        if (writeTo == null) {
            return;
        }
        FileOutputStream output = null;
        try {
            output = writeTo.startWrite();
            this.mAmbientBrightnessStatsTracker.writeStats(output);
            writeTo.finishWrite(output);
        }
        catch (IOException e) {
            writeTo.failWrite(output);
            Slog.e(TAG, "Failed to write ambient brightness stats.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEvents() {
        Object object = this.mEventsLock;
        synchronized (object) {
            this.mEventsDirty = true;
            this.mEvents.clear();
            AtomicFile readFrom = this.mInjector.getFile(EVENTS_FILE);
            if (readFrom != null && readFrom.exists()) {
                FileInputStream input = null;
                try {
                    input = readFrom.openRead();
                    this.readEventsLocked(input);
                }
                catch (IOException e) {
                    readFrom.delete();
                    Slog.e(TAG, "Failed to read change mEvents.", e);
                }
                finally {
                    IoUtils.closeQuietly(input);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAmbientBrightnessStats() {
        this.mAmbientBrightnessStatsTracker = new AmbientBrightnessStatsTracker(this.mUserManager, null);
        AtomicFile readFrom = this.mInjector.getFile(AMBIENT_BRIGHTNESS_STATS_FILE);
        if (readFrom != null && readFrom.exists()) {
            FileInputStream input = null;
            try {
                input = readFrom.openRead();
                this.mAmbientBrightnessStatsTracker.readStats(input);
            }
            catch (IOException e) {
                readFrom.delete();
                Slog.e(TAG, "Failed to read ambient brightness stats.", e);
            }
            finally {
                IoUtils.closeQuietly(input);
            }
        }
    }

    @VisibleForTesting
    @GuardedBy(value={"mEventsLock"})
    void writeEventsLocked(OutputStream stream) throws IOException {
        FastXmlSerializer out = new FastXmlSerializer();
        out.setOutput(stream, StandardCharsets.UTF_8.name());
        out.startDocument(null, true);
        out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        out.startTag(null, TAG_EVENTS);
        BrightnessChangeEvent[] toWrite = this.mEvents.toArray();
        this.mEvents.clear();
        long timeCutOff = this.mInjector.currentTimeMillis() - MAX_EVENT_AGE;
        for (int i = 0; i < toWrite.length; ++i) {
            int userSerialNo = this.mInjector.getUserSerialNumber(this.mUserManager, toWrite[i].userId);
            if (userSerialNo == -1 || toWrite[i].timeStamp <= timeCutOff) continue;
            this.mEvents.append(toWrite[i]);
            out.startTag(null, TAG_EVENT);
            out.attribute(null, ATTR_NITS, Float.toString(toWrite[i].brightness));
            out.attribute(null, ATTR_TIMESTAMP, Long.toString(toWrite[i].timeStamp));
            out.attribute(null, ATTR_PACKAGE_NAME, toWrite[i].packageName);
            out.attribute(null, ATTR_USER, Integer.toString(userSerialNo));
            out.attribute(null, ATTR_BATTERY_LEVEL, Float.toString(toWrite[i].batteryLevel));
            out.attribute(null, ATTR_NIGHT_MODE, Boolean.toString(toWrite[i].nightMode));
            out.attribute(null, ATTR_COLOR_TEMPERATURE, Integer.toString(toWrite[i].colorTemperature));
            out.attribute(null, ATTR_LAST_NITS, Float.toString(toWrite[i].lastBrightness));
            out.attribute(null, ATTR_DEFAULT_CONFIG, Boolean.toString(toWrite[i].isDefaultBrightnessConfig));
            out.attribute(null, ATTR_POWER_SAVE, Float.toString(toWrite[i].powerBrightnessFactor));
            out.attribute(null, ATTR_USER_POINT, Boolean.toString(toWrite[i].isUserSetBrightness));
            StringBuilder luxValues = new StringBuilder();
            StringBuilder luxTimestamps = new StringBuilder();
            for (int j = 0; j < toWrite[i].luxValues.length; ++j) {
                if (j > 0) {
                    luxValues.append(',');
                    luxTimestamps.append(',');
                }
                luxValues.append(Float.toString(toWrite[i].luxValues[j]));
                luxTimestamps.append(Long.toString(toWrite[i].luxTimestamps[j]));
            }
            out.attribute(null, ATTR_LUX, luxValues.toString());
            out.attribute(null, ATTR_LUX_TIMESTAMPS, luxTimestamps.toString());
            if (toWrite[i].colorValueBuckets != null && toWrite[i].colorValueBuckets.length > 0) {
                out.attribute(null, ATTR_COLOR_SAMPLE_DURATION, Long.toString(toWrite[i].colorSampleDuration));
                StringBuilder buckets = new StringBuilder();
                for (int j = 0; j < toWrite[i].colorValueBuckets.length; ++j) {
                    if (j > 0) {
                        buckets.append(',');
                    }
                    buckets.append(Long.toString(toWrite[i].colorValueBuckets[j]));
                }
                out.attribute(null, ATTR_COLOR_VALUE_BUCKETS, buckets.toString());
            }
            out.endTag(null, TAG_EVENT);
        }
        out.endTag(null, TAG_EVENTS);
        out.endDocument();
        stream.flush();
    }

    @VisibleForTesting
    @GuardedBy(value={"mEventsLock"})
    void readEventsLocked(InputStream stream) throws IOException {
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String tag = parser.getName();
            if (!TAG_EVENTS.equals(tag)) {
                throw new XmlPullParserException("Events not found in brightness tracker file " + tag);
            }
            long timeCutOff = this.mInjector.currentTimeMillis() - MAX_EVENT_AGE;
            parser.next();
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                String powerSave;
                if (type == 3 || type == 4 || !TAG_EVENT.equals(tag = parser.getName())) continue;
                BrightnessChangeEvent.Builder builder = new BrightnessChangeEvent.Builder();
                String brightness = parser.getAttributeValue(null, ATTR_NITS);
                builder.setBrightness(Float.parseFloat(brightness));
                String timestamp = parser.getAttributeValue(null, ATTR_TIMESTAMP);
                builder.setTimeStamp(Long.parseLong(timestamp));
                builder.setPackageName(parser.getAttributeValue(null, ATTR_PACKAGE_NAME));
                String user = parser.getAttributeValue(null, ATTR_USER);
                builder.setUserId(this.mInjector.getUserId(this.mUserManager, Integer.parseInt(user)));
                String batteryLevel = parser.getAttributeValue(null, ATTR_BATTERY_LEVEL);
                builder.setBatteryLevel(Float.parseFloat(batteryLevel));
                String nightMode = parser.getAttributeValue(null, ATTR_NIGHT_MODE);
                builder.setNightMode(Boolean.parseBoolean(nightMode));
                String colorTemperature = parser.getAttributeValue(null, ATTR_COLOR_TEMPERATURE);
                builder.setColorTemperature(Integer.parseInt(colorTemperature));
                String lastBrightness = parser.getAttributeValue(null, ATTR_LAST_NITS);
                builder.setLastBrightness(Float.parseFloat(lastBrightness));
                String luxValue = parser.getAttributeValue(null, ATTR_LUX);
                String luxTimestamp = parser.getAttributeValue(null, ATTR_LUX_TIMESTAMPS);
                String[] luxValuesStrings = luxValue.split(",");
                String[] luxTimestampsStrings = luxTimestamp.split(",");
                if (luxValuesStrings.length != luxTimestampsStrings.length) continue;
                float[] luxValues = new float[luxValuesStrings.length];
                long[] luxTimestamps = new long[luxValuesStrings.length];
                for (int i = 0; i < luxValues.length; ++i) {
                    luxValues[i] = Float.parseFloat(luxValuesStrings[i]);
                    luxTimestamps[i] = Long.parseLong(luxTimestampsStrings[i]);
                }
                builder.setLuxValues(luxValues);
                builder.setLuxTimestamps(luxTimestamps);
                String defaultConfig = parser.getAttributeValue(null, ATTR_DEFAULT_CONFIG);
                if (defaultConfig != null) {
                    builder.setIsDefaultBrightnessConfig(Boolean.parseBoolean(defaultConfig));
                }
                if ((powerSave = parser.getAttributeValue(null, ATTR_POWER_SAVE)) != null) {
                    builder.setPowerBrightnessFactor(Float.parseFloat(powerSave));
                } else {
                    builder.setPowerBrightnessFactor(1.0f);
                }
                String userPoint = parser.getAttributeValue(null, ATTR_USER_POINT);
                if (userPoint != null) {
                    builder.setUserBrightnessPoint(Boolean.parseBoolean(userPoint));
                }
                String colorSampleDurationString = parser.getAttributeValue(null, ATTR_COLOR_SAMPLE_DURATION);
                String colorValueBucketsString = parser.getAttributeValue(null, ATTR_COLOR_VALUE_BUCKETS);
                if (colorSampleDurationString != null && colorValueBucketsString != null) {
                    long colorSampleDuration = Long.parseLong(colorSampleDurationString);
                    String[] buckets = colorValueBucketsString.split(",");
                    long[] bucketValues = new long[buckets.length];
                    for (int i = 0; i < bucketValues.length; ++i) {
                        bucketValues[i] = Long.parseLong(buckets[i]);
                    }
                    builder.setColorValues(bucketValues, colorSampleDuration);
                }
                BrightnessChangeEvent event = builder.build();
                if (event.userId == -1 || event.timeStamp <= timeCutOff || event.luxValues.length <= 0) continue;
                this.mEvents.append(event);
            }
        }
        catch (IOException | NullPointerException | NumberFormatException | XmlPullParserException e) {
            this.mEvents = new RingBuffer<BrightnessChangeEvent>(BrightnessChangeEvent.class, 100);
            Slog.e(TAG, "Failed to parse brightness event", e);
            throw new IOException("failed to parse file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        pw.println("BrightnessTracker state:");
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            pw.println("  mStarted=" + this.mStarted);
            pw.println("  mLastBatteryLevel=" + this.mLastBatteryLevel);
            pw.println("  mLastBrightness=" + this.mLastBrightness);
            pw.println("  mLastSensorReadings.size=" + this.mLastSensorReadings.size());
            if (!this.mLastSensorReadings.isEmpty()) {
                pw.println("  mLastSensorReadings time span " + this.mLastSensorReadings.peekFirst().timestamp + "->" + this.mLastSensorReadings.peekLast().timestamp);
            }
        }
        object = this.mEventsLock;
        synchronized (object) {
            pw.println("  mEventsDirty=" + this.mEventsDirty);
            pw.println("  mEvents.size=" + this.mEvents.size());
            BrightnessChangeEvent[] events = this.mEvents.toArray();
            for (int i = 0; i < events.length; ++i) {
                pw.print("    " + FORMAT.format(new Date(events[i].timeStamp)));
                pw.print(", userId=" + events[i].userId);
                pw.print(", " + events[i].lastBrightness + "->" + events[i].brightness);
                pw.print(", isUserSetBrightness=" + events[i].isUserSetBrightness);
                pw.print(", powerBrightnessFactor=" + events[i].powerBrightnessFactor);
                pw.print(", isDefaultBrightnessConfig=" + events[i].isDefaultBrightnessConfig);
                pw.print(" {");
                for (int j = 0; j < events[i].luxValues.length; ++j) {
                    if (j != 0) {
                        pw.print(", ");
                    }
                    pw.print("(" + events[i].luxValues[j] + "," + events[i].luxTimestamps[j] + ")");
                }
                pw.println("}");
            }
        }
        pw.println("  mWriteBrightnessTrackerStateScheduled=" + this.mWriteBrightnessTrackerStateScheduled);
        this.mBgHandler.runWithScissors(() -> this.dumpLocal(pw), 1000L);
        if (this.mAmbientBrightnessStatsTracker != null) {
            pw.println();
            this.mAmbientBrightnessStatsTracker.dump(pw);
        }
    }

    private void dumpLocal(PrintWriter pw) {
        pw.println("  mSensorRegistered=" + this.mSensorRegistered);
        pw.println("  mColorSamplingEnabled=" + this.mColorSamplingEnabled);
        pw.println("  mNoFramesToSample=" + this.mNoFramesToSample);
        pw.println("  mFrameRate=" + this.mFrameRate);
    }

    private void enableColorSampling() {
        if (!this.mInjector.isBrightnessModeAutomatic(this.mContentResolver) || !this.mInjector.isInteractive(this.mContext) || this.mColorSamplingEnabled) {
            return;
        }
        this.mFrameRate = this.mInjector.getFrameRate(this.mContext);
        if (this.mFrameRate <= 0.0f) {
            Slog.wtf(TAG, "Default display has a zero or negative framerate.");
            return;
        }
        this.mNoFramesToSample = (int)(this.mFrameRate * (float)COLOR_SAMPLE_DURATION);
        DisplayedContentSamplingAttributes attributes = this.mInjector.getSamplingAttributes();
        if (attributes != null && attributes.getPixelFormat() == 55 && (attributes.getComponentMask() & 4) != 0) {
            this.mColorSamplingEnabled = this.mInjector.enableColorSampling(true, this.mNoFramesToSample);
        }
        if (this.mColorSamplingEnabled && this.mDisplayListener == null) {
            this.mDisplayListener = new DisplayListener();
            this.mInjector.registerDisplayListener(this.mContext, this.mDisplayListener, this.mBgHandler);
        }
    }

    private void disableColorSampling() {
        if (!this.mColorSamplingEnabled) {
            return;
        }
        this.mInjector.enableColorSampling(false, 0);
        this.mColorSamplingEnabled = false;
        if (this.mDisplayListener != null) {
            this.mInjector.unRegisterDisplayListener(this.mContext, this.mDisplayListener);
            this.mDisplayListener = null;
        }
    }

    private void updateColorSampling() {
        if (!this.mColorSamplingEnabled) {
            return;
        }
        float frameRate = this.mInjector.getFrameRate(this.mContext);
        if (frameRate != this.mFrameRate) {
            this.disableColorSampling();
            this.enableColorSampling();
        }
    }

    public ParceledListSlice<AmbientBrightnessDayStats> getAmbientBrightnessStats(int userId) {
        ArrayList<AmbientBrightnessDayStats> stats;
        if (this.mAmbientBrightnessStatsTracker != null && (stats = this.mAmbientBrightnessStatsTracker.getUserStats(userId)) != null) {
            return new ParceledListSlice<AmbientBrightnessDayStats>(stats);
        }
        return ParceledListSlice.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSensorEvent(SensorEvent event) {
        long horizon = this.mInjector.elapsedRealtimeNanos() - LUX_EVENT_HORIZON;
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            if (!this.mLastSensorReadings.isEmpty() && event.timestamp < this.mLastSensorReadings.getLast().timestamp) {
                return;
            }
            LightData data = null;
            while (!this.mLastSensorReadings.isEmpty() && this.mLastSensorReadings.getFirst().timestamp < horizon) {
                data = this.mLastSensorReadings.removeFirst();
            }
            if (data != null) {
                this.mLastSensorReadings.addFirst(data);
            }
            data = new LightData();
            data.timestamp = event.timestamp;
            data.lux = event.values[0];
            this.mLastSensorReadings.addLast(data);
        }
    }

    private void recordAmbientBrightnessStats(SensorEvent event) {
        this.mAmbientBrightnessStatsTracker.add(this.mCurrentUserId, event.values[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batteryLevelChanged(int level, int scale) {
        Object object = this.mDataCollectionLock;
        synchronized (object) {
            this.mLastBatteryLevel = (float)level / (float)scale;
        }
    }

    @VisibleForTesting
    static class Injector {
        Injector() {
        }

        public void registerSensorListener(Context context, SensorEventListener sensorListener, Handler handler) {
            SensorManager sensorManager = context.getSystemService(SensorManager.class);
            Sensor lightSensor = sensorManager.getDefaultSensor(5);
            sensorManager.registerListener(sensorListener, lightSensor, 3, handler);
        }

        public void unregisterSensorListener(Context context, SensorEventListener sensorListener) {
            SensorManager sensorManager = context.getSystemService(SensorManager.class);
            sensorManager.unregisterListener(sensorListener);
        }

        public void registerBrightnessModeObserver(ContentResolver resolver, ContentObserver settingsObserver) {
            resolver.registerContentObserver(Settings.System.getUriFor("screen_brightness_mode"), false, settingsObserver, -1);
        }

        public void unregisterBrightnessModeObserver(Context context, ContentObserver settingsObserver) {
            context.getContentResolver().unregisterContentObserver(settingsObserver);
        }

        public void registerReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
            context.registerReceiver(receiver, filter);
        }

        public void unregisterReceiver(Context context, BroadcastReceiver receiver) {
            context.unregisterReceiver(receiver);
        }

        public Handler getBackgroundHandler() {
            return BackgroundThread.getHandler();
        }

        public boolean isBrightnessModeAutomatic(ContentResolver resolver) {
            return Settings.System.getIntForUser(resolver, "screen_brightness_mode", 0, -2) == 1;
        }

        public int getSecureIntForUser(ContentResolver resolver, String setting, int defaultValue, int userId) {
            return Settings.Secure.getIntForUser(resolver, setting, defaultValue, userId);
        }

        public AtomicFile getFile(String filename) {
            return new AtomicFile(new File(Environment.getDataSystemDeDirectory(), filename));
        }

        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        public long elapsedRealtimeNanos() {
            return SystemClock.elapsedRealtimeNanos();
        }

        public int getUserSerialNumber(UserManager userManager, int userId) {
            return userManager.getUserSerialNumber(userId);
        }

        public int getUserId(UserManager userManager, int userSerialNumber) {
            return userManager.getUserHandle(userSerialNumber);
        }

        public int[] getProfileIds(UserManager userManager, int userId) {
            if (userManager != null) {
                return userManager.getProfileIds(userId, false);
            }
            return new int[]{userId};
        }

        public ActivityManager.StackInfo getFocusedStack() throws RemoteException {
            return ActivityTaskManager.getService().getFocusedStackInfo();
        }

        public void scheduleIdleJob(Context context) {
            BrightnessIdleJob.scheduleJob(context);
        }

        public void cancelIdleJob(Context context) {
            BrightnessIdleJob.cancelJob(context);
        }

        public boolean isInteractive(Context context) {
            return context.getSystemService(PowerManager.class).isInteractive();
        }

        public int getNightDisplayColorTemperature(Context context) {
            return context.getSystemService(ColorDisplayManager.class).getNightDisplayColorTemperature();
        }

        public boolean isNightDisplayActivated(Context context) {
            return context.getSystemService(ColorDisplayManager.class).isNightDisplayActivated();
        }

        public DisplayedContentSample sampleColor(int noFramesToSample) {
            DisplayManagerInternal displayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
            return displayManagerInternal.getDisplayedContentSample(0, noFramesToSample, 0L);
        }

        public float getFrameRate(Context context) {
            DisplayManager displayManager = context.getSystemService(DisplayManager.class);
            Display display = displayManager.getDisplay(0);
            return display.getRefreshRate();
        }

        public DisplayedContentSamplingAttributes getSamplingAttributes() {
            DisplayManagerInternal displayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
            return displayManagerInternal.getDisplayedContentSamplingAttributes(0);
        }

        public boolean enableColorSampling(boolean enable, int noFrames) {
            DisplayManagerInternal displayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
            return displayManagerInternal.setDisplayedContentSamplingEnabled(0, enable, 4, noFrames);
        }

        public void registerDisplayListener(Context context, DisplayManager.DisplayListener listener, Handler handler) {
            DisplayManager displayManager = context.getSystemService(DisplayManager.class);
            displayManager.registerDisplayListener(listener, handler);
        }

        public void unRegisterDisplayListener(Context context, DisplayManager.DisplayListener listener) {
            DisplayManager displayManager = context.getSystemService(DisplayManager.class);
            displayManager.unregisterDisplayListener(listener);
        }
    }

    private static class BrightnessChangeValues {
        final float brightness;
        final float powerBrightnessFactor;
        final boolean isUserSetBrightness;
        final boolean isDefaultBrightnessConfig;
        final long timestamp;

        BrightnessChangeValues(float brightness, float powerBrightnessFactor, boolean isUserSetBrightness, boolean isDefaultBrightnessConfig, long timestamp) {
            this.brightness = brightness;
            this.powerBrightnessFactor = powerBrightnessFactor;
            this.isUserSetBrightness = isUserSetBrightness;
            this.isDefaultBrightnessConfig = isDefaultBrightnessConfig;
            this.timestamp = timestamp;
        }
    }

    private final class TrackerHandler
    extends Handler {
        public TrackerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    BrightnessTracker.this.backgroundStart(((Float)msg.obj).floatValue());
                    break;
                }
                case 1: {
                    BrightnessChangeValues values = (BrightnessChangeValues)msg.obj;
                    boolean userInitiatedChange = msg.arg1 == 1;
                    BrightnessTracker.this.handleBrightnessChanged(values.brightness, userInitiatedChange, values.powerBrightnessFactor, values.isUserSetBrightness, values.isDefaultBrightnessConfig, values.timestamp);
                    break;
                }
                case 3: {
                    BrightnessTracker.this.startSensorListener();
                    BrightnessTracker.this.enableColorSampling();
                    break;
                }
                case 2: {
                    BrightnessTracker.this.stopSensorListener();
                    BrightnessTracker.this.disableColorSampling();
                }
            }
        }
    }

    private final class Receiver
    extends BroadcastReceiver {
        private Receiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.ACTION_SHUTDOWN".equals(action)) {
                BrightnessTracker.this.stop();
                BrightnessTracker.this.scheduleWriteBrightnessTrackerState();
            } else if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
                int level = intent.getIntExtra("level", -1);
                int scale = intent.getIntExtra("scale", 0);
                if (level != -1 && scale != 0) {
                    BrightnessTracker.this.batteryLevelChanged(level, scale);
                }
            } else if ("android.intent.action.SCREEN_OFF".equals(action)) {
                BrightnessTracker.this.mBgHandler.obtainMessage(2).sendToTarget();
            } else if ("android.intent.action.SCREEN_ON".equals(action)) {
                BrightnessTracker.this.mBgHandler.obtainMessage(3).sendToTarget();
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (BrightnessTracker.this.mInjector.isBrightnessModeAutomatic(BrightnessTracker.this.mContentResolver)) {
                BrightnessTracker.this.mBgHandler.obtainMessage(3).sendToTarget();
            } else {
                BrightnessTracker.this.mBgHandler.obtainMessage(2).sendToTarget();
            }
        }
    }

    private final class DisplayListener
    implements DisplayManager.DisplayListener {
        private DisplayListener() {
        }

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        @Override
        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                BrightnessTracker.this.updateColorSampling();
            }
        }
    }

    private final class SensorListener
    implements SensorEventListener {
        private SensorListener() {
        }

        @Override
        public void onSensorChanged(SensorEvent event) {
            BrightnessTracker.this.recordSensorEvent(event);
            BrightnessTracker.this.recordAmbientBrightnessStats(event);
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    private static class LightData {
        public float lux;
        public long timestamp;

        private LightData() {
        }
    }
}

