/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.ColorSpace;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.SensorManager;
import android.hardware.display.AmbientBrightnessDayStats;
import android.hardware.display.BrightnessChangeEvent;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.Curve;
import android.hardware.display.DisplayManagerInternal;
import android.hardware.display.DisplayViewport;
import android.hardware.display.DisplayedContentSample;
import android.hardware.display.DisplayedContentSamplingAttributes;
import android.hardware.display.IDisplayManager;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.WifiDisplayStatus;
import android.hardware.input.InputManagerInternal;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.IntArray;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Spline;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.Surface;
import android.view.SurfaceControl;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.AnimationThread;
import com.android.server.DisplayThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.UiThread;
import com.android.server.display.DisplayAdapter;
import com.android.server.display.DisplayBlanker;
import com.android.server.display.DisplayDevice;
import com.android.server.display.DisplayDeviceInfo;
import com.android.server.display.DisplayManagerShellCommand;
import com.android.server.display.DisplayModeDirector;
import com.android.server.display.DisplayPowerController;
import com.android.server.display.LocalDisplayAdapter;
import com.android.server.display.LogicalDisplay;
import com.android.server.display.OverlayDisplayAdapter;
import com.android.server.display.PersistentDataStore;
import com.android.server.display.VirtualDisplayAdapter;
import com.android.server.display.WifiDisplayAdapter;
import com.android.server.wm.SurfaceAnimationThread;
import com.android.server.wm.WindowManagerInternal;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DisplayManagerService
extends SystemService {
    private static final String TAG = "DisplayManagerService";
    private static final boolean DEBUG = false;
    private static final String FORCE_WIFI_DISPLAY_ENABLE = "persist.debug.wfd.enable";
    private static final String PROP_DEFAULT_DISPLAY_TOP_INSET = "persist.sys.displayinset.top";
    private static final long WAIT_FOR_DEFAULT_DISPLAY_TIMEOUT = 10000L;
    private static final int MSG_REGISTER_DEFAULT_DISPLAY_ADAPTERS = 1;
    private static final int MSG_REGISTER_ADDITIONAL_DISPLAY_ADAPTERS = 2;
    private static final int MSG_DELIVER_DISPLAY_EVENT = 3;
    private static final int MSG_REQUEST_TRAVERSAL = 4;
    private static final int MSG_UPDATE_VIEWPORT = 5;
    private static final int MSG_LOAD_BRIGHTNESS_CONFIGURATION = 6;
    private final Context mContext;
    private final DisplayManagerHandler mHandler;
    private final Handler mUiHandler;
    private final DisplayAdapterListener mDisplayAdapterListener;
    private final DisplayModeDirector mDisplayModeDirector;
    private WindowManagerInternal mWindowManagerInternal;
    private InputManagerInternal mInputManagerInternal;
    private IMediaProjectionManager mProjectionService;
    private final SyncRoot mSyncRoot = new SyncRoot();
    public boolean mSafeMode;
    public boolean mOnlyCore;
    private final boolean mSingleDisplayDemoMode;
    public final SparseArray<CallbackRecord> mCallbacks = new SparseArray();
    private final ArrayList<DisplayAdapter> mDisplayAdapters = new ArrayList();
    private final ArrayList<DisplayDevice> mDisplayDevices = new ArrayList();
    private final SparseArray<LogicalDisplay> mLogicalDisplays = new SparseArray();
    private int mNextNonDefaultDisplayId = 1;
    private final CopyOnWriteArrayList<DisplayManagerInternal.DisplayTransactionListener> mDisplayTransactionListeners = new CopyOnWriteArrayList();
    private DisplayPowerController mDisplayPowerController;
    private int mGlobalDisplayState = 2;
    private int mGlobalDisplayBrightness = -1;
    private boolean mPendingTraversal;
    private WifiDisplayAdapter mWifiDisplayAdapter;
    private int mWifiDisplayScanRequestCount;
    private VirtualDisplayAdapter mVirtualDisplayAdapter;
    private int mCurrentUserId;
    private Point mStableDisplaySize = new Point();
    private boolean mSystemReady;
    private int mDefaultDisplayTopInset;
    @GuardedBy(value={"mSyncRoot"})
    private final ArrayList<DisplayViewport> mViewports = new ArrayList();
    private final PersistentDataStore mPersistentDataStore = new PersistentDataStore();
    private final ArrayList<CallbackRecord> mTempCallbacks = new ArrayList();
    private final DisplayInfo mTempDisplayInfo = new DisplayInfo();
    private final ArrayList<DisplayViewport> mTempViewports = new ArrayList();
    private final int mDefaultDisplayDefaultColorMode;
    private final ArrayList<Runnable> mTempDisplayStateWorkQueue = new ArrayList();
    private final SparseArray<IntArray> mDisplayAccessUIDs = new SparseArray();
    private final Injector mInjector;
    private final Curve mMinimumBrightnessCurve;
    private final Spline mMinimumBrightnessSpline;
    private final ColorSpace mWideColorSpace;

    public DisplayManagerService(Context context) {
        this(context, new Injector());
    }

    @VisibleForTesting
    DisplayManagerService(Context context, Injector injector) {
        super(context);
        this.mInjector = injector;
        this.mContext = context;
        this.mHandler = new DisplayManagerHandler(DisplayThread.get().getLooper());
        this.mUiHandler = UiThread.getHandler();
        this.mDisplayAdapterListener = new DisplayAdapterListener();
        this.mDisplayModeDirector = new DisplayModeDirector(context, this.mHandler);
        this.mSingleDisplayDemoMode = SystemProperties.getBoolean("persist.demo.singledisplay", false);
        Resources resources = this.mContext.getResources();
        this.mDefaultDisplayDefaultColorMode = this.mContext.getResources().getInteger(17694770);
        this.mDefaultDisplayTopInset = SystemProperties.getInt(PROP_DEFAULT_DISPLAY_TOP_INSET, -1);
        float[] lux = DisplayManagerService.getFloatArray(resources.obtainTypedArray(17236036));
        float[] nits = DisplayManagerService.getFloatArray(resources.obtainTypedArray(17236037));
        this.mMinimumBrightnessCurve = new Curve(lux, nits);
        this.mMinimumBrightnessSpline = Spline.createSpline(lux, nits);
        PowerManager pm = this.mContext.getSystemService(PowerManager.class);
        this.mGlobalDisplayBrightness = pm.getDefaultScreenBrightnessSetting();
        this.mCurrentUserId = 0;
        ColorSpace[] colorSpaces = SurfaceControl.getCompositionColorSpaces();
        this.mWideColorSpace = colorSpaces[1];
        this.mSystemReady = false;
    }

    public void setupSchedulerPolicies() {
        Process.setThreadGroupAndCpuset(DisplayThread.get().getThreadId(), 5);
        Process.setThreadGroupAndCpuset(AnimationThread.get().getThreadId(), 5);
        Process.setThreadGroupAndCpuset(SurfaceAnimationThread.get().getThreadId(), 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.mPersistentDataStore.loadIfNeeded();
            this.loadStableDisplayValuesLocked();
        }
        this.mHandler.sendEmptyMessage(1);
        this.publishBinderService("display", new BinderService(), true);
        this.publishLocalService(DisplayManagerInternal.class, new LocalService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 100) {
            SyncRoot syncRoot = this.mSyncRoot;
            synchronized (syncRoot) {
                long timeout = SystemClock.uptimeMillis() + this.mInjector.getDefaultDisplayDelayTimeout();
                while (this.mLogicalDisplays.get(0) == null || this.mVirtualDisplayAdapter == null) {
                    long delay = timeout - SystemClock.uptimeMillis();
                    if (delay <= 0L) {
                        throw new RuntimeException("Timeout waiting for default display to be initialized. DefaultDisplay=" + this.mLogicalDisplays.get(0) + ", mVirtualDisplayAdapter=" + this.mVirtualDisplayAdapter);
                    }
                    try {
                        this.mSyncRoot.wait(delay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(int newUserId) {
        int userSerial = this.getUserManager().getUserSerialNumber(newUserId);
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mCurrentUserId != newUserId) {
                this.mCurrentUserId = newUserId;
                BrightnessConfiguration config = this.mPersistentDataStore.getBrightnessConfiguration(userSerial);
                this.mDisplayPowerController.setBrightnessConfiguration(config);
            }
            this.mDisplayPowerController.onSwitchUser(newUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowManagerAndInputReady() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
            this.mInputManagerInternal = LocalServices.getService(InputManagerInternal.class);
            this.scheduleTraversalLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(boolean safeMode, boolean onlyCore) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.mSafeMode = safeMode;
            this.mOnlyCore = onlyCore;
            this.mSystemReady = true;
            this.recordTopInsetLocked(this.mLogicalDisplays.get(0));
        }
        this.mDisplayModeDirector.setListener(new AllowedDisplayModeObserver());
        this.mDisplayModeDirector.start();
        this.mHandler.sendEmptyMessage(2);
    }

    @VisibleForTesting
    Handler getDisplayHandler() {
        return this.mHandler;
    }

    private void loadStableDisplayValuesLocked() {
        Point size = this.mPersistentDataStore.getStableDisplaySize();
        if (size.x > 0 && size.y > 0) {
            this.mStableDisplaySize.set(size.x, size.y);
        } else {
            Resources res = this.mContext.getResources();
            int width = res.getInteger(17694895);
            int height = res.getInteger(17694894);
            if (width > 0 && height > 0) {
                this.setStableDisplaySizeLocked(width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Point getStableDisplaySizeInternal() {
        Point r = new Point();
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mStableDisplaySize.x > 0 && this.mStableDisplaySize.y > 0) {
                r.set(this.mStableDisplaySize.x, this.mStableDisplaySize.y);
            }
        }
        return r;
    }

    private void registerDisplayTransactionListenerInternal(DisplayManagerInternal.DisplayTransactionListener listener) {
        this.mDisplayTransactionListeners.add(listener);
    }

    private void unregisterDisplayTransactionListenerInternal(DisplayManagerInternal.DisplayTransactionListener listener) {
        this.mDisplayTransactionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisplayInfoOverrideFromWindowManagerInternal(int displayId, DisplayInfo info) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display != null && display.setDisplayInfoOverrideFromWindowManagerLocked(info)) {
                this.handleLogicalDisplayChanged(displayId, display);
                this.scheduleTraversalLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNonOverrideDisplayInfoInternal(int displayId, DisplayInfo outInfo) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display != null) {
                display.getNonOverrideDisplayInfoLocked(outInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void performTraversalInternal(SurfaceControl.Transaction t) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (!this.mPendingTraversal) {
                return;
            }
            this.mPendingTraversal = false;
            this.performTraversalLocked(t);
        }
        for (DisplayManagerInternal.DisplayTransactionListener listener : this.mDisplayTransactionListeners) {
            listener.onDisplayTransaction(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestGlobalDisplayStateInternal(int state, int brightness) {
        if (state == 0) {
            state = 2;
        }
        if (state == 1) {
            brightness = 0;
        } else if (brightness < 0) {
            brightness = -1;
        } else if (brightness > 255) {
            brightness = 255;
        }
        ArrayList<Runnable> arrayList = this.mTempDisplayStateWorkQueue;
        synchronized (arrayList) {
            try {
                SyncRoot syncRoot = this.mSyncRoot;
                synchronized (syncRoot) {
                    block18: {
                        if (this.mGlobalDisplayState != state || this.mGlobalDisplayBrightness != brightness) break block18;
                        return;
                    }
                    Trace.traceBegin(131072L, "requestGlobalDisplayState(" + Display.stateToString(state) + ", brightness=" + brightness + ")");
                    this.mGlobalDisplayState = state;
                    this.mGlobalDisplayBrightness = brightness;
                    this.applyGlobalDisplayStateLocked(this.mTempDisplayStateWorkQueue);
                }
                for (int i = 0; i < this.mTempDisplayStateWorkQueue.size(); ++i) {
                    this.mTempDisplayStateWorkQueue.get(i).run();
                }
                Trace.traceEnd(131072L);
            }
            finally {
                this.mTempDisplayStateWorkQueue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisplayInfo getDisplayInfoInternal(int displayId, int callingUid) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            DisplayInfo info;
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display != null && ((info = display.getDisplayInfoLocked()).hasAccess(callingUid) || this.isUidPresentOnDisplayInternal(callingUid, displayId))) {
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getDisplayIdsInternal(int callingUid) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            int count = this.mLogicalDisplays.size();
            int[] displayIds = new int[count];
            int n = 0;
            for (int i = 0; i < count; ++i) {
                LogicalDisplay display = this.mLogicalDisplays.valueAt(i);
                DisplayInfo info = display.getDisplayInfoLocked();
                if (!info.hasAccess(callingUid)) continue;
                displayIds[n++] = this.mLogicalDisplays.keyAt(i);
            }
            if (n != count) {
                displayIds = Arrays.copyOfRange(displayIds, 0, n);
            }
            return displayIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCallbackInternal(IDisplayManagerCallback callback, int callingPid) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mCallbacks.get(callingPid) != null) {
                throw new SecurityException("The calling process has already registered an IDisplayManagerCallback.");
            }
            CallbackRecord record = new CallbackRecord(callingPid, callback);
            try {
                IBinder binder = callback.asBinder();
                binder.linkToDeath(record, 0);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex);
            }
            this.mCallbacks.put(callingPid, record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallbackDied(CallbackRecord record) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.mCallbacks.remove(record.mPid);
            this.stopWifiDisplayScanLocked(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWifiDisplayScanInternal(int callingPid) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            CallbackRecord record = this.mCallbacks.get(callingPid);
            if (record == null) {
                throw new IllegalStateException("The calling process has not registered an IDisplayManagerCallback.");
            }
            this.startWifiDisplayScanLocked(record);
        }
    }

    private void startWifiDisplayScanLocked(CallbackRecord record) {
        if (!record.mWifiDisplayScanRequested) {
            record.mWifiDisplayScanRequested = true;
            if (this.mWifiDisplayScanRequestCount++ == 0 && this.mWifiDisplayAdapter != null) {
                this.mWifiDisplayAdapter.requestStartScanLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWifiDisplayScanInternal(int callingPid) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            CallbackRecord record = this.mCallbacks.get(callingPid);
            if (record == null) {
                throw new IllegalStateException("The calling process has not registered an IDisplayManagerCallback.");
            }
            this.stopWifiDisplayScanLocked(record);
        }
    }

    private void stopWifiDisplayScanLocked(CallbackRecord record) {
        if (record.mWifiDisplayScanRequested) {
            record.mWifiDisplayScanRequested = false;
            if (--this.mWifiDisplayScanRequestCount == 0) {
                if (this.mWifiDisplayAdapter != null) {
                    this.mWifiDisplayAdapter.requestStopScanLocked();
                }
            } else if (this.mWifiDisplayScanRequestCount < 0) {
                Slog.wtf(TAG, "mWifiDisplayScanRequestCount became negative: " + this.mWifiDisplayScanRequestCount);
                this.mWifiDisplayScanRequestCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectWifiDisplayInternal(String address) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mWifiDisplayAdapter != null) {
                this.mWifiDisplayAdapter.requestConnectLocked(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseWifiDisplayInternal() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mWifiDisplayAdapter != null) {
                this.mWifiDisplayAdapter.requestPauseLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeWifiDisplayInternal() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mWifiDisplayAdapter != null) {
                this.mWifiDisplayAdapter.requestResumeLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectWifiDisplayInternal() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mWifiDisplayAdapter != null) {
                this.mWifiDisplayAdapter.requestDisconnectLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameWifiDisplayInternal(String address, String alias) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mWifiDisplayAdapter != null) {
                this.mWifiDisplayAdapter.requestRenameLocked(address, alias);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetWifiDisplayInternal(String address) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mWifiDisplayAdapter != null) {
                this.mWifiDisplayAdapter.requestForgetLocked(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WifiDisplayStatus getWifiDisplayStatusInternal() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mWifiDisplayAdapter != null) {
                return this.mWifiDisplayAdapter.getWifiDisplayStatusLocked();
            }
            return new WifiDisplayStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestColorModeInternal(int displayId, int colorMode) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display != null && display.getRequestedColorModeLocked() != colorMode) {
                display.setRequestedColorModeLocked(colorMode);
                this.scheduleTraversalLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createVirtualDisplayInternal(IVirtualDisplayCallback callback, IMediaProjection projection, int callingUid, String packageName, String name, int width, int height, int densityDpi, Surface surface, int flags, String uniqueId) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mVirtualDisplayAdapter == null) {
                Slog.w(TAG, "Rejecting request to create private virtual display because the virtual display adapter is not available.");
                return -1;
            }
            DisplayDevice device = this.mVirtualDisplayAdapter.createVirtualDisplayLocked(callback, projection, callingUid, packageName, name, width, height, densityDpi, surface, flags, uniqueId);
            if (device == null) {
                return -1;
            }
            this.handleDisplayDeviceAddedLocked(device);
            LogicalDisplay display = this.findLogicalDisplayForDeviceLocked(device);
            if (display != null) {
                return display.getDisplayIdLocked();
            }
            Slog.w(TAG, "Rejecting request to create virtual display because the logical display was not created.");
            this.mVirtualDisplayAdapter.releaseVirtualDisplayLocked(callback.asBinder());
            this.handleDisplayDeviceRemovedLocked(device);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeVirtualDisplayInternal(IBinder appToken, int width, int height, int densityDpi) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mVirtualDisplayAdapter == null) {
                return;
            }
            this.mVirtualDisplayAdapter.resizeVirtualDisplayLocked(appToken, width, height, densityDpi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVirtualDisplaySurfaceInternal(IBinder appToken, Surface surface) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mVirtualDisplayAdapter == null) {
                return;
            }
            this.mVirtualDisplayAdapter.setVirtualDisplaySurfaceLocked(appToken, surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseVirtualDisplayInternal(IBinder appToken) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mVirtualDisplayAdapter == null) {
                return;
            }
            DisplayDevice device = this.mVirtualDisplayAdapter.releaseVirtualDisplayLocked(appToken);
            if (device != null) {
                this.handleDisplayDeviceRemovedLocked(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVirtualDisplayStateInternal(IBinder appToken, boolean isOn) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.mVirtualDisplayAdapter == null) {
                return;
            }
            this.mVirtualDisplayAdapter.setVirtualDisplayStateLocked(appToken, isOn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDefaultDisplayAdapters() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.registerDisplayAdapterLocked(new LocalDisplayAdapter(this.mSyncRoot, this.mContext, this.mHandler, this.mDisplayAdapterListener));
            this.mVirtualDisplayAdapter = this.mInjector.getVirtualDisplayAdapter(this.mSyncRoot, this.mContext, this.mHandler, this.mDisplayAdapterListener);
            if (this.mVirtualDisplayAdapter != null) {
                this.registerDisplayAdapterLocked(this.mVirtualDisplayAdapter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAdditionalDisplayAdapters() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            if (this.shouldRegisterNonEssentialDisplayAdaptersLocked()) {
                this.registerOverlayDisplayAdapterLocked();
                this.registerWifiDisplayAdapterLocked();
            }
        }
    }

    private void registerOverlayDisplayAdapterLocked() {
        this.registerDisplayAdapterLocked(new OverlayDisplayAdapter(this.mSyncRoot, this.mContext, (Handler)this.mHandler, (DisplayAdapter.Listener)this.mDisplayAdapterListener, this.mUiHandler));
    }

    private void registerWifiDisplayAdapterLocked() {
        if (this.mContext.getResources().getBoolean(17891451) || SystemProperties.getInt(FORCE_WIFI_DISPLAY_ENABLE, -1) == 1) {
            this.mWifiDisplayAdapter = new WifiDisplayAdapter(this.mSyncRoot, this.mContext, (Handler)this.mHandler, (DisplayAdapter.Listener)this.mDisplayAdapterListener, this.mPersistentDataStore);
            this.registerDisplayAdapterLocked(this.mWifiDisplayAdapter);
        }
    }

    private boolean shouldRegisterNonEssentialDisplayAdaptersLocked() {
        return !this.mSafeMode && !this.mOnlyCore;
    }

    private void registerDisplayAdapterLocked(DisplayAdapter adapter) {
        this.mDisplayAdapters.add(adapter);
        adapter.registerLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayDeviceAdded(DisplayDevice device) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.handleDisplayDeviceAddedLocked(device);
        }
    }

    private void handleDisplayDeviceAddedLocked(DisplayDevice device) {
        DisplayDeviceInfo info = device.getDisplayDeviceInfoLocked();
        if (this.mDisplayDevices.contains(device)) {
            Slog.w(TAG, "Attempted to add already added display device: " + info);
            return;
        }
        Slog.i(TAG, "Display device added: " + info);
        device.mDebugLastLoggedDeviceInfo = info;
        this.mDisplayDevices.add(device);
        LogicalDisplay display = this.addLogicalDisplayLocked(device);
        Runnable work = this.updateDisplayStateLocked(device);
        if (work != null) {
            work.run();
        }
        this.scheduleTraversalLocked(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayDeviceChanged(DisplayDevice device) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            DisplayDeviceInfo info = device.getDisplayDeviceInfoLocked();
            if (!this.mDisplayDevices.contains(device)) {
                Slog.w(TAG, "Attempted to change non-existent display device: " + info);
                return;
            }
            int diff = device.mDebugLastLoggedDeviceInfo.diff(info);
            if (diff == 1) {
                Slog.i(TAG, "Display device changed state: \"" + info.name + "\", " + Display.stateToString(info.state));
            } else if (diff != 0) {
                Slog.i(TAG, "Display device changed: " + info);
            }
            if ((diff & 4) != 0) {
                try {
                    this.mPersistentDataStore.setColorMode(device, info.colorMode);
                }
                finally {
                    this.mPersistentDataStore.saveIfNeeded();
                }
            }
            device.mDebugLastLoggedDeviceInfo = info;
            device.applyPendingDisplayDeviceInfoChangesLocked();
            if (this.updateLogicalDisplaysLocked()) {
                this.scheduleTraversalLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayDeviceRemoved(DisplayDevice device) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.handleDisplayDeviceRemovedLocked(device);
        }
    }

    private void handleDisplayDeviceRemovedLocked(DisplayDevice device) {
        DisplayDeviceInfo info = device.getDisplayDeviceInfoLocked();
        if (!this.mDisplayDevices.remove(device)) {
            Slog.w(TAG, "Attempted to remove non-existent display device: " + info);
            return;
        }
        Slog.i(TAG, "Display device removed: " + info);
        device.mDebugLastLoggedDeviceInfo = info;
        this.updateLogicalDisplaysLocked();
        this.scheduleTraversalLocked(false);
    }

    private void handleLogicalDisplayChanged(int displayId, LogicalDisplay display) {
        if (displayId == 0) {
            this.recordTopInsetLocked(display);
        }
        this.sendDisplayEventLocked(displayId, 2);
    }

    private void applyGlobalDisplayStateLocked(List<Runnable> workQueue) {
        int count = this.mDisplayDevices.size();
        for (int i = 0; i < count; ++i) {
            DisplayDevice device = this.mDisplayDevices.get(i);
            Runnable runnable = this.updateDisplayStateLocked(device);
            if (runnable == null) continue;
            workQueue.add(runnable);
        }
    }

    private Runnable updateDisplayStateLocked(DisplayDevice device) {
        DisplayDeviceInfo info = device.getDisplayDeviceInfoLocked();
        if ((info.flags & 0x20) == 0) {
            return device.requestDisplayStateLocked(this.mGlobalDisplayState, this.mGlobalDisplayBrightness);
        }
        return null;
    }

    private LogicalDisplay addLogicalDisplayLocked(DisplayDevice device) {
        boolean isDefault;
        DisplayDeviceInfo deviceInfo = device.getDisplayDeviceInfoLocked();
        boolean bl = isDefault = (deviceInfo.flags & 1) != 0;
        if (isDefault && this.mLogicalDisplays.get(0) != null) {
            Slog.w(TAG, "Ignoring attempt to add a second default display: " + deviceInfo);
            isDefault = false;
        }
        if (!isDefault && this.mSingleDisplayDemoMode) {
            Slog.i(TAG, "Not creating a logical display for a secondary display  because single display demo mode is enabled: " + deviceInfo);
            return null;
        }
        int displayId = this.assignDisplayIdLocked(isDefault);
        int layerStack = this.assignLayerStackLocked(displayId);
        LogicalDisplay display = new LogicalDisplay(displayId, layerStack, device);
        display.updateLocked(this.mDisplayDevices);
        if (!display.isValidLocked()) {
            Slog.w(TAG, "Ignoring display device because the logical display created from it was not considered valid: " + deviceInfo);
            return null;
        }
        this.configureColorModeLocked(display, device);
        if (isDefault) {
            this.recordStableDisplayStatsIfNeededLocked(display);
            this.recordTopInsetLocked(display);
        }
        this.mLogicalDisplays.put(displayId, display);
        if (isDefault) {
            this.mSyncRoot.notifyAll();
        }
        this.sendDisplayEventLocked(displayId, 1);
        return display;
    }

    private int assignDisplayIdLocked(boolean isDefault) {
        int n;
        if (isDefault) {
            n = 0;
        } else {
            int n2 = this.mNextNonDefaultDisplayId;
            n = n2;
            this.mNextNonDefaultDisplayId = n2 + 1;
        }
        return n;
    }

    private int assignLayerStackLocked(int displayId) {
        return displayId;
    }

    private void configureColorModeLocked(LogicalDisplay display, DisplayDevice device) {
        if (display.getPrimaryDisplayDeviceLocked() == device) {
            int colorMode = this.mPersistentDataStore.getColorMode(device);
            if (colorMode == -1) {
                colorMode = (device.getDisplayDeviceInfoLocked().flags & 1) != 0 ? this.mDefaultDisplayDefaultColorMode : 0;
            }
            display.setRequestedColorModeLocked(colorMode);
        }
    }

    private void recordStableDisplayStatsIfNeededLocked(LogicalDisplay d) {
        if (this.mStableDisplaySize.x <= 0 && this.mStableDisplaySize.y <= 0) {
            DisplayInfo info = d.getDisplayInfoLocked();
            this.setStableDisplaySizeLocked(info.getNaturalWidth(), info.getNaturalHeight());
        }
    }

    private void recordTopInsetLocked(LogicalDisplay d) {
        if (!this.mSystemReady || d == null) {
            return;
        }
        int topInset = d.getInsets().top;
        if (topInset == this.mDefaultDisplayTopInset) {
            return;
        }
        this.mDefaultDisplayTopInset = topInset;
        SystemProperties.set(PROP_DEFAULT_DISPLAY_TOP_INSET, Integer.toString(topInset));
    }

    private void setStableDisplaySizeLocked(int width, int height) {
        this.mStableDisplaySize = new Point(width, height);
        try {
            this.mPersistentDataStore.setStableDisplaySize(this.mStableDisplaySize);
        }
        finally {
            this.mPersistentDataStore.saveIfNeeded();
        }
    }

    @VisibleForTesting
    Curve getMinimumBrightnessCurveInternal() {
        return this.mMinimumBrightnessCurve;
    }

    int getPreferredWideGamutColorSpaceIdInternal() {
        return this.mWideColorSpace.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBrightnessConfigurationForUserInternal(BrightnessConfiguration c, int userId, String packageName) {
        this.validateBrightnessConfiguration(c);
        int userSerial = this.getUserManager().getUserSerialNumber(userId);
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            try {
                this.mPersistentDataStore.setBrightnessConfigurationForUser(c, userSerial, packageName);
            }
            finally {
                this.mPersistentDataStore.saveIfNeeded();
            }
            if (userId == this.mCurrentUserId) {
                this.mDisplayPowerController.setBrightnessConfiguration(c);
            }
        }
    }

    @VisibleForTesting
    void validateBrightnessConfiguration(BrightnessConfiguration config) {
        if (config == null) {
            return;
        }
        if (this.isBrightnessConfigurationTooDark(config)) {
            throw new IllegalArgumentException("brightness curve is too dark");
        }
    }

    private boolean isBrightnessConfigurationTooDark(BrightnessConfiguration config) {
        Pair<float[], float[]> curve = config.getCurve();
        float[] lux = (float[])curve.first;
        float[] nits = (float[])curve.second;
        for (int i = 0; i < lux.length; ++i) {
            if (!(nits[i] < this.mMinimumBrightnessSpline.interpolate(lux[i]))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBrightnessConfiguration() {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            int userSerial = this.getUserManager().getUserSerialNumber(this.mCurrentUserId);
            BrightnessConfiguration config = this.mPersistentDataStore.getBrightnessConfiguration(userSerial);
            this.mDisplayPowerController.setBrightnessConfiguration(config);
        }
    }

    private boolean updateLogicalDisplaysLocked() {
        boolean changed = false;
        int i = this.mLogicalDisplays.size();
        while (i-- > 0) {
            int displayId = this.mLogicalDisplays.keyAt(i);
            LogicalDisplay display = this.mLogicalDisplays.valueAt(i);
            this.mTempDisplayInfo.copyFrom(display.getDisplayInfoLocked());
            display.updateLocked(this.mDisplayDevices);
            if (!display.isValidLocked()) {
                this.mLogicalDisplays.removeAt(i);
                this.sendDisplayEventLocked(displayId, 3);
                changed = true;
                continue;
            }
            if (this.mTempDisplayInfo.equals(display.getDisplayInfoLocked())) continue;
            this.handleLogicalDisplayChanged(displayId, display);
            changed = true;
        }
        return changed;
    }

    private void performTraversalLocked(SurfaceControl.Transaction t) {
        this.clearViewportsLocked();
        int count = this.mDisplayDevices.size();
        for (int i = 0; i < count; ++i) {
            DisplayDevice device = this.mDisplayDevices.get(i);
            this.configureDisplayLocked(t, device);
            device.performTraversalLocked(t);
        }
        if (this.mInputManagerInternal != null) {
            this.mHandler.sendEmptyMessage(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisplayPropertiesInternal(int displayId, boolean hasContent, float requestedRefreshRate, int requestedModeId, boolean inTraversal) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display == null) {
                return;
            }
            if (display.hasContentLocked() != hasContent) {
                display.setHasContentLocked(hasContent);
                this.scheduleTraversalLocked(inTraversal);
            }
            if (requestedModeId == 0 && requestedRefreshRate != 0.0f) {
                requestedModeId = display.getDisplayInfoLocked().findDefaultModeByRefreshRate(requestedRefreshRate);
            }
            this.mDisplayModeDirector.getAppRequestObserver().setAppRequestedMode(displayId, requestedModeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisplayOffsetsInternal(int displayId, int x, int y) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display == null) {
                return;
            }
            if (display.getDisplayOffsetXLocked() != x || display.getDisplayOffsetYLocked() != y) {
                display.setDisplayOffsetsLocked(x, y);
                this.scheduleTraversalLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisplayScalingDisabledInternal(int displayId, boolean disable) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display == null) {
                return;
            }
            if (display.isDisplayScalingDisabled() != disable) {
                display.setDisplayScalingDisabledLocked(disable);
                this.scheduleTraversalLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisplayAccessUIDsInternal(SparseArray<IntArray> newDisplayAccessUIDs) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            this.mDisplayAccessUIDs.clear();
            for (int i = newDisplayAccessUIDs.size() - 1; i >= 0; --i) {
                this.mDisplayAccessUIDs.append(newDisplayAccessUIDs.keyAt(i), newDisplayAccessUIDs.valueAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUidPresentOnDisplayInternal(int uid, int displayId) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            IntArray displayUIDs = this.mDisplayAccessUIDs.get(displayId);
            return displayUIDs != null && displayUIDs.indexOf(uid) != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBinder getDisplayToken(int displayId) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            DisplayDevice device;
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display != null && (device = display.getPrimaryDisplayDeviceLocked()) != null) {
                return device.getDisplayTokenLocked();
            }
            return null;
        }
    }

    private SurfaceControl.ScreenshotGraphicBuffer screenshotInternal(int displayId) {
        IBinder token = this.getDisplayToken(displayId);
        if (token == null) {
            return null;
        }
        return SurfaceControl.screenshotToBufferWithSecureLayersUnsafe(token, new Rect(), 0, 0, false, 0);
    }

    @VisibleForTesting
    DisplayedContentSamplingAttributes getDisplayedContentSamplingAttributesInternal(int displayId) {
        IBinder token = this.getDisplayToken(displayId);
        if (token == null) {
            return null;
        }
        return SurfaceControl.getDisplayedContentSamplingAttributes(token);
    }

    @VisibleForTesting
    boolean setDisplayedContentSamplingEnabledInternal(int displayId, boolean enable, int componentMask, int maxFrames) {
        IBinder token = this.getDisplayToken(displayId);
        if (token == null) {
            return false;
        }
        return SurfaceControl.setDisplayedContentSamplingEnabled(token, enable, componentMask, maxFrames);
    }

    @VisibleForTesting
    DisplayedContentSample getDisplayedContentSampleInternal(int displayId, long maxFrames, long timestamp) {
        IBinder token = this.getDisplayToken(displayId);
        if (token == null) {
            return null;
        }
        return SurfaceControl.getDisplayedContentSample(token, maxFrames, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAllowedDisplayModesChangedInternal() {
        boolean changed = false;
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            int count = this.mLogicalDisplays.size();
            for (int i = 0; i < count; ++i) {
                LogicalDisplay display = this.mLogicalDisplays.valueAt(i);
                int displayId = this.mLogicalDisplays.keyAt(i);
                int[] allowedModes = this.mDisplayModeDirector.getAllowedModes(displayId);
                if (Arrays.equals(allowedModes, display.getAllowedDisplayModesLocked())) continue;
                display.setAllowedDisplayModesLocked(allowedModes);
                changed = true;
            }
            if (changed) {
                this.scheduleTraversalLocked(false);
            }
        }
    }

    private void clearViewportsLocked() {
        this.mViewports.clear();
    }

    private void configureDisplayLocked(SurfaceControl.Transaction t, DisplayDevice device) {
        int viewportType;
        DisplayDeviceInfo info = device.getDisplayDeviceInfoLocked();
        boolean ownContent = (info.flags & 0x80) != 0;
        LogicalDisplay display = this.findLogicalDisplayForDeviceLocked(device);
        if (!ownContent) {
            if (display != null && !display.hasContentLocked()) {
                display = null;
            }
            if (display == null) {
                display = this.mLogicalDisplays.get(0);
            }
        }
        if (display == null) {
            Slog.w(TAG, "Missing logical display to use for physical display device: " + device.getDisplayDeviceInfoLocked());
            return;
        }
        display.configureDisplayLocked(t, device, info.state == 1);
        if ((info.flags & 1) != 0) {
            viewportType = 1;
        } else if (info.touch == 2) {
            viewportType = 2;
        } else if (info.touch == 3 && !TextUtils.isEmpty(info.uniqueId)) {
            viewportType = 3;
        } else {
            Slog.i(TAG, "Display " + info + " does not support input device matching.");
            return;
        }
        this.populateViewportLocked(viewportType, display.getDisplayIdLocked(), device, info.uniqueId);
    }

    private DisplayViewport getViewportLocked(int viewportType, String uniqueId) {
        DisplayViewport viewport;
        if (viewportType != 1 && viewportType != 2 && viewportType != 3) {
            Slog.wtf(TAG, "Cannot call getViewportByTypeLocked for type " + DisplayViewport.typeToString(viewportType));
            return null;
        }
        if (viewportType != 3) {
            uniqueId = "";
        }
        int count = this.mViewports.size();
        for (int i = 0; i < count; ++i) {
            viewport = this.mViewports.get(i);
            if (viewport.type != viewportType || !uniqueId.equals(viewport.uniqueId)) continue;
            return viewport;
        }
        viewport = new DisplayViewport();
        viewport.type = viewportType;
        viewport.uniqueId = uniqueId;
        this.mViewports.add(viewport);
        return viewport;
    }

    private void populateViewportLocked(int viewportType, int displayId, DisplayDevice device, String uniqueId) {
        DisplayViewport viewport = this.getViewportLocked(viewportType, uniqueId);
        device.populateViewportLocked(viewport);
        viewport.valid = true;
        viewport.displayId = displayId;
    }

    private LogicalDisplay findLogicalDisplayForDeviceLocked(DisplayDevice device) {
        int count = this.mLogicalDisplays.size();
        for (int i = 0; i < count; ++i) {
            LogicalDisplay display = this.mLogicalDisplays.valueAt(i);
            if (display.getPrimaryDisplayDeviceLocked() != device) continue;
            return display;
        }
        return null;
    }

    private void sendDisplayEventLocked(int displayId, int event) {
        Message msg = this.mHandler.obtainMessage(3, displayId, event);
        this.mHandler.sendMessage(msg);
    }

    private void scheduleTraversalLocked(boolean inTraversal) {
        if (!this.mPendingTraversal && this.mWindowManagerInternal != null) {
            this.mPendingTraversal = true;
            if (!inTraversal) {
                this.mHandler.sendEmptyMessage(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverDisplayEvent(int displayId, int event) {
        int count;
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            count = this.mCallbacks.size();
            this.mTempCallbacks.clear();
            for (int i = 0; i < count; ++i) {
                this.mTempCallbacks.add(this.mCallbacks.valueAt(i));
            }
        }
        for (int i = 0; i < count; ++i) {
            this.mTempCallbacks.get(i).notifyDisplayEventAsync(displayId, event);
        }
        this.mTempCallbacks.clear();
    }

    private IMediaProjectionManager getProjectionService() {
        if (this.mProjectionService == null) {
            IBinder b = ServiceManager.getService("media_projection");
            this.mProjectionService = IMediaProjectionManager.Stub.asInterface(b);
        }
        return this.mProjectionService;
    }

    private UserManager getUserManager() {
        return this.mContext.getSystemService(UserManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(PrintWriter pw) {
        pw.println("DISPLAY MANAGER (dumpsys display)");
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            pw.println("  mOnlyCode=" + this.mOnlyCore);
            pw.println("  mSafeMode=" + this.mSafeMode);
            pw.println("  mPendingTraversal=" + this.mPendingTraversal);
            pw.println("  mGlobalDisplayState=" + Display.stateToString(this.mGlobalDisplayState));
            pw.println("  mNextNonDefaultDisplayId=" + this.mNextNonDefaultDisplayId);
            pw.println("  mViewports=" + this.mViewports);
            pw.println("  mDefaultDisplayDefaultColorMode=" + this.mDefaultDisplayDefaultColorMode);
            pw.println("  mSingleDisplayDemoMode=" + this.mSingleDisplayDemoMode);
            pw.println("  mWifiDisplayScanRequestCount=" + this.mWifiDisplayScanRequestCount);
            pw.println("  mStableDisplaySize=" + this.mStableDisplaySize);
            pw.println("  mMinimumBrightnessCurve=" + this.mMinimumBrightnessCurve);
            IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "    ");
            ipw.increaseIndent();
            pw.println();
            pw.println("Display Adapters: size=" + this.mDisplayAdapters.size());
            for (DisplayAdapter adapter : this.mDisplayAdapters) {
                pw.println("  " + adapter.getName());
                adapter.dumpLocked(ipw);
            }
            pw.println();
            pw.println("Display Devices: size=" + this.mDisplayDevices.size());
            for (DisplayDevice device : this.mDisplayDevices) {
                pw.println("  " + device.getDisplayDeviceInfoLocked());
                device.dumpLocked(ipw);
            }
            int logicalDisplayCount = this.mLogicalDisplays.size();
            pw.println();
            pw.println("Logical Displays: size=" + logicalDisplayCount);
            for (int i = 0; i < logicalDisplayCount; ++i) {
                int displayId = this.mLogicalDisplays.keyAt(i);
                LogicalDisplay display = this.mLogicalDisplays.valueAt(i);
                pw.println("  Display " + displayId + ":");
                display.dumpLocked(ipw);
            }
            pw.println();
            this.mDisplayModeDirector.dump(pw);
            int callbackCount = this.mCallbacks.size();
            pw.println();
            pw.println("Callbacks: size=" + callbackCount);
            for (int i = 0; i < callbackCount; ++i) {
                CallbackRecord callback = this.mCallbacks.valueAt(i);
                pw.println("  " + i + ": mPid=" + callback.mPid + ", mWifiDisplayScanRequested=" + callback.mWifiDisplayScanRequested);
            }
            if (this.mDisplayPowerController != null) {
                this.mDisplayPowerController.dump(pw);
            }
            pw.println();
            this.mPersistentDataStore.dump(pw);
        }
    }

    private static float[] getFloatArray(TypedArray array2) {
        int length = array2.length();
        float[] floatArray = new float[length];
        for (int i = 0; i < length; ++i) {
            floatArray[i] = array2.getFloat(i, Float.NaN);
        }
        array2.recycle();
        return floatArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    DisplayDeviceInfo getDisplayDeviceInfoInternal(int displayId) {
        SyncRoot syncRoot = this.mSyncRoot;
        synchronized (syncRoot) {
            LogicalDisplay display = this.mLogicalDisplays.get(displayId);
            if (display != null) {
                DisplayDevice displayDevice = display.getPrimaryDisplayDeviceLocked();
                return displayDevice.getDisplayDeviceInfoLocked();
            }
            return null;
        }
    }

    class AllowedDisplayModeObserver
    implements DisplayModeDirector.Listener {
        AllowedDisplayModeObserver() {
        }

        @Override
        public void onAllowedDisplayModesChanged() {
            DisplayManagerService.this.onAllowedDisplayModesChangedInternal();
        }
    }

    private final class LocalService
    extends DisplayManagerInternal {
        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initPowerManagement(final DisplayManagerInternal.DisplayPowerCallbacks callbacks, Handler handler, SensorManager sensorManager) {
            SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
            synchronized (syncRoot) {
                DisplayBlanker blanker = new DisplayBlanker(){

                    @Override
                    public void requestDisplayState(int state, int brightness) {
                        if (state == 1) {
                            DisplayManagerService.this.requestGlobalDisplayStateInternal(state, brightness);
                        }
                        callbacks.onDisplayStateChange(state);
                        if (state != 1) {
                            DisplayManagerService.this.requestGlobalDisplayStateInternal(state, brightness);
                        }
                    }
                };
                DisplayManagerService.this.mDisplayPowerController = new DisplayPowerController(DisplayManagerService.this.mContext, callbacks, handler, sensorManager, blanker);
            }
            DisplayManagerService.this.mHandler.sendEmptyMessage(6);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestPowerState(DisplayManagerInternal.DisplayPowerRequest request, boolean waitForNegativeProximity) {
            SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
            synchronized (syncRoot) {
                return DisplayManagerService.this.mDisplayPowerController.requestPowerState(request, waitForNegativeProximity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isProximitySensorAvailable() {
            SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
            synchronized (syncRoot) {
                return DisplayManagerService.this.mDisplayPowerController.isProximitySensorAvailable();
            }
        }

        @Override
        public SurfaceControl.ScreenshotGraphicBuffer screenshot(int displayId) {
            return DisplayManagerService.this.screenshotInternal(displayId);
        }

        @Override
        public DisplayInfo getDisplayInfo(int displayId) {
            return DisplayManagerService.this.getDisplayInfoInternal(displayId, Process.myUid());
        }

        @Override
        public void registerDisplayTransactionListener(DisplayManagerInternal.DisplayTransactionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            DisplayManagerService.this.registerDisplayTransactionListenerInternal(listener);
        }

        @Override
        public void unregisterDisplayTransactionListener(DisplayManagerInternal.DisplayTransactionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            DisplayManagerService.this.unregisterDisplayTransactionListenerInternal(listener);
        }

        @Override
        public void setDisplayInfoOverrideFromWindowManager(int displayId, DisplayInfo info) {
            DisplayManagerService.this.setDisplayInfoOverrideFromWindowManagerInternal(displayId, info);
        }

        @Override
        public void getNonOverrideDisplayInfo(int displayId, DisplayInfo outInfo) {
            DisplayManagerService.this.getNonOverrideDisplayInfoInternal(displayId, outInfo);
        }

        @Override
        public void performTraversal(SurfaceControl.Transaction t) {
            DisplayManagerService.this.performTraversalInternal(t);
        }

        @Override
        public void setDisplayProperties(int displayId, boolean hasContent, float requestedRefreshRate, int requestedMode, boolean inTraversal) {
            DisplayManagerService.this.setDisplayPropertiesInternal(displayId, hasContent, requestedRefreshRate, requestedMode, inTraversal);
        }

        @Override
        public void setDisplayOffsets(int displayId, int x, int y) {
            DisplayManagerService.this.setDisplayOffsetsInternal(displayId, x, y);
        }

        @Override
        public void setDisplayScalingDisabled(int displayId, boolean disableScaling) {
            DisplayManagerService.this.setDisplayScalingDisabledInternal(displayId, disableScaling);
        }

        @Override
        public void setDisplayAccessUIDs(SparseArray<IntArray> newDisplayAccessUIDs) {
            DisplayManagerService.this.setDisplayAccessUIDsInternal(newDisplayAccessUIDs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void persistBrightnessTrackerState() {
            SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
            synchronized (syncRoot) {
                DisplayManagerService.this.mDisplayPowerController.persistBrightnessTrackerState();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOverlayChanged() {
            SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
            synchronized (syncRoot) {
                for (int i = 0; i < DisplayManagerService.this.mDisplayDevices.size(); ++i) {
                    ((DisplayDevice)DisplayManagerService.this.mDisplayDevices.get(i)).onOverlayChangedLocked();
                }
            }
        }

        @Override
        public DisplayedContentSamplingAttributes getDisplayedContentSamplingAttributes(int displayId) {
            return DisplayManagerService.this.getDisplayedContentSamplingAttributesInternal(displayId);
        }

        @Override
        public boolean setDisplayedContentSamplingEnabled(int displayId, boolean enable, int componentMask, int maxFrames) {
            return DisplayManagerService.this.setDisplayedContentSamplingEnabledInternal(displayId, enable, componentMask, maxFrames);
        }

        @Override
        public DisplayedContentSample getDisplayedContentSample(int displayId, long maxFrames, long timestamp) {
            return DisplayManagerService.this.getDisplayedContentSampleInternal(displayId, maxFrames, timestamp);
        }
    }

    @VisibleForTesting
    final class BinderService
    extends IDisplayManager.Stub {
        BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DisplayInfo getDisplayInfo(int displayId) {
            int callingUid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                DisplayInfo displayInfo = DisplayManagerService.this.getDisplayInfoInternal(displayId, callingUid);
                return displayInfo;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] getDisplayIds() {
            int callingUid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                int[] nArray = DisplayManagerService.this.getDisplayIdsInternal(callingUid);
                return nArray;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUidPresentOnDisplay(int uid, int displayId) {
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = DisplayManagerService.this.isUidPresentOnDisplayInternal(uid, displayId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Point getStableDisplaySize() {
            long token = Binder.clearCallingIdentity();
            try {
                Point point = DisplayManagerService.this.getStableDisplaySizeInternal();
                return point;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerCallback(IDisplayManagerCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            int callingPid = Binder.getCallingPid();
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.registerCallbackInternal(callback, callingPid);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startWifiDisplayScan() {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_WIFI_DISPLAY", "Permission required to start wifi display scans");
            int callingPid = Binder.getCallingPid();
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.startWifiDisplayScanInternal(callingPid);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopWifiDisplayScan() {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_WIFI_DISPLAY", "Permission required to stop wifi display scans");
            int callingPid = Binder.getCallingPid();
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.stopWifiDisplayScanInternal(callingPid);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectWifiDisplay(String address) {
            if (address == null) {
                throw new IllegalArgumentException("address must not be null");
            }
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_WIFI_DISPLAY", "Permission required to connect to a wifi display");
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.connectWifiDisplayInternal(address);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void disconnectWifiDisplay() {
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.disconnectWifiDisplayInternal();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void renameWifiDisplay(String address, String alias) {
            if (address == null) {
                throw new IllegalArgumentException("address must not be null");
            }
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_WIFI_DISPLAY", "Permission required to rename to a wifi display");
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.renameWifiDisplayInternal(address, alias);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forgetWifiDisplay(String address) {
            if (address == null) {
                throw new IllegalArgumentException("address must not be null");
            }
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_WIFI_DISPLAY", "Permission required to forget to a wifi display");
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.forgetWifiDisplayInternal(address);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void pauseWifiDisplay() {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_WIFI_DISPLAY", "Permission required to pause a wifi display session");
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.pauseWifiDisplayInternal();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void resumeWifiDisplay() {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_WIFI_DISPLAY", "Permission required to resume a wifi display session");
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.resumeWifiDisplayInternal();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WifiDisplayStatus getWifiDisplayStatus() {
            long token = Binder.clearCallingIdentity();
            try {
                WifiDisplayStatus wifiDisplayStatus = DisplayManagerService.this.getWifiDisplayStatusInternal();
                return wifiDisplayStatus;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestColorMode(int displayId, int colorMode) {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_DISPLAY_COLOR_MODE", "Permission required to change the display color mode");
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.requestColorModeInternal(displayId, colorMode);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int createVirtualDisplay(IVirtualDisplayCallback callback, IMediaProjection projection, String packageName, String name, int width, int height, int densityDpi, Surface surface, int flags, String uniqueId) {
            int callingUid = Binder.getCallingUid();
            if (!this.validatePackageName(callingUid, packageName)) {
                throw new SecurityException("packageName must match the calling uid");
            }
            if (callback == null) {
                throw new IllegalArgumentException("appToken must not be null");
            }
            if (TextUtils.isEmpty(name)) {
                throw new IllegalArgumentException("name must be non-null and non-empty");
            }
            if (width <= 0 || height <= 0 || densityDpi <= 0) {
                throw new IllegalArgumentException("width, height, and densityDpi must be greater than 0");
            }
            if (surface != null && surface.isSingleBuffered()) {
                throw new IllegalArgumentException("Surface can't be single-buffered");
            }
            if ((flags & 1) != 0 && ((flags |= 0x10) & 0x20) != 0) {
                throw new IllegalArgumentException("Public display must not be marked as SHOW_WHEN_LOCKED_INSECURE");
            }
            if ((flags & 8) != 0) {
                flags &= 0xFFFFFFEF;
            }
            if (projection != null) {
                try {
                    if (!DisplayManagerService.this.getProjectionService().isValidMediaProjection(projection)) {
                        throw new SecurityException("Invalid media projection");
                    }
                    flags = projection.applyVirtualDisplayFlags(flags);
                }
                catch (RemoteException e) {
                    throw new SecurityException("unable to validate media projection or flags");
                }
            }
            if (callingUid != 1000 && (flags & 0x10) != 0 && !this.canProjectVideo(projection)) {
                throw new SecurityException("Requires CAPTURE_VIDEO_OUTPUT or CAPTURE_SECURE_VIDEO_OUTPUT permission, or an appropriate MediaProjection token in order to create a screen sharing virtual display.");
            }
            if (callingUid != 1000 && (flags & 4) != 0 && !this.canProjectSecureVideo(projection)) {
                throw new SecurityException("Requires CAPTURE_SECURE_VIDEO_OUTPUT or an appropriate MediaProjection token to create a secure virtual display.");
            }
            if (callingUid != 1000 && (flags & 0x200) != 0 && !this.checkCallingPermission("android.permission.INTERNAL_SYSTEM_WINDOW", "createVirtualDisplay()")) {
                throw new SecurityException("Requires INTERNAL_SYSTEM_WINDOW permission");
            }
            long token = Binder.clearCallingIdentity();
            try {
                int n = DisplayManagerService.this.createVirtualDisplayInternal(callback, projection, callingUid, packageName, name, width, height, densityDpi, surface, flags, uniqueId);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resizeVirtualDisplay(IVirtualDisplayCallback callback, int width, int height, int densityDpi) {
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.resizeVirtualDisplayInternal(callback.asBinder(), width, height, densityDpi);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVirtualDisplaySurface(IVirtualDisplayCallback callback, Surface surface) {
            if (surface != null && surface.isSingleBuffered()) {
                throw new IllegalArgumentException("Surface can't be single-buffered");
            }
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.setVirtualDisplaySurfaceInternal(callback.asBinder(), surface);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseVirtualDisplay(IVirtualDisplayCallback callback) {
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.releaseVirtualDisplayInternal(callback.asBinder());
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVirtualDisplayState(IVirtualDisplayCallback callback, boolean isOn) {
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.setVirtualDisplayStateInternal(callback.asBinder(), isOn);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(DisplayManagerService.this.mContext, DisplayManagerService.TAG, pw)) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.dumpInternal(pw);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<BrightnessChangeEvent> getBrightnessEvents(String callingPackage) {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.BRIGHTNESS_SLIDER_USAGE", "Permission to read brightness events.");
            int callingUid = Binder.getCallingUid();
            AppOpsManager appOpsManager = DisplayManagerService.this.mContext.getSystemService(AppOpsManager.class);
            int mode = appOpsManager.noteOp(43, callingUid, callingPackage);
            boolean hasUsageStats = mode == 3 ? DisplayManagerService.this.mContext.checkCallingPermission("android.permission.PACKAGE_USAGE_STATS") == 0 : mode == 0;
            int userId = UserHandle.getUserId(callingUid);
            long token = Binder.clearCallingIdentity();
            try {
                SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                synchronized (syncRoot) {
                    ParceledListSlice<BrightnessChangeEvent> parceledListSlice = DisplayManagerService.this.mDisplayPowerController.getBrightnessEvents(userId, hasUsageStats);
                    return parceledListSlice;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<AmbientBrightnessDayStats> getAmbientBrightnessStats() {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_AMBIENT_LIGHT_STATS", "Permission required to to access ambient light stats.");
            int callingUid = Binder.getCallingUid();
            int userId = UserHandle.getUserId(callingUid);
            long token = Binder.clearCallingIdentity();
            try {
                SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                synchronized (syncRoot) {
                    ParceledListSlice<AmbientBrightnessDayStats> parceledListSlice = DisplayManagerService.this.mDisplayPowerController.getAmbientBrightnessStats(userId);
                    return parceledListSlice;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_DISPLAY_BRIGHTNESS", "Permission required to change the display's brightness configuration");
            if (userId != UserHandle.getCallingUserId()) {
                DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", "Permission required to change the display brightness configuration of another user");
            }
            if (packageName != null && !this.validatePackageName(BinderService.getCallingUid(), packageName)) {
                packageName = null;
            }
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerService.this.setBrightnessConfigurationForUserInternal(c, userId, packageName);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BrightnessConfiguration getBrightnessConfigurationForUser(int userId) {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_DISPLAY_BRIGHTNESS", "Permission required to read the display's brightness configuration");
            if (userId != UserHandle.getCallingUserId()) {
                DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", "Permission required to read the display brightness configuration of another user");
            }
            long token = Binder.clearCallingIdentity();
            try {
                int userSerial = DisplayManagerService.this.getUserManager().getUserSerialNumber(userId);
                SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                synchronized (syncRoot) {
                    BrightnessConfiguration config = DisplayManagerService.this.mPersistentDataStore.getBrightnessConfiguration(userSerial);
                    if (config == null) {
                        config = DisplayManagerService.this.mDisplayPowerController.getDefaultBrightnessConfiguration();
                    }
                    BrightnessConfiguration brightnessConfiguration = config;
                    return brightnessConfiguration;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BrightnessConfiguration getDefaultBrightnessConfiguration() {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONFIGURE_DISPLAY_BRIGHTNESS", "Permission required to read the display's default brightness configuration");
            long token = Binder.clearCallingIdentity();
            try {
                SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                synchronized (syncRoot) {
                    BrightnessConfiguration brightnessConfiguration = DisplayManagerService.this.mDisplayPowerController.getDefaultBrightnessConfiguration();
                    return brightnessConfiguration;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTemporaryBrightness(int brightness) {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_BRIGHTNESS", "Permission required to set the display's brightness");
            long token = Binder.clearCallingIdentity();
            try {
                SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                synchronized (syncRoot) {
                    DisplayManagerService.this.mDisplayPowerController.setTemporaryBrightness(brightness);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTemporaryAutoBrightnessAdjustment(float adjustment) {
            DisplayManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_BRIGHTNESS", "Permission required to set the display's auto brightness adjustment");
            long token = Binder.clearCallingIdentity();
            try {
                SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                synchronized (syncRoot) {
                    DisplayManagerService.this.mDisplayPowerController.setTemporaryAutoBrightnessAdjustment(adjustment);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            long token = Binder.clearCallingIdentity();
            try {
                DisplayManagerShellCommand command = new DisplayManagerShellCommand(this);
                command.exec(this, in, out, err, args, callback, resultReceiver);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Curve getMinimumBrightnessCurve() {
            long token = Binder.clearCallingIdentity();
            try {
                Curve curve = DisplayManagerService.this.getMinimumBrightnessCurveInternal();
                return curve;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getPreferredWideGamutColorSpaceId() {
            long token = Binder.clearCallingIdentity();
            try {
                int n = DisplayManagerService.this.getPreferredWideGamutColorSpaceIdInternal();
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        void setBrightness(int brightness) {
            Settings.System.putIntForUser(DisplayManagerService.this.mContext.getContentResolver(), "screen_brightness", brightness, -2);
        }

        void resetBrightnessConfiguration() {
            DisplayManagerService.this.setBrightnessConfigurationForUserInternal(null, DisplayManagerService.this.mContext.getUserId(), DisplayManagerService.this.mContext.getPackageName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setAutoBrightnessLoggingEnabled(boolean enabled) {
            if (DisplayManagerService.this.mDisplayPowerController != null) {
                SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                synchronized (syncRoot) {
                    DisplayManagerService.this.mDisplayPowerController.setAutoBrightnessLoggingEnabled(enabled);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDisplayWhiteBalanceLoggingEnabled(boolean enabled) {
            if (DisplayManagerService.this.mDisplayPowerController != null) {
                SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                synchronized (syncRoot) {
                    DisplayManagerService.this.mDisplayPowerController.setDisplayWhiteBalanceLoggingEnabled(enabled);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setAmbientColorTemperatureOverride(float cct) {
            if (DisplayManagerService.this.mDisplayPowerController != null) {
                SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                synchronized (syncRoot) {
                    DisplayManagerService.this.mDisplayPowerController.setAmbientColorTemperatureOverride(cct);
                }
            }
        }

        private boolean validatePackageName(int uid, String packageName) {
            String[] packageNames;
            if (packageName != null && (packageNames = DisplayManagerService.this.mContext.getPackageManager().getPackagesForUid(uid)) != null) {
                for (String n : packageNames) {
                    if (!n.equals(packageName)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean canProjectVideo(IMediaProjection projection) {
            if (projection != null) {
                try {
                    if (projection.canProjectVideo()) {
                        return true;
                    }
                }
                catch (RemoteException e) {
                    Slog.e(DisplayManagerService.TAG, "Unable to query projection service for permissions", e);
                }
            }
            if (this.checkCallingPermission("android.permission.CAPTURE_VIDEO_OUTPUT", "canProjectVideo()")) {
                return true;
            }
            return this.canProjectSecureVideo(projection);
        }

        private boolean canProjectSecureVideo(IMediaProjection projection) {
            if (projection != null) {
                try {
                    if (projection.canProjectSecureVideo()) {
                        return true;
                    }
                }
                catch (RemoteException e) {
                    Slog.e(DisplayManagerService.TAG, "Unable to query projection service for permissions", e);
                }
            }
            return this.checkCallingPermission("android.permission.CAPTURE_SECURE_VIDEO_OUTPUT", "canProjectSecureVideo()");
        }

        private boolean checkCallingPermission(String permission2, String func) {
            if (DisplayManagerService.this.mContext.checkCallingPermission(permission2) == 0) {
                return true;
            }
            String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
            Slog.w(DisplayManagerService.TAG, msg);
            return false;
        }
    }

    private final class CallbackRecord
    implements IBinder.DeathRecipient {
        public final int mPid;
        private final IDisplayManagerCallback mCallback;
        public boolean mWifiDisplayScanRequested;

        public CallbackRecord(int pid, IDisplayManagerCallback callback) {
            this.mPid = pid;
            this.mCallback = callback;
        }

        @Override
        public void binderDied() {
            DisplayManagerService.this.onCallbackDied(this);
        }

        public void notifyDisplayEventAsync(int displayId, int event) {
            try {
                this.mCallback.onDisplayEvent(displayId, event);
            }
            catch (RemoteException ex) {
                Slog.w(DisplayManagerService.TAG, "Failed to notify process " + this.mPid + " that displays changed, assuming it died.", ex);
                this.binderDied();
            }
        }
    }

    private final class DisplayAdapterListener
    implements DisplayAdapter.Listener {
        private DisplayAdapterListener() {
        }

        @Override
        public void onDisplayDeviceEvent(DisplayDevice device, int event) {
            switch (event) {
                case 1: {
                    DisplayManagerService.this.handleDisplayDeviceAdded(device);
                    break;
                }
                case 2: {
                    DisplayManagerService.this.handleDisplayDeviceChanged(device);
                    break;
                }
                case 3: {
                    DisplayManagerService.this.handleDisplayDeviceRemoved(device);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTraversalRequested() {
            SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
            synchronized (syncRoot) {
                DisplayManagerService.this.scheduleTraversalLocked(false);
            }
        }
    }

    private final class DisplayManagerHandler
    extends Handler {
        public DisplayManagerHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DisplayManagerService.this.registerDefaultDisplayAdapters();
                    break;
                }
                case 2: {
                    DisplayManagerService.this.registerAdditionalDisplayAdapters();
                    break;
                }
                case 3: {
                    DisplayManagerService.this.deliverDisplayEvent(msg.arg1, msg.arg2);
                    break;
                }
                case 4: {
                    DisplayManagerService.this.mWindowManagerInternal.requestTraversalFromDisplayManager();
                    break;
                }
                case 5: {
                    boolean changed;
                    SyncRoot syncRoot = DisplayManagerService.this.mSyncRoot;
                    synchronized (syncRoot) {
                        boolean bl = changed = !DisplayManagerService.this.mTempViewports.equals(DisplayManagerService.this.mViewports);
                        if (changed) {
                            DisplayManagerService.this.mTempViewports.clear();
                            for (DisplayViewport d : DisplayManagerService.this.mViewports) {
                                DisplayManagerService.this.mTempViewports.add(d.makeCopy());
                            }
                        }
                    }
                    if (!changed) break;
                    DisplayManagerService.this.mInputManagerInternal.setDisplayViewports(DisplayManagerService.this.mTempViewports);
                    break;
                }
                case 6: {
                    DisplayManagerService.this.loadBrightnessConfiguration();
                }
            }
        }
    }

    @VisibleForTesting
    static class Injector {
        Injector() {
        }

        VirtualDisplayAdapter getVirtualDisplayAdapter(SyncRoot syncRoot, Context context, Handler handler, DisplayAdapter.Listener displayAdapterListener) {
            return new VirtualDisplayAdapter(syncRoot, context, handler, displayAdapterListener);
        }

        long getDefaultDisplayDelayTimeout() {
            return 10000L;
        }
    }

    public static final class SyncRoot {
    }
}

