/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.Settings;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.DisplayInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class DisplayModeDirector {
    private static final String TAG = "DisplayModeDirector";
    private static final boolean DEBUG = false;
    private static final int MSG_ALLOWED_MODES_CHANGED = 1;
    private static final int GLOBAL_ID = -1;
    private static final float EPSILON = 0.001f;
    private final Object mLock = new Object();
    private final Context mContext;
    private final DisplayModeDirectorHandler mHandler;
    private final SparseArray<SparseArray<Vote>> mVotesByDisplay;
    private final SparseArray<Display.Mode[]> mSupportedModesByDisplay;
    private final SparseArray<Display.Mode> mDefaultModeByDisplay;
    private final AppRequestObserver mAppRequestObserver;
    private final SettingsObserver mSettingsObserver;
    private final DisplayObserver mDisplayObserver;
    private Listener mListener;

    public DisplayModeDirector(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = new DisplayModeDirectorHandler(handler.getLooper());
        this.mVotesByDisplay = new SparseArray();
        this.mSupportedModesByDisplay = new SparseArray();
        this.mDefaultModeByDisplay = new SparseArray();
        this.mAppRequestObserver = new AppRequestObserver();
        this.mSettingsObserver = new SettingsObserver(context, handler);
        this.mDisplayObserver = new DisplayObserver(context, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.mSettingsObserver.observe();
        this.mDisplayObserver.observe();
        this.mSettingsObserver.observe();
        Object object = this.mLock;
        synchronized (object) {
            this.notifyAllowedModesChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAllowedModes(int displayId) {
        Object object = this.mLock;
        synchronized (object) {
            SparseArray<Vote> votes = this.getVotesLocked(displayId);
            Display.Mode[] modes = this.mSupportedModesByDisplay.get(displayId);
            Display.Mode defaultMode = this.mDefaultModeByDisplay.get(displayId);
            if (modes == null || defaultMode == null) {
                Slog.e(TAG, "Asked about unknown display, returning empty allowed set! (id=" + displayId + ")");
                return new int[0];
            }
            return this.getAllowedModesLocked(votes, modes, defaultMode);
        }
    }

    private SparseArray<Vote> getVotesLocked(int displayId) {
        SparseArray<Vote> displayVotes = this.mVotesByDisplay.get(displayId);
        SparseArray<Vote> votes = displayVotes != null ? displayVotes.clone() : new SparseArray<Vote>();
        SparseArray<Vote> globalVotes = this.mVotesByDisplay.get(-1);
        if (globalVotes != null) {
            for (int i = 0; i < globalVotes.size(); ++i) {
                int priority = globalVotes.keyAt(i);
                if (votes.indexOfKey(priority) >= 0) continue;
                votes.put(priority, globalVotes.valueAt(i));
            }
        }
        return votes;
    }

    private int[] getAllowedModesLocked(SparseArray<Vote> votes, Display.Mode[] modes, Display.Mode defaultMode) {
        for (int lowestConsideredPriority = 0; lowestConsideredPriority <= 3; ++lowestConsideredPriority) {
            int[] availableModes;
            float minRefreshRate = 0.0f;
            float maxRefreshRate = Float.POSITIVE_INFINITY;
            int height = -1;
            int width = -1;
            for (int priority = 3; priority >= lowestConsideredPriority; --priority) {
                Vote vote = votes.get(priority);
                if (vote == null) continue;
                minRefreshRate = Math.max(minRefreshRate, vote.minRefreshRate);
                maxRefreshRate = Math.min(maxRefreshRate, vote.maxRefreshRate);
                if (height != -1 || width != -1 || vote.height <= 0 || vote.width <= 0) continue;
                width = vote.width;
                height = vote.height;
            }
            if (height == -1 || width == -1) {
                width = defaultMode.getPhysicalWidth();
                height = defaultMode.getPhysicalHeight();
            }
            if ((availableModes = this.filterModes(modes, width, height, minRefreshRate, maxRefreshRate)).length <= 0) continue;
            return availableModes;
        }
        return new int[]{defaultMode.getModeId()};
    }

    private int[] filterModes(Display.Mode[] supportedModes, int width, int height, float minRefreshRate, float maxRefreshRate) {
        ArrayList<Display.Mode> availableModes = new ArrayList<Display.Mode>();
        for (Display.Mode mode : supportedModes) {
            float refreshRate;
            if (mode.getPhysicalWidth() != width || mode.getPhysicalHeight() != height || (refreshRate = mode.getRefreshRate()) < minRefreshRate - 0.001f || refreshRate > maxRefreshRate + 0.001f) continue;
            availableModes.add(mode);
        }
        int size = availableModes.size();
        int[] availableModeIds = new int[size];
        for (int i = 0; i < size; ++i) {
            availableModeIds[i] = ((Display.Mode)availableModes.get(i)).getModeId();
        }
        return availableModeIds;
    }

    public AppRequestObserver getAppRequestObserver() {
        return this.mAppRequestObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(Listener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        pw.println(TAG);
        Object object = this.mLock;
        synchronized (object) {
            int id2;
            int i;
            pw.println("  mSupportedModesByDisplay:");
            for (i = 0; i < this.mSupportedModesByDisplay.size(); ++i) {
                id2 = this.mSupportedModesByDisplay.keyAt(i);
                Object[] modes = this.mSupportedModesByDisplay.valueAt(i);
                pw.println("    " + id2 + " -> " + Arrays.toString(modes));
            }
            pw.println("  mDefaultModeByDisplay:");
            for (i = 0; i < this.mDefaultModeByDisplay.size(); ++i) {
                id2 = this.mDefaultModeByDisplay.keyAt(i);
                Display.Mode mode = this.mDefaultModeByDisplay.valueAt(i);
                pw.println("    " + id2 + " -> " + mode);
            }
            pw.println("  mVotesByDisplay:");
            for (i = 0; i < this.mVotesByDisplay.size(); ++i) {
                pw.println("    " + this.mVotesByDisplay.keyAt(i) + ":");
                SparseArray<Vote> votes = this.mVotesByDisplay.valueAt(i);
                for (int p = 3; p >= 0; --p) {
                    Vote vote = votes.get(p);
                    if (vote == null) continue;
                    pw.println("      " + Vote.priorityToString(p) + " -> " + vote);
                }
            }
            this.mSettingsObserver.dumpLocked(pw);
            this.mAppRequestObserver.dumpLocked(pw);
        }
    }

    private void updateVoteLocked(int priority, Vote vote) {
        this.updateVoteLocked(-1, priority, vote);
    }

    private void updateVoteLocked(int displayId, int priority, Vote vote) {
        if (priority < 0 || priority > 3) {
            Slog.w(TAG, "Received a vote with an invalid priority, ignoring: priority=" + Vote.priorityToString(priority) + ", vote=" + vote, new Throwable());
            return;
        }
        SparseArray<Vote> votes = this.getOrCreateVotesByDisplay(displayId);
        Vote currentVote = votes.get(priority);
        if (vote != null) {
            votes.put(priority, vote);
        } else {
            votes.remove(priority);
        }
        if (votes.size() == 0) {
            this.mVotesByDisplay.remove(displayId);
        }
        this.notifyAllowedModesChangedLocked();
    }

    private void notifyAllowedModesChangedLocked() {
        if (this.mListener != null && !this.mHandler.hasMessages(1)) {
            Message msg = this.mHandler.obtainMessage(1, this.mListener);
            msg.sendToTarget();
        }
    }

    private SparseArray<Vote> getOrCreateVotesByDisplay(int displayId) {
        int index = this.mVotesByDisplay.indexOfKey(displayId);
        if (this.mVotesByDisplay.indexOfKey(displayId) >= 0) {
            return this.mVotesByDisplay.get(displayId);
        }
        SparseArray<Vote> votes = new SparseArray<Vote>();
        this.mVotesByDisplay.put(displayId, votes);
        return votes;
    }

    private final class DisplayObserver
    implements DisplayManager.DisplayListener {
        private final Context mContext;
        private final Handler mHandler;

        DisplayObserver(Context context, Handler handler) {
            this.mContext = context;
            this.mHandler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void observe() {
            Display[] displays;
            DisplayManager dm = this.mContext.getSystemService(DisplayManager.class);
            dm.registerDisplayListener(this, this.mHandler);
            SparseArray<Display.Mode[]> modes = new SparseArray<Display.Mode[]>();
            SparseArray<Display.Mode> defaultModes = new SparseArray<Display.Mode>();
            DisplayInfo info = new DisplayInfo();
            for (Display d : displays = dm.getDisplays()) {
                int displayId = d.getDisplayId();
                d.getDisplayInfo(info);
                modes.put(displayId, info.supportedModes);
                defaultModes.put(displayId, info.getDefaultMode());
            }
            Object object = DisplayModeDirector.this.mLock;
            synchronized (object) {
                int size = modes.size();
                for (int i = 0; i < size; ++i) {
                    DisplayModeDirector.this.mSupportedModesByDisplay.put(modes.keyAt(i), (Display.Mode[])modes.valueAt(i));
                    DisplayModeDirector.this.mDefaultModeByDisplay.put(defaultModes.keyAt(i), (Display.Mode)defaultModes.valueAt(i));
                }
            }
        }

        @Override
        public void onDisplayAdded(int displayId) {
            this.updateDisplayModes(displayId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayRemoved(int displayId) {
            Object object = DisplayModeDirector.this.mLock;
            synchronized (object) {
                DisplayModeDirector.this.mSupportedModesByDisplay.remove(displayId);
                DisplayModeDirector.this.mDefaultModeByDisplay.remove(displayId);
            }
        }

        @Override
        public void onDisplayChanged(int displayId) {
            this.updateDisplayModes(displayId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDisplayModes(int displayId) {
            Display d = this.mContext.getSystemService(DisplayManager.class).getDisplay(displayId);
            if (d == null) {
                return;
            }
            DisplayInfo info = new DisplayInfo();
            d.getDisplayInfo(info);
            boolean changed = false;
            Object object = DisplayModeDirector.this.mLock;
            synchronized (object) {
                if (!Arrays.equals((Object[])DisplayModeDirector.this.mSupportedModesByDisplay.get(displayId), info.supportedModes)) {
                    DisplayModeDirector.this.mSupportedModesByDisplay.put(displayId, info.supportedModes);
                    changed = true;
                }
                if (!Objects.equals(DisplayModeDirector.this.mDefaultModeByDisplay.get(displayId), info.getDefaultMode())) {
                    changed = true;
                    DisplayModeDirector.this.mDefaultModeByDisplay.put(displayId, info.getDefaultMode());
                }
                if (changed) {
                    DisplayModeDirector.this.notifyAllowedModesChangedLocked();
                }
            }
        }
    }

    final class AppRequestObserver {
        private SparseArray<Display.Mode> mAppRequestedModeByDisplay = new SparseArray();

        AppRequestObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAppRequestedMode(int displayId, int modeId) {
            Object object = DisplayModeDirector.this.mLock;
            synchronized (object) {
                this.setAppRequestedModeLocked(displayId, modeId);
            }
        }

        private void setAppRequestedModeLocked(int displayId, int modeId) {
            Vote sizeVote;
            Vote refreshRateVote;
            Display.Mode requestedMode = this.findModeByIdLocked(displayId, modeId);
            if (Objects.equals(requestedMode, this.mAppRequestedModeByDisplay.get(displayId))) {
                return;
            }
            if (requestedMode != null) {
                this.mAppRequestedModeByDisplay.put(displayId, requestedMode);
                float refreshRate = requestedMode.getRefreshRate();
                refreshRateVote = Vote.forRefreshRates(refreshRate, refreshRate);
                sizeVote = Vote.forSize(requestedMode.getPhysicalWidth(), requestedMode.getPhysicalHeight());
            } else {
                this.mAppRequestedModeByDisplay.remove(displayId);
                refreshRateVote = null;
                sizeVote = null;
            }
            DisplayModeDirector.this.updateVoteLocked(displayId, 1, refreshRateVote);
            DisplayModeDirector.this.updateVoteLocked(displayId, 2, sizeVote);
        }

        private Display.Mode findModeByIdLocked(int displayId, int modeId) {
            Display.Mode[] modes = (Display.Mode[])DisplayModeDirector.this.mSupportedModesByDisplay.get(displayId);
            if (modes == null) {
                return null;
            }
            for (Display.Mode mode : modes) {
                if (mode.getModeId() != modeId) continue;
                return mode;
            }
            return null;
        }

        public void dumpLocked(PrintWriter pw) {
            pw.println("  AppRequestObserver");
            pw.println("    mAppRequestedModeByDisplay:");
            for (int i = 0; i < this.mAppRequestedModeByDisplay.size(); ++i) {
                int id2 = this.mAppRequestedModeByDisplay.keyAt(i);
                Display.Mode mode = this.mAppRequestedModeByDisplay.valueAt(i);
                pw.println("    " + id2 + " -> " + mode);
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri mRefreshRateSetting;
        private final Uri mLowPowerModeSetting;
        private final Context mContext;
        private final float mDefaultPeakRefreshRate;

        SettingsObserver(Context context, Handler handler) {
            super(handler);
            this.mRefreshRateSetting = Settings.System.getUriFor("peak_refresh_rate");
            this.mLowPowerModeSetting = Settings.Global.getUriFor("low_power");
            this.mContext = context;
            this.mDefaultPeakRefreshRate = context.getResources().getInteger(17694779);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void observe() {
            ContentResolver cr = this.mContext.getContentResolver();
            cr.registerContentObserver(this.mRefreshRateSetting, false, this, 0);
            cr.registerContentObserver(this.mLowPowerModeSetting, false, this, 0);
            Object object = DisplayModeDirector.this.mLock;
            synchronized (object) {
                this.updateRefreshRateSettingLocked();
                this.updateLowPowerModeSettingLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            Object object = DisplayModeDirector.this.mLock;
            synchronized (object) {
                if (this.mRefreshRateSetting.equals(uri)) {
                    this.updateRefreshRateSettingLocked();
                } else if (this.mLowPowerModeSetting.equals(uri)) {
                    this.updateLowPowerModeSettingLocked();
                }
            }
        }

        private void updateLowPowerModeSettingLocked() {
            boolean inLowPowerMode = Settings.Global.getInt(this.mContext.getContentResolver(), "low_power", 0) != 0;
            Vote vote = inLowPowerMode ? Vote.forRefreshRates(0.0f, 60.0f) : null;
            DisplayModeDirector.this.updateVoteLocked(3, vote);
        }

        private void updateRefreshRateSettingLocked() {
            float peakRefreshRate = Settings.System.getFloat(this.mContext.getContentResolver(), "peak_refresh_rate", this.mDefaultPeakRefreshRate);
            Vote vote = Vote.forRefreshRates(0.0f, peakRefreshRate);
            DisplayModeDirector.this.updateVoteLocked(0, vote);
        }

        public void dumpLocked(PrintWriter pw) {
            pw.println("  SettingsObserver");
            pw.println("    mDefaultPeakRefreshRate: " + this.mDefaultPeakRefreshRate);
        }
    }

    private static final class Vote {
        public static final int PRIORITY_USER_SETTING = 0;
        public static final int PRIORITY_APP_REQUEST_REFRESH_RATE = 1;
        public static final int PRIORITY_APP_REQUEST_SIZE = 2;
        public static final int PRIORITY_LOW_POWER_MODE = 3;
        public static final int MIN_PRIORITY = 0;
        public static final int MAX_PRIORITY = 3;
        public static final int INVALID_SIZE = -1;
        public final int width;
        public final int height;
        public final float minRefreshRate;
        public final float maxRefreshRate;

        public static Vote forRefreshRates(float minRefreshRate, float maxRefreshRate) {
            return new Vote(-1, -1, minRefreshRate, maxRefreshRate);
        }

        public static Vote forSize(int width, int height) {
            return new Vote(width, height, 0.0f, Float.POSITIVE_INFINITY);
        }

        private Vote(int width, int height, float minRefreshRate, float maxRefreshRate) {
            this.width = width;
            this.height = height;
            this.minRefreshRate = minRefreshRate;
            this.maxRefreshRate = maxRefreshRate;
        }

        public static String priorityToString(int priority) {
            switch (priority) {
                case 0: {
                    return "PRIORITY_USER_SETTING";
                }
                case 1: {
                    return "PRIORITY_APP_REQUEST_REFRESH_RATE";
                }
                case 2: {
                    return "PRIORITY_APP_REQUEST_SIZE";
                }
                case 3: {
                    return "PRIORITY_LOW_POWER_MODE";
                }
            }
            return Integer.toString(priority);
        }

        public String toString() {
            return "Vote{width=" + this.width + ", height=" + this.height + ", minRefreshRate=" + this.minRefreshRate + ", maxRefreshRate=" + this.maxRefreshRate + "}";
        }
    }

    private static final class DisplayModeDirectorHandler
    extends Handler {
        DisplayModeDirectorHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Listener listener = (Listener)msg.obj;
                    listener.onAllowedDisplayModesChanged();
                }
            }
        }
    }

    public static interface Listener {
        public void onAllowedDisplayModesChanged();
    }
}

