/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import java.io.PrintWriter;
import java.util.Arrays;

final class HysteresisLevels {
    private static final String TAG = "HysteresisLevels";
    private static final float DEFAULT_BRIGHTENING_HYSTERESIS = 0.1f;
    private static final float DEFAULT_DARKENING_HYSTERESIS = 0.2f;
    private static final boolean DEBUG = false;
    private final float[] mBrighteningThresholds;
    private final float[] mDarkeningThresholds;
    private final float[] mThresholdLevels;

    HysteresisLevels(int[] brighteningThresholds, int[] darkeningThresholds, int[] thresholdLevels) {
        if (brighteningThresholds.length != darkeningThresholds.length || darkeningThresholds.length != thresholdLevels.length + 1) {
            throw new IllegalArgumentException("Mismatch between hysteresis array lengths.");
        }
        this.mBrighteningThresholds = this.setArrayFormat(brighteningThresholds, 1000.0f);
        this.mDarkeningThresholds = this.setArrayFormat(darkeningThresholds, 1000.0f);
        this.mThresholdLevels = this.setArrayFormat(thresholdLevels, 1.0f);
    }

    float getBrighteningThreshold(float value) {
        float brightConstant = this.getReferenceLevel(value, this.mBrighteningThresholds);
        float brightThreshold = value * (1.0f + brightConstant);
        return brightThreshold;
    }

    float getDarkeningThreshold(float value) {
        float darkConstant = this.getReferenceLevel(value, this.mDarkeningThresholds);
        float darkThreshold = value * (1.0f - darkConstant);
        return darkThreshold;
    }

    private float getReferenceLevel(float value, float[] referenceLevels) {
        int index;
        for (index = 0; this.mThresholdLevels.length > index && value >= this.mThresholdLevels[index]; ++index) {
        }
        return referenceLevels[index];
    }

    private float[] setArrayFormat(int[] configArray, float divideFactor) {
        float[] levelArray = new float[configArray.length];
        for (int index = 0; levelArray.length > index; ++index) {
            levelArray[index] = (float)configArray[index] / divideFactor;
        }
        return levelArray;
    }

    void dump(PrintWriter pw) {
        pw.println(TAG);
        pw.println("  mBrighteningThresholds=" + Arrays.toString(this.mBrighteningThresholds));
        pw.println("  mDarkeningThresholds=" + Arrays.toString(this.mDarkeningThresholds));
        pw.println("  mThresholdLevels=" + Arrays.toString(this.mThresholdLevels));
    }
}

