/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.graphics.Point;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.WifiDisplay;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.display.DisplayDevice;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class PersistentDataStore {
    static final String TAG = "DisplayManager";
    private static final String TAG_DISPLAY_MANAGER_STATE = "display-manager-state";
    private static final String TAG_REMEMBERED_WIFI_DISPLAYS = "remembered-wifi-displays";
    private static final String TAG_WIFI_DISPLAY = "wifi-display";
    private static final String ATTR_DEVICE_ADDRESS = "deviceAddress";
    private static final String ATTR_DEVICE_NAME = "deviceName";
    private static final String ATTR_DEVICE_ALIAS = "deviceAlias";
    private static final String TAG_DISPLAY_STATES = "display-states";
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_COLOR_MODE = "color-mode";
    private static final String ATTR_UNIQUE_ID = "unique-id";
    private static final String TAG_STABLE_DEVICE_VALUES = "stable-device-values";
    private static final String TAG_STABLE_DISPLAY_HEIGHT = "stable-display-height";
    private static final String TAG_STABLE_DISPLAY_WIDTH = "stable-display-width";
    private static final String TAG_BRIGHTNESS_CONFIGURATIONS = "brightness-configurations";
    private static final String TAG_BRIGHTNESS_CONFIGURATION = "brightness-configuration";
    private static final String ATTR_USER_SERIAL = "user-serial";
    private static final String ATTR_PACKAGE_NAME = "package-name";
    private static final String ATTR_TIME_STAMP = "timestamp";
    private ArrayList<WifiDisplay> mRememberedWifiDisplays = new ArrayList();
    private final HashMap<String, DisplayState> mDisplayStates = new HashMap();
    private final StableDeviceValues mStableDeviceValues = new StableDeviceValues();
    private BrightnessConfigurations mBrightnessConfigurations = new BrightnessConfigurations();
    private boolean mLoaded;
    private boolean mDirty;
    private Injector mInjector;

    public PersistentDataStore() {
        this(new Injector());
    }

    @VisibleForTesting
    PersistentDataStore(Injector injector) {
        this.mInjector = injector;
    }

    public void saveIfNeeded() {
        if (this.mDirty) {
            this.save();
            this.mDirty = false;
        }
    }

    public WifiDisplay getRememberedWifiDisplay(String deviceAddress) {
        this.loadIfNeeded();
        int index = this.findRememberedWifiDisplay(deviceAddress);
        if (index >= 0) {
            return this.mRememberedWifiDisplays.get(index);
        }
        return null;
    }

    public WifiDisplay[] getRememberedWifiDisplays() {
        this.loadIfNeeded();
        return this.mRememberedWifiDisplays.toArray(new WifiDisplay[this.mRememberedWifiDisplays.size()]);
    }

    public WifiDisplay applyWifiDisplayAlias(WifiDisplay display) {
        if (display != null) {
            this.loadIfNeeded();
            String alias = null;
            int index = this.findRememberedWifiDisplay(display.getDeviceAddress());
            if (index >= 0) {
                alias = this.mRememberedWifiDisplays.get(index).getDeviceAlias();
            }
            if (!Objects.equals(display.getDeviceAlias(), alias)) {
                return new WifiDisplay(display.getDeviceAddress(), display.getDeviceName(), alias, display.isAvailable(), display.canConnect(), display.isRemembered());
            }
        }
        return display;
    }

    public WifiDisplay[] applyWifiDisplayAliases(WifiDisplay[] displays) {
        WifiDisplay[] results = displays;
        if (results != null) {
            int count = displays.length;
            for (int i = 0; i < count; ++i) {
                WifiDisplay result = this.applyWifiDisplayAlias(displays[i]);
                if (result == displays[i]) continue;
                if (results == displays) {
                    results = new WifiDisplay[count];
                    System.arraycopy(displays, 0, results, 0, count);
                }
                results[i] = result;
            }
        }
        return results;
    }

    public boolean rememberWifiDisplay(WifiDisplay display) {
        this.loadIfNeeded();
        int index = this.findRememberedWifiDisplay(display.getDeviceAddress());
        if (index >= 0) {
            WifiDisplay other = this.mRememberedWifiDisplays.get(index);
            if (other.equals(display)) {
                return false;
            }
            this.mRememberedWifiDisplays.set(index, display);
        } else {
            this.mRememberedWifiDisplays.add(display);
        }
        this.setDirty();
        return true;
    }

    public boolean forgetWifiDisplay(String deviceAddress) {
        this.loadIfNeeded();
        int index = this.findRememberedWifiDisplay(deviceAddress);
        if (index >= 0) {
            this.mRememberedWifiDisplays.remove(index);
            this.setDirty();
            return true;
        }
        return false;
    }

    private int findRememberedWifiDisplay(String deviceAddress) {
        int count = this.mRememberedWifiDisplays.size();
        for (int i = 0; i < count; ++i) {
            if (!this.mRememberedWifiDisplays.get(i).getDeviceAddress().equals(deviceAddress)) continue;
            return i;
        }
        return -1;
    }

    public int getColorMode(DisplayDevice device) {
        if (!device.hasStableUniqueId()) {
            return -1;
        }
        DisplayState state = this.getDisplayState(device.getUniqueId(), false);
        if (state == null) {
            return -1;
        }
        return state.getColorMode();
    }

    public boolean setColorMode(DisplayDevice device, int colorMode) {
        if (!device.hasStableUniqueId()) {
            return false;
        }
        DisplayState state = this.getDisplayState(device.getUniqueId(), true);
        if (state.setColorMode(colorMode)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public Point getStableDisplaySize() {
        this.loadIfNeeded();
        return this.mStableDeviceValues.getDisplaySize();
    }

    public void setStableDisplaySize(Point size) {
        this.loadIfNeeded();
        if (this.mStableDeviceValues.setDisplaySize(size)) {
            this.setDirty();
        }
    }

    public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userSerial, String packageName) {
        this.loadIfNeeded();
        if (this.mBrightnessConfigurations.setBrightnessConfigurationForUser(c, userSerial, packageName)) {
            this.setDirty();
        }
    }

    public BrightnessConfiguration getBrightnessConfiguration(int userSerial) {
        this.loadIfNeeded();
        return this.mBrightnessConfigurations.getBrightnessConfiguration(userSerial);
    }

    private DisplayState getDisplayState(String uniqueId, boolean createIfAbsent) {
        this.loadIfNeeded();
        DisplayState state = this.mDisplayStates.get(uniqueId);
        if (state == null && createIfAbsent) {
            state = new DisplayState();
            this.mDisplayStates.put(uniqueId, state);
            this.setDirty();
        }
        return state;
    }

    public void loadIfNeeded() {
        if (!this.mLoaded) {
            this.load();
            this.mLoaded = true;
        }
    }

    private void setDirty() {
        this.mDirty = true;
    }

    private void clearState() {
        this.mRememberedWifiDisplays.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        InputStream is;
        this.clearState();
        try {
            is = this.mInjector.openRead();
        }
        catch (FileNotFoundException ex) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new BufferedInputStream(is), StandardCharsets.UTF_8.name());
            this.loadFromXml(parser);
        }
        catch (IOException ex) {
            Slog.w(TAG, "Failed to load display manager persistent store data.", ex);
            this.clearState();
        }
        catch (XmlPullParserException ex) {
            Slog.w(TAG, "Failed to load display manager persistent store data.", ex);
            this.clearState();
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        try {
            OutputStream os = this.mInjector.startWrite();
            boolean success = false;
            try {
                FastXmlSerializer serializer = new FastXmlSerializer();
                serializer.setOutput(new BufferedOutputStream(os), StandardCharsets.UTF_8.name());
                this.saveToXml(serializer);
                serializer.flush();
                success = true;
            }
            finally {
                this.mInjector.finishWrite(os, success);
            }
        }
        catch (IOException ex) {
            Slog.w(TAG, "Failed to save display manager persistent store data.", ex);
        }
    }

    private void loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        XmlUtils.beginDocument(parser, TAG_DISPLAY_MANAGER_STATE);
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (parser.getName().equals(TAG_REMEMBERED_WIFI_DISPLAYS)) {
                this.loadRememberedWifiDisplaysFromXml(parser);
            }
            if (parser.getName().equals(TAG_DISPLAY_STATES)) {
                this.loadDisplaysFromXml(parser);
            }
            if (parser.getName().equals(TAG_STABLE_DEVICE_VALUES)) {
                this.mStableDeviceValues.loadFromXml(parser);
            }
            if (!parser.getName().equals(TAG_BRIGHTNESS_CONFIGURATIONS)) continue;
            this.mBrightnessConfigurations.loadFromXml(parser);
        }
    }

    private void loadRememberedWifiDisplaysFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!parser.getName().equals(TAG_WIFI_DISPLAY)) continue;
            String deviceAddress = parser.getAttributeValue(null, ATTR_DEVICE_ADDRESS);
            String deviceName = parser.getAttributeValue(null, ATTR_DEVICE_NAME);
            String deviceAlias = parser.getAttributeValue(null, ATTR_DEVICE_ALIAS);
            if (deviceAddress == null || deviceName == null) {
                throw new XmlPullParserException("Missing deviceAddress or deviceName attribute on wifi-display.");
            }
            if (this.findRememberedWifiDisplay(deviceAddress) >= 0) {
                throw new XmlPullParserException("Found duplicate wifi display device address.");
            }
            this.mRememberedWifiDisplays.add(new WifiDisplay(deviceAddress, deviceName, deviceAlias, false, false, false));
        }
    }

    private void loadDisplaysFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!parser.getName().equals(TAG_DISPLAY)) continue;
            String uniqueId = parser.getAttributeValue(null, ATTR_UNIQUE_ID);
            if (uniqueId == null) {
                throw new XmlPullParserException("Missing unique-id attribute on display.");
            }
            if (this.mDisplayStates.containsKey(uniqueId)) {
                throw new XmlPullParserException("Found duplicate display.");
            }
            DisplayState state = new DisplayState();
            state.loadFromXml(parser);
            this.mDisplayStates.put(uniqueId, state);
        }
    }

    private void saveToXml(XmlSerializer serializer) throws IOException {
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.startTag(null, TAG_DISPLAY_MANAGER_STATE);
        serializer.startTag(null, TAG_REMEMBERED_WIFI_DISPLAYS);
        for (WifiDisplay wifiDisplay : this.mRememberedWifiDisplays) {
            serializer.startTag(null, TAG_WIFI_DISPLAY);
            serializer.attribute(null, ATTR_DEVICE_ADDRESS, wifiDisplay.getDeviceAddress());
            serializer.attribute(null, ATTR_DEVICE_NAME, wifiDisplay.getDeviceName());
            if (wifiDisplay.getDeviceAlias() != null) {
                serializer.attribute(null, ATTR_DEVICE_ALIAS, wifiDisplay.getDeviceAlias());
            }
            serializer.endTag(null, TAG_WIFI_DISPLAY);
        }
        serializer.endTag(null, TAG_REMEMBERED_WIFI_DISPLAYS);
        serializer.startTag(null, TAG_DISPLAY_STATES);
        for (Map.Entry entry : this.mDisplayStates.entrySet()) {
            String uniqueId = (String)entry.getKey();
            DisplayState state = (DisplayState)entry.getValue();
            serializer.startTag(null, TAG_DISPLAY);
            serializer.attribute(null, ATTR_UNIQUE_ID, uniqueId);
            state.saveToXml(serializer);
            serializer.endTag(null, TAG_DISPLAY);
        }
        serializer.endTag(null, TAG_DISPLAY_STATES);
        serializer.startTag(null, TAG_STABLE_DEVICE_VALUES);
        this.mStableDeviceValues.saveToXml(serializer);
        serializer.endTag(null, TAG_STABLE_DEVICE_VALUES);
        serializer.startTag(null, TAG_BRIGHTNESS_CONFIGURATIONS);
        this.mBrightnessConfigurations.saveToXml(serializer);
        serializer.endTag(null, TAG_BRIGHTNESS_CONFIGURATIONS);
        serializer.endTag(null, TAG_DISPLAY_MANAGER_STATE);
        serializer.endDocument();
    }

    public void dump(PrintWriter pw) {
        pw.println("PersistentDataStore");
        pw.println("  mLoaded=" + this.mLoaded);
        pw.println("  mDirty=" + this.mDirty);
        pw.println("  RememberedWifiDisplays:");
        int i = 0;
        for (WifiDisplay wifiDisplay : this.mRememberedWifiDisplays) {
            pw.println("    " + i++ + ": " + wifiDisplay);
        }
        pw.println("  DisplayStates:");
        i = 0;
        for (Map.Entry entry : this.mDisplayStates.entrySet()) {
            pw.println("    " + i++ + ": " + (String)entry.getKey());
            ((DisplayState)entry.getValue()).dump(pw, "      ");
        }
        pw.println("  StableDeviceValues:");
        this.mStableDeviceValues.dump(pw, "      ");
        pw.println("  BrightnessConfigurations:");
        this.mBrightnessConfigurations.dump(pw, "      ");
    }

    @VisibleForTesting
    static class Injector {
        private final AtomicFile mAtomicFile = new AtomicFile(new File("/data/system/display-manager-state.xml"), "display-state");

        public InputStream openRead() throws FileNotFoundException {
            return this.mAtomicFile.openRead();
        }

        public OutputStream startWrite() throws IOException {
            return this.mAtomicFile.startWrite();
        }

        public void finishWrite(OutputStream os, boolean success) {
            if (!(os instanceof FileOutputStream)) {
                throw new IllegalArgumentException("Unexpected OutputStream as argument: " + os);
            }
            FileOutputStream fos = (FileOutputStream)os;
            if (success) {
                this.mAtomicFile.finishWrite(fos);
            } else {
                this.mAtomicFile.failWrite(fos);
            }
        }
    }

    private static final class BrightnessConfigurations {
        private SparseArray<BrightnessConfiguration> mConfigurations = new SparseArray();
        private SparseLongArray mTimeStamps = new SparseLongArray();
        private SparseArray<String> mPackageNames = new SparseArray();

        private boolean setBrightnessConfigurationForUser(BrightnessConfiguration c, int userSerial, String packageName) {
            BrightnessConfiguration currentConfig = this.mConfigurations.get(userSerial);
            if (!(currentConfig == c || currentConfig != null && currentConfig.equals(c))) {
                if (c != null) {
                    if (packageName == null) {
                        this.mPackageNames.remove(userSerial);
                    } else {
                        this.mPackageNames.put(userSerial, packageName);
                    }
                    this.mTimeStamps.put(userSerial, System.currentTimeMillis());
                    this.mConfigurations.put(userSerial, c);
                } else {
                    this.mPackageNames.remove(userSerial);
                    this.mTimeStamps.delete(userSerial);
                    this.mConfigurations.remove(userSerial);
                }
                return true;
            }
            return false;
        }

        public BrightnessConfiguration getBrightnessConfiguration(int userSerial) {
            return this.mConfigurations.get(userSerial);
        }

        public void loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
            int outerDepth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                int userSerial;
                if (!PersistentDataStore.TAG_BRIGHTNESS_CONFIGURATION.equals(parser.getName())) continue;
                try {
                    userSerial = Integer.parseInt(parser.getAttributeValue(null, PersistentDataStore.ATTR_USER_SERIAL));
                }
                catch (NumberFormatException nfe) {
                    userSerial = -1;
                    Slog.e(PersistentDataStore.TAG, "Failed to read in brightness configuration", nfe);
                }
                String packageName = parser.getAttributeValue(null, PersistentDataStore.ATTR_PACKAGE_NAME);
                String timeStampString = parser.getAttributeValue(null, PersistentDataStore.ATTR_TIME_STAMP);
                long timeStamp = -1L;
                if (timeStampString != null) {
                    try {
                        timeStamp = Long.parseLong(timeStampString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                try {
                    BrightnessConfiguration config = BrightnessConfiguration.loadFromXml(parser);
                    if (userSerial < 0 || config == null) continue;
                    this.mConfigurations.put(userSerial, config);
                    if (timeStamp != -1L) {
                        this.mTimeStamps.put(userSerial, timeStamp);
                    }
                    if (packageName == null) continue;
                    this.mPackageNames.put(userSerial, packageName);
                }
                catch (IllegalArgumentException iae) {
                    Slog.e(PersistentDataStore.TAG, "Failed to load brightness configuration!", iae);
                }
            }
        }

        public void saveToXml(XmlSerializer serializer) throws IOException {
            for (int i = 0; i < this.mConfigurations.size(); ++i) {
                long timestamp;
                int userSerial = this.mConfigurations.keyAt(i);
                BrightnessConfiguration config = this.mConfigurations.valueAt(i);
                serializer.startTag(null, PersistentDataStore.TAG_BRIGHTNESS_CONFIGURATION);
                serializer.attribute(null, PersistentDataStore.ATTR_USER_SERIAL, Integer.toString(userSerial));
                String packageName = this.mPackageNames.get(userSerial);
                if (packageName != null) {
                    serializer.attribute(null, PersistentDataStore.ATTR_PACKAGE_NAME, packageName);
                }
                if ((timestamp = this.mTimeStamps.get(userSerial, -1L)) != -1L) {
                    serializer.attribute(null, PersistentDataStore.ATTR_TIME_STAMP, Long.toString(timestamp));
                }
                config.saveToXml(serializer);
                serializer.endTag(null, PersistentDataStore.TAG_BRIGHTNESS_CONFIGURATION);
            }
        }

        public void dump(PrintWriter pw, String prefix) {
            for (int i = 0; i < this.mConfigurations.size(); ++i) {
                int userSerial = this.mConfigurations.keyAt(i);
                long time = this.mTimeStamps.get(userSerial, -1L);
                String packageName = this.mPackageNames.get(userSerial);
                pw.println(prefix + "User " + userSerial + ":");
                if (time != -1L) {
                    pw.println(prefix + "  set at: " + TimeUtils.formatForLogging(time));
                }
                if (packageName != null) {
                    pw.println(prefix + "  set by: " + packageName);
                }
                pw.println(prefix + "  " + this.mConfigurations.valueAt(i));
            }
        }
    }

    private static final class StableDeviceValues {
        private int mWidth;
        private int mHeight;

        private StableDeviceValues() {
        }

        private Point getDisplaySize() {
            return new Point(this.mWidth, this.mHeight);
        }

        public boolean setDisplaySize(Point r) {
            if (this.mWidth != r.x || this.mHeight != r.y) {
                this.mWidth = r.x;
                this.mHeight = r.y;
                return true;
            }
            return false;
        }

        public void loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
            int outerDepth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                switch (parser.getName()) {
                    case "stable-display-width": {
                        this.mWidth = StableDeviceValues.loadIntValue(parser);
                        break;
                    }
                    case "stable-display-height": {
                        this.mHeight = StableDeviceValues.loadIntValue(parser);
                    }
                }
            }
        }

        private static int loadIntValue(XmlPullParser parser) throws IOException, XmlPullParserException {
            try {
                String value = parser.nextText();
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }

        public void saveToXml(XmlSerializer serializer) throws IOException {
            if (this.mWidth > 0 && this.mHeight > 0) {
                serializer.startTag(null, PersistentDataStore.TAG_STABLE_DISPLAY_WIDTH);
                serializer.text(Integer.toString(this.mWidth));
                serializer.endTag(null, PersistentDataStore.TAG_STABLE_DISPLAY_WIDTH);
                serializer.startTag(null, PersistentDataStore.TAG_STABLE_DISPLAY_HEIGHT);
                serializer.text(Integer.toString(this.mHeight));
                serializer.endTag(null, PersistentDataStore.TAG_STABLE_DISPLAY_HEIGHT);
            }
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + "StableDisplayWidth=" + this.mWidth);
            pw.println(prefix + "StableDisplayHeight=" + this.mHeight);
        }
    }

    private static final class DisplayState {
        private int mColorMode;

        private DisplayState() {
        }

        public boolean setColorMode(int colorMode) {
            if (colorMode == this.mColorMode) {
                return false;
            }
            this.mColorMode = colorMode;
            return true;
        }

        public int getColorMode() {
            return this.mColorMode;
        }

        public void loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
            int outerDepth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                if (!parser.getName().equals(PersistentDataStore.TAG_COLOR_MODE)) continue;
                String value = parser.nextText();
                this.mColorMode = Integer.parseInt(value);
            }
        }

        public void saveToXml(XmlSerializer serializer) throws IOException {
            serializer.startTag(null, PersistentDataStore.TAG_COLOR_MODE);
            serializer.text(Integer.toString(this.mColorMode));
            serializer.endTag(null, PersistentDataStore.TAG_COLOR_MODE);
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + "ColorMode=" + this.mColorMode);
        }
    }
}

