/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.color;

import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.display.color.ColorDisplayService;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class AppSaturationController {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final Map<String, SparseArray<SaturationController>> mAppsMap = new HashMap<String, SparseArray<SaturationController>>();
    @VisibleForTesting
    static final float[] TRANSLATION_VECTOR = new float[]{0.0f, 0.0f, 0.0f};

    AppSaturationController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addColorTransformController(String packageName, int userId, WeakReference<ColorDisplayService.ColorTransformController> controller) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getSaturationControllerLocked(packageName, userId).addColorTransformController(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSaturationLevel(String packageName, int userId, int saturationLevel) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getSaturationControllerLocked(packageName, userId).setSaturationLevel(saturationLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("App Saturation: ");
            if (this.mAppsMap.size() == 0) {
                pw.println("    No packages");
                return;
            }
            ArrayList<String> packageNames = new ArrayList<String>(this.mAppsMap.keySet());
            Collections.sort(packageNames);
            for (String packageName : packageNames) {
                pw.println("    " + packageName + ":");
                SparseArray<SaturationController> appUserIdMap = this.mAppsMap.get(packageName);
                for (int i = 0; i < appUserIdMap.size(); ++i) {
                    pw.println("        " + appUserIdMap.keyAt(i) + ":");
                    appUserIdMap.valueAt(i).dump(pw);
                }
            }
        }
    }

    private SaturationController getSaturationControllerLocked(String packageName, int userId) {
        return this.getOrCreateSaturationControllerLocked(this.getOrCreateUserIdMapLocked(packageName), userId);
    }

    private SparseArray<SaturationController> getOrCreateUserIdMapLocked(String packageName) {
        if (this.mAppsMap.get(packageName) != null) {
            return this.mAppsMap.get(packageName);
        }
        SparseArray<SaturationController> appUserIdMap = new SparseArray<SaturationController>();
        this.mAppsMap.put(packageName, appUserIdMap);
        return appUserIdMap;
    }

    private SaturationController getOrCreateSaturationControllerLocked(SparseArray<SaturationController> appUserIdMap, int userId) {
        if (appUserIdMap.get(userId) != null) {
            return appUserIdMap.get(userId);
        }
        SaturationController saturationController = new SaturationController();
        appUserIdMap.put(userId, saturationController);
        return saturationController;
    }

    @VisibleForTesting
    static void computeGrayscaleTransformMatrix(float saturation, float[] matrix) {
        float desaturation = 1.0f - saturation;
        float[] luminance = new float[]{0.231f * desaturation, 0.715f * desaturation, 0.072f * desaturation};
        matrix[0] = luminance[0] + saturation;
        matrix[1] = luminance[0];
        matrix[2] = luminance[0];
        matrix[3] = luminance[1];
        matrix[4] = luminance[1] + saturation;
        matrix[5] = luminance[1];
        matrix[6] = luminance[2];
        matrix[7] = luminance[2];
        matrix[8] = luminance[2] + saturation;
    }

    private static class SaturationController {
        private final List<WeakReference<ColorDisplayService.ColorTransformController>> mControllerRefs = new ArrayList<WeakReference<ColorDisplayService.ColorTransformController>>();
        private int mSaturationLevel = 100;
        private float[] mTransformMatrix = new float[9];

        private SaturationController() {
        }

        private boolean setSaturationLevel(int saturationLevel) {
            this.mSaturationLevel = saturationLevel;
            if (!this.mControllerRefs.isEmpty()) {
                return this.updateState();
            }
            return false;
        }

        private boolean addColorTransformController(WeakReference<ColorDisplayService.ColorTransformController> controller) {
            this.mControllerRefs.add(controller);
            if (this.mSaturationLevel != 100) {
                return this.updateState();
            }
            this.clearExpiredReferences();
            return false;
        }

        private boolean updateState() {
            AppSaturationController.computeGrayscaleTransformMatrix((float)this.mSaturationLevel / 100.0f, this.mTransformMatrix);
            boolean updated = false;
            Iterator<WeakReference<ColorDisplayService.ColorTransformController>> iterator = this.mControllerRefs.iterator();
            while (iterator.hasNext()) {
                WeakReference<ColorDisplayService.ColorTransformController> controllerRef = iterator.next();
                ColorDisplayService.ColorTransformController controller = (ColorDisplayService.ColorTransformController)controllerRef.get();
                if (controller != null) {
                    controller.applyAppSaturation(this.mTransformMatrix, TRANSLATION_VECTOR);
                    updated = true;
                    continue;
                }
                iterator.remove();
            }
            return updated;
        }

        private void clearExpiredReferences() {
            Iterator<WeakReference<ColorDisplayService.ColorTransformController>> iterator = this.mControllerRefs.iterator();
            while (iterator.hasNext()) {
                WeakReference<ColorDisplayService.ColorTransformController> controllerRef = iterator.next();
                ColorDisplayService.ColorTransformController controller = (ColorDisplayService.ColorTransformController)controllerRef.get();
                if (controller != null) continue;
                iterator.remove();
            }
        }

        private void dump(PrintWriter pw) {
            pw.println("            mSaturationLevel: " + this.mSaturationLevel);
            pw.println("            mControllerRefs count: " + this.mControllerRefs.size());
        }
    }
}

