/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.color;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.AlarmManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.display.ColorDisplayManager;
import android.hardware.display.IColorDisplayManager;
import android.hardware.display.Time;
import android.net.Uri;
import android.opengl.Matrix;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.MathUtils;
import android.util.Slog;
import android.view.SurfaceControl;
import android.view.animation.AnimationUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.DumpUtils;
import com.android.server.DisplayThread;
import com.android.server.SystemService;
import com.android.server.display.color.AppSaturationController;
import com.android.server.display.color.DisplayTransformManager;
import com.android.server.display.color.DisplayWhiteBalanceTintController;
import com.android.server.display.color.GlobalSaturationTintController;
import com.android.server.display.color.TintController;
import com.android.server.twilight.TwilightListener;
import com.android.server.twilight.TwilightManager;
import com.android.server.twilight.TwilightState;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;

public final class ColorDisplayService
extends SystemService {
    static final String TAG = "ColorDisplayService";
    static final float[] MATRIX_IDENTITY = new float[16];
    private static final long TRANSITION_DURATION = 3000L;
    private static final int MSG_USER_CHANGED = 0;
    private static final int MSG_SET_UP = 1;
    private static final int MSG_APPLY_NIGHT_DISPLAY_IMMEDIATE = 2;
    private static final int MSG_APPLY_NIGHT_DISPLAY_ANIMATED = 3;
    private static final int MSG_APPLY_GLOBAL_SATURATION = 4;
    private static final int MSG_APPLY_DISPLAY_WHITE_BALANCE = 5;
    private static final int NOT_SET = -1;
    private static final ColorMatrixEvaluator COLOR_MATRIX_EVALUATOR;
    private final NightDisplayTintController mNightDisplayTintController = new NightDisplayTintController();
    @VisibleForTesting
    final DisplayWhiteBalanceTintController mDisplayWhiteBalanceTintController = new DisplayWhiteBalanceTintController();
    private final TintController mGlobalSaturationTintController = new GlobalSaturationTintController();
    private static final float[] MATRIX_GRAYSCALE;
    private static final float[] MATRIX_INVERT_COLOR;
    private final Handler mHandler;
    private final AppSaturationController mAppSaturationController = new AppSaturationController();
    private int mCurrentUser = -10000;
    private ContentObserver mUserSetupObserver;
    private boolean mBootCompleted;
    private ContentObserver mContentObserver;
    private DisplayWhiteBalanceListener mDisplayWhiteBalanceListener;
    private NightDisplayAutoMode mNightDisplayAutoMode;

    public ColorDisplayService(Context context) {
        super(context);
        this.mHandler = new TintHandler(DisplayThread.get().getLooper());
    }

    @Override
    public void onStart() {
        this.publishBinderService("color_display", new BinderService());
        this.publishLocalService(ColorDisplayServiceInternal.class, new ColorDisplayServiceInternal());
        this.publishLocalService(DisplayTransformManager.class, new DisplayTransformManager());
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase >= 1000) {
            this.mBootCompleted = true;
            if (this.mCurrentUser != -10000 && this.mUserSetupObserver == null) {
                this.mHandler.sendEmptyMessage(1);
            }
        }
    }

    @Override
    public void onStartUser(int userHandle) {
        super.onStartUser(userHandle);
        if (this.mCurrentUser == -10000) {
            Message message = this.mHandler.obtainMessage(0);
            message.arg1 = userHandle;
            this.mHandler.sendMessage(message);
        }
    }

    @Override
    public void onSwitchUser(int userHandle) {
        super.onSwitchUser(userHandle);
        Message message = this.mHandler.obtainMessage(0);
        message.arg1 = userHandle;
        this.mHandler.sendMessage(message);
    }

    @Override
    public void onStopUser(int userHandle) {
        super.onStopUser(userHandle);
        if (this.mCurrentUser == userHandle) {
            Message message = this.mHandler.obtainMessage(0);
            message.arg1 = -10000;
            this.mHandler.sendMessage(message);
        }
    }

    private void onUserChanged(int userHandle) {
        final ContentResolver cr = this.getContext().getContentResolver();
        if (this.mCurrentUser != -10000) {
            if (this.mUserSetupObserver != null) {
                cr.unregisterContentObserver(this.mUserSetupObserver);
                this.mUserSetupObserver = null;
            } else if (this.mBootCompleted) {
                this.tearDown();
            }
        }
        this.mCurrentUser = userHandle;
        if (this.mCurrentUser != -10000) {
            if (!ColorDisplayService.isUserSetupCompleted(cr, this.mCurrentUser)) {
                this.mUserSetupObserver = new ContentObserver(this.mHandler){

                    @Override
                    public void onChange(boolean selfChange, Uri uri) {
                        if (ColorDisplayService.isUserSetupCompleted(cr, ColorDisplayService.this.mCurrentUser)) {
                            cr.unregisterContentObserver(this);
                            ColorDisplayService.this.mUserSetupObserver = null;
                            if (ColorDisplayService.this.mBootCompleted) {
                                ColorDisplayService.this.setUp();
                            }
                        }
                    }
                };
                cr.registerContentObserver(Settings.Secure.getUriFor("user_setup_complete"), false, this.mUserSetupObserver, this.mCurrentUser);
            } else if (this.mBootCompleted) {
                this.setUp();
            }
        }
    }

    private static boolean isUserSetupCompleted(ContentResolver cr, int userHandle) {
        return Settings.Secure.getIntForUser(cr, "user_setup_complete", 0, userHandle) == 1;
    }

    private void setUp() {
        Slog.d(TAG, "setUp: currentUser=" + this.mCurrentUser);
        if (this.mContentObserver == null) {
            this.mContentObserver = new ContentObserver(this.mHandler){

                @Override
                public void onChange(boolean selfChange, Uri uri) {
                    String setting;
                    super.onChange(selfChange, uri);
                    String string2 = setting = uri == null ? null : uri.getLastPathSegment();
                    if (setting != null) {
                        switch (setting) {
                            case "night_display_activated": {
                                boolean activated = ColorDisplayService.this.mNightDisplayTintController.isActivatedSetting();
                                if (!ColorDisplayService.this.mNightDisplayTintController.isActivatedStateNotSet() && ColorDisplayService.this.mNightDisplayTintController.isActivated() == activated) break;
                                ColorDisplayService.this.mNightDisplayTintController.setActivated(activated);
                                break;
                            }
                            case "night_display_color_temperature": {
                                int temperature = ColorDisplayService.this.mNightDisplayTintController.getColorTemperatureSetting();
                                if (ColorDisplayService.this.mNightDisplayTintController.getColorTemperature() == temperature) break;
                                ColorDisplayService.this.mNightDisplayTintController.onColorTemperatureChanged(temperature);
                                break;
                            }
                            case "night_display_auto_mode": {
                                ColorDisplayService.this.onNightDisplayAutoModeChanged(ColorDisplayService.this.getNightDisplayAutoModeInternal());
                                break;
                            }
                            case "night_display_custom_start_time": {
                                ColorDisplayService.this.onNightDisplayCustomStartTimeChanged(ColorDisplayService.this.getNightDisplayCustomStartTimeInternal().getLocalTime());
                                break;
                            }
                            case "night_display_custom_end_time": {
                                ColorDisplayService.this.onNightDisplayCustomEndTimeChanged(ColorDisplayService.this.getNightDisplayCustomEndTimeInternal().getLocalTime());
                                break;
                            }
                            case "display_color_mode": {
                                ColorDisplayService.this.onDisplayColorModeChanged(ColorDisplayService.this.getColorModeInternal());
                                break;
                            }
                            case "accessibility_display_inversion_enabled": {
                                ColorDisplayService.this.onAccessibilityInversionChanged();
                                ColorDisplayService.this.onAccessibilityActivated();
                                break;
                            }
                            case "accessibility_display_daltonizer_enabled": {
                                ColorDisplayService.this.onAccessibilityDaltonizerChanged();
                                ColorDisplayService.this.onAccessibilityActivated();
                                break;
                            }
                            case "accessibility_display_daltonizer": {
                                ColorDisplayService.this.onAccessibilityDaltonizerChanged();
                                break;
                            }
                            case "display_white_balance_enabled": {
                                ColorDisplayService.this.updateDisplayWhiteBalanceStatus();
                            }
                        }
                    }
                }
            };
        }
        ContentResolver cr = this.getContext().getContentResolver();
        cr.registerContentObserver(Settings.Secure.getUriFor("night_display_activated"), false, this.mContentObserver, this.mCurrentUser);
        cr.registerContentObserver(Settings.Secure.getUriFor("night_display_color_temperature"), false, this.mContentObserver, this.mCurrentUser);
        cr.registerContentObserver(Settings.Secure.getUriFor("night_display_auto_mode"), false, this.mContentObserver, this.mCurrentUser);
        cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_start_time"), false, this.mContentObserver, this.mCurrentUser);
        cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_end_time"), false, this.mContentObserver, this.mCurrentUser);
        cr.registerContentObserver(Settings.System.getUriFor("display_color_mode"), false, this.mContentObserver, this.mCurrentUser);
        cr.registerContentObserver(Settings.Secure.getUriFor("accessibility_display_inversion_enabled"), false, this.mContentObserver, this.mCurrentUser);
        cr.registerContentObserver(Settings.Secure.getUriFor("accessibility_display_daltonizer_enabled"), false, this.mContentObserver, this.mCurrentUser);
        cr.registerContentObserver(Settings.Secure.getUriFor("accessibility_display_daltonizer"), false, this.mContentObserver, this.mCurrentUser);
        cr.registerContentObserver(Settings.Secure.getUriFor("display_white_balance_enabled"), false, this.mContentObserver, this.mCurrentUser);
        this.onAccessibilityInversionChanged();
        this.onAccessibilityDaltonizerChanged();
        this.onDisplayColorModeChanged(this.getColorModeInternal());
        if (this.mNightDisplayTintController.isAvailable(this.getContext())) {
            this.mNightDisplayTintController.setActivated(null);
            this.mNightDisplayTintController.setUp(this.getContext(), DisplayTransformManager.needsLinearColorMatrix());
            this.mNightDisplayTintController.setMatrix(this.mNightDisplayTintController.getColorTemperatureSetting());
            this.onNightDisplayAutoModeChanged(this.getNightDisplayAutoModeInternal());
            if (this.mNightDisplayTintController.isActivatedStateNotSet()) {
                this.mNightDisplayTintController.setActivated(this.mNightDisplayTintController.isActivatedSetting());
            }
        }
        if (this.mDisplayWhiteBalanceTintController.isAvailable(this.getContext())) {
            this.mDisplayWhiteBalanceTintController.setUp(this.getContext(), true);
            this.updateDisplayWhiteBalanceStatus();
        }
    }

    private void tearDown() {
        Slog.d(TAG, "tearDown: currentUser=" + this.mCurrentUser);
        if (this.mContentObserver != null) {
            this.getContext().getContentResolver().unregisterContentObserver(this.mContentObserver);
        }
        if (this.mNightDisplayTintController.isAvailable(this.getContext())) {
            if (this.mNightDisplayAutoMode != null) {
                this.mNightDisplayAutoMode.onStop();
                this.mNightDisplayAutoMode = null;
            }
            this.mNightDisplayTintController.endAnimator();
        }
        if (this.mDisplayWhiteBalanceTintController.isAvailable(this.getContext())) {
            this.mDisplayWhiteBalanceTintController.endAnimator();
        }
        if (this.mGlobalSaturationTintController.isAvailable(this.getContext())) {
            this.mGlobalSaturationTintController.setActivated(null);
        }
    }

    private void onNightDisplayAutoModeChanged(int autoMode) {
        Slog.d(TAG, "onNightDisplayAutoModeChanged: autoMode=" + autoMode);
        if (this.mNightDisplayAutoMode != null) {
            this.mNightDisplayAutoMode.onStop();
            this.mNightDisplayAutoMode = null;
        }
        if (autoMode == 1) {
            this.mNightDisplayAutoMode = new CustomNightDisplayAutoMode();
        } else if (autoMode == 2) {
            this.mNightDisplayAutoMode = new TwilightNightDisplayAutoMode();
        }
        if (this.mNightDisplayAutoMode != null) {
            this.mNightDisplayAutoMode.onStart();
        }
    }

    private void onNightDisplayCustomStartTimeChanged(LocalTime startTime) {
        Slog.d(TAG, "onNightDisplayCustomStartTimeChanged: startTime=" + startTime);
        if (this.mNightDisplayAutoMode != null) {
            this.mNightDisplayAutoMode.onCustomStartTimeChanged(startTime);
        }
    }

    private void onNightDisplayCustomEndTimeChanged(LocalTime endTime) {
        Slog.d(TAG, "onNightDisplayCustomEndTimeChanged: endTime=" + endTime);
        if (this.mNightDisplayAutoMode != null) {
            this.mNightDisplayAutoMode.onCustomEndTimeChanged(endTime);
        }
    }

    private void onDisplayColorModeChanged(int mode) {
        if (mode == -1) {
            return;
        }
        this.mNightDisplayTintController.cancelAnimator();
        this.mDisplayWhiteBalanceTintController.cancelAnimator();
        if (this.mNightDisplayTintController.isAvailable(this.getContext())) {
            this.mNightDisplayTintController.setUp(this.getContext(), DisplayTransformManager.needsLinearColorMatrix(mode));
            this.mNightDisplayTintController.setMatrix(this.mNightDisplayTintController.getColorTemperatureSetting());
        }
        if (this.mDisplayWhiteBalanceTintController.isAvailable(this.getContext())) {
            this.updateDisplayWhiteBalanceStatus();
        }
        DisplayTransformManager dtm = this.getLocalService(DisplayTransformManager.class);
        dtm.setColorMode(mode, this.mNightDisplayTintController.getMatrix());
    }

    private void onAccessibilityActivated() {
        this.onDisplayColorModeChanged(this.getColorModeInternal());
    }

    private boolean isAccessiblityDaltonizerEnabled() {
        return Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "accessibility_display_daltonizer_enabled", 0, this.mCurrentUser) != 0;
    }

    private boolean isAccessiblityInversionEnabled() {
        return Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "accessibility_display_inversion_enabled", 0, this.mCurrentUser) != 0;
    }

    private boolean isAccessibilityEnabled() {
        return this.isAccessiblityDaltonizerEnabled() || this.isAccessiblityInversionEnabled();
    }

    private void onAccessibilityDaltonizerChanged() {
        if (this.mCurrentUser == -10000) {
            return;
        }
        int daltonizerMode = this.isAccessiblityDaltonizerEnabled() ? Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "accessibility_display_daltonizer", 12, this.mCurrentUser) : -1;
        DisplayTransformManager dtm = this.getLocalService(DisplayTransformManager.class);
        if (daltonizerMode == 0) {
            dtm.setColorMatrix(200, MATRIX_GRAYSCALE);
            dtm.setDaltonizerMode(-1);
        } else {
            dtm.setColorMatrix(200, null);
            dtm.setDaltonizerMode(daltonizerMode);
        }
    }

    private void onAccessibilityInversionChanged() {
        if (this.mCurrentUser == -10000) {
            return;
        }
        DisplayTransformManager dtm = this.getLocalService(DisplayTransformManager.class);
        dtm.setColorMatrix(300, (float[])(this.isAccessiblityInversionEnabled() ? MATRIX_INVERT_COLOR : null));
    }

    private void applyTint(final TintController tintController, boolean immediate) {
        tintController.cancelAnimator();
        final DisplayTransformManager dtm = this.getLocalService(DisplayTransformManager.class);
        float[] from = dtm.getColorMatrix(tintController.getLevel());
        final float[] to = tintController.getMatrix();
        if (immediate) {
            dtm.setColorMatrix(tintController.getLevel(), to);
        } else {
            tintController.setAnimator(ValueAnimator.ofObject(COLOR_MATRIX_EVALUATOR, from == null ? MATRIX_IDENTITY : from, to));
            tintController.getAnimator().setDuration(3000L);
            tintController.getAnimator().setInterpolator(AnimationUtils.loadInterpolator(this.getContext(), 17563661));
            tintController.getAnimator().addUpdateListener(animator2 -> {
                float[] value = (float[])animator2.getAnimatedValue();
                dtm.setColorMatrix(tintController.getLevel(), value);
            });
            tintController.getAnimator().addListener(new AnimatorListenerAdapter(){
                private boolean mIsCancelled;

                @Override
                public void onAnimationCancel(Animator animator2) {
                    this.mIsCancelled = true;
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    if (!this.mIsCancelled) {
                        dtm.setColorMatrix(tintController.getLevel(), to);
                    }
                    tintController.setAnimator(null);
                }
            });
            tintController.getAnimator().start();
        }
    }

    @VisibleForTesting
    static LocalDateTime getDateTimeBefore(LocalTime localTime, LocalDateTime compareTime) {
        LocalDateTime ldt = LocalDateTime.of(compareTime.getYear(), compareTime.getMonth(), compareTime.getDayOfMonth(), localTime.getHour(), localTime.getMinute());
        return ldt.isAfter(compareTime) ? ldt.minusDays(1L) : ldt;
    }

    @VisibleForTesting
    static LocalDateTime getDateTimeAfter(LocalTime localTime, LocalDateTime compareTime) {
        LocalDateTime ldt = LocalDateTime.of(compareTime.getYear(), compareTime.getMonth(), compareTime.getDayOfMonth(), localTime.getHour(), localTime.getMinute());
        return ldt.isBefore(compareTime) ? ldt.plusDays(1L) : ldt;
    }

    @VisibleForTesting
    void updateDisplayWhiteBalanceStatus() {
        boolean oldActivated = this.mDisplayWhiteBalanceTintController.isActivated();
        this.mDisplayWhiteBalanceTintController.setActivated(this.isDisplayWhiteBalanceSettingEnabled() && !this.mNightDisplayTintController.isActivated() && !this.isAccessibilityEnabled() && DisplayTransformManager.needsLinearColorMatrix());
        boolean activated = this.mDisplayWhiteBalanceTintController.isActivated();
        if (this.mDisplayWhiteBalanceListener != null && oldActivated != activated) {
            this.mDisplayWhiteBalanceListener.onDisplayWhiteBalanceStatusChanged(activated);
        }
        if (!activated) {
            this.mHandler.sendEmptyMessage(5);
        }
    }

    private boolean setDisplayWhiteBalanceSettingEnabled(boolean enabled) {
        if (this.mCurrentUser == -10000) {
            return false;
        }
        return Settings.Secure.putIntForUser(this.getContext().getContentResolver(), "display_white_balance_enabled", enabled ? 1 : 0, this.mCurrentUser);
    }

    private boolean isDisplayWhiteBalanceSettingEnabled() {
        if (this.mCurrentUser == -10000) {
            return false;
        }
        return Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "display_white_balance_enabled", this.getContext().getResources().getBoolean(0x1110055) ? 1 : 0, this.mCurrentUser) == 1;
    }

    private boolean isDeviceColorManagedInternal() {
        DisplayTransformManager dtm = this.getLocalService(DisplayTransformManager.class);
        return dtm.isDeviceColorManaged();
    }

    private int getTransformCapabilitiesInternal() {
        Resources res;
        int availabilityFlags = 0;
        if (SurfaceControl.getProtectedContentSupport()) {
            availabilityFlags |= 1;
        }
        if ((res = this.getContext().getResources()).getBoolean(17891506)) {
            availabilityFlags |= 2;
        }
        if (res.getBoolean(17891507)) {
            availabilityFlags |= 4;
        }
        return availabilityFlags;
    }

    private boolean setNightDisplayAutoModeInternal(int autoMode) {
        if (this.getNightDisplayAutoModeInternal() != autoMode) {
            Settings.Secure.putStringForUser(this.getContext().getContentResolver(), "night_display_last_activated_time", null, this.mCurrentUser);
        }
        return Settings.Secure.putIntForUser(this.getContext().getContentResolver(), "night_display_auto_mode", autoMode, this.mCurrentUser);
    }

    private int getNightDisplayAutoModeInternal() {
        int autoMode = this.getNightDisplayAutoModeRawInternal();
        if (autoMode == -1) {
            autoMode = this.getContext().getResources().getInteger(17694772);
        }
        if (autoMode != 0 && autoMode != 1 && autoMode != 2) {
            Slog.e(TAG, "Invalid autoMode: " + autoMode);
            autoMode = 0;
        }
        return autoMode;
    }

    private int getNightDisplayAutoModeRawInternal() {
        if (this.mCurrentUser == -10000) {
            return -1;
        }
        return Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "night_display_auto_mode", -1, this.mCurrentUser);
    }

    private Time getNightDisplayCustomStartTimeInternal() {
        int startTimeValue = Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "night_display_custom_start_time", -1, this.mCurrentUser);
        if (startTimeValue == -1) {
            startTimeValue = this.getContext().getResources().getInteger(17694774);
        }
        return new Time(LocalTime.ofSecondOfDay(startTimeValue / 1000));
    }

    private boolean setNightDisplayCustomStartTimeInternal(Time startTime) {
        return Settings.Secure.putIntForUser(this.getContext().getContentResolver(), "night_display_custom_start_time", startTime.getLocalTime().toSecondOfDay() * 1000, this.mCurrentUser);
    }

    private Time getNightDisplayCustomEndTimeInternal() {
        int endTimeValue = Settings.Secure.getIntForUser(this.getContext().getContentResolver(), "night_display_custom_end_time", -1, this.mCurrentUser);
        if (endTimeValue == -1) {
            endTimeValue = this.getContext().getResources().getInteger(17694773);
        }
        return new Time(LocalTime.ofSecondOfDay(endTimeValue / 1000));
    }

    private boolean setNightDisplayCustomEndTimeInternal(Time endTime) {
        return Settings.Secure.putIntForUser(this.getContext().getContentResolver(), "night_display_custom_end_time", endTime.getLocalTime().toSecondOfDay() * 1000, this.mCurrentUser);
    }

    private LocalDateTime getNightDisplayLastActivatedTimeSetting() {
        ContentResolver cr = this.getContext().getContentResolver();
        String lastActivatedTime = Settings.Secure.getStringForUser(cr, "night_display_last_activated_time", this.getContext().getUserId());
        if (lastActivatedTime != null) {
            try {
                return LocalDateTime.parse(lastActivatedTime);
            }
            catch (DateTimeParseException dateTimeParseException) {
                try {
                    return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(lastActivatedTime)), ZoneId.systemDefault());
                }
                catch (NumberFormatException | DateTimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return LocalDateTime.MIN;
    }

    private boolean setAppSaturationLevelInternal(String packageName, int saturationLevel) {
        return this.mAppSaturationController.setSaturationLevel(packageName, this.mCurrentUser, saturationLevel);
    }

    private void setColorModeInternal(int colorMode) {
        if (!this.isColorModeAvailable(colorMode)) {
            throw new IllegalArgumentException("Invalid colorMode: " + colorMode);
        }
        Settings.System.putIntForUser(this.getContext().getContentResolver(), "display_color_mode", colorMode, this.mCurrentUser);
    }

    private int getColorModeInternal() {
        int a11yColorMode;
        ContentResolver cr = this.getContext().getContentResolver();
        if (this.isAccessibilityEnabled() && (a11yColorMode = this.getContext().getResources().getInteger(17694728)) >= 0) {
            return a11yColorMode;
        }
        int colorMode = Settings.System.getIntForUser(cr, "display_color_mode", -1, this.mCurrentUser);
        if (colorMode == -1) {
            colorMode = this.getCurrentColorModeFromSystemProperties();
        }
        if (!this.isColorModeAvailable(colorMode)) {
            colorMode = colorMode == 1 && this.isColorModeAvailable(0) ? 0 : (colorMode == 2 && this.isColorModeAvailable(3) ? 3 : (colorMode == 3 && this.isColorModeAvailable(2) ? 2 : -1));
        }
        return colorMode;
    }

    private int getCurrentColorModeFromSystemProperties() {
        int displayColorSetting = SystemProperties.getInt("persist.sys.sf.native_mode", 0);
        if (displayColorSetting == 0) {
            return "1.0".equals(SystemProperties.get("persist.sys.sf.color_saturation")) ? 0 : 1;
        }
        if (displayColorSetting == 1) {
            return 2;
        }
        if (displayColorSetting == 2) {
            return 3;
        }
        if (displayColorSetting >= 256 && displayColorSetting <= 511) {
            return displayColorSetting;
        }
        return -1;
    }

    private boolean isColorModeAvailable(int colorMode) {
        int[] availableColorModes = this.getContext().getResources().getIntArray(0x1070017);
        if (availableColorModes != null) {
            for (int mode : availableColorModes) {
                if (mode != colorMode) continue;
                return true;
            }
        }
        return false;
    }

    private void dumpInternal(PrintWriter pw) {
        pw.println("COLOR DISPLAY MANAGER dumpsys (color_display)");
        pw.println("Night display:");
        if (this.mNightDisplayTintController.isAvailable(this.getContext())) {
            pw.println("    Activated: " + this.mNightDisplayTintController.isActivated());
            pw.println("    Color temp: " + this.mNightDisplayTintController.getColorTemperature());
        } else {
            pw.println("    Not available");
        }
        pw.println("Global saturation:");
        if (this.mGlobalSaturationTintController.isAvailable(this.getContext())) {
            pw.println("    Activated: " + this.mGlobalSaturationTintController.isActivated());
        } else {
            pw.println("    Not available");
        }
        this.mAppSaturationController.dump(pw);
        pw.println("Display white balance:");
        if (this.mDisplayWhiteBalanceTintController.isAvailable(this.getContext())) {
            pw.println("    Activated: " + this.mDisplayWhiteBalanceTintController.isActivated());
            this.mDisplayWhiteBalanceTintController.dump(pw);
        } else {
            pw.println("    Not available");
        }
        pw.println("Color mode: " + this.getColorModeInternal());
    }

    static {
        Matrix.setIdentityM(MATRIX_IDENTITY, 0);
        COLOR_MATRIX_EVALUATOR = new ColorMatrixEvaluator();
        MATRIX_GRAYSCALE = new float[]{0.2126f, 0.2126f, 0.2126f, 0.0f, 0.7152f, 0.7152f, 0.7152f, 0.0f, 0.0722f, 0.0722f, 0.0722f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        MATRIX_INVERT_COLOR = new float[]{0.402f, -0.598f, -0.599f, 0.0f, -1.174f, -0.174f, -1.175f, 0.0f, -0.228f, -0.228f, 0.772f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    }

    @VisibleForTesting
    final class BinderService
    extends IColorDisplayManager.Stub {
        BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setColorMode(int colorMode) {
            ColorDisplayService.this.getContext().enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to set display color mode");
            long token = Binder.clearCallingIdentity();
            try {
                ColorDisplayService.this.setColorModeInternal(colorMode);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getColorMode() {
            long token = Binder.clearCallingIdentity();
            try {
                int n = ColorDisplayService.this.getColorModeInternal();
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDeviceColorManaged() {
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = ColorDisplayService.this.isDeviceColorManagedInternal();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setSaturationLevel(int level) {
            boolean hasLegacyPermission;
            boolean hasTransformsPermission = ColorDisplayService.this.getContext().checkCallingPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS") == 0;
            boolean bl = hasLegacyPermission = ColorDisplayService.this.getContext().checkCallingPermission("android.permission.CONTROL_DISPLAY_SATURATION") == 0;
            if (!hasTransformsPermission && !hasLegacyPermission) {
                throw new SecurityException("Permission required to set display saturation level");
            }
            long token = Binder.clearCallingIdentity();
            try {
                Message message = ColorDisplayService.this.mHandler.obtainMessage(4);
                message.arg1 = level;
                ColorDisplayService.this.mHandler.sendMessage(message);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSaturationActivated() {
            ColorDisplayService.this.getContext().enforceCallingPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to get display saturation level");
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = !ColorDisplayService.this.mGlobalSaturationTintController.isActivatedStateNotSet() && ColorDisplayService.this.mGlobalSaturationTintController.isActivated();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setAppSaturationLevel(String packageName, int level) {
            ColorDisplayService.this.getContext().enforceCallingPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to set display saturation level");
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = ColorDisplayService.this.setAppSaturationLevelInternal(packageName, level);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getTransformCapabilities() {
            ColorDisplayService.this.getContext().enforceCallingPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to query transform capabilities");
            long token = Binder.clearCallingIdentity();
            try {
                int n = ColorDisplayService.this.getTransformCapabilitiesInternal();
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setNightDisplayActivated(boolean activated) {
            ColorDisplayService.this.getContext().enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to set night display activated");
            long token = Binder.clearCallingIdentity();
            try {
                ColorDisplayService.this.mNightDisplayTintController.setActivated(activated);
                boolean bl = true;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isNightDisplayActivated() {
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = ColorDisplayService.this.mNightDisplayTintController.isActivated();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setNightDisplayColorTemperature(int temperature) {
            ColorDisplayService.this.getContext().enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to set night display temperature");
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = ColorDisplayService.this.mNightDisplayTintController.setColorTemperature(temperature);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNightDisplayColorTemperature() {
            long token = Binder.clearCallingIdentity();
            try {
                int n = ColorDisplayService.this.mNightDisplayTintController.getColorTemperature();
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setNightDisplayAutoMode(int autoMode) {
            ColorDisplayService.this.getContext().enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to set night display auto mode");
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = ColorDisplayService.this.setNightDisplayAutoModeInternal(autoMode);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNightDisplayAutoMode() {
            ColorDisplayService.this.getContext().enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to get night display auto mode");
            long token = Binder.clearCallingIdentity();
            try {
                int n = ColorDisplayService.this.getNightDisplayAutoModeInternal();
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNightDisplayAutoModeRaw() {
            long token = Binder.clearCallingIdentity();
            try {
                int n = ColorDisplayService.this.getNightDisplayAutoModeRawInternal();
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setNightDisplayCustomStartTime(Time startTime) {
            ColorDisplayService.this.getContext().enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to set night display custom start time");
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = ColorDisplayService.this.setNightDisplayCustomStartTimeInternal(startTime);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Time getNightDisplayCustomStartTime() {
            long token = Binder.clearCallingIdentity();
            try {
                Time time = ColorDisplayService.this.getNightDisplayCustomStartTimeInternal();
                return time;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setNightDisplayCustomEndTime(Time endTime) {
            ColorDisplayService.this.getContext().enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to set night display custom end time");
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = ColorDisplayService.this.setNightDisplayCustomEndTimeInternal(endTime);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Time getNightDisplayCustomEndTime() {
            long token = Binder.clearCallingIdentity();
            try {
                Time time = ColorDisplayService.this.getNightDisplayCustomEndTimeInternal();
                return time;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setDisplayWhiteBalanceEnabled(boolean enabled) {
            ColorDisplayService.this.getContext().enforceCallingOrSelfPermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", "Permission required to set night display activated");
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = ColorDisplayService.this.setDisplayWhiteBalanceSettingEnabled(enabled);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDisplayWhiteBalanceEnabled() {
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = ColorDisplayService.this.isDisplayWhiteBalanceSettingEnabled();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(ColorDisplayService.this.getContext(), ColorDisplayService.TAG, pw)) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                ColorDisplayService.this.dumpInternal(pw);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    public static interface ColorTransformController {
        public void applyAppSaturation(float[] var1, float[] var2);
    }

    private final class TintHandler
    extends Handler {
        private TintHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    ColorDisplayService.this.onUserChanged(msg.arg1);
                    break;
                }
                case 1: {
                    ColorDisplayService.this.setUp();
                    break;
                }
                case 4: {
                    ColorDisplayService.this.mGlobalSaturationTintController.setMatrix(msg.arg1);
                    ColorDisplayService.this.applyTint(ColorDisplayService.this.mGlobalSaturationTintController, false);
                    break;
                }
                case 2: {
                    ColorDisplayService.this.applyTint(ColorDisplayService.this.mNightDisplayTintController, true);
                    break;
                }
                case 3: {
                    ColorDisplayService.this.applyTint(ColorDisplayService.this.mNightDisplayTintController, false);
                    break;
                }
                case 5: {
                    ColorDisplayService.this.applyTint(ColorDisplayService.this.mDisplayWhiteBalanceTintController, false);
                }
            }
        }
    }

    public static interface DisplayWhiteBalanceListener {
        public void onDisplayWhiteBalanceStatusChanged(boolean var1);
    }

    public final class ColorDisplayServiceInternal {
        public boolean setDisplayWhiteBalanceColorTemperature(int cct) {
            ColorDisplayService.this.mDisplayWhiteBalanceTintController.setMatrix(cct);
            if (ColorDisplayService.this.mDisplayWhiteBalanceTintController.isActivated()) {
                ColorDisplayService.this.mHandler.sendEmptyMessage(5);
                return true;
            }
            return false;
        }

        public boolean resetDisplayWhiteBalanceColorTemperature() {
            return this.setDisplayWhiteBalanceColorTemperature(ColorDisplayService.this.getContext().getResources().getInteger(17694788));
        }

        public boolean setDisplayWhiteBalanceListener(DisplayWhiteBalanceListener listener) {
            ColorDisplayService.this.mDisplayWhiteBalanceListener = listener;
            return ColorDisplayService.this.mDisplayWhiteBalanceTintController.isActivated();
        }

        public boolean isDisplayWhiteBalanceEnabled() {
            return ColorDisplayService.this.isDisplayWhiteBalanceSettingEnabled();
        }

        public boolean attachColorTransformController(String packageName, int userId, WeakReference<ColorTransformController> controller) {
            return ColorDisplayService.this.mAppSaturationController.addColorTransformController(packageName, userId, controller);
        }
    }

    private final class NightDisplayTintController
    extends TintController {
        private final float[] mMatrix = new float[16];
        private final float[] mColorTempCoefficients = new float[9];
        private Boolean mIsAvailable;
        private Integer mColorTemp;

        private NightDisplayTintController() {
        }

        @Override
        public void setUp(Context context, boolean needsLinear) {
            String[] coefficients = context.getResources().getStringArray(needsLinear ? 17236042 : 17236043);
            for (int i = 0; i < 9 && i < coefficients.length; ++i) {
                this.mColorTempCoefficients[i] = Float.parseFloat(coefficients[i]);
            }
        }

        @Override
        public void setMatrix(int cct) {
            if (this.mMatrix.length != 16) {
                Slog.d(ColorDisplayService.TAG, "The display transformation matrix must be 4x4");
                return;
            }
            Matrix.setIdentityM(this.mMatrix, 0);
            float squareTemperature = cct * cct;
            float red = squareTemperature * this.mColorTempCoefficients[0] + (float)cct * this.mColorTempCoefficients[1] + this.mColorTempCoefficients[2];
            float green = squareTemperature * this.mColorTempCoefficients[3] + (float)cct * this.mColorTempCoefficients[4] + this.mColorTempCoefficients[5];
            float blue = squareTemperature * this.mColorTempCoefficients[6] + (float)cct * this.mColorTempCoefficients[7] + this.mColorTempCoefficients[8];
            this.mMatrix[0] = red;
            this.mMatrix[5] = green;
            this.mMatrix[10] = blue;
        }

        @Override
        public float[] getMatrix() {
            return this.isActivated() ? this.mMatrix : MATRIX_IDENTITY;
        }

        @Override
        public void setActivated(Boolean activated) {
            boolean activationStateChanged;
            if (activated == null) {
                super.setActivated(null);
                return;
            }
            boolean bl = activationStateChanged = activated.booleanValue() != this.isActivated();
            if (!this.isActivatedStateNotSet() && activationStateChanged) {
                Settings.Secure.putStringForUser(ColorDisplayService.this.getContext().getContentResolver(), "night_display_last_activated_time", LocalDateTime.now().toString(), ColorDisplayService.this.mCurrentUser);
            }
            if (this.isActivatedStateNotSet() || activationStateChanged) {
                super.setActivated(activated);
                if (this.isActivatedSetting() != activated.booleanValue()) {
                    Settings.Secure.putIntForUser(ColorDisplayService.this.getContext().getContentResolver(), "night_display_activated", activated != false ? 1 : 0, ColorDisplayService.this.mCurrentUser);
                }
                this.onActivated(activated);
            }
        }

        @Override
        public int getLevel() {
            return 100;
        }

        @Override
        public boolean isAvailable(Context context) {
            if (this.mIsAvailable == null) {
                this.mIsAvailable = ColorDisplayManager.isNightDisplayAvailable(context);
            }
            return this.mIsAvailable;
        }

        private void onActivated(boolean activated) {
            Slog.i(ColorDisplayService.TAG, activated ? "Turning on night display" : "Turning off night display");
            if (ColorDisplayService.this.mNightDisplayAutoMode != null) {
                ColorDisplayService.this.mNightDisplayAutoMode.onActivated(activated);
            }
            if (ColorDisplayService.this.mDisplayWhiteBalanceTintController.isAvailable(ColorDisplayService.this.getContext())) {
                ColorDisplayService.this.updateDisplayWhiteBalanceStatus();
            }
            ColorDisplayService.this.mHandler.sendEmptyMessage(3);
        }

        int getColorTemperature() {
            return this.mColorTemp != null ? this.clampNightDisplayColorTemperature(this.mColorTemp) : this.getColorTemperatureSetting();
        }

        boolean setColorTemperature(int temperature) {
            this.mColorTemp = temperature;
            boolean success = Settings.Secure.putIntForUser(ColorDisplayService.this.getContext().getContentResolver(), "night_display_color_temperature", temperature, ColorDisplayService.this.mCurrentUser);
            this.onColorTemperatureChanged(temperature);
            return success;
        }

        void onColorTemperatureChanged(int temperature) {
            this.setMatrix(temperature);
            ColorDisplayService.this.mHandler.sendEmptyMessage(2);
        }

        boolean isActivatedSetting() {
            if (ColorDisplayService.this.mCurrentUser == -10000) {
                return false;
            }
            return Settings.Secure.getIntForUser(ColorDisplayService.this.getContext().getContentResolver(), "night_display_activated", 0, ColorDisplayService.this.mCurrentUser) == 1;
        }

        int getColorTemperatureSetting() {
            if (ColorDisplayService.this.mCurrentUser == -10000) {
                return -1;
            }
            return this.clampNightDisplayColorTemperature(Settings.Secure.getIntForUser(ColorDisplayService.this.getContext().getContentResolver(), "night_display_color_temperature", -1, ColorDisplayService.this.mCurrentUser));
        }

        private int clampNightDisplayColorTemperature(int colorTemperature) {
            if (colorTemperature == -1) {
                colorTemperature = ColorDisplayService.this.getContext().getResources().getInteger(17694857);
            }
            int minimumTemperature = ColorDisplayManager.getMinimumColorTemperature(ColorDisplayService.this.getContext());
            int maximumTemperature = ColorDisplayManager.getMaximumColorTemperature(ColorDisplayService.this.getContext());
            if (colorTemperature < minimumTemperature) {
                colorTemperature = minimumTemperature;
            } else if (colorTemperature > maximumTemperature) {
                colorTemperature = maximumTemperature;
            }
            return colorTemperature;
        }
    }

    private static class ColorMatrixEvaluator
    implements TypeEvaluator<float[]> {
        private final float[] mResultMatrix = new float[16];

        private ColorMatrixEvaluator() {
        }

        @Override
        public float[] evaluate(float fraction2, float[] startValue, float[] endValue) {
            for (int i = 0; i < this.mResultMatrix.length; ++i) {
                this.mResultMatrix[i] = MathUtils.lerp(startValue[i], endValue[i], fraction2);
            }
            return this.mResultMatrix;
        }
    }

    private final class TwilightNightDisplayAutoMode
    extends NightDisplayAutoMode
    implements TwilightListener {
        private final TwilightManager mTwilightManager;
        private LocalDateTime mLastActivatedTime;

        TwilightNightDisplayAutoMode() {
            this.mTwilightManager = (TwilightManager)ColorDisplayService.this.getLocalService(TwilightManager.class);
        }

        private void updateActivated(TwilightState state) {
            if (state == null) {
                return;
            }
            boolean activate = state.isNight();
            if (this.mLastActivatedTime != null) {
                LocalDateTime now = LocalDateTime.now();
                LocalDateTime sunrise = state.sunrise();
                LocalDateTime sunset = state.sunset();
                if (this.mLastActivatedTime.isBefore(now) && this.mLastActivatedTime.isBefore(sunrise) ^ this.mLastActivatedTime.isBefore(sunset)) {
                    activate = ColorDisplayService.this.mNightDisplayTintController.isActivatedSetting();
                }
            }
            if (ColorDisplayService.this.mNightDisplayTintController.isActivatedStateNotSet() || ColorDisplayService.this.mNightDisplayTintController.isActivated() != activate) {
                ColorDisplayService.this.mNightDisplayTintController.setActivated(activate);
            }
        }

        @Override
        public void onActivated(boolean activated) {
            this.mLastActivatedTime = ColorDisplayService.this.getNightDisplayLastActivatedTimeSetting();
        }

        @Override
        public void onStart() {
            this.mTwilightManager.registerListener(this, ColorDisplayService.this.mHandler);
            this.mLastActivatedTime = ColorDisplayService.this.getNightDisplayLastActivatedTimeSetting();
            this.updateActivated(this.mTwilightManager.getLastTwilightState());
        }

        @Override
        public void onStop() {
            this.mTwilightManager.unregisterListener(this);
            this.mLastActivatedTime = null;
        }

        @Override
        public void onTwilightStateChanged(TwilightState state) {
            Slog.d(ColorDisplayService.TAG, "onTwilightStateChanged: isNight=" + (state == null ? null : Boolean.valueOf(state.isNight())));
            this.updateActivated(state);
        }
    }

    private final class CustomNightDisplayAutoMode
    extends NightDisplayAutoMode
    implements AlarmManager.OnAlarmListener {
        private final AlarmManager mAlarmManager;
        private final BroadcastReceiver mTimeChangedReceiver;
        private LocalTime mStartTime;
        private LocalTime mEndTime;
        private LocalDateTime mLastActivatedTime;

        CustomNightDisplayAutoMode() {
            this.mAlarmManager = (AlarmManager)ColorDisplayService.this.getContext().getSystemService("alarm");
            this.mTimeChangedReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    CustomNightDisplayAutoMode.this.updateActivated();
                }
            };
        }

        private void updateActivated() {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime start = ColorDisplayService.getDateTimeBefore(this.mStartTime, now);
            LocalDateTime end = ColorDisplayService.getDateTimeAfter(this.mEndTime, start);
            boolean activate = now.isBefore(end);
            if (this.mLastActivatedTime != null && this.mLastActivatedTime.isBefore(now) && this.mLastActivatedTime.isAfter(start) && (this.mLastActivatedTime.isAfter(end) || now.isBefore(end))) {
                activate = ColorDisplayService.this.mNightDisplayTintController.isActivatedSetting();
            }
            if (ColorDisplayService.this.mNightDisplayTintController.isActivatedStateNotSet() || ColorDisplayService.this.mNightDisplayTintController.isActivated() != activate) {
                ColorDisplayService.this.mNightDisplayTintController.setActivated(activate);
            }
            this.updateNextAlarm(ColorDisplayService.this.mNightDisplayTintController.isActivated(), now);
        }

        private void updateNextAlarm(Boolean activated, LocalDateTime now) {
            if (activated != null) {
                LocalDateTime next = activated != false ? ColorDisplayService.getDateTimeAfter(this.mEndTime, now) : ColorDisplayService.getDateTimeAfter(this.mStartTime, now);
                long millis = next.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                this.mAlarmManager.setExact(1, millis, ColorDisplayService.TAG, this, null);
            }
        }

        @Override
        public void onStart() {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            ColorDisplayService.this.getContext().registerReceiver(this.mTimeChangedReceiver, intentFilter);
            this.mStartTime = ColorDisplayService.this.getNightDisplayCustomStartTimeInternal().getLocalTime();
            this.mEndTime = ColorDisplayService.this.getNightDisplayCustomEndTimeInternal().getLocalTime();
            this.mLastActivatedTime = ColorDisplayService.this.getNightDisplayLastActivatedTimeSetting();
            this.updateActivated();
        }

        @Override
        public void onStop() {
            ColorDisplayService.this.getContext().unregisterReceiver(this.mTimeChangedReceiver);
            this.mAlarmManager.cancel(this);
            this.mLastActivatedTime = null;
        }

        @Override
        public void onActivated(boolean activated) {
            this.mLastActivatedTime = ColorDisplayService.this.getNightDisplayLastActivatedTimeSetting();
            this.updateNextAlarm(activated, LocalDateTime.now());
        }

        @Override
        public void onCustomStartTimeChanged(LocalTime startTime) {
            this.mStartTime = startTime;
            this.mLastActivatedTime = null;
            this.updateActivated();
        }

        @Override
        public void onCustomEndTimeChanged(LocalTime endTime) {
            this.mEndTime = endTime;
            this.mLastActivatedTime = null;
            this.updateActivated();
        }

        @Override
        public void onAlarm() {
            Slog.d(ColorDisplayService.TAG, "onAlarm");
            this.updateActivated();
        }
    }

    private abstract class NightDisplayAutoMode {
        private NightDisplayAutoMode() {
        }

        public abstract void onActivated(boolean var1);

        public abstract void onStart();

        public abstract void onStop();

        public void onCustomStartTimeChanged(LocalTime startTime) {
        }

        public void onCustomEndTimeChanged(LocalTime endTime) {
        }
    }
}

