/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.color;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.ColorSpace;
import android.hardware.display.ColorDisplayManager;
import android.opengl.Matrix;
import android.os.IBinder;
import android.util.Slog;
import android.view.SurfaceControl;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.display.color.ColorDisplayService;
import com.android.server.display.color.TintController;
import java.io.PrintWriter;

final class DisplayWhiteBalanceTintController
extends TintController {
    private static final int NUM_VALUES_PER_PRIMARY = 3;
    private static final int NUM_DISPLAY_PRIMARIES_VALS = 12;
    private static final int COLORSPACE_MATRIX_LENGTH = 9;
    private final Object mLock = new Object();
    @VisibleForTesting
    int mTemperatureMin;
    @VisibleForTesting
    int mTemperatureMax;
    private int mTemperatureDefault;
    @VisibleForTesting
    float[] mDisplayNominalWhiteXYZ = new float[3];
    @VisibleForTesting
    ColorSpace.Rgb mDisplayColorSpaceRGB;
    private float[] mChromaticAdaptationMatrix;
    @VisibleForTesting
    int mCurrentColorTemperature;
    private float[] mCurrentColorTemperatureXYZ;
    @VisibleForTesting
    boolean mSetUp = false;
    private float[] mMatrixDisplayWhiteBalance = new float[16];
    private Boolean mIsAvailable;

    DisplayWhiteBalanceTintController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(Context context, boolean needsLinear) {
        this.mSetUp = false;
        Resources res = context.getResources();
        ColorSpace.Rgb displayColorSpaceRGB = this.getDisplayColorSpaceFromSurfaceControl();
        if (displayColorSpaceRGB == null) {
            Slog.w("ColorDisplayService", "Failed to get display color space from SurfaceControl, trying res");
            displayColorSpaceRGB = this.getDisplayColorSpaceFromResources(res);
            if (displayColorSpaceRGB == null) {
                Slog.e("ColorDisplayService", "Failed to get display color space from resources");
                return;
            }
        }
        if (!this.isColorMatrixValid(displayColorSpaceRGB.getTransform())) {
            Slog.e("ColorDisplayService", "Invalid display color space RGB-to-XYZ transform");
            return;
        }
        if (!this.isColorMatrixValid(displayColorSpaceRGB.getInverseTransform())) {
            Slog.e("ColorDisplayService", "Invalid display color space XYZ-to-RGB transform");
            return;
        }
        String[] nominalWhiteValues = res.getStringArray(17236015);
        float[] displayNominalWhiteXYZ = new float[3];
        for (int i = 0; i < nominalWhiteValues.length; ++i) {
            displayNominalWhiteXYZ[i] = Float.parseFloat(nominalWhiteValues[i]);
        }
        int colorTemperatureMin = res.getInteger(17694791);
        if (colorTemperatureMin <= 0) {
            Slog.e("ColorDisplayService", "Display white balance minimum temperature must be greater than 0");
            return;
        }
        int colorTemperatureMax = res.getInteger(17694790);
        if (colorTemperatureMax < colorTemperatureMin) {
            Slog.e("ColorDisplayService", "Display white balance max temp must be greater or equal to min");
            return;
        }
        int colorTemperature = res.getInteger(17694788);
        Object object = this.mLock;
        synchronized (object) {
            this.mDisplayColorSpaceRGB = displayColorSpaceRGB;
            this.mDisplayNominalWhiteXYZ = displayNominalWhiteXYZ;
            this.mTemperatureMin = colorTemperatureMin;
            this.mTemperatureMax = colorTemperatureMax;
            this.mTemperatureDefault = colorTemperature;
            this.mSetUp = true;
        }
        this.setMatrix(this.mTemperatureDefault);
    }

    @Override
    public float[] getMatrix() {
        return this.mSetUp && this.isActivated() ? this.mMatrixDisplayWhiteBalance : ColorDisplayService.MATRIX_IDENTITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMatrix(int cct) {
        if (!this.mSetUp) {
            Slog.w("ColorDisplayService", "Can't set display white balance temperature: uninitialized");
            return;
        }
        if (cct < this.mTemperatureMin) {
            Slog.w("ColorDisplayService", "Requested display color temperature is below allowed minimum");
            cct = this.mTemperatureMin;
        } else if (cct > this.mTemperatureMax) {
            Slog.w("ColorDisplayService", "Requested display color temperature is above allowed maximum");
            cct = this.mTemperatureMax;
        }
        Slog.d("ColorDisplayService", "setDisplayWhiteBalanceTemperatureMatrix: cct = " + cct);
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentColorTemperature = cct;
            this.mCurrentColorTemperatureXYZ = ColorSpace.cctToXyz(cct);
            this.mChromaticAdaptationMatrix = ColorSpace.chromaticAdaptation(ColorSpace.Adaptation.BRADFORD, this.mDisplayNominalWhiteXYZ, this.mCurrentColorTemperatureXYZ);
            float[] result = ColorSpace.mul3x3(this.mChromaticAdaptationMatrix, this.mDisplayColorSpaceRGB.getTransform());
            result = ColorSpace.mul3x3(this.mDisplayColorSpaceRGB.getInverseTransform(), result);
            float adaptedMaxR = result[0] + result[3] + result[6];
            float adaptedMaxG = result[1] + result[4] + result[7];
            float adaptedMaxB = result[2] + result[5] + result[8];
            float denum = Math.max(Math.max(adaptedMaxR, adaptedMaxG), adaptedMaxB);
            Matrix.setIdentityM(this.mMatrixDisplayWhiteBalance, 0);
            for (int i = 0; i < result.length; ++i) {
                int n = i;
                result[n] = result[n] / denum;
                if (this.isColorMatrixCoeffValid(result[i])) continue;
                Slog.e("ColorDisplayService", "Invalid DWB color matrix");
                return;
            }
            System.arraycopy(result, 0, this.mMatrixDisplayWhiteBalance, 0, 3);
            System.arraycopy(result, 3, this.mMatrixDisplayWhiteBalance, 4, 3);
            System.arraycopy(result, 6, this.mMatrixDisplayWhiteBalance, 8, 3);
        }
    }

    @Override
    public int getLevel() {
        return 125;
    }

    @Override
    public boolean isAvailable(Context context) {
        if (this.mIsAvailable == null) {
            this.mIsAvailable = ColorDisplayManager.isDisplayWhiteBalanceAvailable(context);
        }
        return this.mIsAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("    mSetUp = " + this.mSetUp);
            if (!this.mSetUp) {
                return;
            }
            pw.println("    mTemperatureMin = " + this.mTemperatureMin);
            pw.println("    mTemperatureMax = " + this.mTemperatureMax);
            pw.println("    mTemperatureDefault = " + this.mTemperatureDefault);
            pw.println("    mCurrentColorTemperature = " + this.mCurrentColorTemperature);
            pw.println("    mCurrentColorTemperatureXYZ = " + this.matrixToString(this.mCurrentColorTemperatureXYZ, 3));
            pw.println("    mDisplayColorSpaceRGB RGB-to-XYZ = " + this.matrixToString(this.mDisplayColorSpaceRGB.getTransform(), 3));
            pw.println("    mChromaticAdaptationMatrix = " + this.matrixToString(this.mChromaticAdaptationMatrix, 3));
            pw.println("    mDisplayColorSpaceRGB XYZ-to-RGB = " + this.matrixToString(this.mDisplayColorSpaceRGB.getInverseTransform(), 3));
            pw.println("    mMatrixDisplayWhiteBalance = " + this.matrixToString(this.mMatrixDisplayWhiteBalance, 4));
        }
    }

    private String matrixToString(float[] matrix, int columns) {
        if (matrix == null || columns <= 0) {
            Slog.e("ColorDisplayService", "Invalid arguments when formatting matrix to string");
            return "";
        }
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < matrix.length; ++i) {
            if (i % columns == 0) {
                sb.append("\n      ");
            }
            sb.append(String.format("%9.6f", Float.valueOf(matrix[i])));
        }
        return sb.toString();
    }

    private ColorSpace.Rgb makeRgbColorSpaceFromXYZ(float[] redGreenBlueXYZ, float[] whiteXYZ) {
        return new ColorSpace.Rgb("Display Color Space", redGreenBlueXYZ, whiteXYZ, 2.2f);
    }

    private ColorSpace.Rgb getDisplayColorSpaceFromSurfaceControl() {
        IBinder displayToken = SurfaceControl.getInternalDisplayToken();
        if (displayToken == null) {
            return null;
        }
        SurfaceControl.DisplayPrimaries primaries = SurfaceControl.getDisplayNativePrimaries(displayToken);
        if (primaries == null || primaries.red == null || primaries.green == null || primaries.blue == null || primaries.white == null) {
            return null;
        }
        return this.makeRgbColorSpaceFromXYZ(new float[]{primaries.red.X, primaries.red.Y, primaries.red.Z, primaries.green.X, primaries.green.Y, primaries.green.Z, primaries.blue.X, primaries.blue.Y, primaries.blue.Z}, new float[]{primaries.white.X, primaries.white.Y, primaries.white.Z});
    }

    private ColorSpace.Rgb getDisplayColorSpaceFromResources(Resources res) {
        int i;
        String[] displayPrimariesValues = res.getStringArray(17236016);
        float[] displayRedGreenBlueXYZ = new float[9];
        float[] displayWhiteXYZ = new float[3];
        for (i = 0; i < displayRedGreenBlueXYZ.length; ++i) {
            displayRedGreenBlueXYZ[i] = Float.parseFloat(displayPrimariesValues[i]);
        }
        for (i = 0; i < displayWhiteXYZ.length; ++i) {
            displayWhiteXYZ[i] = Float.parseFloat(displayPrimariesValues[displayRedGreenBlueXYZ.length + i]);
        }
        return this.makeRgbColorSpaceFromXYZ(displayRedGreenBlueXYZ, displayWhiteXYZ);
    }

    private boolean isColorMatrixCoeffValid(float coeff) {
        return !Float.isNaN(coeff) && !Float.isInfinite(coeff);
    }

    private boolean isColorMatrixValid(float[] matrix) {
        if (matrix == null || matrix.length != 9) {
            return false;
        }
        for (int i = 0; i < matrix.length; ++i) {
            if (this.isColorMatrixCoeffValid(matrix[i])) continue;
            return false;
        }
        return true;
    }
}

