/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display.color;

import android.content.Context;
import android.hardware.display.ColorDisplayManager;
import android.opengl.Matrix;
import android.util.Slog;
import com.android.server.display.color.TintController;
import java.util.Arrays;

final class GlobalSaturationTintController
extends TintController {
    private final float[] mMatrixGlobalSaturation = new float[16];

    GlobalSaturationTintController() {
    }

    @Override
    public void setUp(Context context, boolean needsLinear) {
    }

    @Override
    public float[] getMatrix() {
        return Arrays.copyOf(this.mMatrixGlobalSaturation, this.mMatrixGlobalSaturation.length);
    }

    @Override
    public void setMatrix(int saturationLevel) {
        if (saturationLevel < 0) {
            saturationLevel = 0;
        } else if (saturationLevel > 100) {
            saturationLevel = 100;
        }
        Slog.d("ColorDisplayService", "Setting saturation level: " + saturationLevel);
        if (saturationLevel == 100) {
            this.setActivated(false);
            Matrix.setIdentityM(this.mMatrixGlobalSaturation, 0);
        } else {
            this.setActivated(true);
            float saturation = (float)saturationLevel * 0.01f;
            float desaturation = 1.0f - saturation;
            float[] luminance = new float[]{0.231f * desaturation, 0.715f * desaturation, 0.072f * desaturation};
            this.mMatrixGlobalSaturation[0] = luminance[0] + saturation;
            this.mMatrixGlobalSaturation[1] = luminance[0];
            this.mMatrixGlobalSaturation[2] = luminance[0];
            this.mMatrixGlobalSaturation[4] = luminance[1];
            this.mMatrixGlobalSaturation[5] = luminance[1] + saturation;
            this.mMatrixGlobalSaturation[6] = luminance[1];
            this.mMatrixGlobalSaturation[8] = luminance[2];
            this.mMatrixGlobalSaturation[9] = luminance[2];
            this.mMatrixGlobalSaturation[10] = luminance[2] + saturation;
        }
    }

    @Override
    public int getLevel() {
        return 150;
    }

    @Override
    public boolean isAvailable(Context context) {
        return ColorDisplayManager.isColorTransformAccelerated(context);
    }
}

